/*
 * Decompiled with CFR 0.152.
 */
package com.sas.beans.editors;

import com.sas.beans.PropertyEditor;
import com.sas.text.Message;
import com.sas.util.Util;

public class InheritedBooleanEditor
extends PropertyEditor {
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String INHERITED = Util.getCommonStringResource((String)"InheritedItem.txt");

    public String getAsText() {
        Boolean boolValue = (Boolean)this.getValue();
        if (boolValue == null) {
            return INHERITED;
        }
        if (boolValue.booleanValue()) {
            return TRUE;
        }
        return FALSE;
    }

    public String getJavaInitializationString() {
        return this.getAsText();
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (text == null || text.length() == 0) {
            this.setValue(null);
            return;
        }
        if (Util.equal((Object)text, (Object)INHERITED)) {
            this.setValue(null);
            return;
        }
        if (Util.equal((Object)text, (Object)TRUE)) {
            this.setValue(Boolean.TRUE);
        } else if (Util.equal((Object)text, (Object)FALSE)) {
            this.setValue(Boolean.FALSE);
        } else {
            String message = Util.getCommonStringResource((String)"InvalidValue.ex.txt");
            throw new IllegalArgumentException(Message.format((String)message, (Object)text));
        }
    }

    public String[] getTags() {
        return new String[]{INHERITED, TRUE, FALSE};
    }
}

