/*
 * Decompiled with CFR 0.152.
 */
package com.sas.beans.editors;

import com.sas.net.AppletResourceLocator;
import com.sas.net.BaseResourceLocator;
import com.sas.net.ClassResourceLocator;
import com.sas.net.FileResourceLocator;
import com.sas.net.ResourceConsumerInterface;
import com.sas.net.ResourceLocatorInterface;
import com.sas.net.ResourceLocatorInterfaceCustomizerPanel;
import com.sas.swing.visuals.ImageIconResource;
import com.sas.visuals.ImageView;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.Field;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class IconEditor
extends PropertyEditorSupport
implements PropertyChangeListener {
    public static final String RB_KEY = "IconEditor.";
    private static String CLASS_SUFFIX = ".class";
    private static String CLASS_PREFIX = "class ";
    protected String defaultText = "null";
    protected int pathTypeOptions = 2 | 4 | 1 | 0x10;
    protected ResourceLocatorInterface resourceLocator;
    protected ResourceLocatorInterfaceCustomizerPanel customizerPanel;
    protected com.sas.swing.visuals.ImageView imageView;

    public void setDefaultText(String newValue) {
        if (!this.defaultText.equals(newValue)) {
            this.defaultText = newValue;
        }
    }

    public void setPathTypeOptions(int newValue) {
        if (this.pathTypeOptions != newValue) {
            this.pathTypeOptions = newValue;
        }
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    public int getPathTypeOptions() {
        return this.pathTypeOptions;
    }

    @Override
    public String getAsText() {
        Object o = this.getValue();
        if (o instanceof String) {
            return (String)o;
        }
        Icon iconValue = (Icon)o;
        String text = this.defaultText;
        if (iconValue != null) {
            String fileName;
            URL location;
            text = iconValue instanceof ResourceConsumerInterface ? ((ResourceConsumerInterface)iconValue).getResourceLocator().getResourceName() : (iconValue instanceof ImageIcon ? ((location = (URL)IconEditor.getPrivateField(iconValue, ImageIcon.class, "location")) != null ? location.toExternalForm() : ((fileName = (String)IconEditor.getPrivateField(iconValue, ImageIcon.class, "filename")) != null ? fileName : iconValue.getClass().toString())) : iconValue.getClass().toString());
            if (text == null) {
                text = this.defaultText;
            }
            int classNameLength = text.length() - CLASS_SUFFIX.length();
            if (text.endsWith(CLASS_SUFFIX) && classNameLength > 0) {
                text = text.substring(0, text.length() - CLASS_SUFFIX.length());
            }
        }
        return text;
    }

    @Override
    public void setAsText(String text) {
        Object iconValue;
        if ((text = text != null ? text.trim() : this.defaultText).length() == 0 || text.equals("null") || text.equals(this.defaultText) || text.indexOf("null") != -1) {
            this.setValue(null);
            return;
        }
        if (text.startsWith(CLASS_PREFIX)) {
            text = text.substring(CLASS_PREFIX.length(), text.length());
            iconValue = null;
            String errorMsg = null;
            try {
                Class<?> iconClass = Class.forName(text);
                iconValue = (Icon)iconClass.newInstance();
                this.setValue(iconValue);
            }
            catch (ClassNotFoundException cnfe) {
                errorMsg = "Class: " + text + " not found.";
            }
            catch (InstantiationException ie) {
                errorMsg = "Class: " + text + " can not be instantiated.";
            }
            catch (IllegalAccessException iae) {
                errorMsg = "Class: " + text + " not accessible.";
            }
            if (errorMsg != null) {
                System.out.println(errorMsg);
                throw new IllegalArgumentException(errorMsg);
            }
        }
        iconValue = null;
        ResourceLocatorInterface rli = this.createResourceLocator(text, ImageView.class);
        iconValue = new ImageIconResource(rli);
        this.setValue(iconValue);
    }

    private ResourceLocatorInterface createResourceLocator(String resource, Class relClass) {
        URL url = null;
        Object resourceLocator = new BaseResourceLocator(resource);
        url = this.getResourceForResourceLocator((ResourceLocatorInterface)resourceLocator);
        if (url == null && (url = this.getResourceForResourceLocator((ResourceLocatorInterface)(resourceLocator = new AppletResourceLocator(resource)))) == null) {
            resourceLocator = new ClassResourceLocator(resource);
            ((ClassResourceLocator)resourceLocator).setRelativeClass(relClass);
            url = this.getResourceForResourceLocator((ResourceLocatorInterface)resourceLocator);
            if (url == null) {
                resourceLocator = new FileResourceLocator(resource);
                url = this.getResourceForResourceLocator((ResourceLocatorInterface)resourceLocator);
            }
        }
        if (url == null) {
            resourceLocator = (this.getPathTypeOptions() & 1) != 0 ? new AppletResourceLocator() : new BaseResourceLocator();
        }
        return resourceLocator;
    }

    private static Object getPrivateField(Object instance, Class declaringClass, String name) {
        try {
            Field f = declaringClass.getDeclaredField(name);
            if (f != null) {
                f.setAccessible(true);
                Object x = f.get(instance);
                return x;
            }
            System.out.println("unable to find field-" + name + " in class " + declaringClass);
            return null;
        }
        catch (Exception e) {
            System.out.println(e + " Field '" + name + "' couldn't be extracted from an object of class '" + declaringClass.getName() + "'");
            return null;
        }
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        this.customizerPanel = new ResourceLocatorInterfaceCustomizerPanel();
        this.customizerPanel.setPathTypeOptions(this.pathTypeOptions);
        this.customizerPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Object value = this.getValue();
        Class relClass = null;
        String resource = null;
        if (value != null) {
            if (value instanceof ResourceConsumerInterface) {
                this.resourceLocator = ((ResourceConsumerInterface)value).getResourceLocator();
                resource = ((ResourceConsumerInterface)value).getResourceLocator().getResourceName();
                if (((ResourceConsumerInterface)value).getResourceLocator() instanceof ClassResourceLocator) {
                    relClass = ((ClassResourceLocator)((ResourceConsumerInterface)value).getResourceLocator()).getRelativeClass();
                }
            } else {
                String fileName;
                URL location;
                resource = value instanceof ImageIcon ? ((location = (URL)IconEditor.getPrivateField(value, ImageIcon.class, "location")) != null ? location.toExternalForm() : ((fileName = (String)IconEditor.getPrivateField(value, ImageIcon.class, "filename")) != null ? fileName : value.toString())) : value.toString();
            }
        }
        if (this.resourceLocator == null) {
            this.resourceLocator = this.createResourceLocator(resource, relClass);
        }
        this.customizerPanel.setObject(this.resourceLocator);
        this.customizerPanel.addPropertyChangeListener(this);
        ((BaseResourceLocator)this.resourceLocator).addPropertyChangeListener((PropertyChangeListener)this);
        return this.customizerPanel;
    }

    private URL getResourceForResourceLocator(ResourceLocatorInterface rli) {
        URL url = null;
        try {
            url = rli.getResource();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url;
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        if (ev.getSource() == this.customizerPanel && ev.getPropertyName().equals("resourceLocator")) {
            if (this.resourceLocator != null) {
                ((BaseResourceLocator)this.resourceLocator).removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.resourceLocator = this.customizerPanel.getResourceLocatorInterface();
            if (this.getResourceForResourceLocator(this.resourceLocator) == null) {
                this.setValue(null);
            } else if (this.getValue() instanceof ResourceConsumerInterface) {
                ((ResourceConsumerInterface)this.getValue()).setResourceLocator(this.resourceLocator);
                this.firePropertyChange();
            } else {
                this.setValue(new ImageIconResource(this.resourceLocator));
            }
            if (this.resourceLocator != null) {
                ((BaseResourceLocator)this.resourceLocator).addPropertyChangeListener((PropertyChangeListener)this);
            }
        } else if (ev.getSource() == this.resourceLocator) {
            if (this.getResourceForResourceLocator(this.resourceLocator) == null) {
                this.setValue(null);
            } else if (this.getValue() instanceof ResourceConsumerInterface) {
                ((ResourceConsumerInterface)this.getValue()).setResourceLocator(this.resourceLocator);
                this.firePropertyChange();
            } else {
                this.setValue(new ImageIconResource(this.resourceLocator));
            }
        }
    }

    @Override
    public void paintValue(Graphics g, Rectangle box) {
        if (this.getValue() != null) {
            ImageView image;
            Object o = this.getValue();
            Icon iconValue = null;
            if (o instanceof String) {
                this.setAsText((String)o);
                iconValue = (Icon)this.getValue();
            } else {
                iconValue = (Icon)o;
            }
            if (iconValue instanceof ImageIcon) {
                ImageIcon image2 = (ImageIcon)iconValue;
                if (image2.getImage() != null) {
                    g.drawImage(image2.getImage(), box.x, box.y, box.x + box.width - 1, box.y + box.height - 1, image2.getImageObserver());
                }
            } else if (iconValue instanceof com.sas.swing.visuals.ImageView) {
                com.sas.swing.visuals.ImageView image3 = (com.sas.swing.visuals.ImageView)iconValue;
                if (image3.getImage() != null) {
                    g.drawImage(image3.getImage(), box.x, box.y, box.x + box.width - 1, box.y + box.height - 1, (ImageObserver)image3);
                }
            } else if (iconValue instanceof ImageView && (image = (ImageView)iconValue).getImage() != null) {
                g.drawImage(image.getImage(), box.x, box.y, box.x + box.width - 1, box.y + box.height - 1, image);
            }
        }
    }
}

