/*
 * Decompiled with CFR 0.152.
 */
package com.sas.beans;

import com.sas.ComponentException;
import com.sas.RunningObjectTable;
import com.sas.beans.BaseCustomizerUtil;
import com.sas.beans.RB;
import com.sas.swing.visuals.SwingCustomizerDialog;
import com.sas.text.Message;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.beans.Customizer;

public class SwingCustomizerUtil
extends BaseCustomizerUtil {
    public static SwingCustomizerDialog getCustomizerDialog(Object bean, Component customizer, Frame frame, boolean useSuperclass) {
        String title;
        boolean customizerPassedIn = true;
        if (customizer == null) {
            if (bean == null) {
                throw new ComponentException(RB.getStringResource((String)"CustomizerUtil.getCustomizerDialog.ex.txt"));
            }
            customizerPassedIn = false;
            customizer = SwingCustomizerUtil.getCustomizer((Object)bean, (boolean)useSuperclass);
            if (customizer == null) {
                return null;
            }
        }
        if (bean != null) {
            String titleMessage;
            Class<?> beanClass = bean.getClass();
            String className = beanClass.getName();
            if (bean instanceof Object[]) {
                className = beanClass.getName();
                className = className.substring(2);
                className = className.substring(0, className.length() - 1);
                titleMessage = RB.getStringResource((String)"CustomizerUtil.getCustomizerDialog.arrayTitle.txt");
            } else {
                titleMessage = RB.getStringResource((String)"CustomizerUtil.getCustomizerDialog.nonArrayTitle.txt");
            }
            title = Message.format((String)titleMessage, (Object)className);
        } else {
            title = customizer.getClass().getName();
        }
        String componentName = RunningObjectTable.lookupComponentName((Object)bean);
        if (componentName != null) {
            title = title + " - " + componentName;
        }
        SwingCustomizerDialog dialog = new SwingCustomizerDialog(customizer, bean, title, frame);
        if (!customizerPassedIn && customizer instanceof Customizer) {
            ((Customizer)((Object)customizer)).setObject(bean);
        }
        dialog.pack();
        Dimension dialogPreferredSize = dialog.getPreferredSize();
        dialogPreferredSize.width += 30;
        dialogPreferredSize.height += 30;
        dialog.setSize(dialogPreferredSize);
        dialog.invalidate();
        dialog.validate();
        return dialog;
    }

    public static SwingCustomizerDialog getCustomizerDialog(Object bean, Component customizer, Frame frame) {
        return SwingCustomizerUtil.getCustomizerDialog(bean, customizer, frame, false);
    }

    public static SwingCustomizerDialog customize(Object bean, Component customizer, Frame frame, boolean modal) {
        SwingCustomizerDialog dialog = SwingCustomizerUtil.getCustomizerDialog(bean, customizer, frame);
        if (dialog != null) {
            dialog.setModal(modal);
            dialog.setVisible(true);
        }
        return dialog;
    }

    public static SwingCustomizerDialog customize(Object bean, Frame frame, boolean modal) {
        Component customizer = SwingCustomizerUtil.getCustomizer((Object)bean);
        if (customizer != null) {
            if (customizer instanceof Customizer) {
                ((Customizer)((Object)customizer)).setObject(bean);
            }
            return SwingCustomizerUtil.customize(bean, customizer, frame, modal);
        }
        return null;
    }

    public static SwingCustomizerDialog customize(Object bean) {
        return SwingCustomizerUtil.customize(bean, null, true);
    }
}

