/*
 * Decompiled with CFR 0.152.
 */
package com.sas.awt.print;

import com.sas.awt.print.Book;
import com.sas.awt.print.PageFormat;
import com.sas.awt.print.PageableInterface;
import com.sas.awt.print.Paper;
import com.sas.awt.print.PrintException;
import com.sas.awt.print.PrintGraphics;
import com.sas.awt.print.PrintJob;
import com.sas.awt.print.PrintableInterface;
import com.sas.awt.print.TOCInterface;
import com.sas.awt.print.TOCItem;
import com.sas.collection.OrderedCollection;
import com.sas.collection.OrderedCollectionInterface;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.print.PrinterException;

class PrintJobImpl
extends PrintJob {
    Toolkit mToolkit = Toolkit.getDefaultToolkit();
    PrintGraphics pGraphics;
    PrintableInterface mPrintableInterface;
    PageFormat mPageFormat;
    PageableInterface mPageableInterface;
    int mCurrentPageNumber;
    OrderedCollection mTOC;
    private int logicalPageNumber = 1;
    private int printableIndex = 0;
    private PrintableInterface currentPrintableObj;
    private PageFormat currentPageFormatObj;
    private boolean hasMoreToPrint = false;
    private int prevIndex = -1;

    public PrintJobImpl(PrintGraphics graphics) {
        this.pGraphics = graphics;
    }

    @Override
    public synchronized void setPrintable(PrintableInterface printable) {
        this.setPrintable(printable, new PageFormat());
    }

    @Override
    public synchronized void setPrintable(PrintableInterface printable, PageFormat format) {
        if (this.mPrintableInterface != null || this.mPageableInterface != null) {
            throw new IllegalStateException("Cannot reuse PrintJob");
        }
        this.mPrintableInterface = printable;
        this.mPageFormat = format;
    }

    @Override
    public void setPageable(PageableInterface document) throws NullPointerException {
        if (this.mPrintableInterface != null || this.mPageableInterface != null) {
            throw new IllegalStateException("Cannot reuse PrintJob");
        }
        if (document == null) {
            throw new NullPointerException();
        }
        this.mPageableInterface = document;
        if (document instanceof TOCInterface) {
            this.mTOC = new OrderedCollection();
            TOCInterface toc = (TOCInterface)document;
            int count = toc.getNumberOfPages();
            for (int i = 0; i < count; ++i) {
                this.mTOC.add((Object)toc.getTOCItem(i));
            }
        }
    }

    @Override
    public void print() throws PrintException {
        if (this.mCurrentPageNumber >= 1) {
            throw new IllegalStateException("Cannot reuse PrintJob");
        }
        this.mCurrentPageNumber = 1;
        if (this.mPageableInterface != null) {
            if (this.mPageableInterface instanceof TOCInterface) {
                OrderedCollectionInterface tocs = ((TOCInterface)this.mPageableInterface).getTOCItems();
                boolean foundOne = false;
                for (int j = 0; j < tocs.count(); ++j) {
                    TOCItem t = (TOCItem)((Object)tocs.get(j));
                    if (t == null) continue;
                    foundOne = true;
                    this.pGraphics.beginDocument(true);
                    break;
                }
                if (!foundOne) {
                    this.pGraphics.beginDocument();
                }
            } else {
                this.pGraphics.beginDocument();
            }
            int i = 0;
            while (true) {
                TOCItem item;
                PrintableInterface p = null;
                try {
                    p = this.mPageableInterface.getPrintable(i);
                }
                catch (IndexOutOfBoundsException e) {
                    break;
                }
                if (this.mPageableInterface instanceof TOCInterface && (item = ((TOCInterface)this.mPageableInterface).getTOCItem(i)) != null) {
                    item.setPageNumber(this.mCurrentPageNumber);
                }
                this.printImpl(p, this.mPageableInterface.getPageFormat(i));
                ++i;
            }
            this.pGraphics.endDocument((OrderedCollectionInterface)this.mTOC);
        } else if (this.mPrintableInterface != null) {
            this.pGraphics.beginDocument();
            this.printImpl(this.mPrintableInterface, this.mPageFormat);
            this.pGraphics.endDocument(null);
        } else {
            throw new PrintException("Nothing to print");
        }
    }

    @Override
    public PageFormat defaultPage(PageFormat page) {
        PageFormat defPage = new PageFormat();
        PageFormat newPage = (PageFormat)page.clone();
        newPage.setPaper(new Paper());
        newPage.setOrientation(defPage.getOrientation());
        newPage.setTopMargin(defPage.getTopMargin());
        newPage.setBottomMargin(defPage.getBottomMargin());
        newPage.setLeftMargin(defPage.getLeftMargin());
        newPage.setRightMargin(defPage.getRightMargin());
        return newPage;
    }

    protected void printImpl(PrintableInterface printable, PageFormat format) throws PrintException {
        Point translatePt = new Point(0, 0);
        Dimension paperSize = new Dimension(0, 0);
        Dimension paperDim = new Dimension(0, 0);
        Dimension pageDim = new Dimension(0, 0);
        PrintGraphics g = this.pGraphics;
        printable.printInitialize(g);
        int logicalPageNumber = 1;
        while (logicalPageNumber == 1 || printable.pageExists(logicalPageNumber)) {
            Paper paper = format.getPaper();
            boolean landscape = format.getOrientation() == 0;
            paperSize.width = (int)paper.getWidth();
            paperSize.height = (int)paper.getHeight();
            this.swapIfLandscape(paperSize, landscape);
            this.pGraphics.beginPage(paperSize.width, paperSize.height);
            paperDim.width = (int)paper.getImageableWidth();
            paperDim.height = (int)paper.getImageableHeight();
            this.swapIfLandscape(paperDim, landscape);
            pageDim.width = (int)format.getImageableWidth();
            pageDim.height = (int)format.getImageableHeight();
            PrintableInterface p = format.getHeader();
            Rectangle aBounds = p != null ? p.getPageBounds(g, 1, paperDim.width, paperDim.height) : new Rectangle(0, 0, (int)format.getHeaderImageableWidth(), (int)format.getHeaderImageableHeight());
            int headerHeight = Math.max(aBounds.height, (int)format.getHeaderImageableHeight());
            p = format.getFooter();
            aBounds = p != null ? p.getPageBounds(g, 1, paperDim.width, paperDim.height) : new Rectangle(0, 0, (int)format.getFooterImageableWidth(), (int)format.getFooterImageableHeight());
            int footerHeight = Math.max(aBounds.height, (int)format.getFooterImageableHeight());
            pageDim.height = Math.max(0, paperDim.height - headerHeight - footerHeight);
            Point pt = null;
            Dimension dim = null;
            if (printable.pageExists(logicalPageNumber)) {
                translatePt.x = (int)format.getImageableX();
                translatePt.y = (int)paper.getImageableY() + headerHeight;
                pt = this.convertToPixels(translatePt);
                dim = this.convertToPixels(pageDim);
                Graphics bg = g.create(pt.x, pt.y, dim.width, dim.height);
                p = format.getUnderlay();
                if (p != null) {
                    p.print(bg, this.mCurrentPageNumber, dim.width, dim.height);
                }
                printable.print(bg, logicalPageNumber, dim.width, dim.height);
                p = format.getOverlay();
                if (p != null) {
                    p.printInitialize(bg);
                    p.print(bg, this.mCurrentPageNumber, dim.width, dim.height);
                    p.printFinalize();
                }
                bg.dispose();
            }
            if ((p = format.getHeader()) != null) {
                int headerWidth = Math.min((int)format.getHeaderImageableWidth(), pageDim.width);
                translatePt.x = (int)format.getHeaderImageableX() + ((int)format.getHeaderImageableWidth() - headerWidth) / 2;
                translatePt.y = (int)format.getHeaderImageableY();
                pt = this.convertToPixels(translatePt);
                headerWidth = this.convertToPixels(headerWidth);
                Graphics hg = g.create(pt.x, pt.y, headerWidth, this.convertToPixels(headerHeight));
                p.printInitialize(hg);
                p.print(hg, this.mCurrentPageNumber, headerWidth, this.convertToPixels(headerHeight));
                p.printFinalize();
                hg.dispose();
            }
            if ((p = format.getFooter()) != null) {
                int footerWidth = Math.min((int)format.getFooterImageableWidth(), pageDim.width);
                translatePt.x = (int)format.getFooterImageableX() + ((int)format.getFooterImageableWidth() - footerWidth) / 2;
                translatePt.y = headerHeight + pageDim.height + (int)paper.getImageableY();
                pt = this.convertToPixels(translatePt);
                pageDim.width = (int)format.getFooterImageableWidth();
                footerWidth = this.convertToPixels(footerWidth);
                Graphics fg = g.create(pt.x, pt.y, footerWidth, this.convertToPixels(footerHeight));
                p.printInitialize(fg);
                p.print(fg, this.mCurrentPageNumber, footerWidth, this.convertToPixels(footerHeight));
                p.printFinalize();
                fg.dispose();
            }
            this.pGraphics.endPage();
            if (pageDim.width <= 0 || pageDim.height <= 0) break;
            ++logicalPageNumber;
            ++this.mCurrentPageNumber;
            if (format.getNextPageFormat() == null) continue;
            format = format.getNextPageFormat();
        }
        printable.printFinalize();
    }

    @Override
    public int print(Graphics graphics, java.awt.print.PageFormat pageFormat, int pageIndex) throws PrinterException {
        PrintableInterface printable = null;
        PageFormat sasPageFormat = null;
        int numberOfPages = ((Book)this.mPageableInterface).getNumberOfPages();
        if (this.prevIndex != pageIndex) {
            if (this.printableIndex >= numberOfPages) {
                this.printableIndex = 0;
                this.prevIndex = -1;
                return 1;
            }
            this.prevIndex = pageIndex;
            return 0;
        }
        try {
            Graphics tg;
            if (this.hasMoreToPrint) {
                printable = this.currentPrintableObj;
                sasPageFormat = this.currentPageFormatObj.getNextPageFormat();
                if (sasPageFormat == null) {
                    sasPageFormat = this.currentPageFormatObj;
                }
            } else {
                this.logicalPageNumber = 1;
                printable = this.mPageableInterface.getPrintable(this.printableIndex);
                sasPageFormat = this.mPageableInterface.getPageFormat(this.printableIndex);
            }
            this.mCurrentPageNumber = pageIndex + 1;
            Point translatePt = new Point(0, 0);
            Dimension paperSize = new Dimension(0, 0);
            Dimension paperDim = new Dimension(0, 0);
            Dimension pageDim = new Dimension(0, 0);
            Paper paper = sasPageFormat.getPaper();
            boolean landscape = sasPageFormat.getOrientation() == 0;
            paperDim.width = (int)paper.getImageableWidth();
            paperDim.height = (int)paper.getImageableHeight();
            this.swapIfLandscape(paperDim, landscape);
            pageDim.width = (int)sasPageFormat.getImageableWidth();
            pageDim.height = (int)sasPageFormat.getImageableHeight();
            if (landscape) {
                graphics.translate((int)paper.getImageableY(), (int)paper.getImageableX());
            } else {
                graphics.translate((int)paper.getImageableX(), (int)paper.getImageableY());
            }
            graphics.setClip(0, 0, paperDim.width, paperDim.height);
            PrintableInterface p = sasPageFormat.getHeader();
            Rectangle aBounds = new Rectangle();
            if (p != null) {
                aBounds = p.getPageBounds(graphics, 1, paperDim.width, paperDim.height);
            }
            int headerHeight = Math.max(aBounds.height, (int)sasPageFormat.getTopMargin().getMagnitude((Object)"pt"));
            p = sasPageFormat.getFooter();
            aBounds.setBounds(0, 0, 0, 0);
            if (p != null) {
                aBounds = p.getPageBounds(graphics, 1, paperDim.width, paperDim.height);
            }
            int footerHeight = Math.max(aBounds.height, (int)sasPageFormat.getBottomMargin().getMagnitude((Object)"pt"));
            pageDim.height = Math.max(0, paperDim.height - headerHeight - footerHeight);
            translatePt.x = (int)sasPageFormat.getLeftMargin().getMagnitude((Object)"pt");
            translatePt.y = headerHeight;
            Graphics bg = graphics.create(translatePt.x, translatePt.y, pageDim.width, pageDim.height);
            if (!this.hasMoreToPrint) {
                printable.printInitialize(bg);
            }
            if ((p = sasPageFormat.getUnderlay()) != null) {
                p.print(bg, this.mCurrentPageNumber, pageDim.width, pageDim.height);
            }
            printable.print(bg, this.logicalPageNumber, pageDim.width, pageDim.height);
            p = sasPageFormat.getOverlay();
            if (p != null) {
                p.printInitialize(bg);
                p.print(bg, this.mCurrentPageNumber, pageDim.width, pageDim.height);
                p.printFinalize();
            }
            bg.dispose();
            p = sasPageFormat.getHeader();
            if (p != null) {
                int headerWidth = Math.min((int)sasPageFormat.getHeaderImageableWidth(), pageDim.width);
                translatePt.x = ((int)sasPageFormat.getHeaderImageableWidth() - headerWidth) / 2;
                tg = graphics.create(translatePt.x, 0, headerWidth, headerHeight);
                p.printInitialize(tg);
                p.print(tg, this.mCurrentPageNumber, headerWidth, headerHeight);
                p.printFinalize();
                tg.dispose();
            }
            if ((p = sasPageFormat.getFooter()) != null) {
                int footerWidth = Math.min((int)sasPageFormat.getFooterImageableWidth(), pageDim.width);
                translatePt.x = ((int)sasPageFormat.getFooterImageableWidth() - footerWidth) / 2;
                translatePt.y = headerHeight + pageDim.height;
                tg = graphics.create(translatePt.x, translatePt.y, footerWidth, footerHeight);
                p.printInitialize(tg);
                p.print(tg, this.mCurrentPageNumber, footerWidth, footerHeight);
                p.printFinalize();
                tg.dispose();
            }
            if (printable.pageExists(this.mCurrentPageNumber + 1)) {
                this.hasMoreToPrint = true;
                this.currentPrintableObj = printable;
                this.currentPageFormatObj = sasPageFormat;
                ++this.logicalPageNumber;
            } else {
                ++this.printableIndex;
                printable.printFinalize();
                this.hasMoreToPrint = false;
            }
        }
        catch (PrintException pe) {
            throw new PrinterException(pe.toString());
        }
        return 0;
    }

    protected void swapIfLandscape(Dimension dim, boolean landscape) {
        if (landscape) {
            int swap = dim.width;
            dim.width = dim.height;
            dim.height = swap;
        }
    }

    protected final Dimension convertToPixels(Dimension dim) {
        return new Dimension((int)((double)dim.width * (double)this.pGraphics.getPageResolutionHorizontal() / 72.0), (int)((double)dim.height * (double)this.pGraphics.getPageResolutionVertical() / 72.0));
    }

    protected final Point convertToPixels(Point pt) {
        return new Point((int)((double)pt.x * (double)this.pGraphics.getPageResolutionHorizontal() / 72.0), (int)((double)pt.y * (double)this.pGraphics.getPageResolutionVertical() / 72.0));
    }

    protected final int convertToPixels(int pt) {
        return (int)((double)pt * (double)this.pGraphics.getPageResolutionVertical() / 72.0);
    }
}

