/*
 * Decompiled with CFR 0.152.
 */
package com.sas.awt.print;

import com.sas.awt.print.RB;
import com.sas.measures.Length;
import java.io.Serializable;

public class Paper
implements Cloneable,
Serializable {
    static final long serialVersionUID = -1199984620885897369L;
    public static final int PPI = 72;
    public static final int LETTER = 0;
    public static final int LEGAL = 1;
    public static final int A4 = 2;
    public static final int A5 = 3;
    private static final double QUARTER_INCH = 18.0;
    private static final double LETTER_WIDTH = 612.0;
    private static final double LETTER_HEIGHT = 792.0;
    private double mHeight;
    private double mWidth;
    private double mImageableX;
    private double mImageableY;
    private double mImageableWidth;
    private double mImageableHeight;
    static Length[][] sizes = new Length[][]{{new Length(8.5, "in"), new Length(11.0, "in")}, {new Length(8.5, "in"), new Length(14.0, "in")}, {new Length(8.27, "in"), new Length(11.69, "in")}, {new Length(5.83, "in"), new Length(8.27, "in")}};

    public Paper() {
        this(Paper.getDefaultPaperType());
    }

    public Paper(int type) {
        this(sizes[type][0], sizes[type][1]);
    }

    public Paper(Length width, Length height) {
        this.setSize(width, height);
        this.setImageableArea(18.0, 18.0, this.getWidth() - 36.0, this.getHeight() - 36.0);
    }

    public Object clone() {
        Paper newPaper;
        try {
            newPaper = (Paper)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            newPaper = null;
        }
        return newPaper;
    }

    public double getHeight() {
        return this.mHeight;
    }

    public void setSize(double width, double height) {
        this.mWidth = width;
        this.mHeight = height;
    }

    public void setSize(Length width, Length height) {
        this.setSize(width.getMagnitude((Object)"pt"), height.getMagnitude((Object)"pt"));
    }

    public double getWidth() {
        return this.mWidth;
    }

    public void setImageableArea(double x, double y, double width, double height) {
        this.mImageableX = x;
        this.mImageableY = y;
        this.mImageableWidth = width;
        this.mImageableHeight = height;
    }

    public void setImageableArea(Length x, Length y, Length width, Length height) {
        this.setImageableArea(x.getMagnitude((Object)"pt"), y.getMagnitude((Object)"pt"), width.getMagnitude((Object)"pt"), height.getMagnitude((Object)"pt"));
    }

    public double getImageableX() {
        return this.mImageableX;
    }

    public double getImageableY() {
        return this.mImageableY;
    }

    public double getImageableWidth() {
        return this.mImageableWidth;
    }

    public double getImageableHeight() {
        return this.mImageableHeight;
    }

    public static int getDefaultPaperType() {
        String typeString = RB.getStringResource("DefaultPaperForm.txt");
        String[] types = new String[]{RB.getStringResource("Letter.txt"), RB.getStringResource("Legal.txt"), RB.getStringResource("A4.txt"), RB.getStringResource("A5.txt")};
        int type = 0;
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equals(typeString)) continue;
            type = i;
            break;
        }
        return type;
    }
}

