/*
 * Decompiled with CFR 0.152.
 */
package com.sas.awt.print;

import com.sas.awt.print.Paper;
import com.sas.awt.print.PrintableInterface;
import com.sas.measures.Length;
import java.io.Serializable;

public class PageFormat
implements Cloneable,
Serializable {
    static final long serialVersionUID = -4645951757617940464L;
    public static final int LANDSCAPE = 0;
    public static final int PORTRAIT = 1;
    private Paper mPaper = new Paper();
    private int mOrientation = 1;
    private PrintableInterface mHeader;
    private PrintableInterface mFooter;
    private PrintableInterface mUnderlay;
    private PrintableInterface mOverlay;
    private Length mTopMargin = new Length(1.0, "in");
    private Length mBottomMargin = new Length(0.5, "in");
    private Length mLeftMargin = new Length(0.5, "in");
    private Length mRightMargin = new Length(0.5, "in");
    private PageFormat mNextPageFormat;

    public PageFormat() {
        this(1);
    }

    public PageFormat(int orientation) {
        this.setOrientation(orientation);
    }

    public Object clone() {
        PageFormat newPage;
        try {
            newPage = (PageFormat)super.clone();
            newPage.mPaper = (Paper)this.mPaper.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            newPage = null;
        }
        return newPage;
    }

    public double getWidth() {
        return this.getOrientation() == 1 ? this.mPaper.getWidth() : this.mPaper.getHeight();
    }

    public double getHeight() {
        return this.getOrientation() == 1 ? this.mPaper.getHeight() : this.mPaper.getWidth();
    }

    public double getImageableX() {
        switch (this.getOrientation()) {
            case 0: {
                double x = this.mPaper.getHeight() - (this.mPaper.getImageableY() + this.mPaper.getImageableHeight());
                break;
            }
            case 1: {
                double x = this.mPaper.getImageableX();
                break;
            }
            default: {
                throw new InternalError("unrecognized orientation");
            }
        }
        return x += this.getLeftMargin().getMagnitude((Object)"pt");
    }

    public double getImageableY() {
        switch (this.getOrientation()) {
            case 0: {
                double y = this.mPaper.getImageableX();
                break;
            }
            case 1: {
                double y = this.mPaper.getImageableY();
                break;
            }
            default: {
                throw new InternalError("unrecognized orientation");
            }
        }
        return y += this.getTopMargin().getMagnitude((Object)"pt");
    }

    public double getImageableWidth() {
        double width = this.mPaper.getImageableWidth();
        if (this.getOrientation() == 0) {
            width = this.mPaper.getImageableHeight();
        }
        width -= this.getLeftMargin().getMagnitude((Object)"pt");
        return width -= this.getRightMargin().getMagnitude((Object)"pt");
    }

    public double getImageableHeight() {
        double height = this.mPaper.getImageableHeight();
        if (this.getOrientation() == 0) {
            height = this.mPaper.getImageableWidth();
        }
        height -= this.getTopMargin().getMagnitude((Object)"pt");
        return height -= this.getBottomMargin().getMagnitude((Object)"pt");
    }

    public Paper getPaper() {
        return (Paper)this.mPaper.clone();
    }

    public void setPaper(Paper paper) {
        this.mPaper = paper;
    }

    public void setOrientation(int orientation) throws IllegalArgumentException {
        if (orientation != 1 && orientation != 0) {
            throw new IllegalArgumentException();
        }
        this.mOrientation = orientation;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public void setHeader(PrintableInterface header) {
        this.mHeader = header;
    }

    public PrintableInterface getHeader() {
        return this.mHeader;
    }

    public void setFooter(PrintableInterface footer) {
        this.mFooter = footer;
    }

    public PrintableInterface getFooter() {
        return this.mFooter;
    }

    public void setUnderlay(PrintableInterface underlay) {
        this.mUnderlay = underlay;
    }

    public PrintableInterface getUnderlay() {
        return this.mUnderlay;
    }

    public void setOverlay(PrintableInterface overlay) {
        this.mOverlay = overlay;
    }

    public PrintableInterface getOverlay() {
        return this.mOverlay;
    }

    public void setTopMargin(Length margin) {
        this.mTopMargin = margin;
    }

    public Length getTopMargin() {
        return this.mTopMargin;
    }

    public void setBottomMargin(Length margin) {
        this.mBottomMargin = margin;
    }

    public Length getBottomMargin() {
        return this.mBottomMargin;
    }

    public void setLeftMargin(Length margin) {
        this.mLeftMargin = margin;
    }

    public Length getLeftMargin() {
        return this.mLeftMargin;
    }

    public void setRightMargin(Length margin) {
        this.mRightMargin = margin;
    }

    public Length getRightMargin() {
        return this.mRightMargin;
    }

    public void setNextPageFormat(PageFormat pageFormat) {
        this.mNextPageFormat = pageFormat;
    }

    public PageFormat getNextPageFormat() {
        return this.mNextPageFormat;
    }

    protected double getHeaderImageableX() {
        return this.mPaper.getImageableX();
    }

    protected double getHeaderImageableY() {
        return this.mPaper.getImageableY();
    }

    protected double getHeaderImageableWidth() {
        return this.getOrientation() == 1 ? this.mPaper.getImageableWidth() : this.mPaper.getImageableHeight();
    }

    protected double getHeaderImageableHeight() {
        return Math.max(0.0, this.getTopMargin().getMagnitude((Object)"pt"));
    }

    protected double getFooterImageableX() {
        return this.mPaper.getImageableX();
    }

    protected double getFooterImageableY() {
        return this.getImageableY() + this.getImageableHeight();
    }

    protected double getFooterImageableWidth() {
        return this.getHeaderImageableWidth();
    }

    protected double getFooterImageableHeight() {
        return Math.max(0.0, this.getBottomMargin().getMagnitude((Object)"pt"));
    }
}

