/*
 * Decompiled with CFR 0.152.
 */
package com.sas.awt.print;

import com.sas.awt.print.MultiPagePrintLayoutConstraints;
import com.sas.awt.print.PrintException;
import com.sas.awt.print.PrintLayout;
import com.sas.awt.print.PrintScrollInterface;
import com.sas.awt.print.PrintableInterface;
import com.sas.collection.OrderedCollection;
import com.sas.measures.Length;
import com.sas.util.Comparator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;

public class MultiPagePrintLayout
implements PrintLayout {
    protected static final Length VerticalMargin = new Length(0.25, "in");
    protected OrderedCollection m_components = new OrderedCollection();
    protected Printable m_lastScrollable;
    protected int m_lastScrollablePageNo;
    protected int m_pageNumberDifference;
    private boolean m_moveFollowingComps = true;
    private boolean m_expandScrollable = true;
    protected boolean m_needLayout;
    protected boolean m_sorted;
    private List m_compList;

    protected void finalize() {
        this.m_components.removeAll();
    }

    @Override
    public void add(Component comp) throws IllegalArgumentException {
        this.add(comp, new MultiPagePrintLayoutConstraints());
        this.m_sorted = false;
    }

    @Override
    public void add(Component comp, Object constraint) throws IllegalArgumentException {
        if (!(comp instanceof PrintableInterface)) {
            throw new IllegalArgumentException();
        }
        if (!(constraint instanceof MultiPagePrintLayoutConstraints)) {
            throw new IllegalArgumentException();
        }
        this.m_components.add((Object)new Printable((PrintableInterface)((Object)comp), (MultiPagePrintLayoutConstraints)constraint));
        this.m_sorted = false;
    }

    @Override
    public void remove(Component comp) {
        Enumeration enumer = this.m_components.getItems();
        while (enumer.hasMoreElements()) {
            Printable printable = (Printable)enumer.nextElement();
            if (printable.mPrintable != comp) continue;
            this.m_components.remove((Object)printable);
            break;
        }
        this.m_sorted = false;
    }

    @Override
    public void printInitialize(Graphics graphics) throws PrintException {
        this.m_needLayout = true;
        this.sortComponents();
    }

    protected List createComponentList() {
        ArrayList<Printable> altList = new ArrayList<Printable>();
        ArrayList<Printable> compList = new ArrayList<Printable>();
        int count = this.m_components.count();
        for (int i = 0; i < count; ++i) {
            Printable comp = (Printable)this.m_components.get(i);
            if (this.getMoveFollowingComponents() && comp.isScrollable()) {
                Rectangle origBounds = comp.getPrintBounds();
                ArrayList<Printable> followingList = new ArrayList<Printable>();
                for (int j = 0; j < count; ++j) {
                    Printable altComp = (Printable)this.m_components.get(j);
                    if (!this.isFollowingComponent(altComp, origBounds)) continue;
                    Rectangle compBounds = altComp.getPrintBounds();
                    int offset = compBounds.y - (int)origBounds.getMaxY();
                    altComp.setOffset(offset);
                    altList.add(altComp);
                    followingList.add(altComp);
                }
                comp.setFollowingComponents(followingList);
            }
            if (altList.contains(comp)) continue;
            compList.add(comp);
        }
        return compList;
    }

    private boolean isFollowingComponent(Printable comp, Rectangle origBounds) {
        Rectangle compBounds = comp.getPrintBounds();
        Point endPt = new Point((int)compBounds.getMaxX(), (int)compBounds.getMaxY());
        int startPtOut = origBounds.outcode(compBounds.getX(), compBounds.getY());
        int endPtOut = origBounds.outcode(endPt.getX(), endPt.getY());
        Rectangle intersectRect = new Rectangle(origBounds.x - 1, origBounds.y - 1, origBounds.width + 2, origBounds.height + 2);
        return comp.isSingle() && !comp.isScrollable() && !comp.isStatic() && (this.isOnSide(8, startPtOut) && this.isOnSide(8, endPtOut) || compBounds.intersects(intersectRect) && (this.isOnSide(8, startPtOut) || this.isOnSide(8, endPtOut)));
    }

    protected void sortComponents() {
        if (!this.m_sorted) {
            this.m_components.sort(new Comparator(){

                public int compare(Object first, Object second) {
                    Rectangle bounds1 = ((Printable)first).getPrintBounds();
                    Rectangle bounds2 = ((Printable)second).getPrintBounds();
                    int value = 0;
                    value = bounds1.y < bounds2.y ? -1 : (bounds1.y == bounds2.y ? (bounds1.x < bounds2.x ? -1 : (bounds1.x == bounds2.x ? 0 : 1)) : 1);
                    return value;
                }
            });
            this.m_sorted = true;
        }
    }

    private boolean isOnSide(int code, int outcode) {
        return (outcode & code) == code;
    }

    private boolean isOnlyOnSide(int code, int outcode) {
        return outcode != 0 && (outcode | code) == code;
    }

    private int getExpansionDistance(Printable scrollComp, int direction, List componentList) {
        Rectangle origBounds = scrollComp.getPrintBounds();
        Line2D.Double areaEdge = null;
        int areaCode = 0;
        if (direction == 1) {
            areaEdge = new Line2D.Double(0.0, origBounds.getMinY(), origBounds.getMaxX(), origBounds.getMinY());
            areaCode = 2;
        } else if (direction == 3) {
            areaEdge = new Line2D.Double(0.0, origBounds.getMaxY(), origBounds.getMaxX(), origBounds.getMaxY());
            areaCode = 8;
        } else if (direction == 2) {
            areaEdge = new Line2D.Double(origBounds.getMinX(), 0.0, origBounds.getMinX(), origBounds.getMaxY());
            areaCode = 1;
        } else if (direction == 4) {
            areaEdge = new Line2D.Double(origBounds.getMaxX(), 0.0, origBounds.getMaxX(), origBounds.getMaxY());
            areaCode = 4;
        } else {
            throw new IllegalArgumentException(" Direction must be specified.");
        }
        int minDist = -1;
        for (Printable comp : componentList) {
            if (comp == scrollComp) continue;
            Rectangle compBounds = comp.getPrintBounds();
            Point endPt = new Point((int)compBounds.getMaxX(), (int)compBounds.getMaxY());
            int startPtOut = origBounds.outcode(compBounds.getX(), compBounds.getY());
            int endPtOut = origBounds.outcode(endPt.getX(), endPt.getY());
            Rectangle intersectRect = new Rectangle(origBounds.x - 1, origBounds.y - 1, origBounds.width + 2, origBounds.height + 2);
            if (compBounds.intersects(intersectRect) && (this.isOnSide(areaCode, startPtOut) || this.isOnSide(areaCode, endPtOut))) {
                return 0;
            }
            if (!this.isOnlyOnSide(areaCode, startPtOut & endPtOut)) continue;
            Point closestPt = endPt;
            if (direction == 3 || direction == 4) {
                closestPt = compBounds.getLocation();
            }
            int distance = (int)areaEdge.ptLineDist(closestPt);
            if (minDist == -1) {
                minDist = distance;
                continue;
            }
            if (distance >= minDist) continue;
            minDist = distance;
        }
        return minDist;
    }

    private void expandComponent(Printable comp, int direction, List componentList, int pageWidth, int pageHeight) {
        int amount = this.getExpansionDistance(comp, direction, componentList);
        Rectangle bounds = comp.getPrintBounds();
        int margin = (int)VerticalMargin.getMagnitude((Object)"px");
        if (amount == 0 || amount <= margin && amount != -1) {
            return;
        }
        if (amount != -1) {
            amount -= margin;
        }
        if (direction == 4) {
            if (amount == -1) {
                amount = pageWidth - (bounds.x + bounds.width);
            }
            bounds.width += amount;
        } else if (direction == 2) {
            if (amount == -1) {
                amount = bounds.x;
            }
            bounds.x -= amount;
            if (bounds.x < 0) {
                amount = -bounds.x;
                bounds.x = 0;
            }
            bounds.width += amount;
        } else if (direction == 1) {
            if (amount == -1) {
                amount = bounds.y;
            }
            bounds.y -= amount;
            if (bounds.y < 0) {
                amount = -bounds.y;
                bounds.y = 0;
            }
            bounds.height += amount;
        } else if (direction == 3) {
            if (amount == -1) {
                amount = pageHeight - (bounds.y + bounds.height);
            }
            bounds.height += amount;
        }
        comp.setPrintBounds(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    protected void expandScrollableComponents(List componentList, int pageWidth, int pageHeight) {
        for (Printable comp : componentList) {
            if (!comp.isScrollable() || comp.isStatic()) continue;
            int[] expandDirections = comp.getExpandDirections();
            int directionCount = expandDirections.length;
            if (comp.isInitialized()) {
                int i;
                int nextScrollDirection = comp.nextPrintScrollDirection();
                int prevScrollDirection = comp.previousPrintScrollDirection();
                if (nextScrollDirection == 0) {
                    boolean verticalScrollNeeded = comp.isPrintScrollNeeded(1);
                    for (int i2 = 0; i2 < directionCount; ++i2) {
                        if (expandDirections[i2] == 1 || expandDirections[i2] == 3) {
                            if (verticalScrollNeeded) continue;
                            this.expandComponent(comp, expandDirections[i2], componentList, pageWidth, pageHeight);
                            continue;
                        }
                        this.expandComponent(comp, expandDirections[i2], componentList, pageWidth, pageHeight);
                    }
                    continue;
                }
                if (nextScrollDirection != 1) continue;
                for (i = 0; i < directionCount; ++i) {
                    if (expandDirections[i] != 1 && expandDirections[i] != 3) continue;
                    this.expandComponent(comp, expandDirections[i], componentList, pageWidth, pageHeight);
                }
                if (prevScrollDirection == nextScrollDirection || prevScrollDirection == -1 || nextScrollDirection == -1) continue;
                for (i = 0; i < directionCount; ++i) {
                    if (expandDirections[i] != 2 && expandDirections[i] != 4) continue;
                    this.expandComponent(comp, expandDirections[i], componentList, pageWidth, pageHeight);
                }
                continue;
            }
            for (int i = 0; i < directionCount; ++i) {
                if (expandDirections[i] == 1 || expandDirections[i] == 2) continue;
                this.expandComponent(comp, expandDirections[i], componentList, pageWidth, pageHeight);
            }
        }
    }

    @Override
    public void print(Graphics graphics, int pageNumber, int pageWidth, int pageHeight) throws PrintException {
        if (this.m_needLayout) {
            this.doLayout(this.m_components, pageWidth, pageHeight);
        }
        if (this.m_compList == null) {
            this.m_compList = this.createComponentList();
        }
        if (this.m_expandScrollable || pageNumber > 1) {
            this.expandScrollableComponents(this.m_compList, pageWidth, pageHeight);
        }
        boolean newPage = false;
        int pbOffset = 0;
        ArrayList<Printable> remainingCompList = new ArrayList<Printable>();
        Graphics pagePg = graphics.create(0, 0, pageWidth, pageHeight);
        ListIterator<Printable> compIterator = this.m_compList.listIterator();
        while (compIterator.hasNext()) {
            Printable comp = (Printable)compIterator.next();
            if (comp.isScrollable()) {
                this.printScrollable(comp, pagePg, pageWidth, pageHeight);
                if (comp.nextPageExists()) continue;
                comp.printFinalize();
                compIterator.remove();
                Rectangle printBounds = comp.getPrintBounds();
                int offset = printBounds.y + printBounds.height;
                List followingCompList = comp.getFollowingComponents();
                for (Printable followingComp : followingCompList) {
                    if (followingComp.isDonePrinting()) continue;
                    Rectangle pb = followingComp.getPrintBounds();
                    int newY = followingComp.getOffset() + offset;
                    if (!newPage) {
                        if (newY + pb.height < pageHeight) {
                            if (pageNumber == 1 && newY > pb.y || pageNumber != 1) {
                                followingComp.setPrintBounds(pb.x, newY, pb.width, pb.height);
                            }
                            remainingCompList.add(followingComp);
                            continue;
                        }
                        newPage = true;
                        pbOffset = pb.y;
                        followingComp.setPrintBounds(pb.x, 0, pb.width, pb.height);
                        compIterator.add(followingComp);
                        continue;
                    }
                    followingComp.setPrintBounds(pb.x, pb.y - pbOffset, pb.width, pb.height);
                    compIterator.add(followingComp);
                }
                continue;
            }
            comp.printInitialize(pagePg);
            comp.print(pagePg, 1, pageWidth, pageHeight);
            comp.printFinalize();
            if (!comp.isSingle()) continue;
            compIterator.remove();
        }
        for (Printable comp : remainingCompList) {
            comp.printInitialize(pagePg);
            comp.print(pagePg, 1, pageWidth, pageHeight);
            comp.printFinalize();
        }
        pagePg.dispose();
    }

    public boolean getMoveFollowingComponents() {
        return this.m_moveFollowingComps;
    }

    public void setMoveFollowingComponents(boolean moveComps) {
        this.m_moveFollowingComps = moveComps;
    }

    public boolean isExpandScrollableComponents() {
        return this.m_expandScrollable;
    }

    public void setExpandScrollableComponents(boolean expand) {
        this.m_expandScrollable = expand;
    }

    @Override
    public boolean pageExists(int pageNumber) {
        int count = this.m_components.count();
        for (int i = 0; i < count; ++i) {
            if (this.getPrintable(i).isDonePrinting()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void printFinalize() {
    }

    @Override
    public Panel getPrintOptionsPanel() {
        return null;
    }

    protected void printScrollable(Printable comp, Graphics g, int pageWidth, int pageHeight) throws PrintException {
        int offset;
        int lastY;
        if (!comp.isInitialized()) {
            comp.printInitialize(g);
        }
        Rectangle origBounds = comp.getPrintBounds();
        Rectangle bounds = null;
        int prevLastY = lastY = origBounds.y;
        int availHeight = origBounds.height;
        int currHeight = 0;
        boolean hasNextPage = false;
        do {
            comp.setPrintBounds(origBounds.x, lastY, origBounds.width, origBounds.height);
            comp.print(g, comp.lastPageIndex + 1, pageWidth, pageHeight);
            bounds = comp.getPageBounds(g, comp.lastPageIndex, pageWidth, pageHeight);
            currHeight = bounds.height;
            offset = currHeight + (int)VerticalMargin.getMagnitude((Object)"px");
            prevLastY = lastY;
            lastY += offset;
        } while ((hasNextPage = comp.nextPageExists()) && currHeight <= (availHeight -= offset));
        if (!hasNextPage) {
            comp.setPrintBounds(bounds.x, prevLastY, bounds.width, bounds.height);
        } else {
            comp.setPrintBounds(origBounds.x, origBounds.y, origBounds.width, origBounds.height);
        }
    }

    protected Printable getPrintable(int i) {
        return (Printable)this.m_components.get(i);
    }

    protected boolean haveNonScrollables() {
        int i;
        int count = this.m_components.count();
        for (i = 0; i < count && this.getPrintable(i).isScrollable(); ++i) {
        }
        return i < count;
    }

    protected boolean haveStatics() {
        int i;
        int count = this.m_components.count();
        for (i = 0; i < count && !this.getPrintable(i).isStatic(); ++i) {
        }
        return i < count;
    }

    protected void doLayout(OrderedCollection components, int pageWidth, int pageHeight) {
        Rectangle bounds;
        Printable comp;
        Point minXY = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
        Point maxXY = new Point(0, 0);
        int count = components.count();
        for (int i = 0; i < count; ++i) {
            comp = (Printable)components.get(i);
            bounds = comp.getPrintBounds();
            minXY.x = Math.min(minXY.x, bounds.x);
            minXY.y = Math.min(minXY.y, bounds.y);
            maxXY.x = Math.max(maxXY.x, bounds.x + bounds.width - 1);
            maxXY.y = Math.max(maxXY.y, bounds.y + bounds.height - 1);
        }
        double hRatio = (double)pageWidth / (double)(maxXY.x - minXY.x + 1);
        double vRatio = (double)pageHeight / (double)(maxXY.y - minXY.y + 1);
        for (int i = 0; i < count; ++i) {
            comp = (Printable)components.get(i);
            bounds = comp.getPrintBounds();
            int newWidth = bounds.width;
            int newHeight = bounds.height;
            if (comp.isScaleable()) {
                newWidth = (int)((double)newWidth * Math.min(hRatio, vRatio));
                newHeight = comp.isScaleablePreservingAspect() ? (int)((double)newWidth / (double)bounds.width * (double)bounds.height) : (int)((double)bounds.height * vRatio);
            }
            double xRatio = comp.isScaleable() ? hRatio : 1.0;
            double yRatio = comp.isScaleable() ? vRatio : 1.0;
            comp.setPrintBounds((int)((double)(bounds.x - minXY.x) * xRatio), (int)((double)(bounds.y - minXY.y) * yRatio), newWidth, newHeight);
        }
        this.m_needLayout = false;
    }

    @Override
    public Rectangle getPageBounds(Graphics g, int pageNumber, int pageWidth, int pageHeight) {
        return new Rectangle(0, 0, pageWidth, pageHeight);
    }

    protected class Printable
    implements PrintableInterface,
    PrintScrollInterface {
        PrintableInterface mPrintable;
        MultiPagePrintLayoutConstraints mConstraints;
        Rectangle mPrintBounds;
        boolean mDone;
        int lastPageIndex = 0;
        int maxCount = 0;
        int offset;
        boolean init = false;
        boolean intersecting;
        List compOffsetList;

        public Printable(PrintableInterface printable, MultiPagePrintLayoutConstraints constraints) {
            this.mPrintable = printable;
            this.mConstraints = constraints;
            Component comp = (Component)((Object)printable);
            Dimension size = comp.getSize();
            this.mPrintBounds = comp.getBounds();
            if (!(comp instanceof Frame)) {
                Rectangle bounds = comp.getParent().getBounds();
                this.mPrintBounds.x += bounds.x;
                this.mPrintBounds.y += bounds.y;
            }
        }

        public Rectangle getPrintBounds() {
            return new Rectangle(this.mPrintBounds);
        }

        public void setPrintBounds(int x, int y, int width, int height) {
            this.mPrintBounds.x = x;
            this.mPrintBounds.y = y;
            this.mPrintBounds.width = width;
            this.mPrintBounds.height = height;
        }

        @Override
        public void printInitialize(Graphics g) throws PrintException {
            this.mPrintable.printInitialize(g);
            this.init = true;
            this.mDone = false;
        }

        @Override
        public void print(Graphics g, int pageNumber, int pageWidth, int pageHeight) throws PrintException {
            Rectangle bounds = this.getPrintBounds();
            bounds.width = Math.min(bounds.width, pageWidth - bounds.x);
            bounds.height = Math.min(bounds.height, pageHeight - bounds.y);
            Graphics tg = g.create(bounds.x, bounds.y, bounds.width, bounds.height);
            this.mPrintable.print(tg, pageNumber, bounds.width, bounds.height);
            this.lastPageIndex = pageNumber;
            tg.dispose();
        }

        @Override
        public void printFinalize() {
            this.mPrintable.printFinalize();
            this.mDone = true;
            ++this.maxCount;
        }

        public boolean nextPageExists() {
            return this.pageExists(this.lastPageIndex + 1);
        }

        @Override
        public boolean pageExists(int pageNumber) {
            return this.mPrintable.pageExists(pageNumber);
        }

        @Override
        public Rectangle getPageBounds(Graphics g, int pageNumber, int pageWidth, int pageHeight) {
            Rectangle bounds = this.getPrintBounds();
            bounds.width = Math.min(bounds.width, pageWidth - bounds.x);
            bounds.height = Math.min(bounds.height, pageHeight - bounds.y);
            return this.mPrintable.getPageBounds(g, pageNumber, bounds.width, bounds.height);
        }

        @Override
        public Panel getPrintOptionsPanel() {
            return this.mPrintable.getPrintOptionsPanel();
        }

        @Override
        public int previousPrintScrollDirection() {
            if (this.mPrintable instanceof PrintScrollInterface) {
                return ((PrintScrollInterface)((Object)this.mPrintable)).previousPrintScrollDirection();
            }
            return -1;
        }

        @Override
        public int nextPrintScrollDirection() {
            if (this.mPrintable instanceof PrintScrollInterface) {
                return ((PrintScrollInterface)((Object)this.mPrintable)).nextPrintScrollDirection();
            }
            return -1;
        }

        @Override
        public boolean isPrintScrollNeeded(int direction) {
            if (this.mPrintable instanceof PrintScrollInterface) {
                return ((PrintScrollInterface)((Object)this.mPrintable)).isPrintScrollNeeded(direction);
            }
            return false;
        }

        int[] getExpandDirections() {
            return this.mConstraints.getExpandDirections();
        }

        void setOffset(int os) {
            this.offset = os;
        }

        int getOffset() {
            return this.offset;
        }

        void setFollowingComponents(List comps) {
            this.compOffsetList = comps;
        }

        List getFollowingComponents() {
            return this.compOffsetList;
        }

        boolean isStatic() {
            return this.mConstraints.getHowPrinted() == 2;
        }

        boolean isSingle() {
            return this.mConstraints.getHowPrinted() == 1;
        }

        boolean isScrollable() {
            return this.mConstraints.getHowPrinted() == 4;
        }

        public boolean isScaleable() {
            return this.mConstraints.getHowScaled() != 1;
        }

        public boolean isScaleablePreservingAspect() {
            return this.mConstraints.getHowScaled() == 4;
        }

        boolean isInitialized() {
            return this.init;
        }

        boolean isDonePrinting() {
            return this.mDone;
        }

        public String toString() {
            return this.mPrintable.toString();
        }
    }
}

