/*
 * Decompiled with CFR 0.152.
 */
package com.sas.awt.print;

import com.sas.awt.print.PageFormat;
import com.sas.awt.print.PrintableInterface;
import com.sas.awt.print.TOCInterface;
import com.sas.awt.print.TOCItem;
import com.sas.collection.OrderedCollection;
import com.sas.collection.OrderedCollectionInterface;

public class Book
implements TOCInterface {
    private OrderedCollection mFormats = new OrderedCollection();
    private OrderedCollection mPrintables = new OrderedCollection();
    private OrderedCollection mTOCItems = new OrderedCollection();

    @Override
    public int getNumberOfPages() {
        return this.mFormats.count();
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        return (PageFormat)this.mFormats.get(pageIndex);
    }

    @Override
    public PrintableInterface getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return (PrintableInterface)this.mPrintables.get(pageIndex);
    }

    @Override
    public TOCItem getTOCItem(int pageIndex) throws IndexOutOfBoundsException {
        return (TOCItem)((Object)this.mTOCItems.get(pageIndex));
    }

    @Override
    public OrderedCollectionInterface getTOCItems() {
        OrderedCollection copyTOCItems = new OrderedCollection();
        for (int i = 0; i < this.mTOCItems.count(); ++i) {
            copyTOCItems.add(this.mTOCItems.get(i));
        }
        return copyTOCItems;
    }

    public void setPage(int pageIndex, PrintableInterface printable, PageFormat page) throws IndexOutOfBoundsException {
        this.setPage(pageIndex, printable, page, null);
    }

    public void setPage(int pageIndex, PrintableInterface printable, PageFormat page, TOCItem item) throws IndexOutOfBoundsException {
        if (printable == null) {
            throw new NullPointerException("printable is null");
        }
        if (page == null) {
            throw new NullPointerException("page is null");
        }
        this.mFormats.set(pageIndex, (Object)page);
        this.mPrintables.set(pageIndex, (Object)printable);
        this.mTOCItems.set(pageIndex, (Object)item);
    }

    public void append(PrintableInterface printable, PageFormat page) {
        this.append(printable, page, null);
    }

    public void append(PrintableInterface printable, PageFormat page, TOCItem item) {
        this.mFormats.add((Object)page);
        this.mPrintables.add((Object)printable);
        this.mTOCItems.add((Object)item);
    }

    public void append(PrintableInterface printable, PageFormat page, int numPages) {
        int pageIndex = this.mFormats.count();
        int newSize = pageIndex + numPages;
        this.mFormats.setSize(newSize);
        this.mPrintables.setSize(newSize);
        for (int i = pageIndex; i < newSize; ++i) {
            this.mFormats.set(i, (Object)page);
            this.mPrintables.set(i, (Object)printable);
        }
    }
}

