/*
 * Decompiled with CFR 0.152.
 */
package com.sas.awt.print;

import com.sas.ComponentException;
import com.sas.ModelInterface;
import com.sas.RB;
import com.sas.awt.Canvas;
import com.sas.awt.print.Annotation;
import com.sas.awt.print.StaticAnnotationInterface;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.transforms.TransformInterface;
import com.sas.visuals.Alignment;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;

public class AnnotationView
extends Canvas
implements Alignment {
    static final long serialVersionUID = -4933079430362146802L;
    private static final String[] requiredInterfacesString = new String[]{"com.sas.awt.print.StaticAnnotationInterface"};
    protected static final Font defaultFont = new Font("serif", 0, 14);
    protected static final Color defaultColor = Color.black;
    protected StaticAnnotationInterface mAnnotation;
    protected int mPageNumber = 1;

    public AnnotationView() {
    }

    public AnnotationView(ModelInterface model) {
        this.attachModel(model);
    }

    @Override
    public synchronized void attachModel(ModelInterface model) {
        if (this.getModelInterface() != null) {
            throw new ComponentException(Message.format((String)RB.getStringResource((String)"ViewInterfaceSupport.attachMax.ex.txt"), (Object)this.getClass().getName(), (Object)new Integer(1)));
        }
        super.attachModel(model);
        this.mAnnotation = (StaticAnnotationInterface)model;
        if (this.mAnnotation instanceof Annotation) {
            ((Annotation)this.mAnnotation).addTransformInterface(Annotation.PAGE_VARIABLE, new TransformInterface(){
                static final long serialVersionUID = 3997345854471946416L;

                public Object transform(Object o) {
                    String message = Strings.replace((String)((String)o), (int)0, (int)-1, (String)Annotation.PAGE_VARIABLE, (String)Integer.toString(AnnotationView.this.mPageNumber));
                    return message;
                }
            });
        }
    }

    @Override
    public synchronized void detachModel(ModelInterface model) {
        if (model != this.mAnnotation || model == null) {
            throw new ComponentException(Message.format((String)RB.getStringResource((String)"ViewInterfaceSupport.noAttach.ex.txt"), (Object)this.getClass().getName()));
        }
        super.detachModel(model);
        this.mAnnotation = null;
    }

    @Override
    public void paint(Graphics graphics) {
        int atMult;
        boolean header;
        int ypos;
        FontMetrics fm;
        int i;
        this.setBackground(Color.white);
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        Rectangle bounds = this.getBounds();
        Rectangle clip = new Rectangle(x, y, bounds.width, bounds.height);
        if (this.mAnnotation == null) {
            graphics.clearRect(clip.x, clip.y, clip.width, clip.height);
            return;
        }
        double rightMargin = 0.0;
        double leftMargin = 0.0;
        double topMargin = 0.0;
        double bottomMargin = 0.0;
        if (this.mAnnotation != null) {
            leftMargin = this.mAnnotation.getLeftMargin().getMagnitude((Object)"pt");
            rightMargin = this.mAnnotation.getRightMargin().getMagnitude((Object)"pt");
            topMargin = this.mAnnotation.getTopMargin().getMagnitude((Object)"pt");
            bottomMargin = this.mAnnotation.getBottomMargin().getMagnitude((Object)"pt");
        }
        x = (int)((double)clip.x + rightMargin);
        y = (int)((double)clip.y + topMargin);
        width = Math.max(0, (int)((double)clip.width - (rightMargin + leftMargin)));
        height = Math.max(0, (int)((double)clip.height - (topMargin + bottomMargin)));
        graphics.setClip(x, y, width, height);
        clip = new Rectangle(x, y, width, height);
        int maxSize = this.mAnnotation.getLineCount();
        int[] align = new int[]{1, 256, 2};
        int startLine = this.mAnnotation.getVerticalJustification() == 0 ? 1 : maxSize;
        Font bigFont = this.getFont(startLine, 1);
        int fHeight = graphics.getFontMetrics(this.getFont(1, 1)).getHeight();
        for (i = 1; i < align.length; ++i) {
            Font f = this.getFont(startLine, align[i]);
            int fH = graphics.getFontMetrics(f).getHeight();
            if (fH <= fHeight) continue;
            bigFont = f;
            fHeight = fH;
        }
        if (this.mAnnotation != null && this.mAnnotation.getVerticalJustification() == 0) {
            fm = graphics.getFontMetrics(bigFont);
            ypos = y + fm.getAscent();
            header = true;
            atMult = 1;
        } else {
            fm = graphics.getFontMetrics(bigFont);
            ypos = y + height - fm.getHeight() + fm.getAscent();
            y = height - fm.getHeight();
            header = false;
            atMult = -1;
        }
        for (i = 1; i <= maxSize; ++i) {
            String rightText;
            String leftText;
            int fH;
            Font f;
            int k;
            int lIndex = header ? i : maxSize + 1 - i;
            fHeight = graphics.getFontMetrics(this.getFont(lIndex, 1)).getHeight();
            bigFont = this.getFont(lIndex, 1);
            for (k = 1; k < align.length; ++k) {
                f = this.getFont(lIndex, align[k]);
                fH = graphics.getFontMetrics(f).getHeight();
                if (fH <= fHeight) continue;
                bigFont = f;
                fHeight = fH;
            }
            fm = graphics.getFontMetrics(bigFont);
            int lwidth = 0;
            boolean rwidth = false;
            int cWidth = 0;
            int leftOver = width;
            fHeight = fm.getHeight();
            String centerText = this.getText(lIndex, 256);
            if (centerText != null && centerText.length() > 0) {
                Font centerFont = this.getFont(lIndex, 256);
                FontMetrics centerFM = graphics.getFontMetrics(centerFont);
                graphics.setColor(this.getForeground(lIndex, 256));
                graphics.setFont(centerFont);
                cWidth = centerFM.stringWidth(centerText);
                leftOver = Math.max(0, width - cWidth) / 2;
                int xpos = x + leftOver;
                graphics.drawString(centerText, xpos, ypos);
            }
            if ((leftText = this.getText(lIndex, 1)) != null && leftText.length() > 0) {
                Font leftFont = this.getFont(lIndex, 1);
                FontMetrics leftFM = graphics.getFontMetrics(leftFont);
                if (leftOver != width) {
                    lwidth = x + leftOver;
                } else {
                    lwidth = width;
                    leftOver = Math.max(0, width - leftFM.stringWidth(leftText));
                }
                graphics.setColor(this.getForeground(lIndex, 1));
                graphics.setFont(leftFont);
                graphics.drawString(leftText, x, ypos);
            }
            if ((rightText = this.getText(lIndex, 2)) != null && rightText.length() > 0) {
                Font rightFont = this.getFont(lIndex, 2);
                FontMetrics rightFM = graphics.getFontMetrics(rightFont);
                int rWidth = rightFM.stringWidth(rightText);
                graphics.setColor(this.getForeground(lIndex, 2));
                graphics.setFont(rightFont);
                graphics.drawString(rightText, x + (width - rWidth), ypos);
            }
            if (this.mAnnotation == null) continue;
            if (this.mAnnotation.getVerticalJustification() == 0 && lIndex + 1 <= maxSize) {
                fHeight = fm.getHeight();
                y += fHeight * atMult;
                fHeight = graphics.getFontMetrics(this.getFont(lIndex + 1, 1)).getHeight();
                bigFont = this.getFont(lIndex + 1, 1);
                for (k = 1; k < align.length; ++k) {
                    f = this.getFont(lIndex + 1, align[k]);
                    fH = graphics.getFontMetrics(f).getHeight();
                    if (fH <= fHeight) continue;
                    bigFont = f;
                    fHeight = fH;
                }
                fm = graphics.getFontMetrics(bigFont);
                ypos = y + fm.getAscent();
                continue;
            }
            if (this.mAnnotation.getVerticalJustification() != 1 || lIndex - 1 < 1) continue;
            fHeight = graphics.getFontMetrics(this.getFont(lIndex - 1, 1)).getHeight();
            bigFont = this.getFont(lIndex, 1);
            for (k = 1; k < align.length; ++k) {
                Font f2 = this.getFont(lIndex - 1, align[k]);
                fH = graphics.getFontMetrics(f2).getHeight();
                if (fH <= fHeight) continue;
                bigFont = f2;
                fHeight = fH;
            }
            fm = graphics.getFontMetrics(bigFont);
            fHeight = fm.getHeight();
            fm = graphics.getFontMetrics(bigFont);
            ypos = (y += fHeight * atMult) + fm.getAscent();
        }
    }

    @Override
    public boolean pageExists(int pageNumber) {
        this.mPageNumber = pageNumber;
        return true;
    }

    @Override
    public void printFinalize() {
        super.printFinalize();
        this.mPageNumber = 1;
    }

    protected String getText(int lineNumber, int align) {
        return this.mAnnotation != null ? this.mAnnotation.getText(lineNumber, align) : null;
    }

    protected Font getFont(int lineNumber, int align) {
        Font font;
        Font font2 = font = this.mAnnotation != null ? this.mAnnotation.getFont(lineNumber, align) : null;
        if (font == null) {
            font = defaultFont;
        }
        return font;
    }

    protected Color getForeground(int lineNumber, int align) {
        Color color;
        Color color2 = color = this.mAnnotation != null ? this.mAnnotation.getForeground(lineNumber, align) : null;
        if (color == null) {
            color = defaultColor;
        }
        return color;
    }

    @Override
    public Rectangle getPageBounds(Graphics graphics, int pageNumber, int height, int width) {
        Rectangle r = super.getPageBounds(graphics, pageNumber, height, width);
        if (this.mAnnotation == null) {
            return new Rectangle(r.x, r.y, r.width, 0);
        }
        int maxSize = this.mAnnotation.getLineCount();
        int[] align = new int[]{1, 256, 2};
        int totalHeight = 0;
        for (int i = 1; i <= maxSize; ++i) {
            int fHeight = graphics.getFontMetrics(this.getFont(i, 1)).getHeight();
            Font bigFont = this.getFont(i, 1);
            for (int k = 1; k < align.length; ++k) {
                Font f = this.getFont(i, align[k]);
                int fH = graphics.getFontMetrics(f).getHeight();
                if (fH <= fHeight) continue;
                bigFont = f;
                fHeight = fH;
            }
            totalHeight += fHeight;
        }
        return new Rectangle(r.x, r.y, r.width, totalHeight);
    }
}

