/*
 * Decompiled with CFR 0.152.
 */
package com.sas.awt;

import com.sas.PostInitInterface;
import com.sas.awt.RB;
import com.sas.awt.WindowInit2Interface;
import com.sas.awt.WindowInitInterface;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;

public class WindowInitThread
extends Thread {
    public static final String RB_KEY = "WindowInitThread.";
    private WindowInitInterface m_window;

    public WindowInitThread(WindowInitInterface window) {
        this.m_window = window;
    }

    @Override
    public void run() {
        if (this.m_window != null) {
            if (this.m_window instanceof WindowInit2Interface) {
                ((WindowInit2Interface)this.m_window).createComponents();
            }
            this.m_window.createROCFComponents();
            this.m_window.initConnections();
            this.m_window.postInit();
            if (this.m_window instanceof WindowInit2Interface) {
                ((WindowInit2Interface)this.m_window).addComponents();
            }
            this.postInit();
            this.checkLocal();
        }
    }

    protected void postInit() {
        if (this.m_window == null) {
            return;
        }
        if (this.m_window instanceof Container) {
            Container cntr = (Container)((Object)this.m_window);
            for (int i = 0; i < cntr.getComponentCount(); ++i) {
                Component c = cntr.getComponent(i);
                if (!(c instanceof PostInitInterface)) continue;
                ((PostInitInterface)c).postInit();
            }
            this.repaintContainer(cntr);
            cntr.validate();
        }
    }

    private void repaintContainer(Container cntr) {
        if (cntr == null) {
            return;
        }
        cntr.invalidate();
        Component[] comps = cntr.getComponents();
        for (int i = 0; comps != null && i < comps.length; ++i) {
            if (comps[i] instanceof Container) {
                this.repaintContainer((Container)comps[i]);
                continue;
            }
            comps[i].invalidate();
        }
        cntr.repaint();
    }

    protected void checkLocal() {
        if (this.m_window == null) {
            return;
        }
        if (!(this.m_window instanceof Applet)) {
            return;
        }
        Applet applet = (Applet)((Object)this.m_window);
        ClassLoader appletLoader = applet.getClass().getClassLoader();
        ClassLoader thisLoader = this.getClass().getClassLoader();
        if (appletLoader != null && thisLoader == null) {
            String message = "NOTE: Using Java classes installed on the client";
            try {
                message = RB.getStringResource((String)RB_KEY, (String)"localClasses");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (message != null) {
                System.out.println(message);
                applet.showStatus(message);
            }
        }
    }
}

