/*
 * Decompiled with CFR 0.152.
 */
package com.sas.awt;

import com.sas.Component;
import com.sas.ComponentInterface;
import com.sas.ComponentInterfaceSupport;
import com.sas.awt.CompositeInterface;
import com.sas.awt.RB;
import com.sas.awt.RefreshCommand;
import com.sas.awt.VisualInterface;
import com.sas.awt.VisualInterfaceChangeListener;
import com.sas.awt.VisualInterfaceSupportInfo;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.beans.PropertyChangeCommandAdaptor;
import com.sas.beans.Util;
import com.sas.graphics.ElasticComponentList;
import com.sas.graphics.ElasticHandles;
import com.sas.util.SimpleCommand;
import com.sas.visuals.BaseBorder;
import com.sas.visuals.BorderInterface;
import com.sas.visuals.PainterInterface;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.Shape;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Window;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeListener;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class VisualInterfaceSupport
implements Serializable {
    static final long serialVersionUID = 6185752449042437057L;
    static final String RB_KEY = "VisualInterfaceSupport.";
    public static final String[][][] propertyMetadata = new String[][][]{{{"Name", "name"}, {"Description", RB.getStringResource((String)"Component.name.pd.txt")}, {"Linkable", "false"}, {"Expert", "true"}}, {{"Name", "prePainter"}, {"Description", RB.getStringResource((String)"VisualProperties.prePainter.pd.txt")}, {"Hidden", "true"}}, {{"Name", "width"}, {"Property editor class", "com.sas.beans.editors._PositiveIntegerEditor"}, {"Description", "The width of this component"}}, {{"Name", "height"}, {"Property editor class", "com.sas.beans.editors._PositiveIntegerEditor"}, {"Description", RB.getStringResource((String)"VisualProperties.height.pd.txt")}}, {{"Name", "horizontalPosition"}, {"Description", RB.getStringResource((String)"VisualProperties.horizontalPosition.pd.txt")}}, {{"Name", "verticalPosition"}, {"Description", RB.getStringResource((String)"VisualProperties.verticalPosition.pd.txt")}}, {{"Name", "font"}, {"Description", RB.getStringResource((String)"VisualProperties.font.pd.txt")}}, {{"Name", "backgroundColor"}, {"Description", RB.getStringResource((String)"VisualProperties.backgroundColor.pd.txt")}}, {{"Name", "foreground"}, {"Hidden", "true"}}, {{"Name", "background"}, {"Hidden", "true"}}, {{"Name", "foregroundColor"}, {"Description", RB.getStringResource((String)"VisualProperties.foregroundColor.pd.txt")}}, {{"Name", "border"}, {"Description", RB.getStringResource((String)"VisualProperties.border.pd.txt")}}, {{"Name", "focus"}, {"Expert", "true"}, {"Description", RB.getStringResource((String)"VisualProperties.focus.pd.txt")}}, {{"Name", "focusTraversable"}, {"Expert", "true"}, {"Description", RB.getStringResource((String)"VisualProperties.focusTraversable.pd.txt")}}, {{"Name", "enabled"}, {"Description", RB.getStringResource((String)"VisualProperties.enabled.pd.txt")}}, {{"Name", "visible"}, {"Description", RB.getStringResource((String)"VisualProperties.visible.pd.txt")}}, {{"Name", "transparent"}, {"Description", RB.getStringResource((String)"VisualProperties.transparent.pd.txt")}}, {{"Name", "alignmentX"}, {"Description", RB.getStringResource((String)"VisualProperties.alignmentX.pd.txt")}, {"Expert", "true"}}, {{"Name", "alignmentY"}, {"Description", RB.getStringResource((String)"VisualProperties.alignmentY.pd.txt")}, {"Expert", "true"}}, {{"Name", "visualInterfaceSupportInfo"}, {"Description", RB.getStringResource((String)"VisualProperties.visualInterfaceSupportInfo.pd.txt")}, {"Hidden", "true"}}};

    public static void readObject(ComponentInterface componentInstance, VisualInterface visualInstance, java.awt.Component awtComponentInstance, ObjectInputStream stream) {
        VisualInterfaceSupportInfo info = visualInstance.getVisualInterfaceSupportInfo();
        if (info.borderInterface == null) {
            if (info.border != null) {
                info.borderInterface = info.border;
            } else {
                info.borderInterface = new BaseBorder();
                info.borderInterface.setStyle(0);
            }
            info.border = null;
        }
        if (info.changeListener == null) {
            info.changeListener = new VisualInterfaceChangeListener(componentInstance);
        }
        Util.addPropertyChangeListener((Object)info.borderInterface, (PropertyChangeListener)info.propertyChangeListener);
        Util.addPropertyChangeListener((Object)info.borderInterface, (PropertyChangeListener)info.changeListener);
    }

    public static Dimension getPreferredSize(ComponentInterface componentInstance, VisualInterface visualInstance, java.awt.Component awtComponentInstance) {
        VisualInterfaceSupportInfo info = visualInstance.getVisualInterfaceSupportInfo();
        if (info.preferredSize != null) {
            return info.preferredSize;
        }
        return visualInstance.computePreferredSize();
    }

    public static Dimension computePreferredSize(ComponentInterface componentInstance, VisualInterface visualInstance, java.awt.Component awtComponentInstance) {
        return visualInstance.superGetPreferredSize();
    }

    public static void setPreferredSize(ComponentInterface componentInstance, VisualInterface visualInstance, java.awt.Component awtComponentInstance, Dimension preferredSize) {
        VisualInterfaceSupportInfo info = visualInstance.getVisualInterfaceSupportInfo();
        info.preferredSize = preferredSize;
        if (awtComponentInstance.getParent() != null) {
            awtComponentInstance.getParent().invalidate();
            awtComponentInstance.getParent().validate();
        }
        componentInstance.firePropertyChange("preferredSize", null, (Object)preferredSize);
    }

    public static void setDefaultValues(ComponentInterface componentInstance, VisualInterface visualInstance, java.awt.Component awtComponentInstance) {
        VisualInterfaceSupportInfo info = visualInstance.getVisualInterfaceSupportInfo();
        info.propertyChangeListener = new PropertyChangeCommandAdaptor((SimpleCommand)new RefreshCommand(awtComponentInstance));
        BaseBorder border = new BaseBorder(0);
        border.setComponent(awtComponentInstance);
        visualInstance.setBorder(border);
    }

    public static void setBounds(ComponentInterface componentInstance, VisualInterface visualInstance, java.awt.Component awtComponentInstance, int x, int y, int width, int height) {
        Rectangle bounds = awtComponentInstance.getBounds();
        boolean changed = false;
        visualInstance.superSetBounds(x, y, width, height);
        if (bounds.x != x) {
            componentInstance.firePropertyChange("horizontalPosition", (Object)new Integer(bounds.x), (Object)new Integer(x));
            changed = true;
        }
        if (bounds.y != y) {
            componentInstance.firePropertyChange("verticalPosition", (Object)new Integer(bounds.y), (Object)new Integer(y));
            changed = true;
        }
        if (bounds.width != width) {
            componentInstance.firePropertyChange("width", (Object)new Integer(bounds.width), (Object)new Integer(width));
            changed = true;
        }
        if (bounds.height != height) {
            componentInstance.firePropertyChange("height", (Object)new Integer(bounds.height), (Object)new Integer(height));
            changed = true;
        }
        if (changed) {
            componentInstance.firePropertyChange("bounds", (Object)bounds, (Object)new Rectangle(x, y, width, height));
        }
    }

    public static PainterInterface getPrePainter(ComponentInterface componentInstance, VisualInterface visualInstance, java.awt.Component awtComponentInstance) {
        VisualInterfaceSupportInfo info = visualInstance.getVisualInterfaceSupportInfo();
        return info.prePainter;
    }

    public static void setPrePainter(ComponentInterface componentInstance, VisualInterface visualInstance, java.awt.Component awtComponentInstance, PainterInterface painter) {
        VisualInterfaceSupportInfo info = visualInstance.getVisualInterfaceSupportInfo();
        PainterInterface prevPainter = info.prePainter;
        if (prevPainter != painter) {
            info.prePainter = painter;
            if (awtComponentInstance.getPeer() instanceof LightweightPeer) {
                awtComponentInstance.invalidate();
                awtComponentInstance.repaint();
            }
            componentInstance.firePropertyChange("prePainter", (Object)prevPainter, (Object)painter);
        }
    }

    public static Color getForegroundColor(ComponentInterface componentInstance, VisualInterface visualInstance, java.awt.Component awtComponentInstance) {
        return awtComponentInstance.getForeground();
    }

    public static void setForegroundColor(ComponentInterface componentInstance, VisualInterface visualInstance, java.awt.Component awtComponentInstance, Color color) {
        Color prevForegroundColor = awtComponentInstance.getForeground();
        if (prevForegroundColor != color) {
            awtComponentInstance.setForeground(color);
            if (awtComponentInstance.getPeer() instanceof LightweightPeer) {
                awtComponentInstance.invalidate();
                awtComponentInstance.repaint();
            }
            componentInstance.firePropertyChange("foregroundColor", (Object)prevForegroundColor, (Object)color);
        }
    }

    public static Color getBackgroundColor(ComponentInterface componentInstance, VisualInterface visualInstance, java.awt.Component awtComponentInstance) {
        return awtComponentInstance.getBackground();
    }

    public static void setBackgroundColor(ComponentInterface componentInstance, VisualInterface visualInstance, java.awt.Component awtComponentInstance, Color color) {
        Color prevBackgroundColor = awtComponentInstance.getBackground();
        if (prevBackgroundColor != color) {
            awtComponentInstance.setBackground(color);
            if (awtComponentInstance.getPeer() instanceof LightweightPeer) {
                awtComponentInstance.invalidate();
                awtComponentInstance.repaint();
            }
            componentInstance.firePropertyChange("backgroundColor", (Object)prevBackgroundColor, (Object)color);
        }
    }

    public static int getWidth(ComponentInterface componentInstance, VisualInterface visualInstance, java.awt.Component awtComponentInstance) {
        return awtComponentInstance.getSize().width;
    }

    public static void setWidth(ComponentInterface componentInstance, VisualInterface visualInstance, java.awt.Component awtComponentInstance, int horizontalSize) {
        Dimension size = awtComponentInstance.getSize();
        Rectangle bounds = awtComponentInstance.getBounds();
        if (size.width != horizontalSize) {
            awtComponentInstance.setBounds(bounds.x, bounds.y, horizontalSize, size.height);
            componentInstance.firePropertyChange("width", (Object)new Integer(size.width), (Object)new Integer(horizontalSize));
        }
    }

    public static int getHeight(ComponentInterface componentInstance, VisualInterface visualInstance, java.awt.Component awtComponentInstance) {
        return awtComponentInstance.getSize().height;
    }

    public static void setHeight(ComponentInterface componentInstance, VisualInterface visualInstance, java.awt.Component awtComponentInstance, int verticalSize) {
        Dimension size = awtComponentInstance.getSize();
        Rectangle bounds = awtComponentInstance.getBounds();
        if (size.height != verticalSize) {
            awtComponentInstance.setBounds(bounds.x, bounds.y, size.width, verticalSize);
            componentInstance.firePropertyChange("height", (Object)new Integer(size.height), (Object)new Integer(verticalSize));
        }
    }

    public static int getHorizontalPosition(ComponentInterface componentInstance, VisualInterface visualInstance, java.awt.Component awtComponentInstance) {
        return awtComponentInstance.getBounds().x;
    }

    public static void setHorizontalPosition(ComponentInterface componentInstance, VisualInterface visualInstance, java.awt.Component awtComponentInstance, int horizontalPosition) {
        Dimension size = awtComponentInstance.getSize();
        Rectangle bounds = awtComponentInstance.getBounds();
        if (bounds.x != horizontalPosition) {
            awtComponentInstance.setBounds(horizontalPosition, bounds.y, size.width, size.height);
            componentInstance.firePropertyChange("horizontalPosition", (Object)new Integer(bounds.x), (Object)new Integer(horizontalPosition));
        }
    }

    public static int getVerticalPosition(ComponentInterface componentInstance, VisualInterface visualInstance, java.awt.Component awtComponentInstance) {
        return awtComponentInstance.getBounds().y;
    }

    public static void setVerticalPosition(ComponentInterface componentInstance, VisualInterface visualInstance, java.awt.Component awtComponentInstance, int verticalPosition) {
        Dimension size = awtComponentInstance.getSize();
        Rectangle bounds = awtComponentInstance.getBounds();
        if (bounds.y != verticalPosition) {
            awtComponentInstance.setBounds(bounds.x, verticalPosition, size.width, size.height);
            componentInstance.firePropertyChange("verticalPosition", (Object)new Integer(bounds.y), (Object)new Integer(verticalPosition));
        }
    }

    public static Font getFont(ComponentInterface componentInstance, VisualInterface visualInstance, java.awt.Component awtComponentInstance) {
        return visualInstance.superGetFont();
    }

    public static void setFont(ComponentInterface componentInstance, VisualInterface visualInstance, java.awt.Component awtComponentInstance, Font font) {
        Font prevFont = awtComponentInstance.getFont();
        if (prevFont != font) {
            visualInstance.superSetFont(font);
            if (awtComponentInstance.getPeer() instanceof LightweightPeer) {
                awtComponentInstance.invalidate();
                awtComponentInstance.repaint();
            }
            componentInstance.firePropertyChange("font", (Object)prevFont, (Object)font);
        }
    }

    public static BorderInterface getBorder(ComponentInterface componentInstance, VisualInterface visualInstance, java.awt.Component awtComponentInstance) {
        VisualInterfaceSupportInfo info = visualInstance.getVisualInterfaceSupportInfo();
        return info.borderInterface;
    }

    public static void setBorder(ComponentInterface componentInstance, VisualInterface visualInstance, java.awt.Component awtComponentInstance, BorderInterface border) {
        VisualInterfaceSupportInfo info = visualInstance.getVisualInterfaceSupportInfo();
        BorderInterface prevBorder = info.borderInterface;
        if (info.borderInterface != border) {
            if (border == null) {
                border = new BaseBorder();
            }
            if (info.borderInterface != null) {
                Util.removePropertyChangeListener((Object)info.borderInterface, (PropertyChangeListener)info.propertyChangeListener);
                if (info.changeListener != null) {
                    Util.removePropertyChangeListener((Object)info.borderInterface, (PropertyChangeListener)info.changeListener);
                }
            }
            info.borderInterface = border;
            Util.addPropertyChangeListener((Object)info.borderInterface, (PropertyChangeListener)info.propertyChangeListener);
            if (info.changeListener == null) {
                info.changeListener = new VisualInterfaceChangeListener(componentInstance);
            }
            Util.addPropertyChangeListener((Object)info.borderInterface, (PropertyChangeListener)info.changeListener);
            awtComponentInstance.invalidate();
            awtComponentInstance.repaint();
            componentInstance.firePropertyChange("border", (Object)prevBorder, (Object)border);
        }
    }

    public static boolean isTransparent(ComponentInterface componentInstance, VisualInterface visualInstance, java.awt.Component awtComponentInstance) {
        VisualInterfaceSupportInfo info = visualInstance.getVisualInterfaceSupportInfo();
        return info.transparent;
    }

    protected static boolean isHeavyWeightComponent(java.awt.Component awtComponentInstance) {
        if (awtComponentInstance.getPeer() != null) {
            return !(awtComponentInstance.getPeer() instanceof LightweightPeer);
        }
        return awtComponentInstance instanceof Checkbox || awtComponentInstance instanceof Canvas || awtComponentInstance instanceof Panel || awtComponentInstance instanceof Window || awtComponentInstance instanceof Choice || awtComponentInstance instanceof List || awtComponentInstance instanceof Button || awtComponentInstance instanceof Label || awtComponentInstance instanceof Scrollbar || awtComponentInstance instanceof ScrollPane || awtComponentInstance instanceof TextArea || awtComponentInstance instanceof TextField;
    }

    public static void setTransparent(ComponentInterface componentInstance, VisualInterface visualInstance, java.awt.Component awtComponentInstance, boolean transparent) {
        if (transparent && VisualInterfaceSupport.isHeavyWeightComponent(awtComponentInstance)) {
            throw new IllegalStateException(RB.getStringResource((String)RB_KEY, (String)"tranparent.ex.txt"));
        }
        VisualInterfaceSupportInfo info = visualInstance.getVisualInterfaceSupportInfo();
        boolean prevTransparent = info.transparent;
        if (prevTransparent != transparent) {
            info.transparent = transparent;
            awtComponentInstance.invalidate();
            awtComponentInstance.repaint();
            componentInstance.firePropertyChange("transparent", (Object)new Boolean(prevTransparent), (Object)new Boolean(transparent));
        }
    }

    public static boolean isEnabled(ComponentInterface componentInstance, VisualInterface visualInstance, java.awt.Component awtComponentInstance) {
        return visualInstance.superIsEnabled();
    }

    public static void setEnabled(ComponentInterface componentInstance, VisualInterface visualInstance, java.awt.Component awtComponentInstance, boolean enabled) {
        boolean prevEnabled = awtComponentInstance.isEnabled();
        if (prevEnabled != enabled) {
            visualInstance.superSetEnabled(enabled);
            if (awtComponentInstance.getPeer() instanceof LightweightPeer) {
                awtComponentInstance.repaint();
            }
            componentInstance.firePropertyChange("enabled", (Object)new Boolean(prevEnabled), (Object)new Boolean(enabled));
        }
    }

    public static boolean isFocus(ComponentInterface componentInstance, VisualInterface visualInstance, java.awt.Component awtComponentInstance) {
        return false;
    }

    public static void setFocus(ComponentInterface componentInstance, VisualInterface visualInstance, java.awt.Component awtComponentInstance, boolean focus) {
        boolean prevFocus = visualInstance.isFocus();
        if (prevFocus != focus) {
            if (focus) {
                awtComponentInstance.requestFocus();
            } else {
                awtComponentInstance.transferFocus();
            }
            componentInstance.firePropertyChange("focus", (Object)new Boolean(prevFocus), (Object)new Boolean(focus));
        }
    }

    public static boolean isVisible(ComponentInterface componentInstance, VisualInterface visualInstance, java.awt.Component awtComponentInstance) {
        return visualInstance.superIsVisible();
    }

    public static void setVisible(ComponentInterface componentInstance, VisualInterface visualInstance, java.awt.Component awtComponentInstance, boolean visible) {
        boolean prevVisible = awtComponentInstance.isVisible();
        if (awtComponentInstance.isVisible() != visible) {
            visualInstance.superSetVisible(visible);
            componentInstance.firePropertyChange("visible", (Object)new Boolean(prevVisible), (Object)new Boolean(visible));
        }
    }

    public static Dimension getMinimumSize(ComponentInterface componentInstance, VisualInterface visualInstance, java.awt.Component awtComponentInstance) {
        ComponentPeer peer = awtComponentInstance.getPeer();
        if (peer != null) {
            return visualInstance.superGetMinimumSize();
        }
        if (componentInstance.isDesignTime()) {
            int min = Math.max(5, 5);
            Dimension minimum = new Dimension(min, min);
            return minimum;
        }
        return visualInstance.superGetMinimumSize();
    }

    public static void update(ComponentInterface componentInstance, VisualInterface visualInstance, java.awt.Component awtComponentInstance, Graphics g) {
        visualInstance.superUpdate(g);
    }

    public static void paint(ComponentInterface componentInstance, VisualInterface visualInstance, java.awt.Component awtComponentInstance, Graphics g) {
        VisualInterfaceSupportInfo info = visualInstance.getVisualInterfaceSupportInfo();
        Rectangle bounds = awtComponentInstance.getBounds();
        BorderInterface border = visualInstance.getBorder();
        if (!visualInstance.isTransparent() && awtComponentInstance.getPeer() instanceof LightweightPeer) {
            g.setColor(visualInstance.getBackgroundColor());
            Dimension size = awtComponentInstance.getSize();
            g.fillRect(0, 0, size.width, size.height);
        }
        if (info.prePainter != null) {
            info.prePainter.paint(awtComponentInstance, g, 0, 0, bounds.width, bounds.height);
        }
        if (border != null) {
            border.drawInRect(awtComponentInstance, g, 0, 0, bounds.width, bounds.height);
            Insets borderInsets = border.getInsets(awtComponentInstance);
            g.clipRect(borderInsets.left, borderInsets.top, bounds.width - (borderInsets.left + borderInsets.right), bounds.height - (borderInsets.top + borderInsets.bottom));
        }
        visualInstance.superPaint(g);
        VisualInterfaceSupport.paintHandles(componentInstance, visualInstance, awtComponentInstance, g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paintHandles(ComponentInterface componentInstance, VisualInterface visualInstance, java.awt.Component awtComponentInstance, Graphics g) {
        Rectangle r;
        if (componentInstance.isDesignTime() && awtComponentInstance instanceof Container && !(awtComponentInstance instanceof CompositeInterface) && (r = g.getClipBounds()) != null) {
            Shape oldClip = g.getClip();
            r.grow(ElasticHandles.handleWidth, ElasticHandles.handleHeight);
            r = r.intersection(new Rectangle(awtComponentInstance.getBounds().getSize()));
            g.setClip(r);
            Object object = awtComponentInstance.getTreeLock();
            synchronized (object) {
                java.awt.Component[] c = ((Container)awtComponentInstance).getComponents();
                for (int i = 0; i < c.length; ++i) {
                    ElasticComponentList.paint(c[i], g);
                }
            }
            g.setClip(oldClip);
        }
    }

    public static void clone(VisualInterface sourceComponent, VisualInterface destComponent) throws CloneNotSupportedException {
        if (sourceComponent.getVisualInterfaceSupportInfo() != null) {
            destComponent.setVisualInterfaceSupportInfo((VisualInterfaceSupportInfo)sourceComponent.getVisualInterfaceSupportInfo().clone());
        }
        destComponent.setWidth(sourceComponent.getWidth());
        destComponent.setHeight(sourceComponent.getHeight());
        destComponent.setFont(sourceComponent.getFont());
        destComponent.setBackgroundColor(sourceComponent.getBackgroundColor());
        destComponent.setForegroundColor(sourceComponent.getForegroundColor());
        BorderInterface sourceComponentBorderClone = null;
        try {
            sourceComponentBorderClone = (BorderInterface)Component.clone((Object)sourceComponent.getBorder());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        destComponent.setBorder(sourceComponentBorderClone);
        destComponent.setEnabled(sourceComponent.isEnabled());
        destComponent.setVisible(sourceComponent.isVisible());
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] compositeMetadata = new String[ComponentInterfaceSupport.propertyMetadata.length + propertyMetadata.length][][];
        System.arraycopy(ComponentInterfaceSupport.propertyMetadata, 0, compositeMetadata, 0, ComponentInterfaceSupport.propertyMetadata.length);
        System.arraycopy(propertyMetadata, 0, compositeMetadata, ComponentInterfaceSupport.propertyMetadata.length, propertyMetadata.length);
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "";
        ebi.defaultOutputPropertyName = "";
        ebi.propertyMetadata = compositeMetadata;
        return ebi;
    }
}

