/*
 * Decompiled with CFR 0.152.
 */
package com.sas.awt;

import com.sas.ComponentInterface;
import com.sas.ComponentInterfaceSupport;
import com.sas.ModelInterface;
import com.sas.PublicClonable;
import com.sas.RB;
import com.sas.ViewDefaultModelInterface;
import com.sas.awt.TextFieldVisualComponent;
import com.sas.awt.VisualInterfaceSupport;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.beans.Util;
import com.sas.lang.StringData;
import com.sas.lang.StringDataInterface;
import com.sas.util.datamonitors.DataMonitorInterface;
import com.sas.util.errorhandlers.ErrorHandlerInterface;
import com.sas.util.validators.ValidationInterface;
import com.sas.util.validators.ValidatorInterface;
import com.sas.visuals.ResizeToFitInterface;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;

public class TextField
extends TextFieldVisualComponent
implements PropertyChangeListener,
PublicClonable,
ResizeToFitInterface,
ValidatorInterface,
ViewDefaultModelInterface,
StringDataInterface {
    private boolean resizeToFit = false;
    private boolean keystrokeUpdate = false;
    private transient ActionListener actionListener;
    private boolean doSuper;
    private int dragWidth = -1;
    private int columnWidth = -1;
    private boolean columnFlag = false;
    private StringData defaultModel;
    private int oldSelStart = 0;
    private int oldSelEnd = 0;
    private int oldCaret;
    private String oldSText;
    private String previousText;
    private boolean autoHighlight = false;
    private transient boolean setStartLocation;
    private transient boolean mouseDragged = false;
    private transient int startLocation = 0;
    private boolean resizeToDefaultSize = false;
    protected ValidationInterface validator;
    protected ErrorHandlerInterface errorHandler;
    protected boolean isValid;
    protected transient Object setTextOnModelLock;
    protected transient boolean inSetTextOnModel;
    protected DataMonitorInterface dataMonitor;
    static final long serialVersionUID = -4163652375961662610L;
    public static final String RB_KEY = "TextField.";
    private static String[] requiredInterfacesString = new String[]{"com.sas.lang.StringDataInterface"};
    private static boolean columnsSetFromConstructor = false;
    private static int constructorColumns = 0;
    static int defaultWidth = 124;
    static int defaultHeight = 23;

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static synchronized void setDefaultWidth(int newDefaultWidth) {
        defaultWidth = newDefaultWidth;
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static synchronized void setDefaultHeight(int newDefaultHeight) {
        defaultHeight = newDefaultHeight;
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "preferredSize"}, {"Read method", "getPreferredSize"}, {"Write method", "setPreferredSize"}}, {{"Name", "border"}, {"Hidden", "true"}}, {{"Name", "autoHighlight"}, {"Description", com.sas.awt.RB.getStringResource((String)"TextComponent.autoHighlight.pd.txt")}}, {{"Name", "caretPosition"}, {"Description", com.sas.awt.RB.getStringResource((String)"TextComponent.caretPosition.pd.txt")}}, {{"Name", "columns"}, {"Description", com.sas.awt.RB.getStringResource((String)"TextComponent.columns.pd.txt")}}, {{"Name", "defaultModelAttached"}, {"Description", com.sas.util.Util.getCommonStringResource((String)"defaultModelAttached.pd.txt")}, {"Expert", "true"}}, {{"Name", "echoChar"}, {"Description", com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"echoChar.pd.txt")}}, {{"Name", "echoCharacter"}, {"Hidden", "true"}}, {{"Name", "editable"}, {"Description", com.sas.awt.RB.getStringResource((String)"TextComponent.editable.pd.txt")}}, {{"Name", "keystrokeUpdate"}, {"Description", com.sas.awt.RB.getStringResource((String)"TextComponent.keystrokeUpdate.pd.txt")}}, {{"Name", "resizeToDefaultSize"}, {"Hidden", "true"}}, {{"Name", "resizeToFit"}, {"Description", com.sas.util.Util.getCommonStringResource((String)"resizeToFit.pd.txt")}}, {{"Name", "selectedText"}, {"Description", com.sas.awt.RB.getStringResource((String)"TextComponent.selectedText.pd.txt")}}, {{"Name", "selectionEnd"}, {"Description", com.sas.awt.RB.getStringResource((String)"TextComponent.selectionEnd.pd.txt")}}, {{"Name", "selectionStart"}, {"Description", com.sas.awt.RB.getStringResource((String)"TextComponent.selectionStart.pd.txt")}}, {{"Name", "transparent"}, {"Hidden", "true"}}, {{"Name", "text"}, {"Description", com.sas.awt.RB.getStringResource((String)"TextComponent.text.pd.txt")}, {"Property editor class", "com.sas.beans.editors._TextEditor"}}, {{"Name", "defaultWidth"}, {"Default value", "124"}, {"Description", RB.getStringResource((String)"VisualInterface.defaultWidth.pd.txt")}}, {{"Name", "defaultHeight"}, {"Default value", "23"}, {"Description", RB.getStringResource((String)"VisualInterface.defaultHeight.pd.txt")}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "text";
        ebi.defaultOutputPropertyName = "text";
        ebi.shortDescription = com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"description.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public TextField() {
        this.initializeComponent();
    }

    public TextField(String text) {
        super(text);
        this.setText(text);
        this.initializeComponent();
    }

    public TextField(String text, int columns) {
        super(text, columns);
        this.initializeComponent();
    }

    public TextField(int columns) {
        super(columns);
        this.initializeComponent();
    }

    public void append(String str) {
        if (str != null && this.getModelInterface() != null) {
            this.select(0, 0);
            String text = super.getText() + str;
            this.setTextOnModel(text);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.resizeToFit) {
            this.setSize(this.getPreferredSize());
        }
    }

    @Override
    public void attachModel(ModelInterface model) {
        super.attachModel(model);
        Util.addPropertyChangeListener((Object)model, (PropertyChangeListener)this);
    }

    private void checkForResizing() {
        if (this.resizeToFit) {
            this.setSize(this.getPreferredSize());
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        try {
            TextField clone = (TextField)this.getClass().newInstance();
            ComponentInterfaceSupport.clone((ComponentInterface)this, (ComponentInterface)clone);
            VisualInterfaceSupport.clone(this, clone);
            clone.setCaretPosition(this.getCaretPosition());
            clone.setEchoChar(this.getEchoChar());
            if (this.getColumns() > 0) {
                clone.setColumns(this.getColumns());
            }
            clone.setEditable(this.isEditable());
            clone.setKeystrokeUpdate(this.isKeystrokeUpdate());
            clone.setResizeToFit(this.isResizeToFit());
            clone.setSelectionStart(this.getSelectionStart());
            clone.setSelectionEnd(this.getSelectionEnd());
            clone.setText(this.getText());
            if (this.defaultModel != null && this.getModelInterface() == this.defaultModel) {
                StringData clonedModel = (StringData)this.defaultModel.clone();
                clone.setModelInterface((ModelInterface)clonedModel);
                clone.defaultModel = clonedModel;
            }
            clone.initialize();
            return clone;
        }
        catch (Exception e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
    }

    @Override
    public Dimension computePreferredSize() {
        if (this.isResizeToDefaultSize()) {
            return new Dimension(defaultWidth, defaultHeight);
        }
        return super.computePreferredSize();
    }

    public void delete(int start, int end) {
        this.replaceRange("", start, end);
    }

    public void deselectAll() {
        if (com.sas.util.Util.unequal((Object)this.getSelectedText(), (Object)"")) {
            this.select(0, 0);
        }
    }

    @Override
    public void detachModel(ModelInterface model) {
        super.detachModel(model);
        Util.removePropertyChangeListener((Object)model, (PropertyChangeListener)this);
        ModelInterface modelInterface = this.getModelInterface();
        if (modelInterface == null) {
            this.defaultModel.setText(null);
            this.setModelInterface((ModelInterface)this.defaultModel);
        }
    }

    public DataMonitorInterface getDataMonitor() {
        return this.dataMonitor;
    }

    public ErrorHandlerInterface getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        return requiredInterfaces;
    }

    public ValidationInterface getValidator() {
        return this.validator;
    }

    protected void handleError() {
        ErrorHandlerInterface handler = this.getErrorHandler();
        for (Container parent = this.getParent(); handler == null && parent != null && parent instanceof ValidatorInterface; parent = parent.getParent()) {
            handler = ((ValidatorInterface)parent).getErrorHandler();
        }
        if (handler != null) {
            handler.handleError((ComponentInterface)this, this.validator.getValidationMessage(), this.validator.getValidationMessageCode());
        }
    }

    public void insert(String str, int pos) {
        if (str != null && this.getModelInterface() != null) {
            this.select(0, 0);
            String text = "";
            text = pos > this.getText().length() ? this.getText() + str : (pos < 0 ? str + this.getText() : this.getText().substring(0, pos) + str + this.getText().substring(pos));
            this.setTextOnModel(text);
        }
    }

    public boolean isAutoHighlight() {
        return this.autoHighlight;
    }

    public boolean isDefaultModelAttached() {
        return this.defaultModel == this.getModelInterface();
    }

    public boolean isKeystrokeUpdate() {
        return this.keystrokeUpdate;
    }

    public boolean isResizeToDefaultSize() {
        return this.resizeToDefaultSize;
    }

    public boolean isResizeToFit() {
        return this.resizeToFit;
    }

    @Override
    public boolean isValid() {
        if (this.validator != null) {
            return this.validator.validateValue((Object)this, (Object)this.getText());
        }
        return true;
    }

    @Override
    protected void processActionEvent(ActionEvent e) {
        ModelInterface model = this.getModelInterface();
        if (model != null && com.sas.util.Util.unequal((Object)this.previousText, (Object)this.getText())) {
            this.setTextOnModel(this.getText());
        }
        super.processActionEvent(e);
        if (this.isAutoHighlight()) {
            this.selectAll();
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        ModelInterface Model = this.getModelInterface();
        if (Model != null) {
            if (e.getID() == 1005 && com.sas.util.Util.unequal((Object)this.previousText, (Object)this.getText())) {
                this.setTextOnModel(this.getText());
            }
            if (this.autoHighlight) {
                if (e.getID() == 1004) {
                    this.selectAll();
                } else if (e.getID() == 1005) {
                    this.deselectAll();
                }
            }
        } else if (com.sas.util.Util.unequal((Object)this.previousText, (Object)this.getText())) {
            this.firePropertyChange("text", this.previousText, this.getText());
            this.previousText = this.getText();
        }
        super.processFocusEvent(e);
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (e.getID() == 402) {
            if (com.sas.util.Util.unequal((Object)this.oldSText, (Object)"")) {
                this.sendTextEvents();
            } else if (this.oldCaret != this.getCaretPosition()) {
                if (this.anyPropertyChangeListeners()) {
                    this.firePropertyChange("caretPosition", new Integer(this.oldCaret), new Integer(this.getCaretPosition()));
                }
                this.oldCaret = this.getCaretPosition();
            }
            char checkKey = e.getKeyChar();
            super.processKeyEvent(e);
            if (this.isKeystrokeUpdate() && checkKey != '\uffff') {
                ModelInterface Model = this.getModelInterface();
                if (Model != null) {
                    this.doSuper = false;
                    if (com.sas.util.Util.unequal((Object)this.previousText, (Object)this.getText())) {
                        this.setTextOnModel(this.getText());
                        this.firePropertyChange("text", null, this.getText());
                        this.previousText = this.getText();
                    }
                    this.doSuper = true;
                } else if (com.sas.util.Util.unequal((Object)this.previousText, (Object)this.getText())) {
                    this.firePropertyChange("text", null, this.getText());
                    this.previousText = this.getText();
                }
            }
        } else {
            super.processKeyEvent(e);
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        if (e.getID() == 506 && this.setStartLocation) {
            this.mouseDragged = true;
            this.startLocation = this.getCaretPosition();
            this.setStartLocation = false;
        }
        super.processMouseMotionEvent(e);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 502 && this.mouseDragged) {
            int newSelStart = this.startLocation;
            if (this.getCaretPosition() >= this.startLocation) {
                super.setSelectionStart(this.startLocation);
            } else {
                super.setSelectionStart(this.getCaretPosition());
                super.setSelectionEnd(newSelStart);
            }
            super.select(this.getSelectionStart(), this.getSelectionEnd());
            this.sendTextEvents();
            this.setStartLocation = true;
            this.mouseDragged = false;
        } else if (e.getID() == 500 && this.oldSText.length() > 0) {
            this.sendTextEvents();
        }
        super.processMouseEvent(e);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (com.sas.util.Util.equal((Object)event.getPropertyName(), (Object)"text")) {
            this.refresh();
        }
    }

    public void refresh() {
        ModelInterface Model = this.getModelInterface();
        if (Model != null) {
            String oldText = this.previousText;
            String text = ((StringDataInterface)Model).getText();
            if (text == null) {
                text = "";
            }
            if (this.doSuper) {
                super.setText(text);
            }
            if (this.dataMonitor != null) {
                this.dataMonitor.monitorData((Object)this, (Object)text);
            }
            this.checkForResizing();
            if (this.doSuper && (this.previousText == null || com.sas.util.Util.unequal((Object)this.previousText, (Object)text))) {
                this.previousText = this.isValid() ? text : "";
                this.firePropertyChange("text", oldText, text);
            }
            if (this.getText() != null && this.getText().length() > 0) {
                this.sendTextEvents();
            }
        }
    }

    @Override
    public void refresh(ModelInterface Model) {
        if (Model == null) {
            this.setText(null);
        } else {
            this.refresh();
        }
    }

    public void replaceRange(String str, int start, int end) {
        if (str != null && this.getModelInterface() != null) {
            if (com.sas.util.Util.equal((Object)str, (Object)"") && start < 0) {
                return;
            }
            this.select(0, 0);
            String text = null;
            text = start < 0 && com.sas.util.Util.unequal((Object)str, (Object)"") ? str + this.getText() : (end > this.getText().length() || end < 0 ? this.getText().substring(0, start) + str : (end < start ? this.getText().substring(0, end) + str + this.getText().substring(start) : this.getText().substring(0, start) + str + this.getText().substring(end)));
            this.setTextOnModel(text);
        }
    }

    @Override
    public void select(int selectionStart, int selectionEnd) {
        super.select(selectionStart, selectionEnd);
        this.sendTextEvents();
    }

    @Override
    public void selectAll() {
        super.selectAll();
        this.sendTextEvents();
    }

    private void sendTextEvents() {
        String test;
        if (this.oldSText == null) {
            return;
        }
        if (this.getSelectionEnd() > this.getText().length()) {
            this.setSelectionEnd(this.getText().length());
        }
        if ((test = this.getSelectedText()) == null) {
            test = "";
        }
        if (com.sas.util.Util.unequal((Object)this.oldSText, (Object)test)) {
            this.firePropertyChange("selectedText", this.oldSText, test);
            this.oldSText = test;
            if (this.oldSelStart != this.getSelectionStart()) {
                if (this.anyPropertyChangeListeners()) {
                    this.firePropertyChange("selectionStart", new Integer(this.oldSelStart), new Integer(this.getSelectionStart()));
                }
                this.oldSelStart = this.getSelectionStart();
            }
            if (this.oldSelEnd != this.getSelectionEnd()) {
                if (this.anyPropertyChangeListeners()) {
                    this.firePropertyChange("selectionEnd", new Integer(this.oldSelEnd), new Integer(this.getSelectionEnd()));
                }
                this.oldSelEnd = this.getSelectionEnd();
            }
            if (this.oldCaret != this.getCaretPosition()) {
                if (this.anyPropertyChangeListeners()) {
                    this.firePropertyChange("caretPosition", new Integer(this.oldCaret), new Integer(this.getCaretPosition()));
                }
                this.oldCaret = this.getCaretPosition();
            }
        }
    }

    public void setAutoHighlight(boolean value) {
        if (value != this.autoHighlight) {
            this.autoHighlight = value;
            this.firePropertyChange("autoHighlight", value ? Boolean.FALSE : Boolean.TRUE, value ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (this.isResizeToFit()) {
            Dimension prefSize = this.getPreferredSize();
            super.setBounds(x, y, width, height);
        } else {
            super.setBounds(x, y, width, height);
            if (!this.columnFlag && width != defaultWidth) {
                this.setResizeToDefaultSize(false);
                this.dragWidth = width;
            } else {
                this.columnFlag = false;
            }
        }
    }

    @Override
    public void setBounds(Rectangle r) {
        if (this.isResizeToFit()) {
            Dimension prefSize = this.getPreferredSize();
            if (r.width == prefSize.width && r.height == prefSize.height) {
                super.setBounds(r.x, r.y, r.width, r.height);
            }
        } else {
            super.setBounds(r);
        }
        if (!this.columnFlag && r.width != defaultWidth) {
            this.setResizeToDefaultSize(false);
            this.dragWidth = r.width;
        } else {
            this.columnFlag = false;
        }
    }

    @Override
    public void setCaretPosition(int position) {
        if (this.getCaretPosition() != position) {
            int oldCaret = this.getCaretPosition();
            if (this.getPeer() != null) {
                this.addNotify();
                super.setCaretPosition(position);
            }
            if (!this.anyPropertyChangeListeners()) {
                return;
            }
            this.firePropertyChange("caretPosition", new Integer(oldCaret), new Integer(position));
        }
    }

    @Override
    public void setColumns(int columns) {
        if (this.getColumns() != columns) {
            int oldCols = this.getColumns();
            Dimension dp = this.getSize();
            if (columns > 0 && !this.isResizeToFit()) {
                super.setColumns(columns);
                Dimension d = super.getPreferredSize(columns);
                this.columnFlag = true;
                this.columnWidth = d.width;
                if (this.isDesignTime()) {
                    this.dragWidth = -1;
                }
                this.setSize(d.width, dp.height);
                if (!this.anyPropertyChangeListeners()) {
                    return;
                }
                this.firePropertyChange("columns", new Integer(oldCols), new Integer(columns));
            } else {
                super.setColumns(columns);
                if (!this.anyPropertyChangeListeners()) {
                    return;
                }
                this.firePropertyChange("columns", new Integer(oldCols), new Integer(columns));
            }
        }
    }

    public void setDataMonitor(DataMonitorInterface dataMonitor) {
        if (this.dataMonitor != dataMonitor) {
            DataMonitorInterface oldDataMonitor = this.dataMonitor;
            this.dataMonitor = dataMonitor;
            this.firePropertyChange("dataMonitor", oldDataMonitor, dataMonitor);
        }
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        this.setRequiredInterfaces(requiredInterfaces);
        this.setTextOnModelLock = new Object();
        this.defaultModel = new StringData();
        String model_text = "";
        this.defaultModel.initialize();
        if (super.getText() != null) {
            model_text = super.getText();
        }
        this.defaultModel.setText(model_text);
        this.attachModel((ModelInterface)this.defaultModel);
        this.enableEvents(188L);
        this.setBackgroundColor(SystemColor.window);
        this.oldCaret = -1;
        this.oldSText = "";
        this.previousText = "";
        this.setStartLocation = true;
        this.doSuper = true;
    }

    @Override
    public void setEchoChar(char echoChar) {
        if (this.getEchoChar() != echoChar) {
            char oldEcho = this.getEchoChar();
            super.setEchoChar(echoChar);
            super.setText(this.getText());
            this.checkForResizing();
            if (!this.anyPropertyChangeListeners()) {
                return;
            }
            this.firePropertyChange("echoChar", new Character(oldEcho), new Character(this.getEchoChar()));
        }
    }

    @Override
    public void setEditable(boolean t) {
        if (this.isEditable() != t) {
            super.setEditable(t);
            this.firePropertyChange("editable", t ? Boolean.FALSE : Boolean.TRUE, t ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public void setErrorHandler(ErrorHandlerInterface errorHandler) {
        if (this.errorHandler != errorHandler) {
            ErrorHandlerInterface oldErrorHandler = this.errorHandler;
            this.errorHandler = errorHandler;
            this.firePropertyChange("errorHandler", oldErrorHandler, errorHandler);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.checkForResizing();
    }

    public void setKeystrokeUpdate(boolean value) {
        if (this.keystrokeUpdate != value) {
            this.keystrokeUpdate = value;
            this.firePropertyChange("keystrokeUpdate", value ? Boolean.FALSE : Boolean.TRUE, value ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    @Override
    public void setSelectionEnd(int selectionEnd) {
        if (this.getSelectionEnd() != selectionEnd) {
            super.setSelectionEnd(selectionEnd);
            this.sendTextEvents();
        }
    }

    @Override
    public void setSelectionStart(int selectionStart) {
        if (this.getSelectionStart() != selectionStart) {
            super.setSelectionStart(selectionStart);
            this.sendTextEvents();
        }
    }

    public void setResizeToDefaultSize(boolean resizeState) {
        if (resizeState != this.resizeToDefaultSize) {
            this.resizeToDefaultSize = resizeState;
            if (resizeState) {
                super.setColumns(0);
                this.setSize(defaultWidth, defaultHeight);
                if (this.isResizeToFit()) {
                    this.setResizeToFit(false);
                }
            }
        }
    }

    public void setResizeToFit(boolean resizeState) {
        if (this.resizeToFit != resizeState) {
            this.resizeToFit = resizeState;
            if (resizeState) {
                if (this.getColumns() > 0) {
                    this.setColumns(0);
                }
                if (this.getFont() != null) {
                    this.checkForResizing();
                }
            } else {
                this.setSize(this.getPreferredSize());
            }
            this.firePropertyChange("resizeToFit", resizeState ? Boolean.FALSE : Boolean.TRUE, resizeState ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    @Override
    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        if ((this.getText() == null || com.sas.util.Util.unequal((Object)this.getText(), (Object)text)) && this.getModelInterface() != null) {
            boolean goodText = this.setTextOnModel(text);
            String modelText = ((StringDataInterface)this.getModelInterface()).getText();
            if (goodText && com.sas.util.Util.unequal((Object)this.getText(), (Object)text)) {
                super.setText(text);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setTextOnModel(String text) {
        Object object = this.setTextOnModelLock;
        synchronized (object) {
            if (this.inSetTextOnModel) {
                return true;
            }
            this.inSetTextOnModel = true;
        }
        if (this.validator == null) {
            this.isValid = true;
            this.firePropertyChange("valid", Boolean.FALSE, Boolean.TRUE);
            ((StringDataInterface)this.getModelInterface()).setText(text);
            this.inSetTextOnModel = false;
            return true;
        }
        if (this.validator.validateValue((Object)this, (Object)text)) {
            this.isValid = true;
            this.firePropertyChange("valid", Boolean.FALSE, Boolean.TRUE);
            text = (String)this.validator.normalizeValue((Object)this, (Object)text);
            ((StringDataInterface)this.getModelInterface()).setText(text);
            this.inSetTextOnModel = false;
            return true;
        }
        this.isValid = false;
        this.firePropertyChange("valid", Boolean.TRUE, Boolean.FALSE);
        this.handleError();
        this.previousText = "";
        this.inSetTextOnModel = false;
        return false;
    }

    public void setValidator(ValidationInterface validator) {
        if (this.validator != validator) {
            ValidationInterface oldValidator = this.validator;
            this.validator = validator;
            this.firePropertyChange("validator", oldValidator, validator);
        }
    }

    private void readObject(ObjectInputStream oi) throws IOException, ClassNotFoundException {
        oi.defaultReadObject();
        this.setTextOnModelLock = new Object();
        if (this.isResizeToDefaultSize()) {
            return;
        }
        Dimension df = this.getSize();
        if (this.dragWidth != -1) {
            this.setSize(this.dragWidth, df.height);
        } else if (this.columnWidth != -1) {
            this.setSize(this.columnWidth, df.height);
        }
        this.setStartLocation = true;
    }
}

