/*
 * Decompiled with CFR 0.152.
 */
package com.sas.awt;

import com.sas.Component;
import com.sas.ComponentInterface;
import com.sas.ComponentInterfaceSupport;
import com.sas.ModelInterface;
import com.sas.PublicClonable;
import com.sas.RB;
import com.sas.ViewDefaultModelInterface;
import com.sas.awt.ScrollbarVisualComponent;
import com.sas.awt.VisualInterfaceSupport;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.beans.Util;
import com.sas.models.BoundedLong;
import com.sas.models.BoundedNumberInterface;
import com.sas.util.IntegerRange;
import java.awt.SystemColor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;

public class Scrollbar
extends ScrollbarVisualComponent
implements PublicClonable,
ViewDefaultModelInterface {
    private IntegerRange defaultModel;
    private BoundedNumberInterface defaultRangeModel;
    static final long serialVersionUID = 1152035054889795950L;
    public static final String RB_KEY = "Scrollbar.";
    private static String[] requiredInterfacesString = new String[]{"com.sas.models.BoundedNumberInterface"};
    private static boolean hasInitialized;
    static int defaultWidth;
    static int defaultHeight;

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static synchronized void setDefaultWidth(int newDefaultWidth) {
        defaultWidth = newDefaultWidth;
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static synchronized void setDefaultHeight(int newDefaultHeight) {
        defaultHeight = newDefaultHeight;
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "border"}, {"Hidden", "true"}}, {{"Name", "name"}, {"Description", com.sas.awt.RB.getStringResource((String)"name.pd.txt")}, {"Expert", "true"}}, {{"Name", "blockIncrement"}, {"Description", com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"blockIncrement.pd.txt")}}, {{"Name", "defaultModelAttached"}, {"Description", com.sas.util.Util.getCommonStringResource((String)"defaultModelAttached.pd.txt")}, {"Expert", "true"}}, {{"Name", "lineIncrement"}, {"Hidden", "true"}}, {{"Name", "maximum"}, {"Description", com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"maximum.pd.txt")}}, {{"Name", "minimum"}, {"Description", com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"minimum.pd.txt")}}, {{"Name", "orientation"}, {"Description", com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"orientation.pd.txt")}, {"Property editor class", "com.sas.beans.editors.ScrollbarOrientationEditor"}}, {{"Name", "pageIncrement"}, {"Hidden", "true"}}, {{"Name", "transparent"}, {"Hidden", "true"}}, {{"Name", "unitIncrement"}, {"Description", com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"unitIncrement.pd.txt")}}, {{"Name", "value"}, {"Description", com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"value.pd.txt")}}, {{"Name", "visibleAmount"}, {"Description", com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"visibleAmount.pd.txt")}}, {{"Name", "defaultWidth"}, {"Default value", "16"}, {"Description", RB.getStringResource((String)"VisualInterface.defaultWidth.pd.txt")}}, {{"Name", "defaultHeight"}, {"Default value", "124"}, {"Description", RB.getStringResource((String)"VisualInterface.defaultHeight.pd.txt")}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "value";
        ebi.defaultOutputPropertyName = "value";
        ebi.shortDescription = com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"description.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public Scrollbar() {
        this.initializeComponent();
        this.setBackgroundColor(SystemColor.control);
    }

    public Scrollbar(int orientation) {
        super(orientation);
        this.initializeComponent();
        this.setBackgroundColor(SystemColor.control);
    }

    public Scrollbar(int orientation, int value, int visible, int minimum, int maximum) {
        super(orientation, value, visible, minimum, maximum);
        this.initializeComponent();
        this.setBackgroundColor(SystemColor.control);
    }

    @Override
    public void attachModel(ModelInterface model) {
        super.attachModel(model);
        Util.addPropertyChangeListener((Object)model, (PropertyChangeListener)((Object)this));
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        try {
            Scrollbar clone = (Scrollbar)this.getClass().newInstance();
            ComponentInterfaceSupport.clone((ComponentInterface)this, (ComponentInterface)clone);
            VisualInterfaceSupport.clone(this, clone);
            clone.setMinimum(this.getMinimum());
            clone.setMaximum(this.getMaximum());
            clone.setValue(this.getValue());
            clone.setVisibleAmount(this.getVisibleAmount());
            clone.setBlockIncrement(this.getBlockIncrement());
            clone.setUnitIncrement(this.getUnitIncrement());
            clone.setOrientation(this.getOrientation());
            if (this.defaultModel != null && this.getModelInterface() == this.defaultModel) {
                BoundedLong clonedModel = (BoundedLong)Component.clone((Object)this.defaultRangeModel);
                clone.setModelInterface((ModelInterface)clonedModel);
                clone.defaultRangeModel = clonedModel;
            }
            clone.initialize();
            return clone;
        }
        catch (Exception e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
    }

    @Override
    public void detachModel(ModelInterface model) {
        super.detachModel(model);
        Util.removePropertyChangeListener((Object)model, (PropertyChangeListener)((Object)this));
        ModelInterface modelInterface = this.getModelInterface();
        if (modelInterface == null) {
            this.defaultRangeModel.setBlockIncrementNumber((Number)new Long(10L));
            this.defaultRangeModel.setUnitIncrementNumber((Number)new Long(1L));
            this.defaultRangeModel.setMinimumNumber((Number)new Long(0L));
            this.defaultRangeModel.setMaximumNumber((Number)new Long(100L));
            this.defaultRangeModel.setNumberValue((Number)new Long(0L));
            super.setVisibleAmount(10);
            this.setModelInterface((ModelInterface)((BoundedLong)this.defaultRangeModel));
        }
    }

    @Override
    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        return requiredInterfaces;
    }

    public boolean isDefaultModelAttached() {
        return this.defaultRangeModel == this.getModelInterface();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (com.sas.util.Util.equal((Object)event.getPropertyName(), (Object)"numberValue")) {
            this.refreshValue();
        } else if (com.sas.util.Util.equal((Object)event.getPropertyName(), (Object)"blockIncrementNumber")) {
            this.refreshBlockIncrement();
        } else if (com.sas.util.Util.equal((Object)event.getPropertyName(), (Object)"unitIncrementNumber")) {
            this.refreshUnitIncrement();
        } else if (com.sas.util.Util.equal((Object)event.getPropertyName(), (Object)"maximumNumber")) {
            this.refreshMaximum();
        } else if (com.sas.util.Util.equal((Object)event.getPropertyName(), (Object)"minimumNumber")) {
            this.refreshMinimum();
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        if (this.defaultRangeModel == null) {
            this.defaultRangeModel = new BoundedLong();
            ((BoundedLong)this.defaultRangeModel).initialize();
            ModelInterface oldModel = this.getModelInterface();
            if (oldModel == null) {
                Long newValue = new Long(this.getValue());
                Long max = new Long(this.getMaximum());
                Long min = new Long(this.getMinimum());
                Long unit = new Long(this.getUnitIncrement());
                Long block = new Long(this.getBlockIncrement());
                ((BoundedLong)this.defaultRangeModel).setNumberValues((Number)newValue, (Number)min, (Number)max, (Number)unit, (Number)block);
                this.setModelInterface((ModelInterface)((BoundedLong)this.defaultRangeModel));
            } else if (oldModel instanceof IntegerRange) {
                IntegerRange oldRange = (IntegerRange)oldModel;
                Number newValue = oldRange.getNumberValue();
                Number min = oldRange.getMinimumNumber();
                Number max = oldRange.getMaximumNumber();
                Number unit = oldRange.getUnitIncrementNumber();
                Number block = oldRange.getBlockIncrementNumber();
                ((BoundedLong)this.defaultRangeModel).setNumberValues(newValue, min, max, unit, block);
                this.setModelInterface((ModelInterface)((BoundedLong)this.defaultRangeModel));
            }
            this.defaultModel = null;
        }
    }

    @Override
    public void refresh(ModelInterface model) {
        if (model != null) {
            int oldValue = this.getValue();
            int oldBlock = this.getBlockIncrement();
            int oldUnit = this.getUnitIncrement();
            int oldMax = this.getMaximum();
            int oldMin = this.getMinimum();
            BoundedNumberInterface range = (BoundedNumberInterface)this.getModelInterface();
            Number numberValue = range.getNumberValue();
            Number minimumNumber = range.getMinimumNumber();
            Number maximumNumber = range.getMaximumNumber();
            Number blockNumber = range.getBlockIncrementNumber();
            Number unitNumber = range.getUnitIncrementNumber();
            super.setValues(numberValue.intValue(), this.getVisibleAmount(), minimumNumber.intValue(), maximumNumber.intValue());
            super.setBlockIncrement(blockNumber.intValue());
            super.setUnitIncrement(unitNumber.intValue());
            if (!this.anyPropertyChangeListeners()) {
                return;
            }
            if (oldValue != numberValue.intValue()) {
                this.firePropertyChange("value", new Integer(oldValue), new Integer(numberValue.intValue()));
            }
            if (oldBlock != blockNumber.intValue()) {
                this.firePropertyChange("blockIncrement", new Integer(oldBlock), new Integer(blockNumber.intValue()));
            }
            if (oldUnit != unitNumber.intValue()) {
                this.firePropertyChange("unitIncrement", new Integer(oldUnit), new Integer(unitNumber.intValue()));
            }
            if (oldMax != maximumNumber.intValue()) {
                this.firePropertyChange("maximum", new Integer(oldMax), new Integer(maximumNumber.intValue()));
            }
            if (oldMin != minimumNumber.intValue()) {
                this.firePropertyChange("minimum", new Integer(oldMin), new Integer(minimumNumber.intValue()));
            }
        }
    }

    public void refreshBlockIncrement() {
        int oldBlock = this.getBlockIncrement();
        int newBlock = ((BoundedNumberInterface)this.getModelInterface()).getBlockIncrementNumber().intValue();
        if (newBlock != oldBlock) {
            super.setBlockIncrement(newBlock);
            if (!this.anyPropertyChangeListeners()) {
                return;
            }
            this.firePropertyChange("blockIncrement", new Integer(oldBlock), new Integer(newBlock));
        }
    }

    public void refreshMaximum() {
        int oldMax = this.getMaximum();
        int newMax = ((BoundedNumberInterface)this.getModelInterface()).getMaximumNumber().intValue();
        if (newMax != oldMax) {
            int oldValue = this.getValue();
            int oldVisible = this.getVisibleAmount();
            int oldUnitIncr = this.getUnitIncrement();
            int oldBlockIncr = this.getBlockIncrement();
            super.setValues(this.getValue(), this.getVisibleAmount(), this.getMinimum(), newMax);
            if (!this.anyPropertyChangeListeners()) {
                return;
            }
            int newValue = this.getValue();
            int newVisible = this.getVisibleAmount();
            int newUnitIncr = this.getUnitIncrement();
            int newBlockIncr = this.getBlockIncrement();
            this.firePropertyChange("maximum", new Integer(oldMax), new Integer(newMax));
            if (oldValue != newValue) {
                this.firePropertyChange("value", new Integer(oldValue), new Integer(newValue));
            }
            if (oldVisible != newVisible) {
                this.firePropertyChange("visibleAmount", new Integer(oldVisible), new Integer(newVisible));
            }
            if (oldUnitIncr != newUnitIncr) {
                this.firePropertyChange("unitIncrement", new Integer(oldUnitIncr), new Integer(newUnitIncr));
            }
            if (oldBlockIncr != newBlockIncr) {
                this.firePropertyChange("blockIncrement", new Integer(oldBlockIncr), new Integer(newBlockIncr));
            }
        }
    }

    public void refreshMinimum() {
        int oldMin = this.getMinimum();
        int newMin = ((BoundedNumberInterface)this.getModelInterface()).getMinimumNumber().intValue();
        if (newMin != oldMin) {
            int oldValue = this.getValue();
            int oldVisible = this.getVisibleAmount();
            int oldUnitIncr = this.getUnitIncrement();
            int oldBlockIncr = this.getBlockIncrement();
            super.setValues(this.getValue(), this.getVisibleAmount(), newMin, this.getMaximum());
            if (!this.anyPropertyChangeListeners()) {
                return;
            }
            int newValue = this.getValue();
            int newVisible = this.getVisibleAmount();
            int newUnitIncr = this.getUnitIncrement();
            int newBlockIncr = this.getBlockIncrement();
            this.firePropertyChange("minimum", new Integer(oldMin), new Integer(newMin));
            if (oldValue != newValue) {
                this.firePropertyChange("value", new Integer(oldValue), new Integer(newValue));
            }
            if (oldVisible != newVisible) {
                this.firePropertyChange("visibleAmount", new Integer(oldVisible), new Integer(newVisible));
            }
            if (oldUnitIncr != newUnitIncr) {
                this.firePropertyChange("unitIncrement", new Integer(oldUnitIncr), new Integer(newUnitIncr));
            }
            if (oldBlockIncr != newBlockIncr) {
                this.firePropertyChange("blockIncrement", new Integer(oldBlockIncr), new Integer(newBlockIncr));
            }
        }
    }

    public void refreshUnitIncrement() {
        int oldUnit = this.getUnitIncrement();
        int newUnit = ((BoundedNumberInterface)this.getModelInterface()).getUnitIncrementNumber().intValue();
        if (newUnit != oldUnit) {
            super.setUnitIncrement(newUnit);
            if (!this.anyPropertyChangeListeners()) {
                return;
            }
            this.firePropertyChange("unitIncrement", new Integer(oldUnit), new Integer(newUnit));
        }
    }

    public void refreshValue() {
        int oldValue = this.getValue();
        int newValue = ((BoundedNumberInterface)this.getModelInterface()).getNumberValue().intValue();
        if (newValue != oldValue) {
            super.setValue(newValue);
            if (!this.anyPropertyChangeListeners()) {
                return;
            }
            this.firePropertyChange("value", new Integer(oldValue), new Integer(newValue));
        }
    }

    @Override
    public void setBlockIncrement(int v) {
        ModelInterface model = this.getModelInterface();
        if (this.getBlockIncrement() != v && model != null) {
            ((BoundedNumberInterface)model).setBlockIncrementNumber((Number)new Integer(v));
        }
    }

    @Override
    public void setDefaultValues() {
        super.setUnitIncrement(1);
        super.setBlockIncrement(10);
        super.setValues(0, 10, 0, 100);
        super.setDefaultValues();
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        this.setRequiredInterfaces(requiredInterfaces);
        this.defaultRangeModel = new BoundedLong();
        ((BoundedLong)this.defaultRangeModel).initialize();
        this.defaultRangeModel.setBlockIncrementNumber((Number)new Long(this.getBlockIncrement()));
        this.defaultRangeModel.setUnitIncrementNumber((Number)new Long(this.getUnitIncrement()));
        this.defaultRangeModel.setMinimumNumber((Number)new Long(this.getMinimum()));
        this.defaultRangeModel.setMaximumNumber((Number)new Long(this.getMaximum()));
        this.defaultRangeModel.setNumberValue((Number)new Long(this.getValue()));
        this.attachModel((ModelInterface)this.defaultRangeModel);
    }

    @Override
    public void setMaximum(int newMaximum) {
        ModelInterface model = this.getModelInterface();
        if (this.getMaximum() != newMaximum && model != null) {
            ((BoundedNumberInterface)model).setMaximumNumber((Number)new Integer(newMaximum));
        }
    }

    @Override
    public void setMinimum(int newMinimum) {
        ModelInterface model = this.getModelInterface();
        if (this.getMinimum() != newMinimum && model != null) {
            ((BoundedNumberInterface)model).setMinimumNumber((Number)new Integer(newMinimum));
        }
    }

    @Override
    public void setOrientation(int orientation) {
        int oldOrient = this.getOrientation();
        if (oldOrient != orientation) {
            super.setOrientation(orientation);
            int currentWidth = this.getWidth();
            int currentHeight = this.getHeight();
            this.setSize(currentHeight, currentWidth);
            if (!this.anyPropertyChangeListeners()) {
                return;
            }
            this.firePropertyChange("orientation", new Integer(oldOrient), new Integer(orientation));
        }
    }

    @Override
    public void setUnitIncrement(int v) {
        ModelInterface model = this.getModelInterface();
        if (this.getUnitIncrement() != v && model != null) {
            ((BoundedNumberInterface)model).setUnitIncrementNumber((Number)new Integer(v));
        }
    }

    @Override
    public void setValue(int newValue) {
        int maxValue = this.getMaximum() - this.getVisibleAmount();
        int minValue = this.getMinimum();
        if (newValue > maxValue) {
            newValue = maxValue;
        } else if (newValue < minValue) {
            newValue = minValue;
        }
        ModelInterface model = this.getModelInterface();
        if (this.getValue() != newValue && model != null) {
            ((BoundedNumberInterface)model).setNumberValue((Number)new Integer(newValue));
        }
    }

    @Override
    public void setValues(int value, int visible, int minimum, int maximum) {
        ModelInterface model = this.getModelInterface();
        if (model != null) {
            BoundedNumberInterface range = (BoundedNumberInterface)model;
            if (this.getMinimum() != minimum) {
                range.setMinimumNumber((Number)new Integer(minimum));
            }
            if (this.getMaximum() != maximum) {
                range.setMaximumNumber((Number)new Integer(maximum));
            }
            int minValue = this.getMinimum();
            int maxValue = this.getMaximum() - visible;
            if (value > maxValue) {
                value = maxValue;
            } else if (value < minValue) {
                value = minValue;
            }
            if (this.getValue() != value) {
                range.setNumberValue((Number)new Integer(value));
            }
            super.setValues(value, visible, minimum, maximum);
        }
    }

    @Override
    public void setVisibleAmount(int newAmount) {
        int oldVis = this.getVisibleAmount();
        if (oldVis != newAmount) {
            int oldValue = this.getValue();
            super.setVisibleAmount(newAmount);
            if (!this.anyPropertyChangeListeners()) {
                return;
            }
            int newValue = this.getValue();
            this.firePropertyChange("visibleAmount", new Integer(oldVis), new Integer(this.getVisibleAmount()));
            if (oldValue != newValue) {
                this.firePropertyChange("value", new Integer(oldValue), new Integer(newValue));
            }
        }
    }

    static {
        defaultWidth = 16;
        defaultHeight = 124;
    }
}

