/*
 * Decompiled with CFR 0.152.
 */
package com.sas.awt;

import com.sas.ComponentInterface;
import com.sas.ComponentInterfaceSupport;
import com.sas.ModelInterface;
import com.sas.PublicClonable;
import com.sas.RB;
import com.sas.ViewDefaultModelInterface;
import com.sas.awt.ButtonVisualComponent;
import com.sas.awt.VisualInterfaceSupport;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.beans.Util;
import com.sas.lang.StringData;
import com.sas.lang.StringDataInterface;
import com.sas.visuals.ResizeToFitInterface;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.SystemColor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;

public class Button
extends ButtonVisualComponent
implements PublicClonable,
StringDataInterface,
ResizeToFitInterface,
ViewDefaultModelInterface {
    private boolean resizeToFit;
    private StringData defaultModel;
    static final long serialVersionUID = -1924370629978755142L;
    public static final String RB_KEY = "Button.";
    private static String[] requiredInterfacesString = new String[]{"com.sas.lang.StringDataInterface"};
    static int defaultWidth = 75;
    static int defaultHeight = 23;

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static synchronized void setDefaultWidth(int newDefaultWidth) {
        defaultWidth = newDefaultWidth;
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static synchronized void setDefaultHeight(int newDefaultHeight) {
        defaultHeight = newDefaultHeight;
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "border"}, {"Hidden", "true"}}, {{"Name", "actionCommand"}, {"Description", com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"actionCommand.pd.txt")}}, {{"Name", "defaultModelAttached"}, {"Description", com.sas.util.Util.getCommonStringResource((String)"defaultModelAttached.pd.txt")}, {"Expert", "true"}}, {{"Name", "label"}, {"Hidden", "true"}}, {{"Name", "resizeToFit"}, {"Description", com.sas.util.Util.getCommonStringResource((String)"resizeToFit.pd.txt")}}, {{"Name", "text"}, {"Description", com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"text.pd.txt")}}, {{"Name", "transparent"}, {"Hidden", "true"}}, {{"Name", "defaultWidth"}, {"Default value", "75"}, {"Description", RB.getStringResource((String)"VisualInterface.defaultWidth.pd.txt")}}, {{"Name", "defaultHeight"}, {"Default value", "23"}, {"Description", RB.getStringResource((String)"VisualInterface.defaultHeight.pd.txt")}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "text";
        ebi.defaultOutputPropertyName = "text";
        ebi.shortDescription = com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"description.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public Button() {
        this.initializeComponent();
        if (this.isDesignTime()) {
            this.setText(com.sas.awt.RB.getStringResource((String)"Button.txt"));
        }
        this.setBackgroundColor(SystemColor.control);
    }

    public Button(String text) {
        super(text);
        this.initializeComponent();
        this.setBackgroundColor(SystemColor.control);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.checkForResizing();
    }

    @Override
    public void attachModel(ModelInterface model) {
        super.attachModel(model);
        Util.addPropertyChangeListener((Object)model, (PropertyChangeListener)((Object)this));
    }

    private void checkForResizing() {
        if (this.isResizeToFit()) {
            this.setSize(this.getPreferredSize());
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        try {
            Button clone = (Button)this.getClass().newInstance();
            ComponentInterfaceSupport.clone((ComponentInterface)this, (ComponentInterface)clone);
            VisualInterfaceSupport.clone(this, clone);
            clone.setActionCommand(this.getActionCommand());
            clone.setText(this.getLabel());
            clone.setResizeToFit(this.isResizeToFit());
            clone.setBackgroundColor(this.getBackgroundColor());
            clone.setBackgroundColor(this.getBackgroundColor());
            if (this.defaultModel != null && this.getModelInterface() == this.defaultModel) {
                StringData clonedModel = (StringData)this.defaultModel.clone();
                clone.setModelInterface((ModelInterface)clonedModel);
                clone.defaultModel = clonedModel;
            }
            clone.initialize();
            return clone;
        }
        catch (Exception e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
    }

    @Override
    public Dimension computePreferredSize() {
        if (this.getFont() != null && this.getLabel().length() > 0) {
            FontMetrics fontmetrics = this.getFontMetrics(this.getFont());
            int textwidth = fontmetrics.stringWidth(this.getLabel()) + 14;
            int textheight = fontmetrics.getHeight() + 8;
            return new Dimension(textwidth, textheight);
        }
        return super.computePreferredSize();
    }

    @Override
    public void detachModel(ModelInterface model) {
        super.detachModel(model);
        Util.removePropertyChangeListener((Object)model, (PropertyChangeListener)((Object)this));
        ModelInterface modelInterface = this.getModelInterface();
        if (modelInterface == null) {
            this.defaultModel.setText(null);
            this.setModelInterface((ModelInterface)this.defaultModel);
        }
    }

    @Override
    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        return requiredInterfaces;
    }

    public String getText() {
        return this.getLabel();
    }

    public boolean isDefaultModelAttached() {
        return this.defaultModel == this.getModelInterface();
    }

    public boolean isResizeToFit() {
        return this.resizeToFit;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getSource() == this.getModelInterface() && com.sas.util.Util.equal((Object)event.getPropertyName(), (Object)"text")) {
            this.refresh();
        }
    }

    public void refresh() {
        ModelInterface model = this.getModelInterface();
        if (model != null) {
            String text = ((StringDataInterface)model).getText();
            String oldtext = this.getLabel();
            super.setLabel(text);
            if (com.sas.util.Util.unequal((Object)text, (Object)oldtext)) {
                this.checkForResizing();
                if (!this.anyPropertyChangeListeners()) {
                    return;
                }
                this.firePropertyChange("text", oldtext, this.getLabel());
                this.firePropertyChange("label", oldtext, this.getLabel());
            }
        }
    }

    @Override
    public void refresh(ModelInterface model) {
        if (model == null) {
            this.setLabel(null);
        } else {
            this.refresh();
        }
    }

    @Override
    public void setActionCommand(String command) {
        String oldCommand = this.getActionCommand();
        if (com.sas.util.Util.unequal((Object)oldCommand, (Object)command)) {
            super.setActionCommand(command);
            this.firePropertyChange("actionCommand", oldCommand, command);
        }
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.defaultModel = new StringData();
        this.defaultModel.initialize();
        if (super.getLabel() != null) {
            this.defaultModel.setText(super.getLabel());
        }
        this.attachModel((ModelInterface)this.defaultModel);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.checkForResizing();
    }

    @Override
    public void setLabel(String label) {
        ModelInterface model = this.getModelInterface();
        if (com.sas.util.Util.unequal((Object)this.getLabel(), (Object)label) && model != null) {
            ((StringDataInterface)model).setText(label);
        }
    }

    public void setResizeToFit(boolean resizeToFit) {
        if (this.resizeToFit != resizeToFit) {
            this.resizeToFit = resizeToFit;
            this.checkForResizing();
            this.firePropertyChange("resizeToFit", resizeToFit ? Boolean.FALSE : Boolean.TRUE, resizeToFit ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public void setText(String text) {
        this.setLabel(text);
    }
}

