/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.interfaces.ElementParserInterface;
import com.sas.graphics.silk.ui.desktop.SILKDesktopPane;
import com.sas.graphics.silk.ui.desktop.SILKInternalFrame;
import com.sas.graphics.silk.xml.SILKParser;
import com.sas.graphics.silk.xml.parsers.ChartParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.xml.GraphParserFactory;
import java.awt.BorderLayout;
import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import org.w3c.dom.Element;

public class WindowLayoutParser
extends ChartParser
implements ElementParserInterface {
    SILKDesktopPane desktop;

    public WindowLayoutParser() {
        this(new SILKDesktopPane());
    }

    public WindowLayoutParser(SILKDesktopPane desktopIn) {
        if (desktopIn != null) {
            this.desktop = desktopIn;
        }
    }

    private SILKInternalFrame parseWindow(Element window, Hashtable context) {
        int i;
        String close;
        String resize;
        String icon;
        if (context == null) {
            context = new Hashtable();
        }
        String title = window.getAttribute("title");
        boolean maximizable = true;
        boolean iconifiable = true;
        boolean resizable = true;
        boolean closeable = true;
        String max = window.getAttribute("maximizable");
        if (max != null && max.length() > 0) {
            maximizable = ParserUtils.getBooleanValue((String)max);
        }
        if ((icon = window.getAttribute("iconifiable")) != null && icon.length() > 0) {
            iconifiable = ParserUtils.getBooleanValue((String)icon);
        }
        if ((resize = window.getAttribute("resizable")) != null && resize.length() > 0) {
            resizable = ParserUtils.getBooleanValue((String)resize);
        }
        if ((close = window.getAttribute("closeable")) != null && close.length() > 0) {
            closeable = ParserUtils.getBooleanValue((String)close);
        }
        SILKInternalFrame frame = new SILKInternalFrame(title, resizable, closeable, maximizable, iconifiable);
        String x = window.getAttribute("x");
        String y = window.getAttribute("y");
        String width = window.getAttribute("width");
        String height = window.getAttribute("height");
        int X = 10;
        if (x != null && x.length() > 0) {
            X = ParserUtils.getIntValue((String)x);
        }
        int Y = 10;
        if (y != null && y.length() > 0) {
            Y = ParserUtils.getIntValue((String)y);
        }
        int w = 400;
        if (width != null && width.length() > 0) {
            w = ParserUtils.getIntValue((String)width);
        }
        int h = 400;
        if (height != null && height.length() > 0) {
            h = ParserUtils.getIntValue((String)height);
        }
        frame.setBounds(X, Y, w, h);
        Vector previous = (Vector)context.get("CHART_LIST");
        if (previous == null) {
            previous = new Vector();
        }
        Object[] prev = new String[previous.size()];
        previous.copyInto(prev);
        for (int i2 = 0; i2 < prev.length; ++i2) {
            SILKParser.removeChart(context, (String)prev[i2]);
        }
        SILKParser.load(context, (Element)window);
        Object[] charts = SILKParser.getCharts(context);
        Vector vec = (Vector)context.get("CHART_LIST");
        if (vec == null) {
            return frame;
        }
        Object[] chartNames = new String[vec.size()];
        vec.copyInto(chartNames);
        Vector<Object> components = new Vector<Object>();
        for (i = 0; i < charts.length; ++i) {
            Object obj = charts[i];
            if (obj instanceof JComponent) {
                components.addElement(obj);
            }
            SILKParser.removeChart(context, (String)chartNames[i]);
        }
        if (components.size() > 0) {
            frame.getContentPane().setLayout(new BorderLayout());
            frame.setChart((JComponent)components.elementAt(0));
            frame.getContentPane().add("Center", (JComponent)components.elementAt(0));
        }
        for (i = 0; i < prev.length; ++i) {
            SILKParser.addChart(context, (String)prev[i]);
        }
        return frame;
    }

    public Element putToXML(Hashtable context, Object instance) {
        SILKDesktopPane pane = this.desktop;
        Object obj = context.get("SILK_DESKTOP");
        if (obj != null && obj instanceof SILKDesktopPane) {
            pane = (SILKDesktopPane)obj;
        }
        if (instance != null && instance instanceof SILKDesktopPane) {
            pane = (SILKDesktopPane)instance;
        }
        Element rc = ParserUtils.newElement((Hashtable)context, (String)"LayoutWindowed");
        JInternalFrame[] frames = pane.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            JComponent chart;
            ElementParserInterface parser;
            Element window = ParserUtils.newElement((Hashtable)context, (String)"Window");
            Rectangle r = frames[i].getBounds();
            window.setAttribute("x", r.x + "");
            window.setAttribute("y", r.y + "");
            window.setAttribute("width", r.width + "");
            window.setAttribute("height", r.height + "");
            window.setAttribute("title", frames[i].getTitle());
            window.setAttribute("maximizable", new Boolean(frames[i].isMaximizable()).toString());
            window.setAttribute("iconifiable", new Boolean(frames[i].isIconifiable()).toString());
            window.setAttribute("resizable", new Boolean(frames[i].isResizable()).toString());
            window.setAttribute("closeable", new Boolean(frames[i].isClosable()).toString());
            if (frames[i] instanceof SILKInternalFrame && (parser = GraphParserFactory.loadParser((Object)(chart = ((SILKInternalFrame)frames[i]).getChart()))) != null) {
                Element e = parser.putToXML(context, (Object)chart);
                window.appendChild(e);
            }
            rc.appendChild(window);
        }
        return rc;
    }

    public Object getObject() {
        return this.desktop;
    }

    protected Element getODSXML(Hashtable context, Object object) {
        return null;
    }

    protected Element getStatgraphXML(Hashtable context, Object object) {
        return null;
    }

    protected void loadFromODS(Hashtable context, Element element) {
    }

    protected void loadFromStatgraph(Hashtable context, Element element) {
        SILKDesktopPane pane = this.desktop;
        Object obj = context.get("SILK_DESKTOP");
        if (obj != null && obj instanceof SILKDesktopPane) {
            pane = (SILKDesktopPane)obj;
        }
        Element window = null;
        int index = 1;
        while ((window = ParserUtils.getChildWithTagName((String)"Window", (Element)element, (int)index)) != null) {
            SILKInternalFrame frame = this.parseWindow(window, context);
            pane.add(frame);
            ++index;
        }
    }

    public boolean setObject(Object instance) {
        if (instance == null || !(instance instanceof SILKDesktopPane)) {
            return false;
        }
        this.desktop = (SILKDesktopPane)instance;
        return true;
    }
}

