/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.LatticeComponent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.xml.SILKParser;
import com.sas.graphics.silk.xml.parsers.ChartParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import org.w3c.dom.Element;

public class LatticeParser
extends ChartParser {
    private LatticeComponent lattice = null;

    public LatticeParser() {
        this(null);
    }

    public LatticeParser(LatticeComponent latticeIn) {
        this.lattice = latticeIn;
    }

    protected void loadFromStatgraph(Hashtable context, Element element) {
    }

    protected void loadFromODS(Hashtable context, Element element) {
    }

    protected Element getODSXML(Hashtable context, Object object) {
        return null;
    }

    protected Element getStatgraphXML(Hashtable context, Object object) {
        int type;
        Element rc = ParserUtils.newElement((Hashtable)context, (String)"Lattice");
        LatticeComponent component = this.lattice;
        if (object instanceof LatticeComponent) {
            component = (LatticeComponent)object;
        }
        if (component == null) {
            return null;
        }
        Object data = component.getDataSource();
        if (data != null) {
            rc.setAttribute("data", ParserUtils.getNameForDataObject((Object)data, (Hashtable)context));
        }
        if ((type = component.getComponentType()) == 2) {
            rc.setAttribute("componentType", "Scatter");
        } else if (type == 1) {
            rc.setAttribute("componentType", "Line");
        } else if (type == 3) {
            rc.setAttribute("componentType", "Bar");
        } else if (type == 4) {
            rc.setAttribute("componentType", "Histogram");
        } else if (type == 14) {
            rc.setAttribute("componentType", "HistogramParm");
        } else if (type == 5) {
            rc.setAttribute("componentType", "PieChart");
        } else if (type == 12) {
            rc.setAttribute("componentType", "Density");
        } else if (type == 9) {
            rc.setAttribute("componentType", "Scatter3D");
        } else if (type == 10) {
            rc.setAttribute("componentType", "Bar3D");
        } else if (type == 17) {
            rc.setAttribute("componentType", "Icicle");
        } else if (type == 18) {
            rc.setAttribute("componentType", "DecisionTree");
        } else if (type == 19) {
            rc.setAttribute("componentType", "Constellation");
        } else if (type == 20) {
            rc.setAttribute("componentType", "Heatmap");
        }
        Dimension cellSize = component.getCellSize();
        if (cellSize != null) {
            rc.setAttribute("cellSize", "(" + cellSize.width + "," + cellSize.height + ")");
        }
        String internalHeaders = component.areCellHeadersInternal() ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
        rc.setAttribute("internalCellHeaders", internalHeaders);
        int numDiv = component.getNumberOfDivisions();
        if (numDiv > 0) {
            rc.setAttribute("numDiv", Integer.toString(numDiv));
        }
        if (!component.isWrapEnabled()) {
            rc.setAttribute("wrapEnabled", Boolean.FALSE.toString());
        }
        String xEqualization = "UNION";
        switch (component.getXEqualizationType()) {
            case 2: {
                xEqualization = "ROW_EQUALIZATION";
                break;
            }
            case 3: {
                xEqualization = "COLUMN_EQUALIZATION";
                break;
            }
            case 1: {
                xEqualization = "DATA";
            }
        }
        rc.setAttribute("xEqualization", xEqualization);
        String yEqualization = "UNION";
        switch (component.getYEqualizationType()) {
            case 2: {
                yEqualization = "ROW_EQUALIZATION";
                break;
            }
            case 3: {
                yEqualization = "COLUMN_EQUALIZATION";
                break;
            }
            case 1: {
                yEqualization = "DATA";
            }
        }
        rc.setAttribute("yEqualization", yEqualization);
        if (!component.isMonitoringAggressive()) {
            rc.setAttribute("aggressiveMonitoring", "false");
        }
        Object[] roles = component.getSupportedRoles(null, true);
        for (int i = 0; i < roles.length; ++i) {
            Object roleValue = component.getAllVariables(roles[i]);
            if (roleValue == null) continue;
            Element e = ParserUtils.newElement((Hashtable)context, (String)"Role");
            e.setAttribute("type", ParserUtils.getString((Object)roles[i]));
            e.setAttribute("discrete", component.isDiscrete(roles[i]) + "");
            Object o = component.getSortOrder(roles[i]);
            if (RoleInterface.ROLE_SORT_ASCENDING.equals(o)) {
                e.setAttribute("sortOrder", "Ascending");
            } else if (RoleInterface.ROLE_SORT_DATA.equals(o)) {
                e.setAttribute("sortOrder", "Data");
            } else if (RoleInterface.ROLE_SORT_DESCENDING.equals(o)) {
                e.setAttribute("sortOrder", "Descending");
            }
            Enumeration en = Extract.elements((Object)roleValue);
            String vars = "";
            while (en.hasMoreElements()) {
                vars = vars + en.nextElement().toString();
                if (!en.hasMoreElements()) continue;
                vars = vars + ",";
            }
            if (vars.length() >= 0) {
                e.setAttribute("variable", vars);
            }
            rc.appendChild(e);
        }
        if (component.areExternalAxesVisible()) {
            rc.setAttribute("externalAxes", Boolean.TRUE.toString());
        }
        rc = component.putChildXML(context, rc);
        return rc;
    }

    public Object getObject() {
        if (this.lattice == null) {
            this.lattice = new LatticeComponent();
        }
        return this.lattice;
    }

    public boolean setObject(Object instance) {
        if (instance == null || !(instance instanceof LatticeComponent)) {
            return false;
        }
        this.lattice = (LatticeComponent)instance;
        return true;
    }

    public Object getFromXML(Hashtable context, Element element, Object instance) {
        String data;
        String aggressiveMonitoring;
        String externalAxes;
        String yEqualization;
        String xEqualization;
        String internalHeaders;
        String wrapEnabled;
        int numDivisions;
        Vector previous = (Vector)context.get("CHART_LIST");
        if (previous == null) {
            previous = new Vector();
        }
        Object[] prev = new String[previous.size()];
        previous.copyInto(prev);
        for (int i = 0; i < prev.length; ++i) {
            SILKParser.removeChart((Hashtable)context, (String)prev[i]);
        }
        if (instance instanceof LatticeComponent) {
            this.lattice = (LatticeComponent)instance;
        }
        if (this.lattice == null) {
            this.lattice = new LatticeComponent();
        }
        String cellSize = element.getAttribute("cellSize");
        Dimension cs = new Dimension(200, 200);
        if (cellSize != null && cellSize.length() > 0) {
            String width = cellSize.substring(cellSize.indexOf("(") + 1, cellSize.indexOf(","));
            String height = cellSize.substring(cellSize.indexOf(",") + 1, cellSize.lastIndexOf(")"));
            int w = 200;
            int h = 200;
            try {
                w = Integer.parseInt(width);
                h = Integer.parseInt(height);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            cs.setSize(w, h);
        }
        this.lattice.setCellSize(cs);
        String numDiv = element.getAttribute("numDiv");
        if (numDiv != null && numDiv.length() > 0 && (numDivisions = ParserUtils.getIntValue((String)numDiv)) > 0) {
            this.lattice.setNumberOfDivisions(numDivisions);
        }
        if ("FALSE".equalsIgnoreCase(wrapEnabled = element.getAttribute("wrapEnabled"))) {
            this.lattice.setWrapEnabled(false);
        }
        if ((internalHeaders = element.getAttribute("internalCellHeaders")) != null && internalHeaders.length() > 0 && ("NO".equalsIgnoreCase(internalHeaders) || "FALSE".equalsIgnoreCase(internalHeaders))) {
            this.lattice.setInternalCellHeaders(false);
        }
        if ((xEqualization = element.getAttribute("xEqualization")) != null && xEqualization.length() > 0) {
            if ("ROW_EQUALIZATION".equalsIgnoreCase(xEqualization)) {
                this.lattice.setXEqualizationType(2);
            } else if ("COLUMN_EQUALIZATION".equalsIgnoreCase(xEqualization)) {
                this.lattice.setXEqualizationType(3);
            } else if ("DATA".equalsIgnoreCase(xEqualization)) {
                this.lattice.setXEqualizationType(1);
            } else {
                this.lattice.setXEqualizationType(4);
            }
        }
        if ((yEqualization = element.getAttribute("yEqualization")) != null && yEqualization.length() > 0) {
            if ("ROW_EQUALIZATION".equalsIgnoreCase(yEqualization)) {
                this.lattice.setYEqualizationType(2);
            } else if ("COLUMN_EQUALIZATION".equalsIgnoreCase(yEqualization)) {
                this.lattice.setYEqualizationType(3);
            } else if ("DATA".equalsIgnoreCase(yEqualization)) {
                this.lattice.setYEqualizationType(1);
            } else {
                this.lattice.setYEqualizationType(4);
            }
        }
        if ((externalAxes = element.getAttribute("externalAxes")) != null && externalAxes.length() > 0 && "TRUE".equalsIgnoreCase(externalAxes)) {
            this.lattice.setExternalAxesVisible(true);
        }
        if ((aggressiveMonitoring = element.getAttribute("aggressiveMonitoring")) != null && aggressiveMonitoring.length() > 0) {
            this.lattice.setAggressiveMonitoring(ParserUtils.getBooleanValue((String)aggressiveMonitoring));
        }
        if ((data = element.getAttribute("data")) == null || data.length() <= 0) {
            return this.lattice;
        }
        this.lattice.setDataSource(context.get(data));
        String type = element.getAttribute("componentType");
        if (this.lattice != null && type != null && type.length() > 0) {
            if (type.equalsIgnoreCase("Scatter")) {
                this.lattice.setComponentType(2);
            } else if (type.equalsIgnoreCase("Line")) {
                this.lattice.setComponentType(1);
            } else if (type.equalsIgnoreCase("Bar")) {
                this.lattice.setComponentType(3);
            } else if (type.equalsIgnoreCase("Histogram")) {
                this.lattice.setComponentType(4);
            } else if (type.equalsIgnoreCase("HistogramParm")) {
                this.lattice.setComponentType(14);
            } else if (type.equalsIgnoreCase("PieChart")) {
                this.lattice.setComponentType(5);
            } else if (type.equalsIgnoreCase("Density")) {
                this.lattice.setComponentType(12);
            } else if (type.equalsIgnoreCase("Scatter3D")) {
                this.lattice.setComponentType(9);
            } else if (type.equalsIgnoreCase("Bar3D")) {
                this.lattice.setComponentType(10);
            } else if (type.equalsIgnoreCase("Icicle")) {
                this.lattice.setComponentType(17);
            } else if (type.equalsIgnoreCase("DecisionTree")) {
                this.lattice.setComponentType(18);
            } else if (type.equalsIgnoreCase("Constellation")) {
                this.lattice.setComponentType(19);
            } else if (type.equalsIgnoreCase("Heatmap")) {
                this.lattice.setComponentType(20);
            }
        }
        Object rc = super.getFromXML(context, element, instance);
        this.lattice.initChildrenFromXML(element, new Hashtable());
        Object[] charts = SILKParser.getCharts((Hashtable)context);
        Vector vec = (Vector)context.get("CHART_LIST");
        if (vec != null) {
            Object[] chartNames = new String[vec.size()];
            vec.copyInto(chartNames);
            Vector<Object> components = new Vector<Object>();
            for (int i = 0; i < charts.length; ++i) {
                Object obj = charts[i];
                if (obj instanceof JComponent) {
                    components.addElement(obj);
                }
                if (obj instanceof LatticeComponent) continue;
                SILKParser.removeChart((Hashtable)context, (String)chartNames[i]);
            }
        }
        for (int i = 0; i < prev.length; ++i) {
            SILKParser.addChart((Hashtable)context, (String)prev[i]);
        }
        return rc;
    }
}

