/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.HeatmapComponent;
import com.sas.graphics.silk.interfaces.ColorInterface;
import com.sas.graphics.silk.util.ColorRamp;
import com.sas.graphics.silk.xml.parsers.ChartParser;
import com.sas.graphics.silk.xml.parsers.ColorRampParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.silk.xml.parsers.SILKElementInfoInterface;
import com.sas.graphics.silk.xml.parsers.SILKElementInfoReader;
import com.sas.graphics.util.ColorParse;
import java.awt.Color;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Element;

public class HeatmapParser
extends ChartParser {
    private HeatmapComponent heatmap = null;
    SILKElementInfoReader heatmapInfo = null;

    public HeatmapParser() {
        this(new HeatmapComponent());
    }

    public HeatmapParser(HeatmapComponent instance) {
        this.heatmap = instance;
        String configFile = "com/sas/graphics/silk/xml/parsers/config/heatmap.config";
        this.heatmapInfo = new SILKElementInfoReader(configFile);
        this.heatmapInfo.setInstance((Object)this.heatmap);
    }

    protected void loadFromStatgraph(Hashtable context, Element element) {
        String colList;
        Element colorRamp;
        ParserUtils.parseElement((Hashtable)context, (Element)element, (SILKElementInfoInterface)this.heatmapInfo);
        if (this.heatmap.getChart() == null) {
            return;
        }
        String type = element.getAttribute("colorRangeType");
        if (type.length() > 0 && type.equalsIgnoreCase("continuous")) {
            this.heatmap.getChart().setColorRangeType(2);
        }
        if ((colorRamp = ParserUtils.getChildWithTagName((String)"continueColorRamp", (Element)element)) != null) {
            this.heatmap.getChart().setColorRamp(this.getColorRamp(colorRamp), 2);
        }
        if ((colorRamp = ParserUtils.getChildWithTagName((String)"discreteColorRamp", (Element)element)) != null) {
            this.heatmap.getChart().setColorRamp(this.getColorRamp(colorRamp), 1);
        }
        if ((colList = element.getAttribute("colorList")) != null && colList.length() > 0) {
            this.heatmap.getChart().setColorList(this.parseColorList(colList));
        }
    }

    private Color[] parseColorList(String colList) {
        Vector<Color> colors = new Vector<Color>();
        colList = colList.replace("(", "");
        colList = colList.replace(")", "");
        int index = -1;
        do {
            int lastIndex;
            if ((index = colList.indexOf(",", lastIndex = index + 1)) >= 0 && index < colList.length()) {
                colors.add(ColorParse.getColorFromString((String)colList.substring(lastIndex, index)));
                continue;
            }
            colors.add(ColorParse.getColorFromString((String)colList.substring(lastIndex)));
        } while (index >= 0 && index < colList.length());
        Color[] colorList = null;
        if (colors.size() > 0) {
            colorList = new Color[colors.size()];
            for (int i = 0; i < colors.size(); ++i) {
                colorList[i] = (Color)colors.elementAt(i);
            }
        }
        return colorList;
    }

    protected void loadFromODS(Hashtable context, Element element) {
    }

    protected Element getODSXML(Hashtable context, Object object) {
        return null;
    }

    protected Element getStatgraphXML(Hashtable context, Object object) {
        Color[] colorList;
        ColorRampParser crp;
        Element el;
        Element rc = ParserUtils.toXML((String)this.getTagName(), (Hashtable)context, (Object)object, (SILKElementInfoInterface)this.heatmapInfo);
        if (!(object instanceof HeatmapComponent) || ((HeatmapComponent)object).getChart() == null) {
            return rc;
        }
        int type = ((HeatmapComponent)object).getChart().getColorRangeType();
        if (type == 2) {
            rc.setAttribute("colorRangeType", "continuous");
            if (((HeatmapComponent)object).getChart().hasUserSetValue(805) && (el = (crp = new ColorRampParser()).putToXML(context, (Object)"continuousColorRamp")) != null) {
                rc.appendChild(el);
            }
        } else if (((HeatmapComponent)object).getChart().hasUserSetValue(804) && (el = (crp = new ColorRampParser()).putToXML(context, (Object)"discreteColorRamp")) != null) {
            rc.appendChild(el);
        }
        if ((colorList = ((HeatmapComponent)object).getChart().getColorList()) != null && colorList.length > 0) {
            StringBuffer colList = new StringBuffer();
            colList.append("(");
            for (int i = 0; i < colorList.length; ++i) {
                colList.append(ColorParse.getColorStrg((Color)colorList[i], (boolean)false));
                if (i >= colorList.length - 1) continue;
                colList.append(",");
            }
            colList.append(")");
            rc.setAttribute("colorList", colList.toString());
        }
        return rc;
    }

    public Object getObject() {
        return this.heatmap;
    }

    public String getTagName() {
        return this.heatmapInfo.props.getProperty("ElementName");
    }

    public boolean setObject(Object instance) {
        if (instance == null || !(instance instanceof HeatmapComponent)) {
            return false;
        }
        this.heatmap = (HeatmapComponent)instance;
        String configFile = "com/sas/graphics/silk/xml/parsers/config/heatmap.config";
        this.heatmapInfo = new SILKElementInfoReader(configFile);
        this.heatmapInfo.setInstance((Object)this.heatmap);
        return true;
    }

    private ColorInterface getColorRamp(Element element) {
        ColorRamp rc = new ColorRamp();
        ColorRampParser crp = new ColorRampParser();
        crp.getFromXML(null, element, (Object)rc);
        return rc;
    }
}

