/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.DendrogramComponent;
import com.sas.graphics.silk.xml.parsers.ChartParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.silk.xml.parsers.SILKElementInfoInterface;
import com.sas.graphics.silk.xml.parsers.SILKElementInfoReader;
import java.util.Hashtable;
import org.w3c.dom.Element;

public class DendrogramParser
extends ChartParser {
    private DendrogramComponent dendrogram = null;
    private SILKElementInfoReader dendrogramInfo = null;

    public DendrogramParser() {
        this(new DendrogramComponent());
    }

    public DendrogramParser(DendrogramComponent instance) {
        this.dendrogram = instance;
        String configFile = "com/sas/graphics/silk/xml/parsers/config/dendrogram.config";
        this.dendrogramInfo = new SILKElementInfoReader(configFile);
        this.dendrogramInfo.setInstance((Object)this.dendrogram);
    }

    protected void loadFromStatgraph(Hashtable context, Element element) {
        ParserUtils.parseElement((Hashtable)context, (Element)element, (SILKElementInfoInterface)this.dendrogramInfo);
        String orient = element.getAttribute("orient");
        if (orient.length() > 0 && orient.equalsIgnoreCase("Vertical") && this.dendrogram.getChart() != null) {
            this.dendrogram.getChart().setOrientation(1);
        }
    }

    protected void loadFromODS(Hashtable context, Element element) {
    }

    protected Element getODSXML(Hashtable context, Object object) {
        return null;
    }

    protected Element getStatgraphXML(Hashtable context, Object object) {
        int type;
        DendrogramComponent d = this.dendrogram;
        if (object instanceof DendrogramComponent) {
            d = (DendrogramComponent)object;
        }
        Element e = ParserUtils.toXML((String)"Dendrogram", (Hashtable)context, (Object)d, (SILKElementInfoInterface)this.dendrogramInfo);
        if (d.getChart() != null && (type = d.getChart().getOrientation()) == 1) {
            e.setAttribute("orient", "Vertical");
        }
        return e;
    }

    public Object getObject() {
        return this.dendrogram;
    }

    public boolean setObject(Object instance) {
        if (instance == null || !(instance instanceof DendrogramComponent)) {
            return false;
        }
        this.dendrogram = (DendrogramComponent)instance;
        String configFile = "com/sas/graphics/silk/xml/parsers/config/dendrogram.config";
        this.dendrogramInfo = new SILKElementInfoReader(configFile);
        this.dendrogramInfo.setInstance((Object)this.dendrogram);
        return true;
    }
}

