/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util.nld;

import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.event.NLDModelListenerInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.DataFilterWriteInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.util.CharacterVariableMapper;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.util.nld.NLD;
import com.sas.graphics.util.nld.NLDNode;
import com.sas.graphics.util.nld.NLDProperties;
import com.sas.graphics.util.nld.NLDViewer;
import com.sas.graphics.util.nld.VectorNodeModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DataFilterNodeModel
extends VectorNodeModel
implements RoleInterface,
DataFilterListenerInterface {
    private static final long serialVersionUID = -1278660115779900532L;
    private DataFilterReadInterface filter;
    protected static Integer[] values = new Integer[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3), new Integer(4), new Integer(5), new Integer(6), new Integer(7), new Integer(8), new Integer(9), new Integer(10), new Integer(11), new Integer(12), new Integer(13), new Integer(14), new Integer(15)};
    protected final NLDProperties props = new NLDProperties((Object[])keys, (Object[])values);
    protected static final int NUM_INPUT_ROLES = 16;
    protected Object[] ROLE_TO_ID_MAP;
    protected Vector listeners;
    protected boolean[] maps = new boolean[3];
    public static final int NUM_SHAPES = 4;
    private int shape;
    protected NLDViewer viewer = null;
    private Hashtable tableIdToDataIdx;
    private Hashtable tableIdToFilterIdx;
    private Hashtable selectedNodeIndices = new Hashtable();

    public DataFilterNodeModel() {
        this.ROLE_TO_ID_MAP = new Object[16];
        this.listeners = new Vector();
    }

    public DataFilterNodeModel(Object dataIn) {
        this.setDataSource(dataIn);
        this.ROLE_TO_ID_MAP = new Object[16];
        this.listeners = new Vector();
    }

    private DataFilterReadInterface getFilter(Object data) {
        if (data instanceof DataFilterReadInterface) {
            return (DataFilterReadInterface)data;
        }
        return FilterFactory.getDataSourceFilter((Object)data);
    }

    public DataFilterReadInterface getFilter() {
        return this.filter;
    }

    public Object getVariable(int id) {
        return this.ROLE_TO_ID_MAP[id];
    }

    public Object[] getColumn(Object id) {
        if (id instanceof String) {
            int property = this.props.getPropertyIndex((String)id);
            return this.getColumn(property);
        }
        return null;
    }

    public Object[] getColumn(int id) {
        int n = this.numNodes();
        Object[] rc = new Object[n];
        for (int i = 0; i < n; ++i) {
            rc[i] = this.getValue(id, i);
        }
        return rc;
    }

    private void setNodeLabelState(NLDNode n) {
        switch (this.nodeLabelMode) {
            case 3: 
            case 4: {
                if (n.isSelected()) {
                    n.setShowLabel(true);
                    break;
                }
                n.setShowLabel(false);
            }
        }
    }

    public int getNodeIndxFromFilter(int index) {
        if (this.tableIdToFilterIdx == null) {
            return -1;
        }
        String oneNodeId = ((NLDNode)this.elementAt(index)).getID();
        Object retVal = null;
        retVal = this.tableIdToFilterIdx.get(oneNodeId);
        if (retVal != null) {
            return retVal;
        }
        return -1;
    }

    public void setSelected(int[] indices, boolean flag, int cntr, boolean handleEvents) {
        int[] indx = new int[cntr];
        for (int i = 0; i < cntr; ++i) {
            int filterIdx;
            NLDNode n = (NLDNode)this.elementAt(indices[i]);
            if (handleEvents) {
                n.setSelected(flag);
                this.setNodeLabelState(n);
            }
            if ((filterIdx = this.getNodeIndxFromFilter(indices[i])) < 0) continue;
            indx[i] = filterIdx;
        }
        if (this.filter != null) {
            this.filter.setSelected((Object)indx, flag);
        }
    }

    public void setSelected(int index, boolean flag, boolean handleEvents) {
        NLDNode n = (NLDNode)this.elementAt(index);
        if (handleEvents) {
            n.setSelected(flag);
            this.setNodeLabelState(n);
        }
        if (this.filter != null) {
            int filterIdx = this.getNodeIndxFromFilter(index);
            if (filterIdx < 0) {
                return;
            }
            this.filter.setSelected((long)filterIdx, flag);
        }
    }

    public void setValue(int property, int id, double val) {
        super.setValue(property, id, val);
        Object variable = this.getVariable(property);
        if (variable != null && this.filter instanceof DataFilterWriteInterface) {
            DataFilterWriteInterface data = (DataFilterWriteInterface)this.filter;
            data.setValue(variable, (long)id, (Object)new Double(val));
        }
    }

    public void setValue(int property, int id, String val) {
        super.setValue(property, id, val);
        Object variable = this.getVariable(property);
        if (variable != null && this.filter instanceof DataFilterWriteInterface) {
            DataFilterWriteInterface data = (DataFilterWriteInterface)this.filter;
            data.setValue(variable, (long)id, (Object)val);
        }
    }

    public void setValue(int property, int id, Color val) {
        super.setValue(property, id, val);
        Object variable = this.getVariable(property);
        if (variable != null && this.filter instanceof DataFilterWriteInterface) {
            DataFilterWriteInterface data = (DataFilterWriteInterface)this.filter;
            data.setValue(variable, (long)id, (Object)val);
        }
    }

    public NLDNode getNode(Object ID) {
        if (this.tableIdToDataIdx == null) {
            return null;
        }
        int targetOb = -1;
        Integer index = (Integer)this.tableIdToDataIdx.get(ID);
        if (index != null) {
            targetOb = index;
        }
        if (targetOb == -1) {
            return null;
        }
        return this.getNode(targetOb);
    }

    public NLDNode getNode(int targetOb) {
        if (targetOb == -1) {
            return null;
        }
        return (NLDNode)this.elementAt(targetOb);
    }

    private double getDouble(Object o) {
        double num;
        if (o != null && o instanceof Number && !Double.isNaN(num = ((Number)o).doubleValue())) {
            return num;
        }
        return -1.0;
    }

    private String getString(Object o) {
        if (o instanceof String) {
            return (String)o;
        }
        return o.toString();
    }

    private Color getColor(Object o) {
        if (o instanceof Color) {
            return (Color)o;
        }
        if (o instanceof String) {
            return NLD.decodeColor((String)o.toString());
        }
        return null;
    }

    public void addRoleListener(RoleListenerInterface listener) {
    }

    public void removeRoleListener(RoleListenerInterface listener) {
    }

    public Object[] getDataIds() {
        return null;
    }

    public Object getSortOrder(Object variableId) {
        return null;
    }

    public boolean setSortOrder(Object variableId, Object order) {
        return false;
    }

    public boolean supportsMultipleAssignments(Object role) {
        return false;
    }

    public boolean removeRole(Object variableId, Object role) {
        int roleIndex = -1;
        if (!(role instanceof String)) {
            return false;
        }
        roleIndex = this.props.getPropertyIndex((String)role);
        this.ROLE_TO_ID_MAP[roleIndex] = null;
        return true;
    }

    public boolean addRole(Object variableId, Object role) {
        return false;
    }

    public int getMaxAllowed(Object role) {
        return 1;
    }

    public Object[] getSupportedRoles(Object type, boolean discrete) {
        return null;
    }

    public Object getRoleValue(Object role, int which) {
        return null;
    }

    public Object getDataSource() {
        return this.filter;
    }

    public Object getDataSource(Object type) {
        return this.getDataSource();
    }

    public void initNodeModel() {
        this.ROLE_TO_ID_MAP = new Object[16];
        this.listeners = new Vector();
    }

    public int getNodePos(Object nodeid) {
        int nNodes = this.size();
        for (int i = 0; i < nNodes; ++i) {
            NLDNode node = (NLDNode)this.elementAt(i);
            if (!(nodeid instanceof String ? node.getID().equalsIgnoreCase((String)nodeid) : nodeid instanceof Number && node.getID().equalsIgnoreCase(nodeid.toString()))) continue;
            return i;
        }
        return -1;
    }

    private void updateAllNodeValues(int property) {
        int num = this.size();
        switch (property) {
            case 2: {
                for (int i = 0; i < num; ++i) {
                    NLDNode n = (NLDNode)this.elementAt(i);
                    n.setLabel(null);
                }
                break;
            }
            case 3: {
                for (int i = 0; i < num; ++i) {
                    NLDNode n = (NLDNode)this.elementAt(i);
                    n.setInfo(null);
                }
                break;
            }
            case 5: {
                for (int i = 0; i < num; ++i) {
                    NLDNode n = (NLDNode)this.elementAt(i);
                    n.setSize(-1.0);
                }
                break;
            }
            case 4: {
                for (int i = 0; i < num; ++i) {
                    NLDNode n = (NLDNode)this.elementAt(i);
                    n.setColor(null);
                }
                break;
            }
            case 7: {
                for (int i = 0; i < num; ++i) {
                    NLDNode n = (NLDNode)this.elementAt(i);
                    n.setValue(0.0);
                }
                break;
            }
            case 6: {
                for (int i = 0; i < num; ++i) {
                    NLDNode n = (NLDNode)this.elementAt(i);
                    n.setType(this.shape);
                }
                break;
            }
            case 11: {
                for (int i = 0; i < num; ++i) {
                    NLDNode n = (NLDNode)this.elementAt(i);
                    n.setUrl(null);
                }
                break;
            }
            case 13: {
                for (int i = 0; i < num; ++i) {
                    NLDNode n = (NLDNode)this.elementAt(i);
                    n.setIcon((String)null);
                }
                break;
            }
            case 12: {
                for (int i = 0; i < num; ++i) {
                    NLDNode n = (NLDNode)this.elementAt(i);
                    n.setImage((String)null);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < num; ++i) {
                    NLDNode n = (NLDNode)this.elementAt(i);
                    n.setParent(null);
                }
                break;
            }
            case 10: {
                for (int i = 0; i < num; ++i) {
                    NLDNode n = (NLDNode)this.elementAt(i);
                    n.setAction(null);
                }
                break;
            }
        }
    }

    public boolean updateDataSource(Object source) {
        int i;
        this.filter = this.getFilter(source);
        if (this.filter == null) {
            return false;
        }
        if (this.filter.getVariableIndex(this.ROLE_TO_ID_MAP[0]) < 0) {
            return false;
        }
        this.filter.addDataFilterListener((Object)this);
        if (this.tableIdToDataIdx == null) {
            this.tableIdToDataIdx = new Hashtable();
        }
        if (this.tableIdToFilterIdx == null) {
            this.tableIdToFilterIdx = new Hashtable();
        }
        int num = this.filter.getNumberObservations((Object)"ID");
        Enumeration keys = this.tableIdToDataIdx.keys();
        Vector removedNodeIds = new Vector();
        while (keys.hasMoreElements()) {
            String nodeId;
            int i2;
            Object obj = keys.nextElement();
            for (i2 = 0; i2 < num && !(nodeId = this.getString(this.filter.getValue(this.ROLE_TO_ID_MAP[0], (long)i2))).equalsIgnoreCase((String)obj); ++i2) {
            }
            if (i2 != num) continue;
            removedNodeIds.addElement(obj);
        }
        for (int j = 0; j < removedNodeIds.size(); ++j) {
            this.tableIdToDataIdx.remove(removedNodeIds.elementAt(j));
            int idx = -1;
            idx = this.getNodePos(removedNodeIds.elementAt(j));
            if (idx == -1) continue;
            this.nodesToRemove.addElement(this.elementAt(idx));
            this.dynamicRemove(idx);
        }
        this.tableIdToDataIdx.clear();
        for (i = 0; i < this.size(); ++i) {
            NLDNode node = (NLDNode)this.elementAt(i);
            this.tableIdToDataIdx.put(node.getID(), new Integer(i));
        }
        this.nodesToUpdate = new Vector();
        for (i = 0; i < num; ++i) {
            String nodeId = this.getString(this.filter.getValue(this.ROLE_TO_ID_MAP[0], (long)i));
            int nodeIdx = this.getNodePos(nodeId);
            if (this.tableIdToDataIdx.containsKey(nodeId) && nodeIdx != -1) {
                this.tableIdToFilterIdx.put(nodeId, new Integer(i));
                continue;
            }
            if (!this.tableIdToFilterIdx.containsKey(nodeId)) {
                this.tableIdToFilterIdx.put(nodeId, new Integer(i));
            }
            NLDNode n = new NLDNode();
            n.setSelected(this.filter.isSelected((long)i));
            this.addElement(n);
            int idx = this.indexOf(n);
            n.setIndex(idx);
            n.setType(this.shape);
            n.setID(nodeId);
            this.nodesToUpdate.addElement(n);
            this.tableIdToDataIdx.put(nodeId, new Integer(idx));
            if (!this.filter.isSelected((long)i)) continue;
            this.selectedNodeIndices.put(new Integer(idx), new Integer(idx));
        }
        for (i = 1; i < 16; ++i) {
            this.updateAllNodeValues(i);
            if (this.ROLE_TO_ID_MAP[i] == null) continue;
            Object vobj = this.getVariable(i);
            this.setNodeValues(vobj, i);
        }
        return true;
    }

    public boolean setDataSource(Object source) {
        this.filter = this.getFilter(source);
        if (this.filter == null) {
            return false;
        }
        if (this.filter.getVariableIndex(this.ROLE_TO_ID_MAP[0]) < 0) {
            return false;
        }
        this.filter.addDataFilterListener((Object)this);
        if (this.tableIdToDataIdx == null) {
            this.tableIdToDataIdx = new Hashtable();
        } else {
            this.tableIdToDataIdx.clear();
        }
        if (this.tableIdToFilterIdx == null) {
            this.tableIdToFilterIdx = new Hashtable();
        } else {
            this.tableIdToFilterIdx.clear();
        }
        int num = this.filter.getNumberObservations((Object)"ID");
        boolean isDuplicateIdPresent = false;
        for (int i = 0; i < num; ++i) {
            String nodeId = this.getString(this.filter.getValue(this.ROLE_TO_ID_MAP[0], (long)i));
            int nodeIdx = this.getNodePos(nodeId);
            if (this.tableIdToDataIdx.containsKey(nodeId) && nodeIdx != -1) {
                isDuplicateIdPresent = true;
                continue;
            }
            if (!this.tableIdToFilterIdx.containsKey(nodeId)) {
                this.tableIdToFilterIdx.put(nodeId, new Integer(i));
            }
            NLDNode n = new NLDNode();
            n.setID(nodeId);
            n.setType(this.shape);
            this.addElement(n);
            int indx = this.indexOf(n);
            n.setIndex(indx);
            this.tableIdToDataIdx.put(nodeId, new Integer(indx));
            boolean isSelected = this.filter.isSelected((long)i);
            n.setSelected(isSelected);
            if (!isSelected) continue;
            this.selectedNodeIndices.put(new Integer(indx), new Integer(indx));
        }
        if (isDuplicateIdPresent) {
            this.showMessageInConsole("SILKErrorUtilities.DuplicateNodeId.txt", "Duplicate NodeId exists in data set", true);
        }
        for (int j = 1; j < 16; ++j) {
            if (this.ROLE_TO_ID_MAP[j] == null) continue;
            Object vobj = this.getVariable(j);
            this.setNodeValues(vobj, j);
        }
        return true;
    }

    private void showMessageInConsole(String key, String defStrg, boolean isWarning) {
        if (isWarning) {
            String format = this.viewer.GRS("ErrorMessage.fmt.txt", "{0} : {1}");
            String message = this.viewer.GRS(key, defStrg);
            String id = this.viewer.getId() == null ? null : this.viewer.getId().toString();
            System.out.println(MessageFormat.format(format, id, message));
        }
    }

    public boolean setDataSource(Object source, Object type) {
        return this.setDataSource(source);
    }

    public Object getLimit(Object role) {
        return null;
    }

    public boolean setLimit(Object role, Object value) {
        return false;
    }

    public Object[][] getSupportedSortableRoles() {
        return null;
    }

    public int[] getSupportedSortDirections(Object role) {
        return null;
    }

    public void setNodeValues(Object vobj, int property) {
        if (this.filter == null) {
            return;
        }
        int num = this.filter.getNumberObservations(-1);
        CharacterVariableMapper shapeMapper = null;
        int nodeIndex = 0;
        switch (property) {
            case 2: {
                for (int i = 0; i < num && nodeIndex >= 0 && nodeIndex < this.size(); ++i) {
                    String filterNodeId;
                    NLDNode n = (NLDNode)this.elementAt(nodeIndex);
                    String vecNodeId = n.getID();
                    if (!vecNodeId.equalsIgnoreCase(filterNodeId = this.getString(this.filter.getValue(this.ROLE_TO_ID_MAP[0], (long)i)))) continue;
                    ++nodeIndex;
                    Object o = this.filter.getValue(vobj, (long)i);
                    if (o instanceof String) {
                        if (o.toString().length() == 0) {
                            n.setLabel(" ");
                            continue;
                        }
                        n.setLabel((String)o);
                        n.analyseLabel();
                        continue;
                    }
                    if (!(o instanceof Number)) continue;
                    if (((Double)o).isNaN()) {
                        n.setLabel(".");
                        continue;
                    }
                    n.setLabel(((Number)o).toString());
                }
                break;
            }
            case 3: {
                for (int i = 0; i < num && nodeIndex >= 0 && nodeIndex < this.size(); ++i) {
                    String filterNodeId;
                    NLDNode n = (NLDNode)this.elementAt(nodeIndex);
                    String vecNodeId = n.getID();
                    if (!vecNodeId.equalsIgnoreCase(filterNodeId = this.getString(this.filter.getValue(this.ROLE_TO_ID_MAP[0], (long)i)))) continue;
                    ++nodeIndex;
                    Object o = this.filter.getValue(vobj, (long)i);
                    if (o != null) {
                        if (o instanceof String) {
                            if (o.toString().length() == 0) {
                                n.setInfo(" ");
                                continue;
                            }
                            n.setInfo((String)o);
                            n.analyseInfo();
                            continue;
                        }
                        if (!(o instanceof Number)) continue;
                        if (((Double)o).isNaN()) {
                            n.setInfo(".");
                            continue;
                        }
                        n.setInfo(this.filter.getFormattedValue(vobj, (long)i, null));
                        continue;
                    }
                    n.setInfo(null);
                }
                break;
            }
            case 5: {
                for (int i = 0; i < num && nodeIndex >= 0 && nodeIndex < this.size(); ++i) {
                    String filterNodeId;
                    NLDNode n = (NLDNode)this.elementAt(nodeIndex);
                    String vecNodeId = n.getID();
                    if (!vecNodeId.equalsIgnoreCase(filterNodeId = this.getString(this.filter.getValue(this.ROLE_TO_ID_MAP[0], (long)i)))) continue;
                    ++nodeIndex;
                    Object obj = this.filter.getValue(vobj, (long)i);
                    if (null != obj) {
                        n.setSize(this.getDouble(obj));
                        continue;
                    }
                    n.setSize(this.viewer.getNodeSize());
                }
                break;
            }
            case 4: {
                for (int i = 0; i < num && nodeIndex >= 0 && nodeIndex < this.size(); ++i) {
                    String filterNodeId;
                    NLDNode n = (NLDNode)this.elementAt(nodeIndex);
                    String vecNodeId = n.getID();
                    if (!vecNodeId.equalsIgnoreCase(filterNodeId = this.getString(this.filter.getValue(this.ROLE_TO_ID_MAP[0], (long)i)))) continue;
                    ++nodeIndex;
                    Color c = this.getColor(this.filter.getValue(vobj, (long)i));
                    if (c != null) {
                        n.setColor(c);
                        continue;
                    }
                    if (this.filter.isNumericVariable(vobj)) {
                        Object obj = this.filter.getValue(vobj, (long)i);
                        if (obj != null) {
                            double val = ((Number)obj).doubleValue();
                            if (!Double.isNaN(val)) {
                                n.setColorValue(val);
                                continue;
                            }
                            n.setColor(this.viewer.getNodeErrorColor());
                            continue;
                        }
                        n.setColor(this.viewer.getNodeErrorColor());
                        continue;
                    }
                    n.setColor(this.viewer.getNodeErrorColor());
                    n.setBorderColor(this.viewer.getNodeBorderColor());
                }
                break;
            }
            case 14: {
                for (int i = 0; i < num && nodeIndex >= 0 && nodeIndex < this.size(); ++i) {
                    String filterNodeId;
                    NLDNode n = (NLDNode)this.elementAt(nodeIndex);
                    String vecNodeId = n.getID();
                    if (!vecNodeId.equalsIgnoreCase(filterNodeId = this.getString(this.filter.getValue(this.ROLE_TO_ID_MAP[0], (long)i)))) continue;
                    ++nodeIndex;
                    double d = this.filter.getNumericValue(vobj, (long)i);
                    if (Double.isNaN(d)) {
                        n.setColorIndex(-1);
                        continue;
                    }
                    int idx = (int)d % 12;
                    n.setColorIndex(idx);
                }
                break;
            }
            case 15: {
                for (int i = 0; i < num && nodeIndex >= 0 && nodeIndex < this.size(); ++i) {
                    String s;
                    String filterNodeId;
                    NLDNode n = (NLDNode)this.elementAt(nodeIndex);
                    String vecNodeId = n.getID();
                    if (!vecNodeId.equalsIgnoreCase(filterNodeId = this.getString(this.filter.getValue(this.ROLE_TO_ID_MAP[0], (long)i)))) continue;
                    ++nodeIndex;
                    Object o = this.filter.getValue(vobj, (long)i);
                    if (o instanceof Boolean) {
                        n.setHasChildren(((Boolean)o).booleanValue());
                        continue;
                    }
                    if (o == null || !"true".equalsIgnoreCase(s = o.toString()) && !"yes".equalsIgnoreCase(s)) continue;
                    n.setHasChildren(true);
                }
                break;
            }
            case 7: {
                for (int i = 0; i < num && nodeIndex >= 0 && nodeIndex < this.size(); ++i) {
                    String filterNodeId;
                    NLDNode n = (NLDNode)this.elementAt(nodeIndex);
                    String vecNodeId = n.getID();
                    if (!vecNodeId.equalsIgnoreCase(filterNodeId = this.getString(this.filter.getValue(this.ROLE_TO_ID_MAP[0], (long)i)))) continue;
                    ++nodeIndex;
                    n.setValue(this.getDouble(this.filter.getValue(vobj, (long)i)));
                }
                break;
            }
            case 6: {
                int i;
                shapeMapper = new CharacterVariableMapper();
                for (i = 0; i < num; ++i) {
                    Object o = this.filter.getValue(vobj, (long)i);
                    if (o instanceof String) {
                        shapeMapper.addValue((Object)((String)o));
                        continue;
                    }
                    if (!(o instanceof Number)) continue;
                    shapeMapper.addValue((Object)((Number)o).toString());
                }
                for (i = 0; i < num && nodeIndex >= 0 && nodeIndex < this.size(); ++i) {
                    String filterNodeId;
                    NLDNode n = (NLDNode)this.elementAt(nodeIndex);
                    String vecNodeId = n.getID();
                    if (!vecNodeId.equalsIgnoreCase(filterNodeId = this.getString(this.filter.getValue(this.ROLE_TO_ID_MAP[0], (long)i)))) continue;
                    ++nodeIndex;
                    Object o = this.filter.getValue(vobj, (long)i);
                    int shapeType = o instanceof String ? shapeMapper.getIndex((Object)((String)o)) % 4 : (o instanceof Number ? shapeMapper.getIndex((Object)((Number)o).toString()) % 4 : 0);
                    n.setType(shapeType);
                }
                break;
            }
            case 11: {
                for (int i = 0; i < num && nodeIndex >= 0 && nodeIndex < this.size(); ++i) {
                    String s;
                    String filterNodeId;
                    NLDNode n = (NLDNode)this.elementAt(nodeIndex);
                    String vecNodeId = n.getID();
                    if (!vecNodeId.equalsIgnoreCase(filterNodeId = this.getString(this.filter.getValue(this.ROLE_TO_ID_MAP[0], (long)i)))) continue;
                    ++nodeIndex;
                    Object o = this.filter.getValue(vobj, (long)i);
                    if (o == null || (s = o.toString().trim()).length() <= 0) continue;
                    n.setUrl(s);
                }
                break;
            }
            case 13: {
                for (int i = 0; i < num && nodeIndex >= 0 && nodeIndex < this.size(); ++i) {
                    Image img;
                    String s;
                    String filterNodeId;
                    NLDNode n = (NLDNode)this.elementAt(nodeIndex);
                    String vecNodeId = n.getID();
                    if (!vecNodeId.equalsIgnoreCase(filterNodeId = this.getString(this.filter.getValue(this.ROLE_TO_ID_MAP[0], (long)i)))) continue;
                    ++nodeIndex;
                    Object o = this.filter.getValue(vobj, (long)i);
                    if (o == null || (s = o.toString()).length() <= 0 || s.trim().equalsIgnoreCase(".") || (img = ResourceLoader.getImage((Component)this.viewer, (String)s)) == null) continue;
                    n.setIcon(img);
                }
                break;
            }
            case 12: {
                for (int i = 0; i < num && nodeIndex >= 0 && nodeIndex < this.size(); ++i) {
                    Image img;
                    String s;
                    String filterNodeId;
                    NLDNode n = (NLDNode)this.elementAt(nodeIndex);
                    String vecNodeId = n.getID();
                    if (!vecNodeId.equalsIgnoreCase(filterNodeId = this.getString(this.filter.getValue(this.ROLE_TO_ID_MAP[0], (long)i)))) continue;
                    ++nodeIndex;
                    Object o = this.filter.getValue(vobj, (long)i);
                    if (o == null || (s = o.toString()).length() <= 0 || s.trim().equalsIgnoreCase(".") || (img = ResourceLoader.getImage((Component)this.viewer, (String)s)) == null) continue;
                    n.setImage(img);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < num && nodeIndex >= 0 && nodeIndex < this.size(); ++i) {
                    String filterNodeId;
                    NLDNode n = (NLDNode)this.elementAt(nodeIndex);
                    String vecNodeId = n.getID();
                    if (!vecNodeId.equalsIgnoreCase(filterNodeId = this.getString(this.filter.getValue(this.ROLE_TO_ID_MAP[0], (long)i)))) continue;
                    ++nodeIndex;
                    n.setParent((String)this.filter.getValue(vobj, (long)i));
                }
                break;
            }
            case 10: {
                for (int i = 0; i < num && nodeIndex >= 0 && nodeIndex < this.size(); ++i) {
                    String filterNodeId;
                    NLDNode n = (NLDNode)this.elementAt(nodeIndex);
                    String vecNodeId = n.getID();
                    if (!vecNodeId.equalsIgnoreCase(filterNodeId = this.getString(this.filter.getValue(this.ROLE_TO_ID_MAP[0], (long)i)))) continue;
                    ++nodeIndex;
                    n.setAction((String)this.filter.getValue(vobj, (long)i));
                }
                break;
            }
            case 8: {
                for (int i = 0; i < num && nodeIndex >= 0 && nodeIndex < this.size(); ++i) {
                    String filterNodeId;
                    NLDNode n = (NLDNode)this.elementAt(nodeIndex);
                    String vecNodeId = n.getID();
                    if (!vecNodeId.equalsIgnoreCase(filterNodeId = this.getString(this.filter.getValue(this.ROLE_TO_ID_MAP[0], (long)i)))) continue;
                    ++nodeIndex;
                    Object o = this.filter.getValue(vobj, (long)i);
                    if (o instanceof Number) {
                        n.setXPosition(((Number)o).doubleValue());
                        continue;
                    }
                    if (o == null) continue;
                    int xpos = 0;
                    try {
                        xpos = Integer.parseInt(o.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    n.setXPosition((double)xpos);
                }
                break;
            }
            case 9: {
                for (int i = 0; i < num && nodeIndex >= 0 && nodeIndex < this.size(); ++i) {
                    String filterNodeId;
                    NLDNode n = (NLDNode)this.elementAt(nodeIndex);
                    String vecNodeId = n.getID();
                    if (!vecNodeId.equalsIgnoreCase(filterNodeId = this.getString(this.filter.getValue(this.ROLE_TO_ID_MAP[0], (long)i)))) continue;
                    ++nodeIndex;
                    Object o = this.filter.getValue(vobj, (long)i);
                    if (o instanceof Number) {
                        n.setYPosition(((Number)o).doubleValue());
                        continue;
                    }
                    if (o == null) continue;
                    int ypos = 0;
                    try {
                        ypos = Integer.parseInt(o.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    n.setYPosition((double)ypos);
                }
                break;
            }
        }
    }

    private void resetNodeValues(Object vobj, int property) {
        int num = this.filter.getNumberObservations((Object)"ID");
        switch (property) {
            case 2: {
                for (int i = 0; i < num; ++i) {
                    NLDNode n = (NLDNode)this.elementAt(i);
                    n.setLabel(null);
                }
                break;
            }
            case 3: {
                for (int i = 0; i < num; ++i) {
                    NLDNode n = (NLDNode)this.elementAt(i);
                    n.setInfo(null);
                }
                break;
            }
            case 5: {
                for (int i = 0; i < num; ++i) {
                    NLDNode n = (NLDNode)this.elementAt(i);
                    n.setSize(-1.0);
                }
                break;
            }
            case 4: {
                for (int i = 0; i < num; ++i) {
                    NLDNode n = (NLDNode)this.elementAt(i);
                    n.setColor(null);
                }
                break;
            }
            case 7: {
                for (int i = 0; i < num; ++i) {
                    NLDNode n = (NLDNode)this.elementAt(i);
                    n.setValue(0.0);
                }
                break;
            }
            case 6: {
                for (int i = 0; i < num; ++i) {
                    NLDNode n = (NLDNode)this.elementAt(i);
                    n.setType(0);
                }
                break;
            }
            case 11: {
                for (int i = 0; i < num; ++i) {
                    NLDNode n = (NLDNode)this.elementAt(i);
                    n.setUrl(null);
                }
                break;
            }
            case 13: {
                for (int i = 0; i < num; ++i) {
                    NLDNode n = (NLDNode)this.elementAt(i);
                    n.setIcon((String)null);
                }
                break;
            }
            case 12: {
                for (int i = 0; i < num; ++i) {
                    NLDNode n = (NLDNode)this.elementAt(i);
                    n.setImage((String)null);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < num; ++i) {
                    NLDNode n = (NLDNode)this.elementAt(i);
                    n.setParent(null);
                }
                break;
            }
            case 10: {
                for (int i = 0; i < num; ++i) {
                    NLDNode n = (NLDNode)this.elementAt(i);
                    n.setAction(null);
                }
                break;
            }
            case 8: {
                for (int i = 0; i < num; ++i) {
                    NLDNode n = (NLDNode)this.elementAt(i);
                    n.setXPosition(0.0);
                }
                break;
            }
            case 9: {
                for (int i = 0; i < num; ++i) {
                    NLDNode n = (NLDNode)this.elementAt(i);
                    n.setYPosition(0.0);
                }
                break;
            }
        }
    }

    public int getPropertyIndex(String role) {
        return this.props.getPropertyIndex(role);
    }

    public Object getAllVariables(Object role) {
        return this.getVariable(role);
    }

    public Object getVariable(Object role) {
        return this.ROLE_TO_ID_MAP[this.props.getPropertyIndex((String)role)];
    }

    public Object getRole(Object variableId) {
        int r = this.ROLE_TO_ID_MAP.length + 1;
        for (int i = 0; i < this.ROLE_TO_ID_MAP.length; ++i) {
            if (null == this.ROLE_TO_ID_MAP[i] || !this.ROLE_TO_ID_MAP[i].equals(variableId)) continue;
            r = i;
            break;
        }
        if (r < this.ROLE_TO_ID_MAP.length) {
            return keys[r];
        }
        return null;
    }

    public boolean isRoleVariablePairPresent(Object variableId, Object role) {
        int roleIndex = -1;
        if (!(role instanceof String)) {
            return false;
        }
        roleIndex = this.props.getPropertyIndex((String)role);
        if (this.ROLE_TO_ID_MAP[roleIndex] == null) {
            return false;
        }
        return ((String)this.ROLE_TO_ID_MAP[roleIndex]).equalsIgnoreCase((String)variableId);
    }

    public boolean setRole(Object variableId, Object role) {
        int roleIndex = -1;
        if (!(role instanceof String)) {
            return false;
        }
        roleIndex = this.props.getPropertyIndex((String)role);
        this.ROLE_TO_ID_MAP[roleIndex] = variableId;
        if (this.filter != null) {
            this.setNodeValues(variableId, roleIndex);
        }
        return true;
    }

    public boolean isDiscrete(Object variableId) {
        return false;
    }

    public boolean setDiscrete(Object variableId, boolean discrete) {
        return false;
    }

    public boolean requiresMultipleRoleAssignments() {
        return false;
    }

    public void dataFilterChanged(DvrDataFilterEvent evt) {
        switch (evt.type) {
            case 1: {
                this.dataSourceChanged(evt);
                break;
            }
            case 3: {
                this.valueChanged(evt);
                break;
            }
            case 4: {
                this.variableAdded(evt);
                break;
            }
            case 5: {
                this.variableRemoved(evt);
                break;
            }
            case 6: {
                this.formatChanged(evt);
                break;
            }
            case 2: {
                this.dataSelectionChanged(evt);
                break;
            }
        }
    }

    public Collection getSelectedNodeIndices() {
        return this.selectedNodeIndices.values();
    }

    public void dataSelectionChanged(DvrDataFilterEvent evt) {
        if (this.tableIdToDataIdx == null) {
            return;
        }
        if (evt.obsStartIndex == -1 && evt.obsEndIndex == -1) {
            NLDNode n;
            Integer indexInData;
            int i;
            int nNodes;
            boolean state;
            int[] obs = (int[])evt.oldValue;
            int numObs = ((Number)evt.newValue).intValue();
            if (obs == null) {
                if (numObs > this.filter.getNumberObservations(-1)) {
                    numObs = this.filter.getNumberObservations(-1);
                }
                if (!(state = this.filter.isSelected(0L))) {
                    this.selectedNodeIndices.clear();
                }
                nNodes = this.size();
                for (i = 0; i < numObs && i < nNodes; ++i) {
                    String nodeIdFromFilter = this.getString(this.filter.getValue(this.ROLE_TO_ID_MAP[0], (long)i));
                    indexInData = (Integer)this.tableIdToDataIdx.get(nodeIdFromFilter);
                    if (indexInData == null || indexInData < 0 || indexInData >= nNodes) continue;
                    n = (NLDNode)this.elementAt(indexInData);
                    if (state) {
                        this.selectedNodeIndices.put(indexInData, indexInData);
                    }
                    n.setSelected(state);
                    this.setNodeLabelState(n);
                }
            } else if (obs.length > 0) {
                if (numObs > obs.length) {
                    numObs = obs.length;
                }
                state = this.filter.isSelected((long)obs[0]);
                nNodes = this.size();
                for (i = 0; i < numObs; ++i) {
                    String filterNodeId = this.getString(this.filter.getValue(this.ROLE_TO_ID_MAP[0], (long)obs[i]));
                    indexInData = (Integer)this.tableIdToDataIdx.get(filterNodeId);
                    if (indexInData == null || indexInData < 0 || indexInData >= nNodes) continue;
                    n = (NLDNode)this.elementAt(indexInData);
                    if (state) {
                        this.selectedNodeIndices.put(indexInData, indexInData);
                    } else {
                        this.selectedNodeIndices.remove(indexInData);
                    }
                    n.setSelected(state);
                    this.setNodeLabelState(n);
                }
            }
        }
        if (!evt.isAdjusting) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((NLDModelListenerInterface)this.listeners.elementAt(i)).modelChanged();
            }
        }
    }

    public void dataSourceChanged(DvrDataFilterEvent evt) {
        DataFilterReadInterface source = evt.source;
        if (source == this.filter) {
            return;
        }
        this.setDataSource(source);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((NLDModelListenerInterface)this.listeners.elementAt(i)).dataChanged();
        }
    }

    public void valueChanged(DvrDataFilterEvent evt) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((NLDModelListenerInterface)this.listeners.elementAt(i)).dataChanged();
        }
    }

    public void variableAdded(DvrDataFilterEvent evt) {
        int i;
        int role_id = -1;
        for (i = 0; i < 16; ++i) {
            if (evt.varStartIndex != this.filter.getVariableIndex(this.ROLE_TO_ID_MAP[i])) continue;
            role_id = i;
            break;
        }
        if (role_id == -1) {
            return;
        }
        this.setNodeValues(this.ROLE_TO_ID_MAP[role_id], role_id);
        for (i = 0; i < this.listeners.size(); ++i) {
            ((NLDModelListenerInterface)this.listeners.elementAt(i)).dataChanged();
        }
    }

    public void variableRemoved(DvrDataFilterEvent evt) {
        int i;
        int role_id = -1;
        for (i = 0; i < 16; ++i) {
            if (evt.varStartIndex != this.filter.getVariableIndex(this.ROLE_TO_ID_MAP[i])) continue;
            role_id = i;
            break;
        }
        if (role_id == -1) {
            return;
        }
        this.resetNodeValues(this.ROLE_TO_ID_MAP[role_id], role_id);
        for (i = 0; i < this.listeners.size(); ++i) {
            ((NLDModelListenerInterface)this.listeners.elementAt(i)).dataChanged();
        }
    }

    public void formatChanged(DvrDataFilterEvent evt) {
    }

    public void dispose() {
        super.dispose();
        this.viewer = null;
    }

    public void addNLDModelListener(NLDModelListenerInterface obj) {
        if (this.listeners != null && obj != null && !this.listeners.contains(obj)) {
            this.listeners.addElement(obj);
        }
    }

    public void removeNLDModelListener(NLDModelListenerInterface obj) {
        if (this.listeners != null && obj != null && this.listeners.contains(obj)) {
            this.listeners.removeElement(obj);
        }
    }

    public void setSelectAll(boolean flag) {
        this.setSelectAll(flag, false);
    }

    public void setSelectAll(boolean flag, boolean handleEvents) {
        long num = this.size();
        int[] indices = new int[(int)num];
        int cntr = 0;
        int i = 0;
        while ((long)i < num) {
            NLDNode n = (NLDNode)this.elementAt(i);
            if (n.isSelected() != flag) {
                indices[cntr++] = i;
            }
            ++i;
        }
        this.setSelected(indices, flag, cntr, handleEvents);
    }

    public void addObservation(NLDNode n) {
        if (!(this.filter instanceof DataFilterWriteInterface)) {
            return;
        }
        DataFilterWriteInterface data = (DataFilterWriteInterface)this.filter;
        if (this.tableIdToDataIdx == null) {
            this.tableIdToDataIdx = new Hashtable();
        }
        Object id = this.tableIdToDataIdx.get(n.getID());
        int index = -1;
        int num = data.getNumberObservations(this.getVariable(0));
        if (id == null) {
            this.tableIdToDataIdx.put(n.getID(), new Integer(num));
            n.setIndex(num);
            this.addElement(n);
        } else {
            index = (Integer)id;
            this.setElementAt(n, index);
        }
        data.setValue(this.ROLE_TO_ID_MAP[0], (long)index, (Object)n.getID());
        if (this.ROLE_TO_ID_MAP[2] != null) {
            data.setValue(this.ROLE_TO_ID_MAP[2], (long)index, (Object)n.getLabel());
        }
        if (this.ROLE_TO_ID_MAP[3] != null) {
            data.setValue(this.ROLE_TO_ID_MAP[3], (long)index, (Object)n.getInfo());
        }
        if (this.ROLE_TO_ID_MAP[5] != null) {
            data.setValue(this.ROLE_TO_ID_MAP[5], (long)index, (Object)new Double(n.getSize()));
        }
        if (this.ROLE_TO_ID_MAP[4] != null) {
            data.setValue(this.ROLE_TO_ID_MAP[4], (long)index, (Object)String.valueOf(n.getColor().getRGB()));
        }
        if (this.ROLE_TO_ID_MAP[7] != null) {
            data.setValue(this.ROLE_TO_ID_MAP[7], (long)index, (Object)new Double(n.getValue()));
        }
        if (this.ROLE_TO_ID_MAP[6] != null) {
            data.setValue(this.ROLE_TO_ID_MAP[6], (long)index, (Object)new Double(n.getType()));
        }
        if (this.ROLE_TO_ID_MAP[11] != null) {
            data.setValue(this.ROLE_TO_ID_MAP[11], (long)index, (Object)n.getUrl());
        }
        if (this.ROLE_TO_ID_MAP[12] != null) {
            data.setValue(this.ROLE_TO_ID_MAP[12], (long)index, (Object)n.getImage());
        }
        if (this.ROLE_TO_ID_MAP[13] != null) {
            data.setValue(this.ROLE_TO_ID_MAP[13], (long)index, (Object)n.getIcon());
        }
        if (this.ROLE_TO_ID_MAP[1] != null) {
            data.setValue(this.ROLE_TO_ID_MAP[1], (long)index, (Object)n.getParent());
        }
        if (this.ROLE_TO_ID_MAP[10] != null) {
            data.setValue(this.ROLE_TO_ID_MAP[10], (long)index, (Object)n.getAction());
        }
        if (this.ROLE_TO_ID_MAP[8] != null) {
            data.setValue(this.ROLE_TO_ID_MAP[8], (long)index, (Object)new Double(n.getXPosition()));
        }
        if (this.ROLE_TO_ID_MAP[9] != null) {
            data.setValue(this.ROLE_TO_ID_MAP[9], (long)index, (Object)new Double(n.getYPosition()));
        }
    }

    public int getIndexOf(Object nodeid) {
        if (this.tableIdToDataIdx == null) {
            return -1;
        }
        Integer index = (Integer)this.tableIdToDataIdx.get(nodeid.toString());
        if (index != null) {
            return index;
        }
        return super.getIndexOf(nodeid);
    }

    public void unselectAll(boolean handleEvents) {
        long num = this.size();
        int[] indices = new int[(int)num];
        int cntr = 0;
        int i = 0;
        while ((long)i < num) {
            NLDNode n = (NLDNode)this.elementAt(i);
            if (n.isSelected()) {
                indices[cntr++] = i;
                if (handleEvents) {
                    n.setSelected(false);
                    this.setNodeLabelState(n);
                }
            }
            ++i;
        }
        this.setSelected(indices, false, cntr, handleEvents);
    }

    public void sendRepaint() {
        DvrDataFilterEvent evt = new DvrDataFilterEvent();
        evt.type = 7;
        this.filter.sendEvent((Object)evt);
    }

    public int getNumberObservations() {
        if (this.filter != null) {
            return this.filter.getNumberObservations(null);
        }
        return this.size();
    }

    public int getNumberInputRoles() {
        return 16;
    }

    public void setInitX(int id, double val) {
        super.setInitX(id, val);
        if (this.ROLE_TO_ID_MAP[8] != null && this.filter instanceof DataFilterWriteInterface) {
            DataFilterWriteInterface data = (DataFilterWriteInterface)this.filter;
            data.setValue(this.ROLE_TO_ID_MAP[8], (long)id, (Object)new Double(val));
        }
    }

    public void setInitY(int id, double val) {
        super.setInitY(id, val);
        if (this.ROLE_TO_ID_MAP[9] != null && this.filter instanceof DataFilterWriteInterface) {
            DataFilterWriteInterface data = (DataFilterWriteInterface)this.filter;
            data.setValue(this.ROLE_TO_ID_MAP[9], (long)id, (Object)new Double(val));
        }
    }

    public void setColor(int id, Color c) {
        super.setColor(id, c);
        if (this.ROLE_TO_ID_MAP[4] != null && this.filter instanceof DataFilterWriteInterface) {
            DataFilterWriteInterface data = (DataFilterWriteInterface)this.filter;
            data.setValue(this.ROLE_TO_ID_MAP[4], (long)id, (Object)c);
        }
    }

    public void setSize(int id, double val) {
        super.setSize(id, val);
        if (this.ROLE_TO_ID_MAP[5] != null && this.filter instanceof DataFilterWriteInterface) {
            DataFilterWriteInterface data = (DataFilterWriteInterface)this.filter;
            data.setValue(this.ROLE_TO_ID_MAP[5], (long)id, (Object)new Double(val));
        }
    }

    public void setLabel(int id, String val) {
        super.setLabel(id, val);
        if (this.ROLE_TO_ID_MAP[2] != null && this.filter instanceof DataFilterWriteInterface) {
            DataFilterWriteInterface data = (DataFilterWriteInterface)this.filter;
            data.setValue(this.ROLE_TO_ID_MAP[2], (long)id, (Object)val);
        }
    }

    public void setID(int id, String val) {
        super.setID(id, val);
        if (this.ROLE_TO_ID_MAP[0] != null && this.filter instanceof DataFilterWriteInterface) {
            DataFilterWriteInterface data = (DataFilterWriteInterface)this.filter;
            data.setValue(this.ROLE_TO_ID_MAP[0], (long)id, (Object)val);
        }
    }

    public void setParent(int id, String val) {
        super.setParent(id, val);
        if (this.ROLE_TO_ID_MAP[1] != null && this.filter instanceof DataFilterWriteInterface) {
            DataFilterWriteInterface data = (DataFilterWriteInterface)this.filter;
            data.setValue(this.ROLE_TO_ID_MAP[1], (long)id, (Object)val);
        }
    }

    public void setInfo(int id, String val) {
        super.setInfo(id, val);
        if (this.ROLE_TO_ID_MAP[3] != null && this.filter instanceof DataFilterWriteInterface) {
            DataFilterWriteInterface data = (DataFilterWriteInterface)this.filter;
            data.setValue(this.ROLE_TO_ID_MAP[3], (long)id, (Object)val);
        }
    }

    public void setShape(int id, String val) {
        super.setShape(id, val);
        if (this.ROLE_TO_ID_MAP[6] != null && this.filter instanceof DataFilterWriteInterface) {
            DataFilterWriteInterface data = (DataFilterWriteInterface)this.filter;
            data.setValue(this.ROLE_TO_ID_MAP[6], (long)id, (Object)val);
        }
    }

    public void setValue(int id, double val) {
        super.setValue(id, val);
        if (this.ROLE_TO_ID_MAP[7] != null && this.filter instanceof DataFilterWriteInterface) {
            DataFilterWriteInterface data = (DataFilterWriteInterface)this.filter;
            data.setValue(this.ROLE_TO_ID_MAP[7], (long)id, (Object)new Double(val));
        }
    }

    public void setAction(int id, String val) {
        super.setAction(id, val);
        if (this.ROLE_TO_ID_MAP[10] != null && this.filter instanceof DataFilterWriteInterface) {
            DataFilterWriteInterface data = (DataFilterWriteInterface)this.filter;
            data.setValue(this.ROLE_TO_ID_MAP[10], (long)id, (Object)val);
        }
    }

    public void setUrl(int id, String val) {
        super.setUrl(id, val);
        if (this.ROLE_TO_ID_MAP[11] != null && this.filter instanceof DataFilterWriteInterface) {
            DataFilterWriteInterface data = (DataFilterWriteInterface)this.filter;
            data.setValue(this.ROLE_TO_ID_MAP[11], (long)id, (Object)val);
        }
    }

    public void setImage(int id, String val) {
        super.setImage(id, val);
        if (this.ROLE_TO_ID_MAP[12] != null && this.filter instanceof DataFilterWriteInterface) {
            DataFilterWriteInterface data = (DataFilterWriteInterface)this.filter;
            data.setValue(this.ROLE_TO_ID_MAP[12], (long)id, (Object)val);
        }
    }

    public void setIcon(int id, String val) {
        super.setIcon(id, val);
        if (this.ROLE_TO_ID_MAP[13] != null && this.filter instanceof DataFilterWriteInterface) {
            DataFilterWriteInterface data = (DataFilterWriteInterface)this.filter;
            data.setValue(this.ROLE_TO_ID_MAP[13], (long)id, (Object)val);
        }
    }

    public void setImage(int id, Image im) {
        super.setImage(id, im);
        if (this.ROLE_TO_ID_MAP[12] != null && this.filter instanceof DataFilterWriteInterface) {
            DataFilterWriteInterface data = (DataFilterWriteInterface)this.filter;
            data.setValue(this.ROLE_TO_ID_MAP[12], (long)id, (Object)im);
        }
    }

    public void setIcon(int id, Image im) {
        super.setIcon(id, im);
        if (this.ROLE_TO_ID_MAP[13] != null && this.filter instanceof DataFilterWriteInterface) {
            DataFilterWriteInterface data = (DataFilterWriteInterface)this.filter;
            data.setValue(this.ROLE_TO_ID_MAP[13], (long)id, (Object)im);
        }
    }

    public void setShape(int shape) {
        this.shape = shape;
    }

    public void setViewer(NLDViewer viewer) {
        this.viewer = viewer;
    }

    public boolean readNodePositions() {
        int roleXIndex = this.getPropertyIndex("X");
        int roleYIndex = this.getPropertyIndex("Y");
        if (roleXIndex >= 0 && roleXIndex <= this.getNumberInputRoles() && roleYIndex >= 0 && roleYIndex <= this.getNumberInputRoles()) {
            this.setNodeValues(this.getVariable(roleXIndex), roleXIndex);
            this.setNodeValues(this.getVariable(roleYIndex), roleYIndex);
            int num = this.filter.getNumberObservations(-1);
            int nodeIndex = 0;
            Object xPosVariable = this.getVariable(roleXIndex);
            Object yPosVariable = this.getVariable(roleYIndex);
            if (xPosVariable == null || yPosVariable == null) {
                return false;
            }
            for (int i = 0; i < num && nodeIndex >= 0 && nodeIndex < this.size(); ++i) {
                String filterNodeId;
                NLDNode n = (NLDNode)this.elementAt(nodeIndex);
                String vecNodeId = n.getID();
                if (!vecNodeId.equalsIgnoreCase(filterNodeId = this.getString(this.filter.getValue(this.ROLE_TO_ID_MAP[0], (long)i)))) continue;
                ++nodeIndex;
                Object o = this.filter.getValue(xPosVariable, (long)i);
                if (o instanceof Number) {
                    n.setOrgXPosition(((Number)o).doubleValue());
                } else if (o != null) {
                    int xpos = 0;
                    try {
                        xpos = Integer.parseInt(o.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    n.setOrgXPosition((double)xpos);
                }
                o = this.filter.getValue(yPosVariable, (long)i);
                if (o instanceof Number) {
                    n.setOrgYPosition(((Number)o).doubleValue());
                    continue;
                }
                if (o == null) continue;
                int ypos = 0;
                try {
                    ypos = Integer.parseInt(o.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                n.setOrgYPosition((double)ypos);
            }
            return true;
        }
        return false;
    }

    public void updateNodeTable(String nodeId, int nodeIdx) {
        if (this.tableIdToDataIdx == null) {
            this.tableIdToDataIdx = new Hashtable();
        }
        this.tableIdToDataIdx.put(nodeId, new Integer(nodeIdx));
    }
}

