/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util.nld;

import com.sas.graphics.silk.constchart.ConstViewer;
import com.sas.graphics.silk.constchart.layout.GRIPLayout;
import com.sas.graphics.silk.event.NLDModelListenerInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.treeview.TreeViewer;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.nld.DataFilterLinkModel;
import com.sas.graphics.silk.util.nld.DataFilterNodeModel;
import com.sas.graphics.silk.util.nld.DvrLink;
import com.sas.graphics.util.nld.NLDLink;
import com.sas.graphics.util.nld.NLDModel;
import com.sas.graphics.util.nld.NLDNode;
import com.sas.graphics.util.nld.NLDViewer;
import com.sas.graphics.util.nld.VectorLinkModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class DataFilterModel
extends NLDModel
implements NLDModelListenerInterface {
    private Queue[] roles = new Queue[2];
    private DataFilterReadInterface nodedata;
    private DataFilterReadInterface linkdata;
    private int modelMode;
    private Hashtable nodeRoleAssignments = new Hashtable();
    private Hashtable linkRoleAssignments = new Hashtable();
    private Queue linkRoles;
    private Queue nodeRoles;

    public DataFilterModel() {
    }

    public DataFilterModel(int type) {
        super(type);
    }

    public DataFilterModel(Object source) {
        this.links = null;
        DataFilterNodeModel nld = new DataFilterNodeModel(source);
        nld.addNLDModelListener(this);
        this.nodes = nld;
        this.nodes.setLabelMode(this.nodeLabelMode);
    }

    public DataFilterModel(Object ns, Object ls) {
        DataFilterNodeModel nm = new DataFilterNodeModel(ns);
        nm.addNLDModelListener(this);
        this.nodes = nm;
        this.nodes.setLabelMode(this.nodeLabelMode);
        DataFilterLinkModel nl = new DataFilterLinkModel(ls);
        nl.setNodeModel(nm);
        nl.addNLDModelListener(this);
        this.links = nl;
        this.links.setLabelMode(this.nodeLabelMode);
    }

    public void setNodeSource(Object source) {
        if (!(this.nodes instanceof DataFilterNodeModel)) {
            DataFilterNodeModel nld = new DataFilterNodeModel(source);
            nld.addNLDModelListener(this);
            this.nodes = nld;
            this.nodes.setLabelMode(this.nodeLabelMode);
        } else {
            DataFilterNodeModel nld = (DataFilterNodeModel)this.nodes;
            nld.setDataSource(source);
        }
        if (!(this.links instanceof DataFilterLinkModel)) {
            this.links = null;
        }
    }

    public void setLinkSource(Object source) {
        DataFilterLinkModel nl = new DataFilterLinkModel(source);
        nl.addNLDModelListener(this);
        this.links = nl;
        this.links.setLabelMode(this.nodeLabelMode);
        if (!(this.nodes instanceof DataFilterNodeModel)) {
            this.nodes = null;
        }
    }

    public void updateLinks() {
        if (this.links == null) {
            return;
        }
        if (this.hideLinks) {
            boolean visible = false;
            for (int i = 0; i < this.numLinks; ++i) {
                NLDLink a = (NLDLink)this.links.elementAt(i);
                int from = a.getFromIndex();
                int to = a.getToIndex();
                if (from > this.nodes.size() || from < 0 || to > this.nodes.size() || to < 0 || !this.nodes.isVisible(from) || !this.nodes.isVisible(to)) continue;
                boolean fromsel = this.nodes.isSelected(from);
                boolean tosel = this.nodes.isSelected(to);
                visible = false;
                if ((this.arcMask & 1) != 0 && !fromsel && tosel) {
                    visible = true;
                } else if ((this.arcMask & 2) != 0 && fromsel && !tosel) {
                    visible = true;
                } else if ((this.arcMask & 4) != 0 && fromsel && tosel) {
                    visible = true;
                }
                this.links.setVisible(i, visible);
            }
        } else {
            this.links.setShowAll();
        }
        this.initLinkTable();
    }

    public boolean loadLayer(NLDNode parent, int index) {
        return false;
    }

    public boolean loadModel() {
        return this.loadModel(null);
    }

    private void removeUnWantedNodes() {
        int i;
        Vector<String> currentSetOfNodes = new Vector<String>();
        for (int i2 = 0; i2 < this.numLinks; ++i2) {
            Object to;
            NLDLink a = (NLDLink)this.links.elementAt(i2);
            Object from = a.getFromNode();
            if (from != null && !currentSetOfNodes.contains(a.getFromNode().toString())) {
                currentSetOfNodes.addElement(a.getFromNode().toString());
            }
            if ((to = a.getToNode()) == null || currentSetOfNodes.contains(a.getToNode().toString())) continue;
            currentSetOfNodes.addElement(a.getToNode().toString());
        }
        Vector removedLinks = this.links.getRemovedLinks();
        Vector<String> nodesToRemove = new Vector<String>();
        for (i = 0; i < removedLinks.size(); ++i) {
            Object to;
            NLDLink a = (NLDLink)removedLinks.elementAt(i);
            Object from = a.getFromNode();
            if (from != null && !currentSetOfNodes.contains(from.toString())) {
                nodesToRemove.addElement(from.toString());
            }
            if ((to = a.getToNode()) == null || currentSetOfNodes.contains(to.toString())) continue;
            nodesToRemove.addElement(to.toString());
        }
        for (i = 0; i < this.nodes.size(); ++i) {
            String nodeId = ((NLDNode)this.nodes.elementAt(i)).getID();
            int nCurrNode = currentSetOfNodes.size();
            int j = 0;
            for (j = 0; j < nCurrNode && !nodeId.equalsIgnoreCase((String)currentSetOfNodes.elementAt(j)); ++j) {
            }
            if (j != nCurrNode) continue;
            nodesToRemove.addElement(nodeId);
        }
        Vector removedNodes = this.nodes.getRemovedNodes();
        for (int i3 = 0; i3 < nodesToRemove.size(); ++i3) {
            int nodeIdx = ((DataFilterNodeModel)this.nodes).getNodePos(nodesToRemove.elementAt(i3));
            if (nodeIdx == -1) continue;
            removedNodes.addElement(((DataFilterNodeModel)this.nodes).elementAt(nodeIdx));
            this.nodes.dynamicRemove(nodeIdx);
        }
    }

    public boolean updateModel(NLDViewer v) {
        int i;
        if (v.isEmptyPlot()) {
            return false;
        }
        this.setArrangeFirstTime(false);
        if (v == null) {
            return false;
        }
        this.viewer = v;
        if (this.linkdata == null) {
            return false;
        }
        if (this.linkdata != null) {
            ((DataFilterLinkModel)this.links).initLinkModel();
            this.linkRoles = new Queue();
            boolean needToSetLinkColorMapping = false;
            boolean needToSetLinkWidthMapping = false;
            while (this.roles[1] != null && !this.roles[1].isEmpty()) {
                String[] next = (String[])this.roles[1].dequeue();
                this.linkRoles.enqueue(next);
                ((DataFilterLinkModel)this.links).setRole(next[0], next[1]);
                if (next[1].compareTo("Value") == 0 || next[1].compareTo("Color") == 0) {
                    needToSetLinkColorMapping = true;
                }
                if (next[1].compareTo("Value") != 0 && next[1].compareTo("Width") != 0) continue;
                needToSetLinkWidthMapping = true;
            }
            this.viewer.setColorMappingLinks(needToSetLinkColorMapping);
            this.viewer.setWidthMappingLinks(needToSetLinkWidthMapping);
            this.roles[1] = this.linkRoles;
            ((DataFilterLinkModel)this.links).updateNodeModel(this.nodes);
            if (!((DataFilterLinkModel)this.links).updateDataSource(this.linkdata)) {
                return false;
            }
            ((DataFilterLinkModel)this.links).addNLDModelListener(this);
            this.links.setLabelMode(this.nodeLabelMode);
            this.numLinks = ((DataFilterLinkModel)this.links).numLinks();
        }
        if (this.nodedata != null) {
            ((DataFilterNodeModel)this.nodes).initNodeModel();
            this.nodeRoles = new Queue();
            boolean needToSetNodeColorMapping = false;
            boolean needToSetNodeSizeMapping = false;
            boolean needToSetNodeShapeMapping = false;
            while (this.roles[0] != null && !this.roles[0].isEmpty()) {
                String[] next = (String[])this.roles[0].dequeue();
                this.nodeRoles.enqueue(next);
                ((DataFilterNodeModel)this.nodes).setRole(next[0], next[1]);
                if (next[1].compareTo("Value") == 0 || next[1].compareTo("Color") == 0) {
                    needToSetNodeColorMapping = true;
                }
                if (next[1].compareTo("Value") == 0 || next[1].compareTo("Size") == 0) {
                    needToSetNodeSizeMapping = true;
                }
                if (next[1].compareTo("Shape") != 0) continue;
                needToSetNodeShapeMapping = true;
            }
            this.viewer.setColorMappingNodes(needToSetNodeColorMapping);
            this.viewer.setSizeMappingNodes(needToSetNodeSizeMapping);
            this.viewer.setShapeMappingNodes(needToSetNodeShapeMapping);
            this.roles[0] = this.nodeRoles;
            ((DataFilterNodeModel)this.nodes).setShape(this.shape);
            if (!((DataFilterNodeModel)this.nodes).updateDataSource(this.nodedata)) {
                return false;
            }
            ((DataFilterNodeModel)this.nodes).addNLDModelListener(this);
            this.nodes.setLabelMode(this.nodeLabelMode);
        } else {
            this.removeUnWantedNodes();
            Vector newNodes = this.nodes.getNewNodes();
            this.nodes.setLabelMode(this.nodeLabelMode);
            this.modelMode = 1;
            for (i = 0; i < this.numLinks; ++i) {
                int nIdx;
                String id;
                NLDLink a = (NLDLink)this.links.elementAt(i);
                Object obj = a.getFromNode();
                int nodeIdx = ((DataFilterNodeModel)this.nodes).getNodePos(obj);
                if (nodeIdx == -1) {
                    if (obj != null) {
                        id = obj.toString();
                        NLDNode node = new NLDNode(0.0, 0.0);
                        node.setID(id);
                        if (obj instanceof Number && Double.isNaN(((Number)obj).doubleValue())) {
                            id = new String(".");
                        }
                        node.setLabel(id);
                        node.setInfo(id);
                        node.setSelected(false);
                        this.nodes.addElement((Object)node);
                        node.setIndex(this.nodes.indexOf((Object)node));
                        node.setType(this.shape);
                        newNodes.addElement(node);
                        nIdx = node.getIndex();
                        a.setFromIndex(nIdx);
                        ((DataFilterNodeModel)this.nodes).updateNodeTable(id, nIdx);
                    }
                } else {
                    NLDNode node = (NLDNode)this.nodes.elementAt(nodeIdx);
                    a.setFromIndex(node.getIndex());
                    ((DataFilterNodeModel)this.nodes).updateNodeTable(node.getID(), node.getIndex());
                }
                if ((nodeIdx = ((DataFilterNodeModel)this.nodes).getNodePos(obj = a.getToNode())) == -1) {
                    if (obj == null) continue;
                    id = obj.toString();
                    NLDNode node = new NLDNode(0.0, 0.0);
                    node.setID(id);
                    if (obj instanceof Number && Double.isNaN(((Number)obj).doubleValue())) {
                        id = new String(".");
                    }
                    node.setLabel(id);
                    node.setInfo(id);
                    node.setSelected(false);
                    this.nodes.addElement((Object)node);
                    node.setIndex(this.nodes.indexOf((Object)node));
                    node.setType(this.shape);
                    newNodes.addElement(node);
                    nIdx = node.getIndex();
                    a.setToIndex(nIdx);
                    ((DataFilterNodeModel)this.nodes).updateNodeTable(id, nIdx);
                    continue;
                }
                NLDNode node = (NLDNode)this.nodes.elementAt(nodeIdx);
                a.setToIndex(node.getIndex());
                ((DataFilterNodeModel)this.nodes).updateNodeTable(node.getID(), node.getIndex());
            }
        }
        if (this.links != null && this.links instanceof DataFilterLinkModel) {
            ((DataFilterLinkModel)this.links).updateNodeModel(this.nodes);
        }
        this.numNodes = this.nodes.numNodes();
        this.initLinkTable();
        if (this.linkdata == null) {
            VectorLinkModel ls;
            this.links = ls = new VectorLinkModel();
            this.links.setLabelMode(this.nodeLabelMode);
            for (i = 0; i < this.numNodes; ++i) {
                NLDNode node = (NLDNode)this.nodes.elementAt(i);
                int parent = this.nodes.getIndexOf((Object)node.getParent());
                if (parent == -1) continue;
                NLDLink link = new NLDLink(parent, node.getIndex());
                ls.addElement((Object)link);
                link.setIndex(ls.indexOf((Object)link));
            }
        }
        Vector nsel = null;
        Vector lsel = null;
        if (this.nodes instanceof DataFilterNodeModel) {
            nsel = new Vector(((DataFilterNodeModel)this.nodes).getSelectedNodeIndices());
        }
        if (this.links instanceof DataFilterLinkModel) {
            lsel = new Vector(((DataFilterLinkModel)this.links).getSelectedLinkIndices());
        }
        int[] sni = null;
        int[] sli = null;
        int nc = 0;
        int lc = 0;
        if (nsel != null) {
            sni = new int[nsel.size()];
            for (int i2 = 0; i2 < sni.length; ++i2) {
                sni[i2] = ((Number)nsel.elementAt(i2)).intValue();
            }
            nc = sni.length;
        }
        if (lsel != null) {
            sli = new int[lsel.size()];
            for (int i3 = 0; i3 < sli.length; ++i3) {
                sli[i3] = ((Number)lsel.elementAt(i3)).intValue();
            }
            lc = sli.length;
        }
        this.viewer.setSelectedList(sni, nc, sli, lc);
        return true;
    }

    public boolean loadModel(NLDViewer v) {
        DataFilterLinkModel ls;
        this.setArrangeFirstTime(true);
        if (v == null) {
            return false;
        }
        this.viewer = v;
        if (this.linkdata == null) {
            return false;
        }
        this.numLinks = 0;
        this.numNodes = 0;
        if (this.linkdata != null) {
            ls = new DataFilterLinkModel();
            ls.setNodeModel(this.nodes);
            ls.setViewer(this.viewer);
            this.linkRoles = new Queue();
            boolean needToSetLinkColorMapping = false;
            boolean needToSetLinkWidthMapping = false;
            while (this.roles[1] != null && !this.roles[1].isEmpty()) {
                String[] next = (String[])this.roles[1].dequeue();
                this.linkRoles.enqueue(next);
                ls.setRole(next[0], next[1]);
                if (next[1].compareTo("Value") == 0 || next[1].compareTo("Color") == 0) {
                    needToSetLinkColorMapping = true;
                }
                if (next[1].compareTo("Value") != 0 && next[1].compareTo("Width") != 0) continue;
                needToSetLinkWidthMapping = true;
            }
            v.setColorMappingLinks(needToSetLinkColorMapping);
            v.setWidthMappingLinks(needToSetLinkWidthMapping);
            this.roles[1] = this.linkRoles;
            if (!ls.setDataSource(this.linkdata)) {
                return false;
            }
            ls.addNLDModelListener(this);
            this.links = ls;
            this.links.setLabelMode(this.nodeLabelMode);
            this.numLinks = ls.numLinks();
            if (v.getCascadeLinkFilters()) {
                int[] subset = (int[])this.linkdata.getSubsetList();
                if (subset != null) {
                    HashSet<Object> nodeSet = new HashSet<Object>();
                    for (int i = 0; i < this.links.size(); ++i) {
                        NLDLink l = (NLDLink)this.links.elementAt(i);
                        Object fromNode = l.getFromNode();
                        Object toNode = l.getToNode();
                        nodeSet.add(fromNode);
                        nodeSet.add(toNode);
                    }
                    ArrayList<Integer> nodesubsetList = new ArrayList<Integer>();
                    Object[] nodeIDs = nodeSet.toArray();
                    for (int i = 0; i < nodeIDs.length; ++i) {
                        NLDNode node = this.nodes.getNode(nodeIDs[i]);
                        if (node == null) continue;
                        nodesubsetList.add(this.nodedata.getObservationNumber(node.getIndex()));
                    }
                    int[] nodesubset = new int[nodesubsetList.size()];
                    for (int i = 0; i < nodesubset.length; ++i) {
                        nodesubset[i] = (Integer)nodesubsetList.get(i);
                    }
                    if (this.nodedata != null) {
                        this.nodedata.setSubsetList((Object)nodesubset);
                    }
                } else if (this.nodedata != null) {
                    this.nodedata.setSubsetList(null);
                }
            }
        }
        if (this.nodedata != null) {
            DataFilterNodeModel ns = new DataFilterNodeModel();
            ns.setViewer(this.viewer);
            this.nodeRoles = new Queue();
            boolean needToSetNodeColorMapping = false;
            boolean needToSetNodeSizeMapping = false;
            boolean needToSetNodeShapeMapping = false;
            while (this.roles[0] != null && !this.roles[0].isEmpty()) {
                String[] next = (String[])this.roles[0].dequeue();
                this.nodeRoles.enqueue(next);
                ns.setRole(next[0], next[1]);
                if (next[1].compareTo("Value") == 0 || next[1].compareTo("Color") == 0) {
                    needToSetNodeColorMapping = true;
                }
                if (next[1].compareTo("Value") == 0 || next[1].compareTo("Size") == 0) {
                    needToSetNodeSizeMapping = true;
                }
                if (next[1].compareTo("Shape") != 0) continue;
                needToSetNodeShapeMapping = true;
            }
            v.setColorMappingNodes(needToSetNodeColorMapping);
            v.setSizeMappingNodes(needToSetNodeSizeMapping);
            v.setShapeMappingNodes(needToSetNodeShapeMapping);
            this.roles[0] = this.nodeRoles;
            ns.setShape(this.shape);
            if (!ns.setDataSource(this.nodedata)) {
                return false;
            }
            ns.addNLDModelListener(this);
            this.nodes = ns;
            this.nodes.setLabelMode(this.nodeLabelMode);
        } else {
            Hashtable<Object, NLDNode> table = new Hashtable<Object, NLDNode>();
            this.nodes = new DataFilterNodeModel();
            this.nodes.setLabelMode(this.nodeLabelMode);
            this.modelMode = 1;
            for (int i = 0; i < this.numLinks; ++i) {
                String id;
                NLDLink a = (NLDLink)this.links.elementAt(i);
                Object obj = this.links.getFromNode(i);
                NLDNode node = (NLDNode)table.get(obj);
                if (node == null) {
                    id = obj.toString();
                    node = new NLDNode(0.0, 0.0);
                    node.setID(id);
                    if (obj instanceof Number && Double.isNaN(((Number)obj).doubleValue())) {
                        id = new String(".");
                    }
                    node.setLabel(id);
                    node.setInfo(id);
                    node.setSelected(false);
                    this.nodes.addElement((Object)node);
                    node.setIndex(this.nodes.indexOf((Object)node));
                    node.setType(this.shape);
                    table.put(obj, node);
                }
                a.setFromIndex(node.getIndex());
                obj = this.links.getToNode(i);
                node = (NLDNode)table.get(obj);
                if (table.get(obj) == null) {
                    id = obj.toString();
                    node = new NLDNode(0.0, 0.0);
                    node.setID(id);
                    if (obj instanceof Number && Double.isNaN(((Number)obj).doubleValue())) {
                        id = new String(".");
                    }
                    node.setLabel(id);
                    node.setInfo(id);
                    node.setSelected(false);
                    this.nodes.addElement((Object)node);
                    node.setIndex(this.nodes.indexOf((Object)node));
                    node.setType(this.shape);
                    table.put(obj, node);
                }
                a.setToIndex(node.getIndex());
            }
        }
        if (this.links != null && this.links instanceof DataFilterLinkModel) {
            ((DataFilterLinkModel)this.links).setNodeModel(this.nodes);
        }
        this.numNodes = this.nodes.numNodes();
        this.initLinkTable();
        if (this.linkdata == null) {
            ls = new VectorLinkModel();
            this.links = ls;
            this.links.setLabelMode(this.nodeLabelMode);
            for (int i = 0; i < this.numNodes; ++i) {
                NLDNode node = (NLDNode)this.nodes.elementAt(i);
                int parent = this.nodes.getIndexOf((Object)node.getParent());
                if (parent == -1) continue;
                NLDLink link = new NLDLink(parent, node.getIndex());
                ls.addElement(link);
                link.setIndex(ls.indexOf(link));
            }
        }
        Vector nsel = null;
        Vector lsel = null;
        if (this.nodes instanceof DataFilterNodeModel) {
            nsel = new Vector(((DataFilterNodeModel)this.nodes).getSelectedNodeIndices());
        }
        if (this.links instanceof DataFilterLinkModel) {
            lsel = new Vector(((DataFilterLinkModel)this.links).getSelectedLinkIndices());
        }
        int[] sni = null;
        int[] sli = null;
        int nc = 0;
        int lc = 0;
        if (nsel != null) {
            sni = new int[nsel.size()];
            for (int i = 0; i < sni.length; ++i) {
                sni[i] = ((Number)nsel.elementAt(i)).intValue();
            }
            nc = sni.length;
        }
        if (lsel != null) {
            sli = new int[lsel.size()];
            for (int i = 0; i < sli.length; ++i) {
                sli[i] = ((Number)lsel.elementAt(i)).intValue();
            }
            lc = sli.length;
        }
        this.viewer.setSelectedList(sni, nc, sli, lc);
        return true;
    }

    public void initLinkTable() {
        this.resetSizes();
        this.linkTable = new Hashtable(this.numLinks);
        for (int i = 0; i < this.numLinks; ++i) {
            DvrLink l;
            Object linkO = this.links.elementAt(i);
            int from = -1;
            int to = -1;
            if (linkO instanceof DvrLink) {
                l = (DvrLink)((Object)linkO);
                from = l.getFromIndex();
                to = l.getToIndex();
            } else if (linkO instanceof NLDLink) {
                l = (NLDLink)linkO;
                from = l.getFromIndex();
                to = l.getToIndex();
            }
            if (from > this.nodes.size() || from < 0 || to > this.nodes.size() || to < 0) continue;
            Long hashValue = new Long(from * this.numLinks + to);
            this.linkTable.put(hashValue, new Integer(i));
        }
    }

    @Override
    public void modelChanged() {
        int i;
        this.viewer.checkState();
        Vector nsel = null;
        Vector lsel = null;
        if (this.nodes instanceof DataFilterNodeModel) {
            nsel = new Vector(((DataFilterNodeModel)this.nodes).getSelectedNodeIndices());
        }
        if (this.links instanceof DataFilterLinkModel) {
            lsel = new Vector(((DataFilterLinkModel)this.links).getSelectedLinkIndices());
        }
        int[] sni = null;
        int[] sli = null;
        int nc = 0;
        int lc = 0;
        if (nsel != null) {
            sni = new int[nsel.size()];
            for (i = 0; i < sni.length; ++i) {
                sni[i] = ((Number)nsel.elementAt(i)).intValue();
            }
            nc = sni.length;
        }
        if (lsel != null) {
            sli = new int[lsel.size()];
            for (i = 0; i < sli.length; ++i) {
                sli[i] = ((Number)lsel.elementAt(i)).intValue();
            }
            lc = sli.length;
        }
        this.viewer.buildSelected(sni, nc, sli, lc);
        this.viewer.repaint();
    }

    @Override
    public void dataChanged() {
        DataFilterReadInterface filter;
        this.resetSizes();
        if (this.nodes instanceof DataFilterNodeModel && (filter = ((DataFilterNodeModel)this.nodes).getFilter()) != null) {
            filter.removeDataFilterListener((Object)this.nodes);
        }
        if (this.links instanceof DataFilterLinkModel && (filter = ((DataFilterLinkModel)this.links).getFilter()) != null) {
            filter.removeDataFilterListener((Object)this.links);
        }
        if (this.doUpdateModel) {
            if (this.viewer != null) {
                if (this.viewer instanceof ConstViewer) {
                    boolean needToStart = false;
                    if (this.isLayoutThreadAlive()) {
                        this.viewer.setPauseLayout(true);
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        needToStart = true;
                    }
                    this.updateModel(this.viewer);
                    if (needToStart) {
                        this.viewer.setPauseLayout(false);
                    }
                } else {
                    this.loadModel(this.viewer);
                }
            }
        } else {
            this.loadModel(this.viewer);
        }
        if (this.viewer != null) {
            if (this.viewer instanceof ConstViewer) {
                ((ConstViewer)this.viewer).load();
            } else if (this.viewer instanceof TreeViewer) {
                ((TreeViewer)this.viewer).load();
            }
        }
    }

    public void resetRoles() {
        if (this.linkRoles != null) {
            this.roles[1] = this.linkRoles;
        }
        if (this.nodeRoles != null) {
            this.roles[0] = this.nodeRoles;
        }
    }

    public boolean setDataSource(DataFilterReadInterface n, DataFilterReadInterface l) {
        if (n == null || l == null) {
            return false;
        }
        if (l != null) {
            this.linkdata = l;
        }
        if (n != null) {
            this.nodedata = n;
        }
        return true;
    }

    public boolean setDataSource(int modelType, DataFilterReadInterface source) {
        if (source == null) {
            return false;
        }
        if (modelType == 0) {
            this.nodedata = source;
        } else {
            if (source != null) {
                this.doUpdateModel = false;
            }
            this.linkdata = source;
        }
        return true;
    }

    public DataFilterReadInterface getFilter() {
        if (this.nodes != null && this.nodes instanceof DataFilterNodeModel) {
            return ((DataFilterNodeModel)this.nodes).getFilter();
        }
        if (this.links != null && this.links instanceof DataFilterLinkModel) {
            return ((DataFilterLinkModel)this.links).getFilter();
        }
        return null;
    }

    public boolean setRole(int modelType, String var, String role) {
        boolean rc = false;
        if (role.equalsIgnoreCase("ID") || role.equalsIgnoreCase("To") || role.equalsIgnoreCase("From") || role.equalsIgnoreCase("X") || role.equalsIgnoreCase("Y")) {
            this.doUpdateModel = false;
        }
        try {
            if (this.roles[modelType] == null) {
                this.roles[modelType] = new Queue();
            } else {
                Object vobj = this.getVariable(modelType, role);
                if (vobj != null) {
                    this.removeRole(modelType, vobj.toString(), role);
                }
            }
            String[] set = new String[]{var, role};
            this.roles[modelType].enqueue(set);
            switch (modelType) {
                case 0: {
                    this.nodeRoleAssignments.put(role, var);
                    if (this.nodedata == null || !(this.nodes instanceof DataFilterNodeModel)) break;
                    ((DataFilterNodeModel)this.nodes).setRole(var, role);
                    break;
                }
                case 1: {
                    this.linkRoleAssignments.put(role, var);
                    if (this.linkdata == null || !(this.links instanceof DataFilterLinkModel)) break;
                    ((DataFilterLinkModel)this.links).setRole(var, role);
                }
            }
            rc = true;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
        return rc;
    }

    public boolean removeRole(int modelType, String var, String role) {
        boolean rc = false;
        if (role.equalsIgnoreCase("ID") || role.equalsIgnoreCase("To") || role.equalsIgnoreCase("From") || role.equalsIgnoreCase("X") || role.equalsIgnoreCase("Y")) {
            this.doUpdateModel = false;
        }
        try {
            if (null != this.roles[modelType]) {
                String[] set = new String[]{var, role};
                if (null != this.roles[modelType].dequeue(set)) {
                    rc = true;
                }
                switch (modelType) {
                    case 0: {
                        this.nodeRoleAssignments.remove(role);
                        if (this.nodedata == null || !(this.nodes instanceof DataFilterNodeModel)) break;
                        ((DataFilterNodeModel)this.nodes).removeRole(var, role);
                        break;
                    }
                    case 1: {
                        this.linkRoleAssignments.remove(role);
                        if (this.linkdata == null || !(this.links instanceof DataFilterLinkModel)) break;
                        ((DataFilterLinkModel)this.links).removeRole(var, role);
                    }
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
        return rc;
    }

    public Object getDataSource(int modelType) {
        if (modelType == 0) {
            if (this.nodedata == null) {
                return null;
            }
            return this.nodedata.getSource();
        }
        if (modelType == 1) {
            if (this.linkdata == null) {
                return null;
            }
            return this.linkdata.getSource();
        }
        return null;
    }

    public Object getVariable(int modelType, String role) {
        if (role == null) {
            return null;
        }
        if (modelType == 0) {
            if (this.nodedata == null) {
                return null;
            }
            if (this.nodeRoleAssignments != null) {
                return this.nodeRoleAssignments.get(role);
            }
            if (this.nodes instanceof DataFilterNodeModel) {
                return ((DataFilterNodeModel)this.nodes).getVariable(role);
            }
        } else if (modelType == 1) {
            if (this.linkdata == null) {
                return null;
            }
            if (this.linkRoleAssignments != null) {
                return this.linkRoleAssignments.get(role);
            }
            if (this.links instanceof DataFilterLinkModel) {
                return ((DataFilterLinkModel)this.links).getVariable(role);
            }
        }
        return null;
    }

    public Object getRole(int modelType, String variableId) {
        if (modelType == 0) {
            if (this.nodedata == null) {
                return null;
            }
            return ((DataFilterNodeModel)this.nodes).getRole(variableId);
        }
        if (modelType == 1) {
            if (this.linkdata == null) {
                return null;
            }
            return ((DataFilterLinkModel)this.links).getRole(variableId);
        }
        return null;
    }

    public boolean setModelMode(int newMode) {
        if (newMode == 0 || newMode == 1) {
            this.modelMode = newMode;
            return true;
        }
        return false;
    }

    public int getModelMode() {
        return this.modelMode;
    }

    public Object getDataSource() {
        return this.getDataSource(this.modelMode);
    }

    public boolean setDataSource(int modelType, Object source) {
        DataFilterReadInterface filter = null;
        filter = FilterFactory.getDataSourceFilter((Object)source);
        if (filter == null) {
            return false;
        }
        return this.setDataSource(modelType, filter);
    }

    public boolean setDataSource(Object source) {
        if (source == null) {
            return false;
        }
        DataFilterReadInterface filter = null;
        filter = FilterFactory.getDataSourceFilter((Object)source);
        if (filter == null) {
            return false;
        }
        return this.setDataSource(this.modelMode, filter);
    }

    public Object getVariable(Object role) {
        if (role instanceof SILKNumber) {
            int dsid = 1;
            if (this.isNodeRole(role)) {
                dsid = 0;
            }
            String r = this.getMappedRole(role);
            return this.getVariable(dsid, r);
        }
        if (role instanceof String) {
            return this.getVariable(this.modelMode, (String)role);
        }
        return null;
    }

    public Object getRole(Object variableId) {
        if (variableId instanceof String) {
            return this.getRole(this.modelMode, (String)variableId);
        }
        return null;
    }

    public boolean removeRole(Object variableId, Object role) {
        if (role == null) {
            return false;
        }
        if (variableId == null || !(variableId instanceof String)) {
            return false;
        }
        if (this.isNodeRole(role)) {
            String r = this.getMappedRole(role);
            return this.removeRole(0, variableId.toString(), r);
        }
        if (this.isLinkRole(role)) {
            String r = this.getMappedRole(role);
            return this.removeRole(1, variableId.toString(), r);
        }
        return false;
    }

    public boolean setRole(Object variableId, Object role) {
        if (role == null) {
            return false;
        }
        if (variableId == null || !(variableId instanceof String)) {
            return false;
        }
        if (this.isNodeRole(role)) {
            String r = this.getMappedRole(role);
            return this.setRole(0, variableId.toString(), r);
        }
        if (this.isLinkRole(role)) {
            String r = this.getMappedRole(role);
            return this.setRole(1, variableId.toString(), r);
        }
        return false;
    }

    public boolean isNodeRole(Object role) {
        if (role == null) {
            return false;
        }
        int roleInt = this.getRoleInt(0, role);
        switch (roleInt) {
            case 2: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 41: 
            case 43: {
                return true;
            }
        }
        return false;
    }

    public boolean isLinkRole(Object role) {
        if (role == null) {
            return false;
        }
        int roleInt = this.getRoleInt(1, role);
        switch (roleInt) {
            case 29: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 73: {
                return true;
            }
        }
        return false;
    }

    public int getRoleInt(int model, Object role) {
        if (role == null) {
            return -1;
        }
        if (role instanceof Number) {
            return ((Number)role).intValue();
        }
        if (role instanceof String) {
            if (model == -1) {
                model = 0;
            }
            String s = (String)role;
            switch (model) {
                case 0: {
                    if (s.equalsIgnoreCase("NodeID") || s.equalsIgnoreCase("Node ID") || s.equalsIgnoreCase("ID")) {
                        return 26;
                    }
                    if (s.equalsIgnoreCase("NodeValue") || s.equalsIgnoreCase("Node Value") || s.equalsIgnoreCase("Value")) {
                        return 43;
                    }
                    if (s.equalsIgnoreCase("NodeSize") || s.equalsIgnoreCase("Node Size") || s.equalsIgnoreCase("Size")) {
                        return 19;
                    }
                    if (s.equalsIgnoreCase("NodeColor") || s.equalsIgnoreCase("Node Color") || s.equalsIgnoreCase("Color")) {
                        return 2;
                    }
                    if (s.equalsIgnoreCase("NodeShape") || s.equalsIgnoreCase("Node Shape") || s.equalsIgnoreCase("Shape")) {
                        return 18;
                    }
                    if (s.equalsIgnoreCase("NodeLabel") || s.equalsIgnoreCase("Node Label") || s.equalsIgnoreCase("Label")) {
                        return 28;
                    }
                    if (s.equalsIgnoreCase("NodeTip") || s.equalsIgnoreCase("Node Tip") || s.equalsIgnoreCase("Tip") || s.equalsIgnoreCase("Info")) {
                        return 22;
                    }
                    if (s.equalsIgnoreCase("NodeURL") || s.equalsIgnoreCase("Node URL") || s.equalsIgnoreCase("URL")) {
                        return 41;
                    }
                    if (s.equalsIgnoreCase("NodeX") || s.equalsIgnoreCase("Node X") || s.equalsIgnoreCase("X")) {
                        return 24;
                    }
                    if (!s.equalsIgnoreCase("NodeY") && !s.equalsIgnoreCase("Node Y") && !s.equalsIgnoreCase("Y")) break;
                    return 25;
                }
                case 1: {
                    if (s.equalsIgnoreCase("LinkID") || s.equalsIgnoreCase("Link ID") || s.equalsIgnoreCase("ID")) {
                        return 44;
                    }
                    if (s.equalsIgnoreCase("LinkFrom") || s.equalsIgnoreCase("Link From") || s.equalsIgnoreCase("From")) {
                        return 45;
                    }
                    if (s.equalsIgnoreCase("LinkTo") || s.equalsIgnoreCase("Link To") || s.equalsIgnoreCase("To")) {
                        return 46;
                    }
                    if (s.equalsIgnoreCase("LinkValue") || s.equalsIgnoreCase("Link Value") || s.equalsIgnoreCase("Value")) {
                        return 47;
                    }
                    if (s.equalsIgnoreCase("LinkWidth") || s.equalsIgnoreCase("Link Width") || s.equalsIgnoreCase("Width")) {
                        return 29;
                    }
                    if (s.equalsIgnoreCase("LinkColor") || s.equalsIgnoreCase("Link Color") || s.equalsIgnoreCase("Color")) {
                        return 48;
                    }
                    if (s.equalsIgnoreCase("LinkLabel") || s.equalsIgnoreCase("Link Label") || s.equalsIgnoreCase("Label")) {
                        return 49;
                    }
                    if (s.equalsIgnoreCase("LinkTip") || s.equalsIgnoreCase("Link Tip") || s.equalsIgnoreCase("Tip") || s.equalsIgnoreCase("Info")) {
                        return 50;
                    }
                    if (!s.equalsIgnoreCase("LinkGroup") && !s.equalsIgnoreCase("Link Group") && !s.equalsIgnoreCase("Group") && !s.equalsIgnoreCase("Group")) break;
                    return 73;
                }
            }
        }
        return -1;
    }

    public String getMappedRole(Object role) {
        String r = null;
        switch (this.getRoleInt(-1, role)) {
            case 26: 
            case 44: {
                r = "ID";
                break;
            }
            case 43: 
            case 47: {
                r = "Value";
                break;
            }
            case 19: {
                r = "Size";
                break;
            }
            case 18: {
                r = "Shape";
                break;
            }
            case 2: 
            case 48: {
                r = "Color";
                break;
            }
            case 28: 
            case 49: {
                r = "Label";
                break;
            }
            case 22: 
            case 50: {
                r = "Info";
                break;
            }
            case 41: {
                r = "URL";
                break;
            }
            case 24: {
                r = "X";
                break;
            }
            case 25: {
                r = "Y";
                break;
            }
            case 45: {
                r = "From";
                break;
            }
            case 46: {
                r = "To";
                break;
            }
            case 29: {
                r = "Width";
                break;
            }
            case 73: {
                r = "Group";
            }
        }
        return r;
    }

    public Object[] getSupportedRoles(Object type, boolean discrete) {
        int modelType = -1;
        if (type instanceof Number) {
            modelType = ((Number)type).intValue();
        } else if (type instanceof String) {
            if ("Nodes".equals(type)) {
                modelType = 0;
            } else if ("Links".equals(type)) {
                modelType = 1;
            }
        }
        if (modelType == 0) {
            if (this.nodedata == null) {
                return null;
            }
            return ((DataFilterNodeModel)this.nodes).getSupportedRoles(new Integer(0), discrete);
        }
        if (modelType == 1) {
            if (this.linkdata == null) {
                return null;
            }
            return ((DataFilterLinkModel)this.links).getSupportedRoles(new Integer(1), discrete);
        }
        return null;
    }

    public void dispose() {
        this.removeListeners();
        super.dispose();
        this.nodedata = null;
        this.linkdata = null;
        if (this.nodeRoleAssignments != null) {
            this.nodeRoleAssignments.clear();
        }
        this.nodeRoleAssignments = null;
        if (this.linkRoleAssignments != null) {
            this.linkRoleAssignments.clear();
        }
        this.linkRoleAssignments = null;
    }

    public void removeListeners() {
        if (this.nodes instanceof DataFilterNodeModel) {
            DataFilterNodeModel dfn = (DataFilterNodeModel)this.nodes;
            if (dfn.getFilter() != null) {
                dfn.getFilter().removeDataFilterListener((Object)dfn);
            }
            dfn.removeNLDModelListener(this);
        }
        if (this.links instanceof DataFilterLinkModel) {
            DataFilterLinkModel dfl = (DataFilterLinkModel)this.links;
            if (dfl.getFilter() != null) {
                dfl.getFilter().removeDataFilterListener((Object)dfl);
            }
            dfl.removeNLDModelListener(this);
        }
    }

    public boolean loadNodePositions() {
        if (this.nodes != null) {
            return this.nodes.readNodePositions();
        }
        return false;
    }

    public boolean arrange() {
        if (this.viewer == null) {
            return false;
        }
        this.viewer.setPauseLayout(true);
        while (this.isLayoutThreadAlive()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        int type = this.viewer.getLayoutStrategy();
        if (type == 3) {
            if (this.viewer.getAnimationFlag() && this.viewer.isAnimating()) {
                this.viewer.setAnimating(false);
            }
            GRIPLayout gl = new GRIPLayout(this);
            gl.doGRIPLayout();
            gl.updateModelPositions();
            return true;
        }
        return super.arrange();
    }

    private class Queue
    extends Vector {
        private static final long serialVersionUID = 798363115961452847L;

        private Queue() {
        }

        public void enqueue(Object o) {
            if (!this.contains(o)) {
                this.addElement(o);
            }
        }

        public Object dequeue() {
            if (this.size() <= 0) {
                return null;
            }
            Object o = this.elementAt(0);
            this.removeElementAt(0);
            return o;
        }

        public Object dequeue(Object obj) {
            if (this.size() <= 0) {
                return null;
            }
            if (obj instanceof String[]) {
                String[] vals = (String[])obj;
                for (int i = 0; i < this.size(); ++i) {
                    Object o = this.elementAt(i);
                    if (!(o instanceof String[]) || !this.isEqual((String[])o, vals)) continue;
                    this.remove(o);
                    return o;
                }
            }
            return null;
        }

        private boolean isEqual(String[] arr1, String[] arr2) {
            if (arr1 == null && arr2 == null) {
                return true;
            }
            if (arr1 == null || arr2 == null) {
                return false;
            }
            if (arr1.length != arr2.length) {
                return false;
            }
            for (int i = 0; i < arr1.length; ++i) {
                String s1 = arr1[i];
                String s2 = arr2[i];
                if (this.isEqual(s1, s2)) continue;
                return false;
            }
            return true;
        }

        public boolean isEqual(String s1, String s2) {
            if (s1 == null && s2 == null) {
                return true;
            }
            if (s1 == null || s2 == null) {
                return false;
            }
            return s1.equalsIgnoreCase(s2);
        }
    }
}

