/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util.nld;

import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.event.NLDModelListenerInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.DataFilterWriteInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.util.nld.DvrLink;
import com.sas.graphics.util.nld.NLD;
import com.sas.graphics.util.nld.NLDLink;
import com.sas.graphics.util.nld.NLDNode;
import com.sas.graphics.util.nld.NLDProperties;
import com.sas.graphics.util.nld.NLDViewer;
import com.sas.graphics.util.nld.VectorLinkModel;
import com.sas.graphics.util.nld.VectorNodeModel;
import java.awt.Color;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DataFilterLinkModel
extends VectorLinkModel
implements RoleInterface,
DataFilterListenerInterface {
    private static final long serialVersionUID = 1391787132954972221L;
    private DataFilterReadInterface filter;
    private VectorNodeModel nodes;
    protected static Integer[] values = new Integer[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3), new Integer(4), new Integer(5), new Integer(6), new Integer(7), new Integer(8), new Integer(9)};
    protected final NLDProperties props = new NLDProperties((Object[])keys, (Object[])values);
    protected static final int NUM_INPUT_ROLES = 10;
    protected Object[] ROLE_TO_ID_MAP;
    protected Vector listeners;
    protected NLDViewer viewer = null;
    private Hashtable tableIdToDataIdx;
    private Hashtable tableIdToFilterIdx;
    private Hashtable selectedLinkIndices = new Hashtable();

    public DataFilterLinkModel() {
        this.ROLE_TO_ID_MAP = new Object[10];
        this.listeners = new Vector();
    }

    public DataFilterLinkModel(Object dataIn) {
        this.setDataSource(dataIn);
        this.ROLE_TO_ID_MAP = new Object[10];
        this.listeners = new Vector();
    }

    public void dispose() {
        super.dispose();
        this.viewer = null;
    }

    public void initLinkModel() {
        this.ROLE_TO_ID_MAP = new Object[10];
        this.listeners = new Vector();
    }

    public void updateNodeModel(VectorNodeModel list) {
        int nLinks = this.size();
        for (int i = 0; i < nLinks; ++i) {
            DvrLink l = (DvrLink)((Object)this.elementAt(i));
            l.setFromIndex(-1);
            l.setToIndex(-1);
            l.setNodeModel(list);
        }
        this.nodes = list;
    }

    public void setNodeModel(VectorNodeModel list) {
        this.nodes = list;
        if (this.size() > 0) {
            for (int i = 0; i < this.size(); ++i) {
                Object o = this.elementAt(i);
                if (!(o instanceof DvrLink)) continue;
                ((DvrLink)((Object)o)).setNodeModel(this.nodes);
            }
        }
    }

    public VectorNodeModel getNodeModel() {
        return this.nodes;
    }

    private DataFilterReadInterface getFilter(Object data) {
        if (data instanceof DataFilterReadInterface) {
            return (DataFilterReadInterface)data;
        }
        return FilterFactory.getDataSourceFilter((Object)data);
    }

    public DataFilterReadInterface getFilter() {
        return this.filter;
    }

    public Object getVariable(int id) {
        return this.ROLE_TO_ID_MAP[id];
    }

    private Object getValue(Object id, int index) {
        if (this.filter == null) {
            return null;
        }
        if (!(id instanceof String)) {
            return null;
        }
        int roleIndex = this.props.getPropertyIndex((String)id);
        if (roleIndex == -1 || roleIndex >= 10) {
            return null;
        }
        Object variable = this.getVariable(roleIndex);
        if (variable == null) {
            return null;
        }
        return this.filter.getValue(variable, (long)index);
    }

    public Object[] getColumn(Object id) {
        int n = this.numLinks();
        Object[] rc = new Object[n];
        for (int i = 0; i < n; ++i) {
            rc[i] = this.getValue(id, i);
        }
        return rc;
    }

    public void setSelected(int index, boolean flag) {
        NLDLink l = (NLDLink)this.elementAt(index);
        l.setSelected(flag);
        this.setNodeLabelState(l);
        int filterIdx = this.getLinkIndxFromFilter(index);
        if (filterIdx < 0) {
            return;
        }
        this.filter.setSelected((long)filterIdx, flag);
    }

    public void setNodeLabelState(NLDLink l) {
        NLDNode from = this.nodes.getNode(l.getFromIndex());
        NLDNode to = this.nodes.getNode(l.getToIndex());
        switch (this.nodeLabelMode) {
            case 3: 
            case 5: {
                if (l.isSelected()) {
                    from.setShowLabel(true);
                    to.setShowLabel(true);
                    break;
                }
                from.setShowLabel(false);
                to.setShowLabel(false);
            }
        }
    }

    public DvrLink getLink(int index) {
        if (index == -1 || index >= this.size()) {
            return null;
        }
        return (DvrLink)((Object)this.elementAt(index));
    }

    private double getDouble(Object o) {
        double num;
        if (o != null && o instanceof Number && !Double.isNaN(num = ((Number)o).doubleValue())) {
            return num;
        }
        return -1.0;
    }

    private double getDouble(Object o, double val) {
        double num;
        if (o != null && o instanceof Number && !Double.isNaN(num = ((Number)o).doubleValue())) {
            return num;
        }
        return val;
    }

    private Color getColor(Object o) {
        if (o instanceof Color) {
            return (Color)o;
        }
        if (o instanceof String) {
            return NLD.decodeColor((String)o.toString());
        }
        return null;
    }

    private String getString(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        return String.valueOf(o);
    }

    public boolean removeRole(Object variableId, Object role) {
        int roleIndex = -1;
        if (!(role instanceof String)) {
            return false;
        }
        roleIndex = this.props.getPropertyIndex((String)role);
        this.ROLE_TO_ID_MAP[roleIndex] = null;
        return true;
    }

    public boolean addRole(Object variableId, Object role) {
        return false;
    }

    public int getMaxAllowed(Object role) {
        return 1;
    }

    public Object[] getSupportedRoles(Object type, boolean discrete) {
        return null;
    }

    public Object getSortOrder(Object variableId) {
        return null;
    }

    public boolean setSortOrder(Object variableId, Object order) {
        return false;
    }

    public Object getRoleValue(Object role, int which) {
        return null;
    }

    public Object getDataSource() {
        return this.filter;
    }

    public Object getDataSource(Object id) {
        return this.getDataSource();
    }

    private int getLinkPos(Object linkid) {
        int nLinks = this.size();
        for (int i = 0; i < nLinks; ++i) {
            DvrLink link = (DvrLink)((Object)this.elementAt(i));
            if (!link.id.equalsIgnoreCase((String)linkid)) continue;
            return i;
        }
        return -1;
    }

    private void updateAllLinkValues(int property) {
        int num = this.size();
        switch (property) {
            case 3: {
                for (int i = 0; i < num; ++i) {
                    DvrLink n = (DvrLink)((Object)this.elementAt(i));
                    n.setLabel(null);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < num; ++i) {
                    DvrLink n = (DvrLink)((Object)this.elementAt(i));
                    n.setFromNode(null);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < num; ++i) {
                    DvrLink n = (DvrLink)((Object)this.elementAt(i));
                    n.setToNode(null);
                }
                break;
            }
            case 5: {
                for (int i = 0; i < num; ++i) {
                    DvrLink n = (DvrLink)((Object)this.elementAt(i));
                    n.setWidth(1.0);
                }
                break;
            }
            case 4: {
                for (int i = 0; i < num; ++i) {
                    DvrLink n = (DvrLink)((Object)this.elementAt(i));
                    n.setInfo(null);
                }
                break;
            }
            case 7: {
                for (int i = 0; i < num; ++i) {
                    DvrLink n = (DvrLink)((Object)this.elementAt(i));
                    n.setColor(null);
                }
                break;
            }
            case 6: {
                for (int i = 0; i < num; ++i) {
                    DvrLink n = (DvrLink)((Object)this.elementAt(i));
                    n.setValue(0.0);
                }
                break;
            }
            case 8: {
                for (int i = 0; i < num; ++i) {
                    DvrLink n = (DvrLink)((Object)this.elementAt(i));
                    n.setStipple(0);
                }
                break;
            }
        }
    }

    public boolean updateDataSource(Object source) {
        if (this.filter != null) {
            this.filter.removeDataFilterListener((Object)this);
        }
        this.filter = this.getFilter(source);
        if (this.filter == null) {
            return false;
        }
        if (this.filter.getVariableIndex(this.ROLE_TO_ID_MAP[0]) < 0) {
            return false;
        }
        if (this.filter.getVariableIndex(this.ROLE_TO_ID_MAP[1]) < 0) {
            return false;
        }
        if (this.filter.getVariableIndex(this.ROLE_TO_ID_MAP[2]) < 0) {
            return false;
        }
        this.filter.addDataFilterListener((Object)this);
        long num = this.filter.getNumberObservations((Object)"ID");
        if (this.tableIdToDataIdx == null) {
            this.tableIdToDataIdx = new Hashtable();
        }
        if (this.tableIdToFilterIdx == null) {
            this.tableIdToFilterIdx = new Hashtable();
        } else {
            this.tableIdToFilterIdx.clear();
        }
        Enumeration keys = this.tableIdToDataIdx.keys();
        Vector removedLinkIds = new Vector();
        while (keys.hasMoreElements()) {
            String linkId;
            Object obj = keys.nextElement();
            int i = 0;
            while ((long)i < num && !(linkId = this.getString(this.filter.getValue(this.ROLE_TO_ID_MAP[0], (long)i))).equalsIgnoreCase((String)obj)) {
                ++i;
            }
            if ((long)i != num) continue;
            removedLinkIds.addElement(obj);
        }
        for (int j = 0; j < removedLinkIds.size(); ++j) {
            String rLinkId = removedLinkIds.elementAt(j).toString();
            if (this.tableIdToDataIdx.containsKey(rLinkId)) {
                this.tableIdToDataIdx.remove(rLinkId);
            }
            int idx = -1;
            idx = this.getLinkPos(removedLinkIds.elementAt(j).toString());
            if (idx == -1) continue;
            this.linksToRemove.addElement(this.elementAt(idx));
            this.dynamicRemove(idx);
        }
        this.tableIdToDataIdx.clear();
        for (int i = 0; i < this.size(); ++i) {
            DvrLink link = (DvrLink)((Object)this.elementAt(i));
            this.tableIdToDataIdx.put(link.id, new Integer(i));
        }
        this.linksToUpdate = new Vector();
        int i = 0;
        while ((long)i < num) {
            String linkId = this.getString(this.filter.getValue(this.ROLE_TO_ID_MAP[0], (long)i));
            String from = this.filter.getValue(this.ROLE_TO_ID_MAP[1], (long)i).toString();
            String to = this.filter.getValue(this.ROLE_TO_ID_MAP[2], (long)i).toString();
            int linkIdx = this.getLinkPos(linkId);
            if (!this.tableIdToFilterIdx.containsKey(linkId)) {
                this.tableIdToFilterIdx.put(linkId, new Integer(i));
            }
            if (!this.tableIdToDataIdx.containsKey(linkId) || linkIdx == -1) {
                DvrLink link = new DvrLink(from, to, this.nodes);
                link.setSelected(this.filter.isSelected((long)i));
                link.setID(linkId);
                this.addElement((Object)link);
                int idx = this.indexOf((Object)link);
                link.setIndex(idx);
                this.tableIdToDataIdx.put(link.id, new Integer(idx));
                this.linksToUpdate.addElement(link);
                if (this.filter.isSelected((long)i)) {
                    this.selectedLinkIndices.put(new Integer(idx), new Integer(idx));
                }
            }
            ++i;
        }
        for (i = 3; i < 10; ++i) {
            this.updateAllLinkValues(i);
            if (this.ROLE_TO_ID_MAP[i] == null) continue;
            Object vobj = this.getVariable(i);
            this.setLinkValues(vobj, i);
        }
        return true;
    }

    public int getLinkIndxFromFilter(int index) {
        if (this.tableIdToFilterIdx == null) {
            return -1;
        }
        String oneLinkId = ((DvrLink)((Object)this.elementAt(index))).getID();
        Object retVal = null;
        retVal = this.tableIdToFilterIdx.get(oneLinkId);
        if (retVal != null) {
            return retVal;
        }
        return -1;
    }

    public boolean setDataSource(Object source) {
        if (this.filter != null) {
            this.filter.removeDataFilterListener((Object)this);
        }
        this.filter = this.getFilter(source);
        if (this.filter == null) {
            return false;
        }
        if (this.filter.getVariableIndex(this.ROLE_TO_ID_MAP[0]) < 0) {
            return false;
        }
        if (this.filter.getVariableIndex(this.ROLE_TO_ID_MAP[1]) < 0) {
            return false;
        }
        if (this.filter.getVariableIndex(this.ROLE_TO_ID_MAP[2]) < 0) {
            return false;
        }
        this.filter.addDataFilterListener((Object)this);
        long num = this.filter.getNumberObservations((Object)"ID");
        if (this.tableIdToDataIdx == null) {
            this.tableIdToDataIdx = new Hashtable();
        } else {
            this.tableIdToDataIdx.clear();
        }
        if (this.tableIdToFilterIdx == null) {
            this.tableIdToFilterIdx = new Hashtable();
        } else {
            this.tableIdToFilterIdx.clear();
        }
        int i = 0;
        boolean isDuplicateIdPresent = false;
        while ((long)i < num) {
            Object from = this.filter.getValue(this.ROLE_TO_ID_MAP[1], (long)i);
            Object to = this.filter.getValue(this.ROLE_TO_ID_MAP[2], (long)i);
            String linkId = this.getString(this.filter.getValue(this.ROLE_TO_ID_MAP[0], (long)i));
            int linkIdx = this.getLinkPos(linkId);
            if (this.tableIdToDataIdx.containsKey(linkId) && linkIdx != -1) {
                isDuplicateIdPresent = true;
            } else {
                if (!this.tableIdToFilterIdx.containsKey(linkId)) {
                    this.tableIdToFilterIdx.put(linkId, new Integer(i));
                }
                DvrLink link = new DvrLink(from, to, this.nodes);
                link.setID(linkId);
                this.addElement((Object)link);
                int indx = this.indexOf((Object)link);
                link.setIndex(indx);
                this.tableIdToDataIdx.put(link.id, new Integer(indx));
                boolean isSelected = this.filter.isSelected((long)i);
                link.setSelected(isSelected);
                if (isSelected) {
                    this.selectedLinkIndices.put(new Integer(indx), new Integer(indx));
                }
            }
            ++i;
        }
        if (isDuplicateIdPresent) {
            this.showMessageInConsole("SILKErrorUtilities.DuplicateLinkId.txt", "Duplicate LinkId exists in data set", true);
        }
        for (int j = 3; j < 10; ++j) {
            if (this.ROLE_TO_ID_MAP[j] == null) continue;
            Object vobj = this.getVariable(j);
            this.setLinkValues(vobj, j);
        }
        return true;
    }

    private void showMessageInConsole(String key, String defStrg, boolean isWarning) {
        if (isWarning) {
            String format = this.viewer.GRS("ErrorMessage.fmt.txt", "{0} : {1}");
            String message = this.viewer.GRS(key, defStrg);
            String id = this.viewer.getId() == null ? null : this.viewer.getId().toString();
            System.out.println(MessageFormat.format(format, id, message));
        }
    }

    public boolean setDataSource(Object source, Object id) {
        return this.setDataSource(source);
    }

    public void addRoleListener(RoleListenerInterface listener) {
    }

    public void removeRoleListener(RoleListenerInterface listener) {
    }

    public Object[] getDataIds() {
        return null;
    }

    public Object getLimit(Object role) {
        return null;
    }

    public boolean setLimit(Object role, Object value) {
        return false;
    }

    public void setLinkValues(Object vobj, int property) {
        int num = this.filter.getNumberObservations(-1);
        int linkIndex = 0;
        switch (property) {
            case 3: {
                for (int i = 0; i < num && linkIndex >= 0 && linkIndex < this.size(); ++i) {
                    String filterLinkId;
                    DvrLink n = (DvrLink)((Object)this.elementAt(linkIndex));
                    String vecLinkId = n.getID();
                    if (!vecLinkId.equalsIgnoreCase(filterLinkId = this.getString(this.filter.getValue(this.ROLE_TO_ID_MAP[0], (long)i)))) continue;
                    ++linkIndex;
                    n.setLabel((String)this.filter.getValue(vobj, (long)i));
                    Object o = this.filter.getValue(vobj, (long)i);
                    if (o != null) {
                        if (o instanceof String) {
                            if (o.toString().length() == 0) {
                                n.setLabel(" ");
                                continue;
                            }
                            n.setLabel((String)o);
                            n.analyseLabel();
                            continue;
                        }
                        if (!(o instanceof Number)) continue;
                        if (((Double)o).isNaN()) {
                            n.setLabel(".");
                            continue;
                        }
                        n.setLabel(((Number)o).toString());
                        continue;
                    }
                    n.setLabel(null);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < num && linkIndex >= 0 && linkIndex < this.size(); ++i) {
                    String filterLinkId;
                    DvrLink n = (DvrLink)((Object)this.elementAt(linkIndex));
                    String vecLinkId = n.getID();
                    if (!vecLinkId.equalsIgnoreCase(filterLinkId = this.getString(this.filter.getValue(this.ROLE_TO_ID_MAP[0], (long)i)))) continue;
                    ++linkIndex;
                    n.setFromNode(this.filter.getValue(vobj, (long)i));
                }
                break;
            }
            case 2: {
                for (int i = 0; i < num && linkIndex >= 0 && linkIndex < this.size(); ++i) {
                    String filterLinkId;
                    DvrLink n = (DvrLink)((Object)this.elementAt(linkIndex));
                    String vecLinkId = n.getID();
                    if (!vecLinkId.equalsIgnoreCase(filterLinkId = this.getString(this.filter.getValue(this.ROLE_TO_ID_MAP[0], (long)i)))) continue;
                    ++linkIndex;
                    n.setToNode(this.filter.getValue(vobj, (long)i));
                }
                break;
            }
            case 5: {
                for (int i = 0; i < num && linkIndex >= 0 && linkIndex < this.size(); ++i) {
                    String filterLinkId;
                    DvrLink n = (DvrLink)((Object)this.elementAt(linkIndex));
                    String vecLinkId = n.getID();
                    if (!vecLinkId.equalsIgnoreCase(filterLinkId = this.getString(this.filter.getValue(this.ROLE_TO_ID_MAP[0], (long)i)))) continue;
                    ++linkIndex;
                    n.setWidth(this.getDouble(this.filter.getValue(vobj, (long)i), 1.0));
                }
                break;
            }
            case 9: {
                for (int i = 0; i < num && linkIndex >= 0 && linkIndex < this.size(); ++i) {
                    String filterLinkId;
                    DvrLink n = (DvrLink)((Object)this.elementAt(linkIndex));
                    String vecLinkId = n.getID();
                    if (!vecLinkId.equalsIgnoreCase(filterLinkId = this.getString(this.filter.getValue(this.ROLE_TO_ID_MAP[0], (long)i)))) continue;
                    ++linkIndex;
                    Object o = this.filter.getValue(vobj, (long)i);
                    if (o == null) continue;
                    n.setGroup(o.toString());
                }
                break;
            }
            case 4: {
                for (int i = 0; i < num && linkIndex >= 0 && linkIndex < this.size(); ++i) {
                    String filterLinkId;
                    DvrLink n = (DvrLink)((Object)this.elementAt(linkIndex));
                    String vecLinkId = n.getID();
                    if (!vecLinkId.equalsIgnoreCase(filterLinkId = this.getString(this.filter.getValue(this.ROLE_TO_ID_MAP[0], (long)i)))) continue;
                    ++linkIndex;
                    Object o = this.filter.getValue(vobj, (long)i);
                    if (o != null) {
                        if (o instanceof String) {
                            if (o.toString().length() == 0) {
                                n.setInfo(" ");
                            } else {
                                n.setInfo((String)o);
                                n.analyseInfo();
                            }
                        } else if (o instanceof Number) {
                            if (((Double)o).isNaN()) {
                                n.setInfo(".");
                            } else {
                                n.setInfo(((Number)o).toString());
                            }
                        }
                        n.analyseInfo();
                        continue;
                    }
                    n.setInfo(null);
                }
                break;
            }
            case 7: {
                for (int i = 0; i < num && linkIndex >= 0 && linkIndex < this.size(); ++i) {
                    String filterLinkId;
                    DvrLink n = (DvrLink)((Object)this.elementAt(linkIndex));
                    String vecLinkId = n.getID();
                    if (!vecLinkId.equalsIgnoreCase(filterLinkId = this.getString(this.filter.getValue(this.ROLE_TO_ID_MAP[0], (long)i)))) continue;
                    ++linkIndex;
                    Color c = this.getColor(this.filter.getValue(vobj, (long)i));
                    if (c != null) {
                        n.setColor(c);
                        continue;
                    }
                    if (this.filter.isNumericVariable(vobj)) {
                        Object obj = this.filter.getValue(vobj, (long)i);
                        if (obj != null) {
                            double val = ((Number)obj).doubleValue();
                            if (!Double.isNaN(val)) {
                                n.setColorValue(val);
                                continue;
                            }
                            n.setColor(this.viewer.getLinkErrorColor());
                            continue;
                        }
                        n.setColor(this.viewer.getLinkErrorColor());
                        continue;
                    }
                    n.setColor(this.viewer.getLinkErrorColor());
                }
                break;
            }
            case 6: {
                for (int i = 0; i < num && linkIndex >= 0 && linkIndex < this.size(); ++i) {
                    String filterLinkId;
                    DvrLink n = (DvrLink)((Object)this.elementAt(linkIndex));
                    String vecLinkId = n.getID();
                    if (!vecLinkId.equalsIgnoreCase(filterLinkId = this.getString(this.filter.getValue(this.ROLE_TO_ID_MAP[0], (long)i)))) continue;
                    ++linkIndex;
                    n.setValue(this.getDouble(this.filter.getValue(vobj, (long)i), 0.0));
                    this.computeMinMax(n.getValue());
                }
                break;
            }
            case 8: {
                for (int i = 0; i < num && linkIndex >= 0 && linkIndex < this.size(); ++i) {
                    String filterLinkId;
                    DvrLink n = (DvrLink)((Object)this.elementAt(linkIndex));
                    String vecLinkId = n.getID();
                    if (!vecLinkId.equalsIgnoreCase(filterLinkId = this.getString(this.filter.getValue(this.ROLE_TO_ID_MAP[0], (long)i)))) continue;
                    ++linkIndex;
                    n.setStipple(((Number)this.filter.getValue(vobj, (long)i)).intValue());
                }
                break;
            }
        }
    }

    private void resetLinkValues(Object vobj, int property) {
        int num = this.filter.getNumberObservations((Object)"ID");
        switch (property) {
            case 3: {
                for (int i = 0; i < num; ++i) {
                    DvrLink n = (DvrLink)((Object)this.elementAt(i));
                    n.setLabel(null);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < num; ++i) {
                    DvrLink n = (DvrLink)((Object)this.elementAt(i));
                    n.setFromNode(null);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < num; ++i) {
                    DvrLink n = (DvrLink)((Object)this.elementAt(i));
                    n.setToNode(null);
                }
                break;
            }
            case 5: {
                for (int i = 0; i < num; ++i) {
                    DvrLink n = (DvrLink)((Object)this.elementAt(i));
                    n.setWidth(1.0);
                }
                break;
            }
            case 4: {
                for (int i = 0; i < num; ++i) {
                    DvrLink n = (DvrLink)((Object)this.elementAt(i));
                    n.setInfo(null);
                }
                break;
            }
            case 7: {
                for (int i = 0; i < num; ++i) {
                    DvrLink n = (DvrLink)((Object)this.elementAt(i));
                    n.setColor(null);
                }
                break;
            }
            case 6: {
                for (int i = 0; i < num; ++i) {
                    DvrLink n = (DvrLink)((Object)this.elementAt(i));
                    n.setValue(0.0);
                }
                break;
            }
            case 8: {
                for (int i = 0; i < num; ++i) {
                    DvrLink n = (DvrLink)((Object)this.elementAt(i));
                    n.setStipple(0);
                }
                break;
            }
        }
    }

    public int getPropertyIndex(String role) {
        return this.props.getPropertyIndex(role);
    }

    public Object getAllVariables(Object role) {
        return this.getVariable(role);
    }

    public Object getVariable(Object role) {
        return this.ROLE_TO_ID_MAP[this.props.getPropertyIndex((String)role)];
    }

    public Object getRole(Object variableId) {
        int r = this.ROLE_TO_ID_MAP.length + 1;
        for (int i = 0; i < this.ROLE_TO_ID_MAP.length; ++i) {
            if (null == this.ROLE_TO_ID_MAP[i] || !this.ROLE_TO_ID_MAP[i].toString().equals(variableId.toString())) continue;
            r = i;
            break;
        }
        if (r < this.ROLE_TO_ID_MAP.length) {
            return keys[r];
        }
        return null;
    }

    public boolean isDiscrete(Object variableId) {
        return false;
    }

    public boolean setDiscrete(Object variableId, boolean discrete) {
        return false;
    }

    public boolean isRoleVariablePairPresent(Object variableId, Object role) {
        int roleIndex = -1;
        if (!(role instanceof String)) {
            return false;
        }
        roleIndex = this.props.getPropertyIndex((String)role);
        if (this.ROLE_TO_ID_MAP[roleIndex] == null) {
            return false;
        }
        return ((String)this.ROLE_TO_ID_MAP[roleIndex]).equalsIgnoreCase((String)variableId);
    }

    public boolean setRole(Object variableId, Object role) {
        int roleIndex = -1;
        if (!(role instanceof String)) {
            return false;
        }
        roleIndex = this.props.getPropertyIndex((String)role);
        this.ROLE_TO_ID_MAP[roleIndex] = variableId;
        return true;
    }

    public Object[][] getSupportedSortableRoles() {
        return null;
    }

    public int[] getSupportedSortDirections(Object role) {
        return null;
    }

    public boolean requiresMultipleRoleAssignments() {
        return false;
    }

    public boolean supportsMultipleAssignments(Object role) {
        return false;
    }

    public void dataFilterChanged(DvrDataFilterEvent evt) {
        if (evt.source != this.filter) {
            return;
        }
        switch (evt.type) {
            case 1: {
                this.dataSourceChanged(evt);
                break;
            }
            case 3: {
                this.valueChanged(evt);
                break;
            }
            case 4: {
                this.variableAdded(evt);
                break;
            }
            case 5: {
                this.variableRemoved(evt);
                break;
            }
            case 6: {
                this.formatChanged(evt);
                break;
            }
            case 2: {
                this.dataSelectionChanged(evt);
                break;
            }
        }
    }

    public Collection getSelectedLinkIndices() {
        return this.selectedLinkIndices.values();
    }

    public void dataSelectionChanged(DvrDataFilterEvent evt) {
        if (this.tableIdToDataIdx == null) {
            return;
        }
        if (evt.obsStartIndex == -1 && evt.obsEndIndex == -1) {
            NLDLink l;
            int i;
            int nLinks;
            boolean state;
            int[] obs = (int[])evt.oldValue;
            int numObs = ((Number)evt.newValue).intValue();
            if (obs == null) {
                if (numObs > this.filter.getNumberObservations(-1)) {
                    numObs = this.filter.getNumberObservations(-1);
                }
                if (!(state = this.filter.isSelected(0L))) {
                    this.selectedLinkIndices.clear();
                }
                nLinks = this.size();
                for (i = 0; i < numObs; ++i) {
                    String linkIdFromFilter = this.getString(this.filter.getValue(this.ROLE_TO_ID_MAP[0], (long)i));
                    Integer indexInData = (Integer)this.tableIdToDataIdx.get(linkIdFromFilter);
                    if (indexInData == null || indexInData < 0 || indexInData >= nLinks) continue;
                    if (state) {
                        this.selectedLinkIndices.put(indexInData, indexInData);
                    }
                    l = (NLDLink)this.elementAt(indexInData);
                    l.setSelected(state);
                    this.setNodeLabelState(l);
                }
            } else {
                state = this.filter.isSelected((long)obs[0]);
                nLinks = this.size();
                for (i = 0; i < numObs; ++i) {
                    String filterLinkId = this.getString(this.filter.getValue(this.ROLE_TO_ID_MAP[0], (long)obs[i]));
                    String filterFromId = this.getString(this.filter.getValue(this.ROLE_TO_ID_MAP[1], (long)obs[i]));
                    String filterToId = this.getString(this.filter.getValue(this.ROLE_TO_ID_MAP[2], (long)obs[i]));
                    Integer indexInData = (Integer)this.tableIdToDataIdx.get(filterLinkId);
                    if (indexInData == null || indexInData < 0 || indexInData >= nLinks) continue;
                    l = (NLDLink)this.elementAt(indexInData);
                    String fromId = l.getFromNode().toString();
                    String toId = l.getToNode().toString();
                    if (this.viewer.getModel().getDirected()) {
                        if (!fromId.equalsIgnoreCase(filterFromId) || !toId.equalsIgnoreCase(filterToId)) {
                            if (numObs != 1) continue;
                            this.selectedLinkIndices.remove(indexInData);
                            l.setSelected(false);
                            this.setNodeLabelState(l);
                            continue;
                        }
                    } else if (!(fromId.equalsIgnoreCase(filterFromId) && toId.equalsIgnoreCase(filterToId) || toId.equalsIgnoreCase(filterFromId) && fromId.equalsIgnoreCase(filterToId))) {
                        if (numObs != 1) continue;
                        this.selectedLinkIndices.remove(indexInData);
                        l.setSelected(false);
                        this.setNodeLabelState(l);
                        continue;
                    }
                    if (state) {
                        this.selectedLinkIndices.put(indexInData, indexInData);
                    } else {
                        this.selectedLinkIndices.remove(indexInData);
                    }
                    l.setSelected(state);
                    this.setNodeLabelState(l);
                }
            }
        }
        if (!evt.isAdjusting) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((NLDModelListenerInterface)this.listeners.elementAt(i)).modelChanged();
            }
        }
    }

    public void dataSourceChanged(DvrDataFilterEvent evt) {
        DataFilterReadInterface source = evt.source;
        if (source == this.filter) {
            return;
        }
        this.setDataSource(source);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((NLDModelListenerInterface)this.listeners.elementAt(i)).modelChanged();
        }
    }

    public void valueChanged(DvrDataFilterEvent evt) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((NLDModelListenerInterface)this.listeners.elementAt(i)).dataChanged();
        }
    }

    public void variableAdded(DvrDataFilterEvent evt) {
        int i;
        int role_id = -1;
        for (i = 0; i < 10; ++i) {
            if (evt.varStartIndex != this.filter.getVariableIndex(this.ROLE_TO_ID_MAP[i])) continue;
            role_id = i;
            break;
        }
        if (role_id == -1) {
            return;
        }
        this.setLinkValues(this.ROLE_TO_ID_MAP[role_id], role_id);
        for (i = 0; i < this.listeners.size(); ++i) {
            ((NLDModelListenerInterface)this.listeners.elementAt(i)).dataChanged();
        }
    }

    public void variableRemoved(DvrDataFilterEvent evt) {
        int i;
        int role_id = -1;
        for (i = 0; i < 10; ++i) {
            if (evt.varStartIndex != this.filter.getVariableIndex(this.ROLE_TO_ID_MAP[i])) continue;
            role_id = i;
            break;
        }
        if (role_id == -1) {
            return;
        }
        this.resetLinkValues(this.ROLE_TO_ID_MAP[role_id], role_id);
        for (i = 0; i < this.listeners.size(); ++i) {
            ((NLDModelListenerInterface)this.listeners.elementAt(i)).dataChanged();
        }
    }

    public void formatChanged(DvrDataFilterEvent evt) {
    }

    public void addNLDModelListener(NLDModelListenerInterface obj) {
        if (this.listeners != null && obj != null && !this.listeners.contains(obj)) {
            this.listeners.addElement(obj);
        }
    }

    public void removeNLDModelListener(NLDModelListenerInterface obj) {
        if (this.listeners != null && obj != null && this.listeners.contains(obj)) {
            this.listeners.removeElement(obj);
        }
    }

    public void setSelectAll(boolean flag) {
        long num = this.size();
        int i = 0;
        while ((long)i < num) {
            DvrLink n = (DvrLink)((Object)this.elementAt(i));
            if (n.isSelected() != flag) {
                n.setSelected(flag);
                this.setNodeLabelState(n);
                int filterIdx = this.getLinkIndxFromFilter(i);
                if (filterIdx < 0) {
                    return;
                }
                this.filter.setSelected((long)filterIdx, flag);
            }
            ++i;
        }
    }

    public Object getFromNode(int id) {
        DvrLink link = (DvrLink)((Object)this.elementAt(id));
        return link.From;
    }

    public Object getToNode(int id) {
        DvrLink link = (DvrLink)((Object)this.elementAt(id));
        return link.To;
    }

    public Object[] getNodes(int id) {
        Object[] rc = new Object[2];
        DvrLink link = (DvrLink)((Object)this.elementAt(id));
        rc[0] = link.From;
        rc[1] = link.To;
        return rc;
    }

    public int numLinks() {
        return this.size();
    }

    public void setValue(int property, int id, Object val) {
        super.setValue(property, id, val);
        Object variable = this.getVariable(property);
        if (variable != null && this.filter instanceof DataFilterWriteInterface) {
            DataFilterWriteInterface data = (DataFilterWriteInterface)this.filter;
            data.setValue(variable, (long)id, val);
        }
    }

    public int getIndexOf(Object link) {
        if (link instanceof DvrLink) {
            DvrLink a = (DvrLink)((Object)link);
            if (this.tableIdToDataIdx == null) {
                return -1;
            }
            Integer index = (Integer)this.tableIdToDataIdx.get(a.getID());
            return index;
        }
        return super.getIndexOf(link);
    }

    public void unselectAll() {
        this.filter.unselectAll();
    }

    public int getNumberInputRoles() {
        return 10;
    }

    public void setFrom(int id, int from) {
        super.setFrom(id, from);
    }

    public void setTo(int id, int to) {
        super.setFrom(id, to);
    }

    public void setLabel(int id, String val) {
        super.setLabel(id, val);
    }

    public void setInfo(int id, String val) {
        super.setInfo(id, val);
    }

    public void setColor(int id, Color c) {
        super.setColor(id, c);
    }

    public void setWidth(int id, double val) {
        super.setWidth(id, val);
    }

    public void setStipple(int id, int val) {
        super.setStipple(id, val);
    }

    public void setValue(int id, double val) {
        super.setValue(id, val);
    }

    public void setSelected(int[] indices, boolean flag, int cntr, boolean handleEvents) {
        int[] indx = new int[cntr];
        int count = 0;
        boolean duplicatesPresent = false;
        for (int i = 0; i < cntr; ++i) {
            if (indices[i] < 0 || indices[i] >= this.size()) continue;
            NLDLink l = (NLDLink)this.elementAt(indices[i]);
            if (l.isSelected()) {
                duplicatesPresent = true;
            } else {
                int filterIdx = this.getLinkIndxFromFilter(indices[i]);
                if (filterIdx < 0) continue;
                indx[count++] = filterIdx;
            }
            if (!handleEvents) continue;
            l.setSelected(flag);
            this.setNodeLabelState(l);
        }
        if (duplicatesPresent) {
            indx = this.trimIndexList(indx, count);
        }
        this.filter.setSelected((Object)indx, flag);
    }

    public int[] trimIndexList(int[] list, int cnt) {
        if (list == null) {
            return null;
        }
        if (cnt >= list.length) {
            return list;
        }
        int[] newList = new int[cnt];
        for (int i = 0; i < cnt; ++i) {
            newList[i] = list[i];
        }
        return newList;
    }

    public void setSelected(int index, boolean flag, boolean handleEvents) {
        int filterIdx;
        NLDLink l = (NLDLink)this.elementAt(index);
        if (handleEvents) {
            l.setSelected(flag);
            this.setNodeLabelState(l);
        }
        if ((filterIdx = this.getLinkIndxFromFilter(index)) < 0) {
            return;
        }
        this.filter.setSelected((long)filterIdx, flag);
    }

    public void unselectAll(boolean handleEvents) {
        long num = this.size();
        int[] indices = new int[(int)num];
        int cntr = 0;
        int i = 0;
        while ((long)i < num) {
            NLDLink l = (NLDLink)this.elementAt(i);
            if (l.isSelected()) {
                indices[cntr++] = i;
                if (handleEvents) {
                    l.setSelected(false);
                    this.setNodeLabelState(l);
                }
            }
            ++i;
        }
        this.setSelected(indices, false, cntr, handleEvents);
    }

    public void setViewer(NLDViewer viewer) {
        this.viewer = viewer;
    }
}

