/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.orgchart.OrgViewer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.ImageObserver;
import java.util.ArrayList;

public class NodeRenderer {
    private static final int ROUNDING_DIAMETER = 8;

    public static void drawOrgChartNode(Graphics g, Color nodeColor, Color nodeOutlineColor, Color textColor, int x, int y, int nodeWidth, int nodeHeight, Object label, int numTextLines, boolean inFocus, Color focusColor, boolean selected, Color selectColor, boolean drawIcon, Image nodeIcon, boolean drawShadow, int handleX, int handleY, Image handleIcon, ImageObserver observer, int handleShapeType, boolean drawOnlyLabel, boolean isChildrenOnStack) {
        int x1 = x - nodeWidth / 2;
        int y1 = y - nodeHeight / 2;
        if (drawOnlyLabel) {
            NodeRenderer.drawStackedLabel(g, x1, y1, nodeWidth, nodeHeight, 8, label, textColor, numTextLines, selected, selectColor, inFocus, focusColor);
            return;
        }
        g.setColor(Color.white);
        g.fillRoundRect(x1, y1, nodeWidth, nodeHeight, 8, 8);
        if (drawShadow) {
            g.setColor(nodeColor.darker());
            g.fillRoundRect(x1 + 3, y1 + 3, nodeWidth, nodeHeight, 8, 8);
            g.setColor(Color.white);
            g.fillRoundRect(x1, y1, nodeWidth, nodeHeight, 8, 8);
        }
        int xOffset = 0;
        if (drawIcon) {
            xOffset = 32;
            if (nodeIcon != null) {
                int iw = nodeIcon.getWidth(null);
                int ih = nodeIcon.getHeight(null);
                if (iw <= 24 && ih <= 24) {
                    int xo = (24 - iw) / 2;
                    int yo = (24 - ih) / 2;
                    g.drawImage(nodeIcon, x1 + 4 + xo, y1 + 4 + yo, null);
                }
            }
            g.setColor(nodeColor);
            g.fillRect(x1 + xOffset, y1, 8, nodeHeight);
            g.setColor(Color.white);
            g.fillRoundRect(x1 + xOffset, y1, nodeWidth - xOffset, nodeHeight, 8, 8);
            g.setColor(nodeOutlineColor);
            g.drawLine(x1 + xOffset, y1, x1 + xOffset, y1 + nodeHeight);
        }
        g.setColor(nodeColor);
        g.fillRoundRect(x1 + xOffset, y1, nodeWidth - xOffset, nodeHeight, 8, 8);
        g.setColor(nodeOutlineColor);
        g.drawRoundRect(x1, y1, nodeWidth, nodeHeight, 8, 8);
        if (selected) {
            Stroke savedStroke = null;
            Graphics2D g2 = null;
            if (g instanceof Graphics2D) {
                g2 = (Graphics2D)g;
                savedStroke = g2.getStroke();
                g2.setStroke(new BasicStroke(2.0f, 2, 2));
            }
            g.setColor(selectColor);
            g.drawRoundRect(x1 - 1, y1 - 1, nodeWidth + 2, nodeHeight + 2, 8, 8);
            if (g2 != null) {
                g2.setStroke(savedStroke);
            }
        }
        if (inFocus) {
            Stroke savedStroke = null;
            Graphics2D g2 = null;
            if (g instanceof Graphics2D) {
                g2 = (Graphics2D)g;
                savedStroke = g2.getStroke();
                g2.setStroke(new BasicStroke(1.0f, 2, 2, 0.0f, new float[]{3.0f}, 0.0f));
            }
            g.setColor(focusColor);
            g.drawRoundRect(x1 + 2, y1 + 2, nodeWidth - 4, nodeHeight - 4, 8, 8);
            if (g2 != null) {
                g2.setStroke(savedStroke);
            }
        }
        NodeRenderer.drawString(g, x1, y1, nodeWidth, xOffset, label, textColor, numTextLines, false, isChildrenOnStack);
        if (handleIcon != null) {
            int iconW = handleIcon.getWidth(observer);
            int iconH = handleIcon.getHeight(observer);
            if (handleShapeType == -1) {
                g.drawImage(handleIcon, handleX - iconW / 2, handleY - iconH / 2, observer);
            } else {
                Polygon pl = new Polygon();
                if (handleShapeType == 0) {
                    pl.addPoint(handleX - iconW / 2, handleY);
                    pl.addPoint(handleX, handleY + iconH / 2);
                    pl.addPoint(handleX + iconW / 2, handleY);
                } else if (handleShapeType == 1) {
                    pl.addPoint(handleX - iconW / 2, handleY + iconH / 2);
                    pl.addPoint(handleX + iconW / 2, handleY + iconH / 2);
                    pl.addPoint(handleX, handleY);
                }
                Graphics2D g2 = null;
                if (g instanceof Graphics2D) {
                    g2 = (Graphics2D)g;
                }
                Object renderingHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setColor(nodeOutlineColor);
                g.drawPolygon(pl);
                g.setColor(nodeColor);
                g.fillPolygon(pl);
                if (renderingHint != null) {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, renderingHint);
                }
            }
        }
    }

    protected static void drawStackedLabel(Graphics g, int x1, int y1, int nodeWidth, int nodeHeight, int xOffset, Object label, Color textColor, int numTextLines, boolean selected, Color selectColor, boolean inFocus, Color focusColor) {
        Graphics2D g2;
        Stroke savedStroke;
        if (selected) {
            savedStroke = null;
            g2 = null;
            if (g instanceof Graphics2D) {
                g2 = (Graphics2D)g;
                savedStroke = g2.getStroke();
                g2.setStroke(new BasicStroke(2.0f, 2, 2));
            }
            g.setColor(selectColor);
            g.drawRoundRect(x1 + 8 - 2, y1, nodeWidth + 2 - 8, nodeHeight, 8, 8);
            if (g2 != null) {
                g2.setStroke(savedStroke);
            }
        }
        if (inFocus) {
            savedStroke = null;
            g2 = null;
            if (g instanceof Graphics2D) {
                g2 = (Graphics2D)g;
                savedStroke = g2.getStroke();
                g2.setStroke(new BasicStroke(1.0f, 2, 2, 0.0f, new float[]{3.0f}, 0.0f));
            }
            g.setColor(focusColor);
            g.drawRoundRect(x1 + 8, y1 + 2, nodeWidth - 4 - 8, nodeHeight - 4, 8, 8);
            if (g2 != null) {
                g2.setStroke(savedStroke);
            }
        }
        NodeRenderer.drawString(g, x1, y1, nodeWidth, 8, label, textColor, numTextLines, true, false);
    }

    protected static void drawString(Graphics g, int x1, int y1, int nodeWidth, int xOffset, Object label, Color textColor, int numTextLines, boolean drawOnlyLabel, boolean isChildrenOnStack) {
        int textAreaWidth = nodeWidth - xOffset - 8;
        if (label != null) {
            FontMetrics fm = g.getFontMetrics();
            g.setColor(textColor);
            if (numTextLines > 1) {
                x1 += 4;
                y1 += 2 + fm.getAscent();
                ArrayList v = OrgViewer.makeMultiLineStrings(label);
                Font f = g.getFont();
                if (f != null && isChildrenOnStack) {
                    Font font = new Font(f.getName(), 1, f.getSize());
                    g.setFont(font);
                }
                for (int i = 0; i < v.size() && i < 5; ++i) {
                    String s = null;
                    s = i == 4 && v.size() > 5 ? "..." : v.get(i).toString();
                    NodeRenderer.drawString(g, fm, s, x1 + xOffset, y1, textAreaWidth);
                    y1 += fm.getAscent();
                }
                if (f != null && isChildrenOnStack) {
                    g.setFont(f);
                }
            } else {
                x1 += 4;
                y1 += 2 + fm.getAscent();
                Font f = g.getFont();
                if (f != null && isChildrenOnStack) {
                    Font font = new Font(f.getName(), 1, f.getSize());
                    g.setFont(font);
                }
                NodeRenderer.drawString(g, fm, label.toString(), x1 + xOffset, y1, textAreaWidth);
                if (f != null && isChildrenOnStack) {
                    g.setFont(f);
                }
            }
        }
    }

    protected static void drawString(Graphics g, FontMetrics fm, String s, int x1, int y1, int textAreaWidth) {
        boolean stringChopped = false;
        while (fm.stringWidth(s) > textAreaWidth) {
            s = s.substring(0, s.length() - 1);
            stringChopped = true;
        }
        if (stringChopped && s.length() > 3) {
            s = s.substring(0, s.length() - 3) + "...";
        }
        g.drawString(s, x1, y1);
    }
}

