/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.interfaces.ColorSchemeInterface;
import com.sas.graphics.silk.interfaces.ComponentInterface;
import com.sas.graphics.silk.interfaces.SourceInterface;
import com.sas.graphics.silk.interfaces.StyleInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class LayoutNode
extends JPanel
implements ComponentListener,
SourceInterface {
    private static final long serialVersionUID = 5142783284892041997L;
    private int splitDir = 1;
    private JComponent[] children;
    private double[] sizes;
    private JSplitPane[] containers;
    private int dividerSize = 3;
    boolean first = true;
    StyleInterface style = null;
    ColorSchemeInterface scheme = null;

    public LayoutNode(int direction, double[] percentages, JComponent[] components) {
        this();
        this.setDirection(direction);
        this.setSpacing(percentages);
        this.setComponents(components);
    }

    public LayoutNode() {
        this.addComponentListener(this);
    }

    public boolean setDirection(int direction) {
        if (direction != 1 && direction != 0) {
            return false;
        }
        this.splitDir = direction;
        this.setupSplits();
        return true;
    }

    public boolean setComponents(JComponent[] components) {
        if (components == null) {
            return false;
        }
        if (this.sizes != null && this.sizes.length != components.length) {
            this.containers = null;
        }
        this.children = components;
        if (this.sizes == null || this.sizes.length != this.children.length) {
            this.setSpacing(null);
        }
        this.applyStyles();
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.setupSplits();
        this.first = true;
        this.doResize();
        if (this.children.length > 1) {
            this.add(this.containers[this.containers.length - 1]);
        } else {
            this.add(this.children[0]);
        }
        return true;
    }

    private void applyStyles() {
        if (this.children == null) {
            return;
        }
        for (int i = 0; i < this.children.length; ++i) {
            if (!(this.children[i] instanceof ComponentInterface)) continue;
            if (this.style != null) {
                ((ComponentInterface)this.children[i]).setStyle((Object)this.style);
            }
            if (this.scheme == null) continue;
            ((ComponentInterface)this.children[i]).setColorScheme((Object)this.scheme);
        }
    }

    public boolean setSpacing(double[] percentages) {
        if (this.children == null) {
            return false;
        }
        if (percentages == null || this.sum(percentages) > 1.0) {
            this.sizes = new double[this.children.length];
            double d = 1.0 / (double)this.children.length;
            for (int i = 0; i < this.sizes.length; ++i) {
                this.sizes[i] = d;
            }
        } else {
            this.sizes = new double[this.children.length];
            for (int i = 0; i < percentages.length && i < this.sizes.length; ++i) {
                this.sizes[i] = percentages[i];
            }
            if (percentages.length < this.sizes.length) {
                double d = this.sum(percentages);
                double d1 = 1.0 - d;
                int num = this.sizes.length - percentages.length;
                double val = d1 / (double)num;
                for (int i = percentages.length; i < this.sizes.length; ++i) {
                    this.sizes[i] = val;
                }
            }
        }
        this.setupSplits();
        return true;
    }

    private double sum(double[] d) {
        double rc = 0.0;
        for (int i = 0; i < d.length; ++i) {
            rc += d[i];
        }
        return rc;
    }

    public JComponent[] getChildren() {
        if (this.containers == null && this.children != null && this.children.length == 1) {
            return new JComponent[]{this.children[0]};
        }
        if (this.containers == null) {
            return null;
        }
        Vector<Component> vec = new Vector<Component>();
        for (int i = 0; i < this.containers.length; ++i) {
            Component c;
            if (this.splitDir == 0) {
                c = this.containers[i].getTopComponent();
                if (!(c instanceof JSplitPane)) {
                    vec.addElement(c);
                }
                if ((c = this.containers[i].getBottomComponent()) instanceof JSplitPane) continue;
                vec.addElement(c);
                continue;
            }
            c = this.containers[i].getLeftComponent();
            if (!(c instanceof JSplitPane)) {
                vec.addElement(c);
            }
            if ((c = this.containers[i].getRightComponent()) instanceof JSplitPane) continue;
            vec.addElement(c);
        }
        JComponent[] rc = new JComponent[vec.size()];
        for (int i = 0; i < rc.length; ++i) {
            rc[i] = (JComponent)vec.elementAt(i);
        }
        return rc;
    }

    @Override
    public void addNotify() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.setupSplits();
        if (this.children != null) {
            if (this.children.length > 1) {
                this.add(this.containers[this.containers.length - 1]);
            } else {
                this.add(this.children[0]);
            }
        }
        super.addNotify();
    }

    public int getDirection() {
        return this.splitDir;
    }

    private void setupSplits() {
        if (this.children == null) {
            return;
        }
        if (this.children.length > 1) {
            this.containers = new JSplitPane[this.children.length - 1];
            for (int i = 0; i < this.containers.length; ++i) {
                JComponent child1 = null;
                JComponent child2 = null;
                child1 = i == 0 ? this.children[0] : this.containers[i - 1];
                child2 = this.children[i + 1];
                this.containers[i] = new JSplitPane(this.splitDir, child1, child2);
                this.containers[i].setBorder(null);
                this.containers[i].setDividerSize(this.dividerSize);
            }
        }
    }

    private void doResize() {
        if (this.children == null) {
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.first && this.children.length > 1) {
            int i;
            int[] spans = new int[this.sizes.length];
            if (this.splitDir == 1) {
                for (i = 0; i < spans.length; ++i) {
                    spans[i] = (int)((double)width * this.sizes[i]);
                }
            } else {
                for (i = 0; i < spans.length; ++i) {
                    spans[i] = (int)((double)height * this.sizes[i]);
                }
            }
            int span = 0;
            for (int i2 = 0; i2 < this.containers.length; ++i2) {
                this.containers[i2].setDividerLocation(span += spans[i2]);
            }
            this.first = false;
        }
    }

    @Override
    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.doResize();
    }

    @Override
    public void componentMoved(ComponentEvent ce) {
    }

    @Override
    public void componentShown(ComponentEvent ce) {
    }

    @Override
    public void componentResized(ComponentEvent ce) {
        if (this.children == null) {
            return;
        }
        if (this.children.length > 1) {
            int i;
            int[] spans = new int[this.sizes.length];
            if (this.splitDir == 1) {
                for (i = 0; i < spans.length; ++i) {
                    spans[i] = (int)((double)this.getWidth() * this.sizes[i]);
                }
            } else {
                for (i = 0; i < spans.length; ++i) {
                    spans[i] = (int)((double)this.getHeight() * this.sizes[i]);
                }
            }
            int span = 0;
            for (int i2 = 0; i2 < this.containers.length; ++i2) {
                this.containers[i2].setDividerLocation(span += spans[i2]);
            }
            this.validate();
        }
    }

    @Override
    public void componentHidden(ComponentEvent ce) {
    }

    public int getIndexOfChild(Object arg1) {
        JComponent[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!children[i].equals(arg1)) continue;
            return i;
        }
        return -1;
    }

    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.getChildren().length;
    }

    public Object getChild(int arg1) {
        JComponent[] c = this.getChildren();
        if (c.length <= arg1) {
            return null;
        }
        return c[arg1];
    }

    public Object[] getDataIds() {
        this.children = this.getChildren();
        Vector<Object> v = new Vector<Object>();
        for (int i = 0; i < this.children.length; ++i) {
            Object[] ids;
            if (!(this.children[i] instanceof SourceInterface) || (ids = ((SourceInterface)this.children[i]).getDataIds()) == null) continue;
            for (int j = 0; j < ids.length; ++j) {
                v.addElement(ids[j]);
            }
        }
        Object[] rc = new Object[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            rc[i] = v.elementAt(i);
        }
        if (rc.length == 0) {
            rc = null;
        }
        return rc;
    }

    public Object getDataSource() {
        this.children = this.getChildren();
        for (int i = 0; i < this.children.length; ++i) {
            if (!(this.children[i] instanceof SourceInterface)) continue;
            return ((SourceInterface)this.children[i]).getDataSource();
        }
        return null;
    }

    public Object getDataSource(Object id) {
        this.children = this.getChildren();
        for (int i = 0; i < this.children.length; ++i) {
            Object o;
            if (!(this.children[i] instanceof SourceInterface) || (o = ((SourceInterface)this.children[i]).getDataSource(id)) == null) continue;
            return o;
        }
        return null;
    }

    public boolean setDataSource(Object source, Object id) {
        return false;
    }

    public boolean setDataSource(Object source) {
        return false;
    }

    public void dispose() {
        JComponent[] c = this.getChildren();
        if (c == null) {
            return;
        }
        for (int i = 0; i < c.length; ++i) {
            if (c[i] instanceof ComponentInterface) {
                ((ComponentInterface)c[i]).dispose();
            } else if (c[i] instanceof LayoutNode) {
                ((LayoutNode)c[i]).dispose();
            }
            this.remove(c[i]);
        }
        this.children = null;
        this.containers = null;
    }

    public void print(int width, int height, Graphics2D g) {
        switch (this.splitDir) {
            case 1: {
                int currentX = 0;
                for (int i = 0; i < this.children.length; ++i) {
                    int childWidth = (int)((double)width * this.sizes[i]);
                    g.translate(currentX, 0);
                    if (this.children[i] instanceof LayoutNode) {
                        ((LayoutNode)this.children[i]).print(childWidth, height, g);
                    } else if (this.children[i] != null) {
                        Dimension oldSize = this.children[i].getSize();
                        this.children[i].setSize(childWidth, height);
                        this.children[i].paint(g);
                        this.children[i].setSize(oldSize);
                    }
                    g.translate(-currentX, 0);
                    currentX += childWidth;
                }
                break;
            }
            case 0: {
                int currentY = 0;
                for (int i = 0; i < this.children.length; ++i) {
                    int childHeight = (int)((double)height * this.sizes[i]);
                    g.translate(0, currentY);
                    if (this.children[i] instanceof LayoutNode) {
                        ((LayoutNode)this.children[i]).print(width, childHeight, g);
                    } else {
                        Dimension oldSize = this.children[i].getSize();
                        this.children[i].setSize(width, childHeight);
                        this.children[i].paint(g);
                        this.children[i].setSize(oldSize);
                    }
                    g.translate(0, -currentY);
                    currentY += childHeight;
                }
                break;
            }
        }
    }

    public ColorSchemeInterface getScheme() {
        return this.scheme;
    }

    public void setScheme(ColorSchemeInterface scheme) {
        this.scheme = scheme;
    }

    public StyleInterface getStyle() {
        return this.style;
    }

    public void setStyle(StyleInterface style) {
        this.style = style;
    }
}

