/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.GridLayoutComponent;
import com.sas.graphics.silk.interfaces.AnnotateInterface;
import com.sas.graphics.silk.interfaces.BaseComponentInterface;
import com.sas.graphics.silk.interfaces.ColorSchemeInterface;
import com.sas.graphics.silk.interfaces.ComponentInterface;
import com.sas.graphics.silk.interfaces.CompositeChartPrintInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.GraphInterface;
import com.sas.graphics.silk.interfaces.SourceInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.UIUtilities;
import com.sas.graphics.silk.ui.graphwizard.GraphWizard;
import com.sas.graphics.silk.util.Cell;
import com.sas.graphics.silk.util.Clone;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.util.GlobalDefaults;
import com.sas.graphics.silk.util.ImagePaginator;
import com.sas.graphics.silk.util.LayoutNode;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.TreeLayoutNode;
import com.sas.graphics.silk.xml.SILKParser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class GraphLayout
extends JComponent
implements ActionListener,
MouseListener,
TreeSelectionListener,
SourceInterface,
Printable,
CompositeChartPrintInterface,
Pageable,
BaseComponentInterface {
    private static final long serialVersionUID = -7679391938927826905L;
    public static String SAVE_LAYOUT = "GRAPHLAYOUT_SAVE";
    JToolBar toolbar = new JToolBar();
    JButton hSplit = null;
    JButton vSplit = null;
    JButton graph = null;
    JButton save = null;
    LayoutNode root = null;
    JComponent selected = null;
    Border nonSelectedBorder = null;
    Border selectedBorder = null;
    GraphWizard wiz = null;
    DataFilterReadInterface model = null;
    JSplitPane innerPanel = new JSplitPane(1);
    JPanel displayPanel = new JPanel(new BorderLayout());
    JTree tree = new JTree();
    TreeLayoutNode treeRoot;
    DefaultTreeModel treeModel = null;
    NodeRenderer renderer = null;
    ActionListener saveLayoutCallback = null;
    private int splitLimit = 99;
    JPopupMenu menu = null;
    JComponent pasteBuffer = null;
    Object mouseEventSource = null;
    ResourceBundle rb = null;
    protected GlobalDefaults silkDefaults = new GlobalDefaults();
    public boolean isInModalDialog = false;
    private int printMode = 3;
    private Vector printableChildren = null;
    private BufferedImage printImage = null;
    private ImagePaginator imagePaginator = null;
    private static int[] supportedPrintModes = new int[]{3, 2, 1};

    @Override
    public void addNotify() {
        Container c;
        super.addNotify();
        for (c = this.getParent(); c != null && !(c instanceof Dialog); c = c.getParent()) {
        }
        if (c != null && c instanceof Dialog && ((Dialog)c).isModal()) {
            this.isInModalDialog = true;
        }
    }

    public boolean initFromXML(Hashtable context, String xml) {
        if (xml == null) {
            return false;
        }
        Hashtable results = SILKParser.parse((Hashtable)context, (String)xml);
        Object[] charts = SILKParser.getCharts((Hashtable)results);
        if (charts == null || charts.length == 0 || !(charts[0] instanceof JComponent)) {
            return false;
        }
        JComponent newRoot = (JComponent)charts[0];
        if (newRoot instanceof GridLayoutComponent) {
            GridLayoutComponent glc = (GridLayoutComponent)newRoot;
            glc.removeMyMouseListeners();
            newRoot = glc.getRoot();
        }
        this.recursiveAddMouseListeners(newRoot);
        this.setRoot(newRoot);
        return true;
    }

    public LayoutNode getRoot() {
        return this.root;
    }

    public void recursiveAddMouseListeners(JComponent component) {
        if (component == null) {
            return;
        }
        if (component instanceof LayoutNode) {
            JComponent[] children = ((LayoutNode)component).getChildren();
            if (children == null) {
                return;
            }
            for (int i = 0; i < children.length; ++i) {
                this.recursiveAddMouseListeners(children[i]);
            }
        } else {
            this.addAsFirstMouseListener(component, this);
        }
    }

    private void addAsFirstMouseListener(Component component, MouseListener l) {
        int i;
        if (component == null || l == null) {
            return;
        }
        MouseListener[] mouseListeners = component.getMouseListeners();
        if (mouseListeners != null) {
            for (i = 0; i < mouseListeners.length; ++i) {
                component.removeMouseListener(mouseListeners[i]);
            }
        }
        component.addMouseListener(l);
        if (mouseListeners != null) {
            for (i = 0; i < mouseListeners.length; ++i) {
                component.addMouseListener(mouseListeners[i]);
            }
        }
    }

    public String getLayoutXML(boolean standAlone, Hashtable context) {
        if (context == null) {
            context = new Hashtable();
        }
        if (standAlone) {
            return SILKParser.getStandAloneXML(context, (Object)this.root);
        }
        return SILKParser.getXML(context, (Object)this.root);
    }

    public String getLayoutXML(boolean standAlone) {
        return this.getLayoutXML(standAlone, new Hashtable());
    }

    public void setSaveLayoutCallback(ActionListener listener) {
        if (listener == null) {
            this.save.setEnabled(false);
        } else {
            this.save.setEnabled(true);
        }
        this.saveLayoutCallback = listener;
    }

    public GraphLayout() {
        this.init(null);
    }

    public GraphLayout(DataFilterReadInterface data, JFrame parent) {
        this.model = data;
        this.init(parent);
    }

    private void init(JFrame parent) {
        this.rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.util.silk_util_NLS");
        this.wiz = new GraphWizard(parent, this.model);
        this.wiz.addActionListener(this);
        this.selectedBorder = BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createLoweredBevelBorder());
        this.nonSelectedBorder = BorderFactory.createEmptyBorder();
        this.setLayout(new BorderLayout());
        this.add("North", this.toolbar);
        this.toolbar.setVisible(false);
        this.hSplit = new JButton(new ImageIcon(ResourceLoader.getImage((Component)this, (String)"icons/SplitPaneHorizontal.gif")));
        this.hSplit.addActionListener(this);
        this.vSplit = new JButton(new ImageIcon(ResourceLoader.getImage((Component)this, (String)"icons/SplitPaneVertical.gif")));
        this.vSplit.addActionListener(this);
        this.graph = new JButton(new ImageIcon(ResourceLoader.getImage((Component)this, (String)"icons/SplitPaneGraph.gif")));
        this.graph.addActionListener(this);
        this.save = new JButton("XML");
        this.save.setActionCommand(SAVE_LAYOUT);
        this.setSaveLayoutCallback(this);
        this.save.addActionListener(this);
        this.innerPanel.setBackground(Color.white);
        this.innerPanel.setLeftComponent(new JScrollPane(this.tree));
        this.innerPanel.setOneTouchExpandable(true);
        this.innerPanel.setDividerLocation(0);
        this.toolbar.add(this.vSplit);
        this.toolbar.add(this.hSplit);
        this.toolbar.addSeparator();
        this.toolbar.add(this.graph);
        this.toolbar.addSeparator();
        this.toolbar.addSeparator();
        this.toolbar.add(this.save);
        this.tree.setShowsRootHandles(true);
        this.tree.setModel(null);
        this.tree.putClientProperty("JTree.lineStyle", "Horizontal");
        this.tree.setPreferredSize(new Dimension(200, 200));
        this.tree.addTreeSelectionListener(this);
        this.add("Center", this.displayPanel);
        Cell cell = new Cell(this);
        this.setRoot(cell);
    }

    private void setRoot(JComponent component) {
        LayoutNode node = null;
        node = component instanceof LayoutNode ? (LayoutNode)component : new LayoutNode(-1, null, new JComponent[]{component});
        if (node.getChildCount() == 0) {
            return;
        }
        this.root = node;
        this.displayPanel.removeAll();
        this.displayPanel.add("Center", this.root);
        this.treeRoot = new TreeLayoutNode(node);
        this.treeModel = new DefaultTreeModel(this.treeRoot);
        this.tree.setModel(this.treeModel);
        this.renderer = new NodeRenderer();
        this.renderer.addNodeType(this.root.getClass(), "Grid Layout", null);
        this.tree.setCellRenderer(this.renderer);
        this.updateTree();
    }

    public void setSplitLimit(int limit) {
        if (limit > 0) {
            this.splitLimit = limit;
        }
    }

    public void setTreeVisible(boolean vis) {
        this.remove(this.displayPanel);
        this.remove(this.innerPanel);
        if (vis) {
            this.innerPanel.setRightComponent(this.displayPanel);
            this.add("Center", this.innerPanel);
        } else {
            this.add("Center", this.displayPanel);
        }
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    public void setToolbarVisible(boolean vis) {
        this.toolbar.setVisible(vis);
    }

    private int getNumSplits() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        JSpinner spinner = new JSpinner();
        spinner.setModel(new SpinnerNumberModel(2, 1, this.splitLimit, 1));
        spinner.setValue(new Integer(2));
        panel.add(spinner);
        int option = JOptionPane.showOptionDialog(this, panel, ResourceLoader.getResourceString((Object)this.rb, (String)"GraphLayout.How_Many_Splits.txt", (String)"How Many Splits?"), 2, -1, null, null, null);
        if (option == 2) {
            return -1;
        }
        Object o = spinner.getValue();
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        return -1;
    }

    public void addNode(JComponent target, JComponent node) {
        Container c;
        LayoutNode parent = null;
        for (c = this.selected.getParent(); c != null && !(c instanceof LayoutNode); c = c.getParent()) {
        }
        if (c == null) {
            return;
        }
        parent = (LayoutNode)c;
        JComponent[] children = parent.getChildren();
        int index = 0;
        for (index = 0; index < children.length && target != children[index]; ++index) {
        }
        if (index >= children.length) {
            return;
        }
        node.setPreferredSize(target.getSize());
        children[index] = node;
        parent.setComponents(children);
        this.invalidate();
        this.revalidate();
        this.updateTree();
        this.repaint();
    }

    protected void insertNode(int direction) {
        int num = this.getNumSplits();
        if (num < 0) {
            return;
        }
        JComponent oldComponent = this.selected;
        LayoutNode node = new LayoutNode(direction, null, null);
        if (this.selected != null) {
            this.addNode(this.selected, node);
            JComponent[] arr = new JComponent[num];
            for (int i = 0; i < num; ++i) {
                arr[i] = i == 0 ? oldComponent : new Cell(this);
            }
            node.setComponents(arr);
            this.selected.setBorder(this.nonSelectedBorder);
            this.selected = null;
            this.updateTree();
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        String command = ae.getActionCommand();
        if (source == this.hSplit || command.equalsIgnoreCase("SPLITHORIZONTAL")) {
            if (this.mouseEventSource != null && this.mouseEventSource instanceof JComponent) {
                this.select((JComponent)this.mouseEventSource);
            }
            this.insertNode(0);
        } else if (source == this.vSplit || command.equalsIgnoreCase("SPLITVERTICAL")) {
            if (this.mouseEventSource != null && this.mouseEventSource instanceof JComponent) {
                this.select((JComponent)this.mouseEventSource);
            }
            this.insertNode(1);
        } else if (source == this.graph) {
            this.wiz.setVisible(true);
        } else if (source == this.wiz) {
            JComponent component = this.wiz.getGraph();
            this.recursiveAddMouseListener(component);
            if (this.isInModalDialog && component instanceof GraphInterface) {
                ((GraphInterface)component).setToolBar(null);
            }
            if (this.renderer != null) {
                this.renderer.addNodeType(component.getClass(), this.wiz.getName(), this.wiz.getImage() == null ? null : new ImageIcon(this.wiz.getImage()));
            }
            if (this.selected != null) {
                this.addNode(this.selected, component);
            }
        } else if (source == this.save) {
            ActionEvent saveEvent = new ActionEvent(this, 0, SAVE_LAYOUT);
            this.saveLayoutCallback.actionPerformed(saveEvent);
        } else if (source == this && ae.getActionCommand().equalsIgnoreCase(SAVE_LAYOUT)) {
            System.out.println(this.getLayoutXML(true));
        } else if (command.equalsIgnoreCase("CUTCOMPONENT")) {
            if (this.mouseEventSource instanceof JComponent) {
                this.pasteBuffer = (JComponent)this.mouseEventSource;
            }
            if (!(this.pasteBuffer.getParent() instanceof JSplitPane)) {
                return;
            }
            JSplitPane parent = (JSplitPane)this.pasteBuffer.getParent();
            Cell replacement = new Cell(this);
            this.addAsFirstMouseListener(replacement, this);
            int position = parent.getDividerLocation();
            if (parent.getTopComponent() == this.pasteBuffer) {
                parent.setTopComponent(replacement);
            } else {
                parent.setBottomComponent(replacement);
            }
            parent.setDividerLocation(position);
            this.updateTree();
        } else if (command.equalsIgnoreCase("COPYCOMPONENT")) {
            if (!(this.mouseEventSource instanceof JComponent)) {
                return;
            }
            this.pasteBuffer = (JComponent)Clone.clone((Object)this.mouseEventSource);
        } else if (command.equalsIgnoreCase("PASTECOMPONENT")) {
            if (!(this.mouseEventSource instanceof JComponent)) {
                return;
            }
            this.recursiveAddMouseListener(this.pasteBuffer);
            if (this.isInModalDialog && this.pasteBuffer instanceof GraphInterface) {
                ((GraphInterface)this.pasteBuffer).setToolBar(null);
            }
            this.select((JComponent)this.mouseEventSource);
            if (this.selected != null) {
                this.addNode(this.selected, this.pasteBuffer);
            }
            this.pasteBuffer = null;
        } else if (command.equalsIgnoreCase("SELECTCOMPONENT")) {
            if (!(this.mouseEventSource instanceof JComponent)) {
                return;
            }
            this.select((JComponent)this.mouseEventSource);
        } else if (command.equalsIgnoreCase("UNSPLIT")) {
            Container c;
            if (!(this.mouseEventSource instanceof JComponent)) {
                return;
            }
            JComponent saveComp = (JComponent)this.mouseEventSource;
            this.select(saveComp);
            LayoutNode parent = null;
            for (c = this.selected.getParent(); c != null && !(c instanceof LayoutNode); c = c.getParent()) {
            }
            if (c == null) {
                return;
            }
            parent = (LayoutNode)c;
            parent.setComponents(new JComponent[]{saveComp});
            this.invalidate();
            this.revalidate();
            this.updateTree();
            this.repaint();
        }
    }

    public void recursiveAddMouseListener(Container component) {
        this.addAsFirstMouseListener(component, this);
        Component[] children = component.getComponents();
        for (int i = 0; i < children.length; ++i) {
            if (children[i] instanceof Container) {
                this.recursiveAddMouseListener((Container)children[i]);
                continue;
            }
            this.addAsFirstMouseListener(children[i], this);
        }
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        int x = me.getX();
        int y = me.getY();
        Object source = me.getSource();
        JComponent comp = (JComponent)source;
        for (Container parent = ((JComponent)source).getParent(); parent != null && !(parent instanceof LayoutNode) && !(parent instanceof JSplitPane); parent = parent.getParent()) {
            if (!(parent instanceof JComponent)) continue;
            comp = (JComponent)parent;
        }
        this.mouseEventSource = comp;
        int flags = me.getModifiers();
        if ((flags & 4) != 0) {
            this.buildMenu(comp);
        }
        if (source instanceof Cell) {
            this.select((JComponent)source);
        }
    }

    public void buildMenu(Object source) {
        this.menu = new JPopupMenu();
        String cellLabel = ResourceLoader.getResourceString((Object)this.rb, (String)"GraphLayout.Cell_Menu.txt", (String)"Cell");
        JMenu cell = new JMenu(cellLabel);
        JMenuItem select = new JMenuItem(ResourceLoader.getResourceString((Object)this.rb, (String)"GraphLayout.Select_MenuItem.txt", (String)"Select Graph"));
        cell.add(select);
        select.setActionCommand("SELECTCOMPONENT");
        select.addActionListener(this);
        cell.addSeparator();
        JMenuItem cut = new JMenuItem(ResourceLoader.getResourceString((Object)this.rb, (String)"GraphLayout.Cut_MenuItem.txt", (String)"Cut Graph"));
        cut.setActionCommand("CUTCOMPONENT");
        cut.addActionListener(this);
        cell.add(cut);
        if (source instanceof Cell) {
            cut.setEnabled(false);
        }
        JMenuItem copy = new JMenuItem(ResourceLoader.getResourceString((Object)this.rb, (String)"GraphLayout.Copy_MenuItem.txt", (String)"Copy Graph"));
        copy.setActionCommand("COPYCOMPONENT");
        copy.addActionListener(this);
        cell.add(copy);
        if (source instanceof Cell) {
            copy.setEnabled(false);
        }
        JMenuItem paste = new JMenuItem(ResourceLoader.getResourceString((Object)this.rb, (String)"GraphLayout.Paste_MenuItem.txt", (String)"Paste Graph"));
        cell.add(paste);
        paste.setActionCommand("PASTECOMPONENT");
        paste.addActionListener(this);
        if (this.pasteBuffer == null) {
            paste.setEnabled(false);
        }
        cell.addSeparator();
        JMenu split = new JMenu(ResourceLoader.getResourceString((Object)this.rb, (String)"GraphLayout.Split_Menu.txt", (String)"Split"));
        cell.add(split);
        JMenuItem horiz = new JMenuItem(ResourceLoader.getResourceString((Object)this.rb, (String)"GraphLayout.Horizontal_MenuItem.txt", (String)"Horizontal"));
        split.add(horiz);
        horiz.setActionCommand("SPLITHORIZONTAL");
        horiz.addActionListener(this);
        JMenuItem vert = new JMenuItem(ResourceLoader.getResourceString((Object)this.rb, (String)"GraphLayout.Vertical_MenuItem.txt", (String)"Vertical"));
        split.add(vert);
        vert.setActionCommand("SPLITVERTICAL");
        vert.addActionListener(this);
        if (source instanceof JComponent && ((JComponent)source).getParent() instanceof JSplitPane) {
            JMenuItem unsplit = new JMenuItem(ResourceLoader.getResourceString((Object)this.rb, (String)"GraphLayout.UnSplit_MenuItem.txt", (String)"Un-Split"));
            cell.add(unsplit);
            unsplit.setActionCommand("UNSPLIT");
            unsplit.addActionListener(this);
        }
        if (source instanceof ComponentInterface && ((ComponentInterface)source).getPopupMenu() != null) {
            JPopupMenu popup = ((ComponentInterface)source).getPopupMenu();
            Component c = popup.getComponent(0);
            if (!(c instanceof JMenu) || !((JMenu)c).getText().equals(cellLabel)) {
                popup.add((Component)new JSeparator(), 0);
                popup.add((Component)new JSeparator(), 0);
            } else {
                popup.remove(0);
            }
            popup.add((Component)cell, 0);
        } else {
            UIUtilities.addMenu((JMenu)cell, (JPopupMenu)this.menu);
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    protected void select(JComponent component) {
        if (this.selected != null) {
            this.selected.setBorder(this.nonSelectedBorder);
        }
        JComponent comp = component;
        if (!(comp instanceof Cell)) {
            for (Container parent = component.getParent(); parent != null && !(parent instanceof JSplitPane) && !(parent instanceof LayoutNode); parent = parent.getParent()) {
                if (!(parent instanceof JComponent)) continue;
                comp = (JComponent)parent;
            }
        }
        this.selected = comp;
        if (this.selected != null) {
            this.selected.setBorder(this.selectedBorder);
        }
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    private void updateTree() {
        this.treeModel.reload();
        this.revalidate();
        this.expandAll(this.tree);
    }

    public void expandAll(JTree tree) {
        for (int row = 0; row < tree.getRowCount(); ++row) {
            tree.expandRow(row);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent arg0) {
        TreePath path = arg0.getPath();
        Object obj = path.getLastPathComponent();
        if (obj instanceof TreeLayoutNode) {
            TreeLayoutNode node = (TreeLayoutNode)obj;
            this.select(node.value);
        }
    }

    public Object[] getDataModels() {
        return new Object[]{this.model};
    }

    public Object[] getDataIds() {
        if (this.root == null) {
            return null;
        }
        return this.root.getDataIds();
    }

    public Object getDataSource() {
        if (this.root == null) {
            return null;
        }
        return this.root.getDataSource();
    }

    public Object getDataSource(Object id) {
        if (this.root == null) {
            return null;
        }
        return this.root.getDataSource(id);
    }

    public boolean setDataSource(Object source, Object id) {
        if (this.root == null) {
            return false;
        }
        return this.root.setDataSource(source, id);
    }

    public boolean setDataSource(Object source) {
        this.model = FilterFactory.getDataSourceFilter((Object)source);
        if (this.model != null) {
            this.wiz.setData(this.model.getSource());
        }
        return true;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        int rc = 1;
        switch (this.printMode) {
            case 1: {
                rc = this.printSpanPages(graphics, pageFormat, pageIndex);
                break;
            }
            case 3: {
                rc = this.printOnePage(graphics, pageFormat, pageIndex);
                break;
            }
            case 2: {
                rc = this.printChartPerPage(graphics, pageFormat, pageIndex);
            }
        }
        return rc;
    }

    private void createPrintSpanObjects(PageFormat pageFormat) {
        this.printImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        this.root.paint(this.printImage.getGraphics());
        this.imagePaginator = new ImagePaginator(this.printImage);
        if (!this.imagePaginator.isSplit()) {
            this.imagePaginator.splitViewToPages(pageFormat);
        }
    }

    private int printSpanPages(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        if (this.printImage == null) {
            this.createPrintSpanObjects(pageFormat);
        }
        if (pageIndex < 0 || pageIndex > this.imagePaginator.getNumberOfPages()) {
            return 1;
        }
        Image img = this.imagePaginator.getImage(pageIndex);
        if (pageIndex == this.imagePaginator.getNumberOfPages() - 1) {
            this.imagePaginator.disposeImages();
            this.imagePaginator = null;
            this.printImage = null;
        }
        if (img != null) {
            int x = (int)((pageFormat.getWidth() - pageFormat.getImageableWidth()) / 2.0);
            int y = (int)((pageFormat.getHeight() - pageFormat.getImageableHeight()) / 2.0);
            graphics.drawImage(img, x, y, this);
            return 0;
        }
        return 1;
    }

    private int printChartPerPage(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        if (pageIndex == 0) {
            this.recursiveGetPrintableChildren(this.root);
        }
        if (pageIndex >= 0 && pageIndex < this.printableChildren.size()) {
            this.printChartToOnePage((JComponent)this.printableChildren.elementAt(pageIndex), graphics, pageFormat);
            return 0;
        }
        this.printableChildren = null;
        return 1;
    }

    private void printChartToOnePage(JComponent component, Graphics graphics, PageFormat pageFormat) {
        int newHeight;
        int newWidth;
        double maxAspect;
        double compAspect;
        Graphics2D g = (Graphics2D)graphics;
        int maxWidth = (int)pageFormat.getImageableWidth();
        if (this.silkDefaults != null && this.silkDefaults.maxPrintableResolutionX > 0) {
            maxWidth = Math.min(maxWidth, this.silkDefaults.maxPrintableResolutionX);
        }
        int maxHeight = (int)pageFormat.getImageableHeight();
        if (this.silkDefaults != null && this.silkDefaults.maxPrintableResolutionY > 0) {
            maxHeight = Math.min(maxHeight, this.silkDefaults.maxPrintableResolutionY);
        }
        if ((compAspect = (double)this.getWidth() / (double)this.getHeight()) == (maxAspect = (double)maxWidth / (double)maxHeight)) {
            newWidth = maxWidth;
            newHeight = maxHeight;
        } else if (compAspect > maxAspect) {
            newWidth = maxWidth;
            newHeight = (int)((double)newWidth / compAspect);
        } else {
            newHeight = maxHeight;
            newWidth = (int)((double)newHeight * compAspect);
        }
        int xTrans = (int)Math.max((pageFormat.getImageableWidth() - (double)newWidth) / 2.0, 0.0);
        int yTrans = (int)Math.max((pageFormat.getImageableHeight() - (double)newHeight) / 2.0, 0.0);
        AffineTransform defaultXfm = g.getTransform();
        AffineTransform xfm = new AffineTransform(defaultXfm);
        xfm.translate(pageFormat.getImageableX() + (double)xTrans, pageFormat.getImageableY() + (double)yTrans);
        g.setTransform(xfm);
        component.setSize(newWidth, newHeight);
        component.paint(graphics);
        component.setSize(newWidth, newHeight);
        this.invalidate();
        this.revalidate();
    }

    private int printOnePage(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        Graphics2D g = (Graphics2D)graphics;
        int maxWidth = (int)pageFormat.getImageableWidth();
        if (this.silkDefaults != null && this.silkDefaults.maxPrintableResolutionX > 0) {
            maxWidth = Math.min(maxWidth, this.silkDefaults.maxPrintableResolutionX);
        }
        int maxHeight = (int)pageFormat.getImageableHeight();
        if (this.silkDefaults != null && this.silkDefaults.maxPrintableResolutionY > 0) {
            maxHeight = Math.min(maxHeight, this.silkDefaults.maxPrintableResolutionY);
        }
        switch (pageIndex) {
            case 0: {
                int newHeight;
                int newWidth;
                double compAspect = (double)this.getWidth() / (double)this.getHeight();
                double maxAspect = (double)maxWidth / (double)maxHeight;
                if (compAspect == maxAspect) {
                    newWidth = maxWidth;
                    newHeight = maxHeight;
                } else if (compAspect > maxAspect) {
                    newWidth = maxWidth;
                    newHeight = (int)((double)newWidth / compAspect);
                } else {
                    newHeight = maxHeight;
                    newWidth = (int)((double)newHeight * compAspect);
                }
                int xTrans = (int)Math.max((pageFormat.getImageableWidth() - (double)newWidth) / 2.0, 0.0);
                int yTrans = (int)Math.max((pageFormat.getImageableHeight() - (double)newHeight) / 2.0, 0.0);
                AffineTransform defaultXfm = g.getTransform();
                AffineTransform xfm = new AffineTransform(defaultXfm);
                xfm.translate(pageFormat.getImageableX() + (double)xTrans, pageFormat.getImageableY() + (double)yTrans);
                g.setTransform(xfm);
                this.root.print(newWidth, newHeight, g);
                return 0;
            }
        }
        return 1;
    }

    public int getPrintMode() {
        return this.printMode;
    }

    public boolean setPrintMode(int printMode) {
        if (printMode != 1 && printMode != 2 && printMode != 3) {
            return false;
        }
        this.printMode = printMode;
        return true;
    }

    public int[] getSupportedPrintModes() {
        return supportedPrintModes;
    }

    @Override
    public int getNumberOfPages() {
        int rc = 1;
        switch (this.printMode) {
            case 1: {
                if (this.imagePaginator == null) {
                    this.createPrintSpanObjects(this.getPageFormat(0));
                }
                rc = this.imagePaginator.getNumberOfPages();
                break;
            }
            case 3: {
                rc = 1;
                break;
            }
            case 2: {
                rc = this.recursiveNumPrintableChildren(this.root);
            }
        }
        return rc;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        return (PageFormat)SILKGlobal.getInstance().getPropertyValue(57);
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this;
    }

    private int recursiveNumPrintableChildren(LayoutNode node) {
        JComponent[] c = node.getChildren();
        if (c == null || c.length == 0) {
            return 0;
        }
        int rc = 0;
        for (int i = 0; i < c.length; ++i) {
            if (c[i] instanceof LayoutNode) {
                rc += this.recursiveNumPrintableChildren((LayoutNode)c[i]);
                continue;
            }
            if (!(c[i] instanceof Printable)) continue;
            ++rc;
        }
        return rc;
    }

    private void recursiveGetPrintableChildren(LayoutNode node) {
        JComponent[] c;
        if (this.printableChildren == null) {
            this.printableChildren = new Vector();
        }
        if ((c = node.getChildren()) == null || c.length == 0) {
            return;
        }
        for (int i = 0; i < c.length; ++i) {
            if (c[i] instanceof LayoutNode) {
                this.recursiveGetPrintableChildren((LayoutNode)c[i]);
                continue;
            }
            if (!(c[i] instanceof Printable)) continue;
            this.printableChildren.addElement(c[i]);
        }
    }

    public AnnotateInterface getAnnotate() {
        return null;
    }

    public boolean addTabs(Object id, Dialog dialogIn, int category, Object listener) {
        return false;
    }

    public boolean addTabs(Object id, Dialog dialogIn, int category) {
        return false;
    }

    public boolean applyWhereClause(String clause, boolean clearPrevious) {
        return false;
    }

    public boolean areChartTipsOn() {
        return false;
    }

    public void dispose() {
        this.recursiveDispose(this.root);
    }

    private void recursiveDispose(LayoutNode node) {
        if (node == null) {
            return;
        }
        JComponent[] c = node.getChildren();
        if (c == null) {
            return;
        }
        for (int i = 0; i < c.length; ++i) {
            if (c[i] instanceof LayoutNode) {
                this.recursiveDispose((LayoutNode)c[i]);
                continue;
            }
            if (!(c[i] instanceof BaseComponentInterface)) continue;
            ((BaseComponentInterface)c[i]).dispose();
        }
    }

    public int getActionMode() {
        return 0;
    }

    public Object getChartObject(Object id) {
        return null;
    }

    public ColorSchemeInterface getColorScheme() {
        return null;
    }

    public String getColorSchemeName() {
        return null;
    }

    public DataFilterReadInterface getFilter() {
        return null;
    }

    public DataFilterReadInterface getFilter(Object id) {
        return null;
    }

    public Object getId() {
        return null;
    }

    public boolean getUsageMode(int mode) {
        return false;
    }

    public String getWhereClause() {
        return null;
    }

    public boolean isActionEnabled(String action) {
        return false;
    }

    public boolean isBackBufferDrawEnabled() {
        return false;
    }

    public boolean isDataListening() {
        return false;
    }

    public boolean setActionEnabled(String action, boolean enable) {
        return false;
    }

    public boolean setActionMode(int mode) {
        return false;
    }

    public void setBackBufferDrawEnabled(boolean drawback) {
    }

    public void setChartTipsOn(boolean on) {
    }

    public boolean setColorScheme(Object newScheme) {
        return false;
    }

    public boolean setDataListening(boolean listen) {
        return false;
    }

    public void setId(Object id) {
    }

    public void setUsageMode(int mode, boolean on) {
    }

    class NodeRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = -5043384502986941561L;
        Hashtable table = new Hashtable();

        public void addNodeType(Class type, String name, Icon icon) {
            Object c = this.table.get(type);
            if (c == null) {
                this.table.put(type, new Object[]{name, icon});
            }
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object node, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JComponent value = ((TreeLayoutNode)node).value;
            if (value == null) {
                return super.getTreeCellRendererComponent(tree, node, selected, expanded, leaf, row, hasFocus);
            }
            Object[] arr = (Object[])this.table.get(value.getClass());
            if (arr == null) {
                return super.getTreeCellRendererComponent(tree, node, selected, expanded, leaf, row, hasFocus);
            }
            if (arr[1] != null) {
                JLabel rc = new JLabel((String)arr[0], (Icon)arr[1], 2);
                rc.setFont(TabbedPropertiesDialog.dialogFont);
                return rc;
            }
            return new JLabel((String)arr[0]);
        }
    }
}

