/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

public class DatasetInfo {
    protected boolean twoLevelToString;
    protected String libname;
    protected String memname;
    protected String memtype;
    protected long nobs;
    protected long nvars;
    protected double crdate;
    protected double modate;

    public DatasetInfo(String libname, String memname, String memtype, long nobs, long nvars, double crdate, double modate) {
        this.libname = libname;
        if (this.libname != null) {
            this.libname = this.libname.trim();
        }
        this.memname = memname;
        if (this.memname != null) {
            this.memname = this.memname.trim();
        }
        this.memtype = memtype;
        if (this.memtype != null) {
            this.memtype = memtype.trim();
        }
        this.nobs = nobs;
        this.nvars = nvars;
        this.crdate = crdate;
        this.modate = modate;
    }

    public boolean isTwoLevelToString() {
        return this.twoLevelToString;
    }

    public void setTwoLevelToString(boolean twoLevel) {
        this.twoLevelToString = twoLevel;
    }

    public String getLibname() {
        String libString = this.libname == null ? "WORK" : this.libname;
        libString = libString.toUpperCase();
        return libString;
    }

    public String getMemname() {
        if (this.memname == null) {
            return "";
        }
        return this.memname;
    }

    public String getMemtype() {
        if (this.memtype == null) {
            return "DATA";
        }
        return this.memtype.toUpperCase();
    }

    public String getTwoLevelName() {
        return this.getLibname() + "." + this.getMemname();
    }

    public String getThreeLevelName() {
        return this.getLibname() + "." + this.getMemname() + "." + this.getMemtype();
    }

    public long getNumberObservations() {
        return this.nobs;
    }

    public long getNumberVariables() {
        return this.nvars;
    }

    public double getCreateDate() {
        return this.crdate;
    }

    public double getModifiedDate() {
        return this.modate;
    }

    public String toString() {
        if (this.memname == null) {
            return super.toString();
        }
        if (this.twoLevelToString) {
            return this.getTwoLevelName();
        }
        return this.memname;
    }
}

