/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.LineStyleInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.ReferenceLineInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.util.Axes;
import com.sas.graphics.silk.util.LineAttrib;
import com.sas.graphics.silk.util.TextAttrib;
import com.sas.graphics.util.PropertyMulticaster;
import java.awt.Component;
import java.util.ArrayList;

public class AxesHandler
implements AxisInterface,
PropertyInterface {
    private ArrayList axes = new ArrayList();
    private Axes masterAxis = new Axes();
    private Component component = null;
    private PropertyMulticaster pm = null;

    public AxesHandler(Component comp) {
        this.masterAxis.setGridLines((Object)new Boolean(false));
        this.axes.add(this.masterAxis);
        this.component = comp;
        this.pm = new PropertyMulticaster();
        this.pm.addListener((PropertyInterface)this.masterAxis);
    }

    public AxesHandler() {
        this(null);
    }

    public void add(Object axis) {
        this.add(axis, true);
    }

    public void add(Object axis, boolean sync) {
        if (!(axis instanceof AxisInterface) || !(axis instanceof PropertyInterface)) {
            return;
        }
        this.axes.add(axis);
        this.pm.addListener((PropertyInterface)axis);
        if (sync && axis instanceof AxisInterface) {
            this.syncAttributes((AxisInterface)this.masterAxis, (AxisInterface)axis);
        }
    }

    public void remove(Object axis) {
        this.axes.remove(axis);
        if (axis instanceof PropertyInterface) {
            this.pm.removeListener((PropertyInterface)axis);
        }
    }

    public void removeAll() {
        while (this.axes.size() > 1) {
            this.remove(this.axes.get(1));
        }
        this.pm.removeAllListeners();
    }

    public AxisInterface getAxisInterface() {
        for (int i = 0; i < this.axes.size(); ++i) {
            if (!(this.axes.get(i) instanceof AxisInterface)) continue;
            return (AxisInterface)this.axes.get(i);
        }
        return null;
    }

    public void syncAllAxes() {
    }

    private void syncLineAttributes(LineStyleInterface ls1, LineStyleInterface ls2) {
        if (ls1 == null || ls2 == null) {
            return;
        }
        if (ls1 instanceof LineAttrib && ls2 instanceof LineAttrib) {
            LineAttrib line1 = (LineAttrib)ls1;
            LineAttrib line2 = (LineAttrib)ls2;
            if (line1.hasUserSetValue(9502)) {
                line2.setColor((Object)line1.getColor());
            }
            if (line1.hasUserSetValue(9503)) {
                line2.setWidth(line1.getWidth());
            }
            if (line1.hasUserSetValue(9501)) {
                line2.setVisible(line1.isVisible());
            }
        }
    }

    private void syncTextAttributes(TextStyleInterface ts1, TextStyleInterface ts2) {
        if (ts1 == null || ts2 == null) {
            return;
        }
        if (ts1 instanceof TextAttrib && ts2 instanceof TextAttrib) {
            TextAttrib text1 = (TextAttrib)ts1;
            TextAttrib text2 = (TextAttrib)ts2;
            if (text1.hasUserSetValue(9000)) {
                text2.setVisible(text1.isVisible());
            }
            if (text1.hasUserSetValue(9001)) {
                text2.setColor((Object)text1.getColor());
            }
            if (text1.hasUserSetValue(9002)) {
                text2.setFont((Object)text1.getFont());
            }
            if (text1.hasUserSetValue(9006) || text1.hasUserSetValue(9007)) {
                text2.setJustification(text1.getHorizontalJustification(), text1.getVerticalJustification());
            }
            if (text1.hasUserSetValue(9016)) {
                text2.setTransparency(text1.getTransparency());
            }
        }
    }

    private void syncAttributes(AxisInterface refAxis, AxisInterface axis) {
        if (refAxis == null || axis == null) {
            return;
        }
        if (refAxis == axis) {
            return;
        }
        this.syncLineAttributes(refAxis.getLine(), axis.getLine());
        this.syncLineAttributes(refAxis.getMajorTicks(), axis.getMajorTicks());
        this.syncLineAttributes(refAxis.getMinorTicks(), axis.getMinorTicks());
        this.syncLineAttributes(refAxis.getGridLines(), axis.getGridLines());
        this.syncTextAttributes(refAxis.getLabel(), axis.getLabel());
        this.syncTextAttributes(refAxis.getValues(), axis.getValues());
    }

    protected void copyLineStyleProperties(LineStyleInterface to_ls, LineStyleInterface from_ls) {
        if (to_ls == null || from_ls == null) {
            return;
        }
        to_ls.setColor((Object)from_ls.getColor());
        to_ls.setWidth(from_ls.getWidth());
        to_ls.setVisible(from_ls.isVisible());
        this.syncUserSetProperties(to_ls, from_ls);
    }

    protected void syncUserSetProperties(LineStyleInterface to_ls, LineStyleInterface from_ls) {
        LineAttrib la1 = null;
        LineAttrib la2 = null;
        if (to_ls instanceof LineAttrib) {
            la1 = (LineAttrib)to_ls;
        }
        if (from_ls instanceof LineAttrib) {
            la2 = (LineAttrib)from_ls;
        }
        if (la1 != null && la2 != null) {
            if (!la2.hasUserSetValue(9502)) {
                la1.setCurrentValueAsDefault(9502);
            }
            if (!la2.hasUserSetValue(9503)) {
                la1.setCurrentValueAsDefault(9503);
            }
            if (!la2.hasUserSetValue(9501)) {
                la1.setCurrentValueAsDefault(9501);
            }
        }
    }

    protected void copyTextStyleProperties(TextStyleInterface to_ts, TextStyleInterface from_ts) {
        if (to_ts == null || from_ts == null) {
            return;
        }
        to_ts.setColor((Object)from_ts.getColor());
        to_ts.setFont((Object)from_ts.getFont());
        to_ts.setVisible(from_ts.isVisible());
        to_ts.setJustification(from_ts.getHorizontalJustification(), from_ts.getVerticalJustification());
        to_ts.setTransparency(from_ts.getTransparency());
        this.syncUserSetProperties(to_ts, from_ts);
    }

    protected void syncUserSetProperties(TextStyleInterface to_ts, TextStyleInterface from_ts) {
        TextAttrib ta1 = null;
        TextAttrib ta2 = null;
        if (to_ts instanceof TextAttrib) {
            ta1 = (TextAttrib)to_ts;
        }
        if (from_ts instanceof TextAttrib) {
            ta2 = (TextAttrib)from_ts;
        }
        if (ta1 != null && ta2 != null) {
            if (!ta2.hasUserSetValue(9000)) {
                ta1.setCurrentValueAsDefault(9000);
            }
            if (!ta2.hasUserSetValue(9001)) {
                ta1.setCurrentValueAsDefault(9001);
            }
            if (!ta2.hasUserSetValue(9002)) {
                ta1.setCurrentValueAsDefault(9002);
            }
            if (!ta2.hasUserSetValue(9006)) {
                ta1.setCurrentValueAsDefault(9006);
            }
            if (!ta2.hasUserSetValue(9007)) {
                ta1.setCurrentValueAsDefault(9007);
            }
            if (!ta2.hasUserSetValue(9016)) {
                ta1.setCurrentValueAsDefault(9016);
            }
        }
    }

    public boolean isRebuildRequired() {
        boolean rebuild = false;
        for (int i = 1; i < this.axes.size(); ++i) {
            if (!(this.axes.get(i) instanceof Axes)) continue;
            rebuild |= ((Axes)this.axes.get(i)).isRebuildRequired();
        }
        return rebuild;
    }

    public boolean isVisible() {
        AxisInterface axis = this.getAxisInterface();
        if (axis instanceof Axes) {
            return ((Axes)axis).isVisible();
        }
        return false;
    }

    public LineStyleInterface getLine() {
        AxisInterface axis = this.getAxisInterface();
        if (axis != null) {
            if (this.axes != null && this.axes.size() > 1) {
                this.copyLineStyleProperties(axis.getLine(), ((AxisInterface)this.axes.get(1)).getLine());
            }
            return axis.getLine();
        }
        return null;
    }

    public boolean setLine(Object line) {
        boolean returnVal = true;
        for (int i = 0; i < this.axes.size(); ++i) {
            if (!(this.axes.get(i) instanceof AxisInterface)) continue;
            returnVal = ((AxisInterface)this.axes.get(i)).setLine(line) && returnVal;
        }
        return returnVal;
    }

    public TextStyleInterface getLabel() {
        AxisInterface axis = this.getAxisInterface();
        if (axis != null) {
            if (this.axes != null && this.axes.size() > 1) {
                this.copyTextStyleProperties(axis.getLabel(), ((AxisInterface)this.axes.get(1)).getLabel());
            }
            return axis.getLabel();
        }
        return null;
    }

    public boolean setLabel(Object labelIn) {
        boolean returnVal = true;
        for (int i = 0; i < this.axes.size(); ++i) {
            if (!(this.axes.get(i) instanceof AxisInterface)) continue;
            returnVal = ((AxisInterface)this.axes.get(i)).setLabel(labelIn) && returnVal;
        }
        return returnVal;
    }

    public String getLabelString() {
        AxisInterface axis = this.getAxisInterface();
        if (axis != null) {
            return axis.getLabelString();
        }
        return null;
    }

    public TextStyleInterface getValues() {
        AxisInterface axis = this.getAxisInterface();
        if (axis != null) {
            if (this.axes != null && this.axes.size() > 1) {
                this.copyTextStyleProperties(axis.getValues(), ((AxisInterface)this.axes.get(1)).getValues());
            }
            return axis.getValues();
        }
        return null;
    }

    public boolean setValues(Object valuesIn) {
        boolean returnVal = true;
        for (int i = 0; i < this.axes.size(); ++i) {
            if (!(this.axes.get(i) instanceof AxisInterface)) continue;
            returnVal = ((AxisInterface)this.axes.get(i)).setValues(valuesIn) && returnVal;
        }
        return returnVal;
    }

    public LineStyleInterface getMajorTicks() {
        AxisInterface axis = this.getAxisInterface();
        if (axis != null) {
            if (this.axes != null && this.axes.size() > 1) {
                this.copyLineStyleProperties(axis.getMajorTicks(), ((AxisInterface)this.axes.get(1)).getMajorTicks());
            }
            return axis.getMajorTicks();
        }
        return null;
    }

    public boolean setMajorTicks(Object ticks) {
        boolean returnVal = true;
        for (int i = 0; i < this.axes.size(); ++i) {
            if (!(this.axes.get(i) instanceof AxisInterface)) continue;
            returnVal = ((AxisInterface)this.axes.get(i)).setMajorTicks(ticks) && returnVal;
        }
        return returnVal;
    }

    public LineStyleInterface getMinorTicks() {
        AxisInterface axis = this.getAxisInterface();
        if (axis != null) {
            if (this.axes != null && this.axes.size() > 1) {
                this.copyLineStyleProperties(axis.getMinorTicks(), ((AxisInterface)this.axes.get(1)).getMinorTicks());
            }
            return axis.getMinorTicks();
        }
        return null;
    }

    public boolean setMinorTicks(Object ticks) {
        boolean returnVal = true;
        for (int i = 0; i < this.axes.size(); ++i) {
            if (!(this.axes.get(i) instanceof AxisInterface)) continue;
            returnVal = ((AxisInterface)this.axes.get(i)).setMinorTicks(ticks) && returnVal;
        }
        return returnVal;
    }

    public LineStyleInterface getGridLines() {
        AxisInterface axis = this.getAxisInterface();
        if (axis != null) {
            if (this.axes != null && this.axes.size() > 1) {
                this.copyLineStyleProperties(axis.getGridLines(), ((AxisInterface)this.axes.get(1)).getGridLines());
            }
            return axis.getGridLines();
        }
        return null;
    }

    public boolean setGridLines(Object lines) {
        boolean returnVal = true;
        for (int i = 0; i < this.axes.size(); ++i) {
            if (!(this.axes.get(i) instanceof AxisInterface)) continue;
            returnVal = ((AxisInterface)this.axes.get(i)).setGridLines(lines) && returnVal;
        }
        return returnVal;
    }

    public boolean setAxis(Object low, Object high, int nMajor, int nMinor, Object[] values, Boolean autoCalculate, Boolean equallySpacedDiscrete) {
        boolean returnVal = true;
        for (int i = 0; i < this.axes.size(); ++i) {
            if (!(this.axes.get(i) instanceof AxisInterface)) continue;
            returnVal = ((AxisInterface)this.axes.get(i)).setAxis(low, high, nMajor, nMinor, values, autoCalculate, equallySpacedDiscrete) && returnVal;
        }
        return returnVal;
    }

    public boolean isAxisAutoCalculated() {
        AxisInterface axis = this.getAxisInterface();
        if (axis != null) {
            return axis.isAxisAutoCalculated();
        }
        return true;
    }

    public double[] getEndPoint(boolean high, boolean screen) {
        AxisInterface axis = this.getAxisInterface();
        if (axis != null) {
            return axis.getEndPoint(high, screen);
        }
        return null;
    }

    public Object[] getTickMarkValues(boolean formatted) {
        AxisInterface axis = this.getAxisInterface();
        if (axis != null) {
            return axis.getTickMarkValues(formatted);
        }
        return null;
    }

    public int getNumberMajorTicks() {
        AxisInterface axis = this.getAxisInterface();
        if (axis != null) {
            return axis.getNumberMajorTicks();
        }
        return 0;
    }

    public int getNumberMinorTicks() {
        AxisInterface axis = this.getAxisInterface();
        if (axis != null) {
            return axis.getNumberMinorTicks();
        }
        return 0;
    }

    public void setMultiRole(boolean multi) {
        for (int i = 0; i < this.axes.size(); ++i) {
            if (!(this.axes.get(i) instanceof AxisInterface)) continue;
            ((AxisInterface)this.axes.get(i)).setMultiRole(multi);
        }
    }

    public ReferenceLineInterface addReferenceLine(Object value, String label) {
        for (int i = 0; i < this.axes.size(); ++i) {
            if (!(this.axes.get(i) instanceof AxisInterface)) continue;
            ((AxisInterface)this.axes.get(i)).addReferenceLine(value, label);
        }
        return null;
    }

    public boolean removeReferenceLine(Object id, boolean nearest) {
        boolean returnVal = true;
        for (int i = 0; i < this.axes.size(); ++i) {
            if (!(this.axes.get(i) instanceof AxisInterface)) continue;
            returnVal = ((AxisInterface)this.axes.get(i)).removeReferenceLine(id, nearest) && returnVal;
        }
        return returnVal;
    }

    public boolean removeAllReferenceLines() {
        boolean returnVal = true;
        for (int i = 0; i < this.axes.size(); ++i) {
            if (!(this.axes.get(i) instanceof AxisInterface)) continue;
            returnVal = ((AxisInterface)this.axes.get(i)).removeAllReferenceLines() && returnVal;
        }
        return returnVal;
    }

    public ReferenceLineInterface getReferenceLineByValue(Object value, boolean nearest) {
        AxisInterface axis = this.getAxisInterface();
        if (axis != null) {
            return axis.getReferenceLineByValue(value, nearest);
        }
        return null;
    }

    public ReferenceLineInterface getReferenceLine(int index) {
        AxisInterface axis = this.getAxisInterface();
        if (axis != null) {
            return axis.getReferenceLine(index);
        }
        return null;
    }

    public int getNumberReferenceLines() {
        AxisInterface axis = this.getAxisInterface();
        if (axis != null) {
            return axis.getNumberReferenceLines();
        }
        return 0;
    }

    public boolean setRangeModel(Object obj) {
        boolean returnVal = true;
        for (int i = 0; i < this.axes.size(); ++i) {
            if (!(this.axes.get(i) instanceof AxisInterface)) continue;
            returnVal = ((AxisInterface)this.axes.get(i)).setRangeModel(obj) && returnVal;
        }
        return returnVal;
    }

    public Object getRangeModel(boolean createFlag) {
        AxisInterface axis = this.getAxisInterface();
        if (axis != null) {
            return axis.getRangeModel(createFlag);
        }
        return null;
    }

    public int getTimeSplittingPolicy() {
        AxisInterface axis = this.getAxisInterface();
        if (axis != null) {
            return axis.getTimeSplittingPolicy();
        }
        return 2;
    }

    public void setTimeSplittingPolicy(int policy) {
        for (int i = 0; i < this.axes.size(); ++i) {
            if (!(this.axes.get(i) instanceof AxisInterface)) continue;
            ((AxisInterface)this.axes.get(i)).setTimeSplittingPolicy(policy);
        }
    }

    public boolean isFixedFormat() {
        AxisInterface axis = this.getAxisInterface();
        if (axis != null) {
            return axis.isFixedFormat();
        }
        return true;
    }

    public void setFixedFormat(boolean fix) {
        for (int i = 0; i < this.axes.size(); ++i) {
            if (!(this.axes.get(i) instanceof AxisInterface)) continue;
            ((AxisInterface)this.axes.get(i)).setFixedFormat(fix);
        }
    }

    public Object getTransformInfo(int transformType) {
        AxisInterface axis = this.getAxisInterface();
        if (axis != null) {
            return axis.getTransformInfo(transformType);
        }
        return null;
    }

    public int getTransformType() {
        AxisInterface axis = this.getAxisInterface();
        if (axis != null) {
            return axis.getTransformType();
        }
        return -1;
    }

    public void setTransformType(int type, Object transInfo) {
        for (int i = 0; i < this.axes.size(); ++i) {
            if (!(this.axes.get(i) instanceof AxisInterface)) continue;
            ((AxisInterface)this.axes.get(i)).setTransformType(type, transInfo);
        }
    }

    public boolean isPropertySupported(int id) {
        boolean rc = false;
        switch (id) {
            case 229: 
            case 237: 
            case 248: 
            case 249: 
            case 250: 
            case 251: {
                rc = true;
                break;
            }
            default: {
                Object o;
                if (this.axes == null || this.axes.size() <= 1 || (o = this.axes.get(1)) == null || !(o instanceof PropertyInterface)) break;
                PropertyInterface p = (PropertyInterface)o;
                rc = p.isPropertySupported(id);
            }
        }
        return rc;
    }

    public boolean isPropertyPending(int id) {
        if (this.axes == null || this.axes.size() < 2) {
            return false;
        }
        Object o = this.axes.get(1);
        if (o != null && o instanceof PropertyInterface) {
            PropertyInterface p = (PropertyInterface)o;
            return p.isPropertyPending(id);
        }
        return false;
    }

    public Object getPropertyValue(int id) {
        if (this.axes == null || this.axes.size() < 2) {
            if (id == 237) {
                return new Boolean(false);
            }
            return null;
        }
        if (id == 248) {
            return Boolean.FALSE;
        }
        if (id == 229 || id == 251) {
            return Boolean.FALSE;
        }
        if (id == 249) {
            this.copyTextStyleProperties(this.getAxisInterface().getLabel(), ((AxisInterface)this.axes.get(1)).getLabel());
            return this.pm.getPropertyValue(249);
        }
        if (id == 250) {
            this.copyTextStyleProperties(this.getAxisInterface().getValues(), ((AxisInterface)this.axes.get(1)).getValues());
            return this.pm.getPropertyValue(250);
        }
        Object o = this.axes.get(1);
        if (o != null && o instanceof PropertyInterface) {
            PropertyInterface p = (PropertyInterface)o;
            return p.getPropertyValue(id);
        }
        return null;
    }

    public boolean setPropertyValue(int id, Object value) {
        if (this.axes == null || this.axes.size() == 0) {
            return false;
        }
        boolean return_flag = true;
        int numAxes = this.axes.size();
        for (int i = 0; i < numAxes; ++i) {
            Object o = this.axes.get(i);
            if (o == null || !(o instanceof PropertyInterface)) continue;
            PropertyInterface p = (PropertyInterface)o;
            return_flag = p.setPropertyValue(id, value) && return_flag;
        }
        return return_flag;
    }

    public int getNumberPendingProperties() {
        return 0;
    }

    public boolean applyPropertyChanges() {
        return this.applyPropertyChanges(null);
    }

    public boolean applyPropertyChanges(Object source) {
        boolean returnValue = true;
        int size = this.axes.size();
        for (int i = 0; i < size; ++i) {
            Object o = this.axes.get(i);
            if (o == null || !(o instanceof PropertyInterface)) continue;
            PropertyInterface p = (PropertyInterface)o;
            returnValue = p.applyPropertyChanges(source) && returnValue;
        }
        if (this.component != null) {
            this.component.repaint();
        }
        return returnValue;
    }

    public void cancelPropertyChanges() {
        if (this.axes != null && this.axes.size() > 0) {
            int size = this.axes.size();
            for (int i = 0; i < size; ++i) {
                Object o = this.axes.get(i);
                if (o == null || !(o instanceof PropertyInterface)) continue;
                PropertyInterface p = (PropertyInterface)o;
                p.cancelPropertyChanges();
            }
        }
    }

    public void cancelPropertyChanges(Object source) {
        this.cancelPropertyChanges();
    }

    public int[] getPendingChanges() {
        return null;
    }

    public int[] getPendingChanges(Object source) {
        return null;
    }

    public boolean hasUserSetValue(int id) {
        boolean rc = true;
        if (this.axes == null || this.axes.size() < 2) {
            rc = id == 237;
        }
        return rc;
    }

    public void setThreshold(double value) {
    }
}

