/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui.graphwizard;

import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.GraphInterface;
import com.sas.graphics.silk.interfaces.LegendInterface;
import com.sas.graphics.silk.interfaces.RenderInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.ui.graphwizard.SILKWizardUtil;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.tools.wizard.WizardPage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TitlesPage
extends WizardPage {
    private static final long serialVersionUID = -886139561573676767L;
    JTextField title;
    JTextField footnote;
    JTextField legendLabel;
    JTextField xAxisLabel;
    JTextField yAxisLabel;
    ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.graphwizard.silk_graphwizard_NLS");

    public GraphInterface getGraph() {
        JComponent graph = SILKWizardUtil.getInternalGraph(this.wizard);
        if (graph instanceof GraphInterface) {
            return (GraphInterface)graph;
        }
        return null;
    }

    public void display() {
        this.removeAll();
        GraphInterface graph = this.getGraph();
        this.title = new JTextField();
        TextStyleInterface t = graph.getTitle(0);
        if (t != null) {
            this.title.setText((String)t.getText());
        }
        this.title.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent ke) {
                TitlesPage.this.getGraph().setTitle(0, TitlesPage.this.title.getText());
                ((JComponent)TitlesPage.this.getGraph()).repaint();
            }
        });
        this.footnote = new JTextField();
        t = graph.getFootnote(0);
        if (t != null) {
            this.footnote.setText((String)t.getText());
        }
        this.footnote.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent ke) {
                TitlesPage.this.getGraph().setFootnote(0, TitlesPage.this.footnote.getText());
                ((JComponent)TitlesPage.this.getGraph()).repaint();
            }
        });
        this.legendLabel = new JTextField();
        LegendInterface leg = graph.getLegend(null);
        if (leg == null) {
            this.legendLabel.setEnabled(false);
            this.legendLabel.setBackground(Color.lightGray);
        } else {
            if (leg.getTitle() != null && leg.getTitle().getText() != null) {
                this.legendLabel.setText(leg.getTitle().getTextString());
            }
            this.legendLabel.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent ke) {
                    TitlesPage.this.getGraph().getLegend(null).setTitle((Object)TitlesPage.this.legendLabel.getText());
                    TitlesPage.this.getGraph().getLegend(null).getTitle().setVisible(true);
                    if (TitlesPage.this.getGraph().getLegend(null) instanceof RenderInterface) {
                        ((RenderInterface)TitlesPage.this.getGraph().getLegend(null)).setVisible(true);
                    }
                    ((JComponent)TitlesPage.this.getGraph()).repaint();
                }
            });
        }
        this.xAxisLabel = new JTextField();
        AxisInterface ai = graph.getAxis((Object)"X");
        if (ai == null) {
            this.xAxisLabel.setEnabled(false);
            this.xAxisLabel.setBackground(Color.lightGray);
        } else {
            if (ai.getLabel() != null && ai.getLabel().getText() != null) {
                this.xAxisLabel.setText((String)ai.getLabel().getText());
            }
            this.xAxisLabel.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent ke) {
                    TitlesPage.this.getGraph().getAxis((Object)"X").getLabel().setText((Object)TitlesPage.this.xAxisLabel.getText());
                    ((JComponent)TitlesPage.this.getGraph()).repaint();
                }
            });
        }
        this.yAxisLabel = new JTextField();
        ai = graph.getAxis((Object)"Y");
        if (ai == null) {
            this.yAxisLabel.setEnabled(false);
            this.yAxisLabel.setBackground(Color.lightGray);
        } else {
            if (ai.getLabel() != null && ai.getLabel().getText() != null) {
                this.yAxisLabel.setText((String)ai.getLabel().getText());
            }
            this.yAxisLabel.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent ke) {
                    TitlesPage.this.getGraph().getAxis((Object)"Y").getLabel().setText((Object)TitlesPage.this.yAxisLabel.getText());
                    ((JComponent)TitlesPage.this.getGraph()).repaint();
                }
            });
        }
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel(new GridLayout(5, 2, 5, 12));
        p.add(new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"TitlesPage.Title.txt", (String)"Title")));
        p.add(this.title);
        p.add(new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"TitlesPage.Footnote.txt", (String)"Footnote")));
        p.add(this.footnote);
        p.add(new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"TitlesPage.Legend_Label.txt", (String)"Legend Label")));
        p.add(this.legendLabel);
        p.add(new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"TitlesPage.X_Axis_Label.txt", (String)"X Axis Label")));
        p.add(this.xAxisLabel);
        p.add(new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"TitlesPage.Y_Axis_Label.txt", (String)"Y Axis Label")));
        p.add(this.yAxisLabel);
        this.add("Center", p);
        p = new JPanel();
        p.setPreferredSize(new Dimension(105, 50));
        this.add("West", p);
        p = new JPanel();
        p.setPreferredSize(new Dimension(105, 50));
        this.add("East", p);
        p = new JPanel();
        p.setPreferredSize(new Dimension(50, 50));
        this.add("North", p);
        p = new JPanel();
        p.setPreferredSize(new Dimension(50, 50));
        this.add("South", p);
    }

    public String getTitle() {
        return ResourceLoader.getResourceString((Object)this.rb, (String)"TitlesPage.Chart_Titles.txt", (String)"Chart Titles");
    }
}

