/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui.graphwizard;

import com.sas.graphics.silk.base.BaseElementComponent;
import com.sas.graphics.silk.info.RoleInfo;
import com.sas.graphics.silk.info.SILKChartInfo;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.ui.RoleSelectionTable;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.graphwizard.SILKWizardEntry;
import com.sas.graphics.silk.ui.graphwizard.SILKWizardUtil;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.tools.wizard.WizardEntry;
import com.sas.graphics.tools.wizard.WizardPage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class RoleSelectionPage
extends WizardPage
implements ActionListener,
TableModelListener {
    private static final long serialVersionUID = -8929728429824262680L;
    RoleSelectionTable table = null;
    JCheckBox multiple;
    JPanel errorPanel = null;
    JButton assignButton = null;
    JLabel label = null;
    ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.graphwizard.silk_graphwizard_NLS");
    private String errorMessage = null;

    public RoleInterface getGraph() {
        JComponent chart = SILKWizardUtil.getInternalGraph(this.wizard);
        if (chart instanceof BaseElementComponent) {
            return (RoleInterface)((BaseElementComponent)chart).getChart(null);
        }
        if (chart instanceof RoleInterface) {
            return (RoleInterface)chart;
        }
        return null;
    }

    public void init() {
        SILKChartInfo info;
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.errorMessage = ResourceLoader.getResourceString((Object)this.rb, (String)"RoleSelectionPage.Required_Roles_Error.txt", (String)"Missing required roles");
        RoleInterface graph = this.getGraph();
        if (graph == null) {
            return;
        }
        this.label = new JLabel();
        this.label.setIcon(new ImageIcon(ResourceLoader.getImage((Component)((Object)this), (String)"/icons/MessageError_16.gif")));
        this.label.setText(this.errorMessage);
        this.label.setFont(TabbedPropertiesDialog.dialogFont);
        this.assignButton = new JButton(ResourceLoader.getResourceString((Object)this.rb, (String)"RoleSelectionPage.Use_default_assignments.txt", (String)"Use default assignments"));
        this.assignButton.setFont(TabbedPropertiesDialog.dialogFont);
        this.assignButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardEntry entry = RoleSelectionPage.this.wizard.getCurrentEntry();
                if (entry instanceof SILKWizardEntry) {
                    ((SILKWizardEntry)entry).doRoleAssignments((Object)RoleSelectionPage.this.getGraph());
                    RoleSelectionPage.this.table.updateFromSource();
                    RoleSelectionPage.this.table.revalidate();
                    RoleSelectionPage.this.repaint();
                    RoleSelectionPage.this.wizard.updateButtons();
                    RoleSelectionPage.this.updateErrorPanel();
                }
            }
        });
        this.errorPanel = new JPanel(new BorderLayout());
        this.errorPanel.add("West", this.label);
        this.errorPanel.add("East", this.assignButton);
        this.errorPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add("North", this.errorPanel);
        JComponent jc = graph instanceof JComponent ? (JComponent)graph : null;
        RoleInterface ri = graph;
        if (this.table != null) {
            this.table.dispose();
        }
        this.table = new RoleSelectionTable(ri, jc);
        this.table.addTableModelListener((TableModelListener)this);
        this.table.setAllowMultipleRoleAssignment(false);
        this.add("Center", (Component)this.table);
        this.multiple = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"RoleSelectionPage.Allow_multiple_role_assignments.txt", (String)"Allow multiple role assignments"));
        this.multiple.setSelected(false);
        this.multiple.setFont(TabbedPropertiesDialog.dialogFont);
        this.multiple.addActionListener(this);
        if (!ri.supportsMultipleAssignments(null)) {
            this.multiple.setSelected(false);
            this.multiple.setEnabled(false);
        } else {
            this.multiple.setEnabled(true);
            Object[] roles = ri.getSupportedRoles(null, true);
            if (roles != null) {
                for (int i = 0; i < roles.length; ++i) {
                    Object obj = ri.getAllVariables(roles[i]);
                    int num = Extract.getNumberItems((Object)obj, (int)Extract.getSourceType((Object)obj));
                    if (num <= 1) continue;
                    this.multiple.setSelected(true);
                }
            }
        }
        WizardEntry entry = this.wizard.getCurrentEntry();
        if (entry instanceof SILKWizardEntry && (info = ((SILKWizardEntry)entry).getChartInfo()).requiresMultipleRoleAssignments()) {
            this.multiple.setSelected(true);
            this.multiple.setEnabled(false);
        }
        this.table.setAllowMultipleRoleAssignment(this.multiple.isSelected());
        this.add("South", this.multiple);
        this.revalidate();
    }

    private void updateErrorPanel() {
        if (this.getGraph() == null) {
            this.init();
        }
        this.errorPanel.remove(this.label);
        WizardEntry entry = this.wizard.getCurrentEntry();
        if (!(entry instanceof SILKWizardEntry)) {
            return;
        }
        boolean req = ((SILKWizardEntry)entry).areRequiredRolesAssigned();
        if (!req) {
            RoleInfo[] roles = ((SILKWizardEntry)entry).getChartInfo().getRequiredRoles((Object)this.getGraph());
            RoleInterface ri = this.getGraph();
            String message = this.errorMessage + ": ";
            for (int i = 0; i < roles.length; ++i) {
                String roleName = roles[i].getRoleDisplayName();
                SILKNumber num = roles[i].getRoleObject();
                Object vars = ri.getAllVariables((Object)num);
                if (Extract.getNumberItems((Object)vars, (int)Extract.getSourceType((Object)vars)) >= roles[i].getNumRequired()) continue;
                message = message + roleName;
                message = i == roles.length - 1 ? message + "." : message + ", ";
            }
            this.label.setText(message);
            this.errorPanel.add("West", this.label);
        }
    }

    public String getTitle() {
        return ResourceLoader.getResourceString((Object)ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.graphwizard.silk_graphwizard_NLS"), (String)"RoleSelectionPage.Select_Chart_Roles.txt", (String)"Select Chart Roles");
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        SILKChartInfo info;
        RoleInterface chart = this.getGraph();
        if (this.multiple == null || this.table == null) {
            return;
        }
        if (!chart.supportsMultipleAssignments(null)) {
            this.multiple.setSelected(false);
            this.multiple.setEnabled(false);
        } else {
            this.multiple.setEnabled(true);
        }
        WizardEntry entry = this.wizard.getCurrentEntry();
        if (entry instanceof SILKWizardEntry && (info = ((SILKWizardEntry)entry).getChartInfo()).requiresMultipleRoleAssignments()) {
            this.multiple.setSelected(true);
            this.multiple.setEnabled(false);
        }
        this.table.setAllowMultipleRoleAssignment(this.multiple.isSelected());
        this.updateErrorPanel();
        this.wizard.updateButtons();
        this.revalidate();
        this.repaint();
    }

    public boolean canProceed() {
        WizardEntry entry = this.wizard.getCurrentEntry();
        if (!(entry instanceof SILKWizardEntry)) {
            return true;
        }
        return ((SILKWizardEntry)entry).areRequiredRolesAssigned();
    }

    public boolean canFinish() {
        WizardEntry entry = this.wizard.getCurrentEntry();
        if (!(entry instanceof SILKWizardEntry)) {
            return true;
        }
        return ((SILKWizardEntry)entry).areRequiredRolesAssigned();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.multiple) {
            this.table.setAllowMultipleRoleAssignment(this.multiple.isSelected());
            return;
        }
    }

    protected void display() {
        super.display();
        this.init();
        this.updateErrorPanel();
    }

    public void reset() {
        super.reset();
        this.removeAll();
    }
}

