/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui.desktop;

import com.sas.graphics.silk.ui.desktop.SILKDesktopPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

class WindowMenu
extends JMenu {
    private static final long serialVersionUID = -6786214312519190466L;
    private SILKDesktopPane desktop;
    private JMenuItem cascade = new JMenuItem("Cascade");
    private JMenuItem tile = new JMenuItem("Tile");

    public WindowMenu(SILKDesktopPane desktop) {
        this.desktop = desktop;
        this.setText("Window");
        this.cascade.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                WindowMenu.this.desktop.cascadeFrames();
            }
        });
        this.tile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                WindowMenu.this.desktop.tileFrames();
            }
        });
        this.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
                WindowMenu.this.removeAll();
            }

            @Override
            public void menuSelected(MenuEvent e) {
                WindowMenu.this.buildChildMenus();
            }
        });
    }

    private void buildChildMenus() {
        JInternalFrame[] array = this.desktop.getAllFrames();
        this.add(this.cascade);
        this.add(this.tile);
        if (array.length > 0) {
            this.addSeparator();
        }
        this.cascade.setEnabled(array.length > 0);
        this.tile.setEnabled(array.length > 0);
        for (int i = 0; i < array.length; ++i) {
            ChildMenuItem menu = new ChildMenuItem(array[i]);
            menu.setState(i == 0);
            menu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    JInternalFrame frame = ((ChildMenuItem)ae.getSource()).getFrame();
                    frame.moveToFront();
                    try {
                        frame.setSelected(true);
                    }
                    catch (PropertyVetoException e) {
                        e.printStackTrace();
                    }
                }
            });
            menu.setIcon(array[i].getFrameIcon());
            this.add(menu);
        }
    }

    class ChildMenuItem
    extends JCheckBoxMenuItem {
        private static final long serialVersionUID = 2245157578533623911L;
        private JInternalFrame frame;

        public ChildMenuItem(JInternalFrame frame) {
            super(frame.getTitle());
            this.frame = frame;
        }

        public JInternalFrame getFrame() {
            return this.frame;
        }
    }
}

