/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PlotMatrixPanel
extends JPanel
implements TabPanelInterface,
ItemListener {
    private static int PANEL_WIDTH = 265;
    private static int PANEL_HEIGHT = 410;
    private static int ITEM_HEIGHT = 20;
    private Vector propertyListeners = new Vector();
    private ResourceBundle rb;
    private JComboBox dtCombo = null;

    public PlotMatrixPanel() {
        this.setSize(PANEL_WIDTH, PANEL_HEIGHT);
        this.rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
        this.initialize();
    }

    private void initialize() {
        BorderLayout l = new BorderLayout();
        l.setVgap(4);
        this.setLayout(l);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.getDiagonalTypePanel(), "North");
    }

    private JPanel getDiagonalTypePanel() {
        JPanel diagonalTypePanel = new JPanel(new BorderLayout());
        JLabel diagonalTypeLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"PlotMatrixPanel.DiagonalType.txt", (String)"Diagonal Type:"));
        diagonalTypeLabel.setFont(TabbedPropertiesDialog.dialogFont);
        diagonalTypePanel.add(diagonalTypeLabel);
        this.dtCombo = new JComboBox();
        this.dtCombo.setFont(TabbedPropertiesDialog.dialogFont);
        this.dtCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"PlotMatrixPanel.Label.txt", (String)"Label"));
        this.dtCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"PlotMatrixPanel.Histogram.txt", (String)"Histogram"));
        this.dtCombo.addItemListener(this);
        diagonalTypePanel.add((Component)this.dtCombo, "East");
        return diagonalTypePanel;
    }

    public boolean applyChanges() {
        if (this.propertyListeners == null) {
            return false;
        }
        for (int i = 0; i < this.propertyListeners.size(); ++i) {
            ((PropertyInterface)this.propertyListeners.elementAt(i)).applyPropertyChanges();
        }
        return true;
    }

    public boolean cancelChanges() {
        if (this.propertyListeners == null) {
            return false;
        }
        for (int i = 0; i < this.propertyListeners.size(); ++i) {
            ((PropertyInterface)this.propertyListeners.elementAt(i)).cancelPropertyChanges();
        }
        return true;
    }

    public boolean addPropertyListener(PropertyInterface prop) {
        if (this.propertyListeners != null && prop != null && !this.propertyListeners.contains(prop)) {
            this.propertyListeners.add(prop);
            return true;
        }
        return false;
    }

    public boolean removePropertyListener(PropertyInterface prop) {
        if (this.propertyListeners != null && prop != null) {
            return this.propertyListeners.remove(prop);
        }
        return false;
    }

    private void removeAllPropertyListeners() {
        if (this.propertyListeners == null) {
            return;
        }
        while (this.propertyListeners.size() > 0) {
            this.removePropertyListener((PropertyInterface)this.propertyListeners.elementAt(0));
        }
    }

    private void setPropertyValue(int propId, Object value) {
        if (this.propertyListeners == null) {
            return;
        }
        for (int i = 0; i < this.propertyListeners.size(); ++i) {
            ((PropertyInterface)this.propertyListeners.elementAt(i)).setPropertyValue(propId, value);
        }
    }

    private Object getPropertyValue(int propId) {
        if (this.propertyListeners != null && this.propertyListeners.size() > 0) {
            return ((PropertyInterface)this.propertyListeners.elementAt(0)).getPropertyValue(propId);
        }
        return null;
    }

    public void dispose() {
        if (this.propertyListeners != null) {
            this.removeAllPropertyListeners();
            this.propertyListeners = null;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.dtCombo) {
            this.setPropertyValue(21001, this.dtCombo.getSelectedIndex() + 1);
        }
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.initUI();
        }
    }

    private void initUI() {
        this.dtCombo.removeItemListener(this);
        Object dt = this.getPropertyValue(21001);
        if (dt instanceof Number) {
            this.dtCombo.setSelectedIndex(((Number)dt).intValue() - 1);
        }
        this.dtCombo.addItemListener(this);
    }
}

