/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.ParallelAxisPropertyInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.ColorMapperChooserPanel;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.text.Message;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ParallelAxisPanel
extends JPanel
implements TabPanelInterface,
ParallelAxisPropertyInterface,
ChangeListener,
ItemListener {
    private static final long serialVersionUID = 859159859342090469L;
    private PropertyInterface chart;
    private static int BORDER = 8;
    private static int PANEL_WIDTH = 265;
    private static int PANEL_HEIGHT = 410;
    private static int ITEM_HEIGHT = 20;
    private JSlider opacity;
    private JSlider width;
    private JCheckBox equalizeAxes;
    private JCheckBox showValues;
    private JCheckBox showLabels;
    private JCheckBox skipMissingValues;
    private JLabel opacityValue;
    private JLabel widthValue;
    protected ColorMapperChooserPanel colorMapperChooserPanel = null;
    protected Vector listeners = null;
    private static ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.parallelaxis.parallelaxis_NLS");

    public ParallelAxisPanel(PropertyInterface chart) {
        this.chart = chart;
        this.listeners = new Vector();
        if (chart != null) {
            this.listeners.add(chart);
        }
        this.setLayout(null);
        this.setSize(PANEL_WIDTH, PANEL_HEIGHT);
        this.layoutPanel();
        this.updatePanelUI(this);
        this.setInitialValues();
        this.addListeners();
    }

    private void updatePanelUI(JComponent comp) {
        Border b = comp.getBorder();
        if (b != null && b instanceof TitledBorder) {
            ((TitledBorder)b).setTitleFont(TabbedPropertiesDialog.dialogFont);
            ((TitledBorder)b).setTitleColor(Color.black);
        } else if (b != null && b instanceof CompoundBorder) {
            ((TitledBorder)((CompoundBorder)b).getInsideBorder()).setTitleFont(TabbedPropertiesDialog.dialogFont);
            ((TitledBorder)((CompoundBorder)b).getInsideBorder()).setTitleColor(Color.black);
        }
        int count = comp.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component c = comp.getComponent(i);
            if (c instanceof JPanel) {
                this.updatePanelUI((JComponent)c);
                continue;
            }
            c.setForeground(Color.black);
            c.setFont(TabbedPropertiesDialog.dialogFont);
        }
    }

    private void layoutPanel() {
        this.setLayout(null);
        JPanel linePanel = this.makeLinePanel();
        JPanel axesPanel = this.makeAxesPanel();
        this.colorMapperChooserPanel = new ColorMapperChooserPanel(this.listeners);
        linePanel.setBounds(BORDER, BORDER, PANEL_WIDTH, ITEM_HEIGHT * 7 + BORDER);
        int h = ITEM_HEIGHT * 7 + BORDER;
        axesPanel.setBounds(BORDER, BORDER + h + BORDER, PANEL_WIDTH, ITEM_HEIGHT * 3 + BORDER);
        this.colorMapperChooserPanel.setBounds(BORDER, BORDER + (h += ITEM_HEIGHT * 3 + BORDER) + BORDER, PANEL_WIDTH, ITEM_HEIGHT * 4 + BORDER);
        this.add(linePanel);
        this.add(axesPanel);
        this.add((Component)this.colorMapperChooserPanel);
    }

    private JPanel makeLinePanel() {
        JPanel pan = new JPanel();
        pan.setLayout(null);
        Insets margin = new Insets(BORDER, BORDER, BORDER, BORDER);
        Border b1 = BorderFactory.createEmptyBorder(margin.top, margin.left, margin.bottom, margin.right);
        TitledBorder b2 = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceLoader.getResourceString((Object)rb, (String)"ParallelAxisPanel.Line.txt", (String)"Line"));
        pan.setBorder(BorderFactory.createCompoundBorder(b1, b2));
        JLabel opacityLabel = new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"ParallelAxisPanel.Opacity.txt", (String)"Opacity:"));
        JLabel widthLabel = new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"ParallelAxisPanel.Width.txt", (String)"Width:"));
        JLabel skipLabel = new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"ParallelAxisPanel.SkipMissing.txt", (String)"Skip missing values"));
        this.opacityValue = new JLabel();
        this.widthValue = new JLabel();
        this.skipMissingValues = new JCheckBox();
        this.opacity = new JSlider();
        this.opacity.setMinimum(1);
        this.opacity.setMaximum(100);
        this.width = new JSlider();
        this.width.setMinimum(1);
        this.width.setMaximum(10);
        int x = margin.left + BORDER;
        int y = margin.top + ITEM_HEIGHT;
        int labelWidth = 50;
        int valueWidth = 40;
        int w = PANEL_WIDTH - margin.left - margin.right - BORDER * 2;
        widthLabel.setBounds(x, y, labelWidth, ITEM_HEIGHT);
        this.widthValue.setBounds(x += labelWidth, y, valueWidth, ITEM_HEIGHT);
        this.width.setBounds(x += valueWidth, y, w - labelWidth - valueWidth, ITEM_HEIGHT);
        x = margin.left + BORDER;
        opacityLabel.setBounds(x, y += ITEM_HEIGHT + ITEM_HEIGHT, labelWidth, ITEM_HEIGHT);
        this.opacityValue.setBounds(x += labelWidth, y, valueWidth, ITEM_HEIGHT);
        this.opacity.setBounds(x += valueWidth, y, w - labelWidth - valueWidth, ITEM_HEIGHT);
        x = margin.left + BORDER;
        this.skipMissingValues.setBounds(x, y += ITEM_HEIGHT + ITEM_HEIGHT, labelWidth, ITEM_HEIGHT);
        skipLabel.setBounds(x += labelWidth, y, labelWidth * 4, ITEM_HEIGHT);
        pan.add(widthLabel);
        pan.add(this.widthValue);
        pan.add(this.width);
        pan.add(opacityLabel);
        pan.add(this.opacityValue);
        pan.add(this.opacity);
        pan.add(this.skipMissingValues);
        pan.add(skipLabel);
        return pan;
    }

    private JPanel makeAxesPanel() {
        JPanel pan = new JPanel();
        pan.setLayout(null);
        Insets margin = new Insets(BORDER, BORDER, BORDER, BORDER);
        Border b1 = BorderFactory.createEmptyBorder(margin.top, margin.left, margin.bottom, margin.right);
        TitledBorder b2 = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceLoader.getResourceString((Object)rb, (String)"ParallelAxisPanel.Axes.txt", (String)"Axes"));
        pan.setBorder(BorderFactory.createCompoundBorder(b1, b2));
        JLabel equalizeLabel = new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"ParallelAxisPanel.Equalized.txt", (String)"Equalized"));
        this.equalizeAxes = new JCheckBox();
        this.showLabels = new JCheckBox();
        this.showValues = new JCheckBox();
        int x = margin.left + BORDER;
        int y = margin.top + ITEM_HEIGHT;
        int labelWidth = 50;
        int w = PANEL_WIDTH - margin.left - margin.right - BORDER * 2;
        this.equalizeAxes.setBounds(x, y, labelWidth, ITEM_HEIGHT);
        equalizeLabel.setBounds(x += labelWidth, y, w - labelWidth, ITEM_HEIGHT);
        pan.add(this.equalizeAxes);
        pan.add(equalizeLabel);
        return pan;
    }

    private void addListeners() {
        this.width.addChangeListener(this);
        this.opacity.addChangeListener(this);
        this.skipMissingValues.addItemListener(this);
        this.equalizeAxes.addItemListener(this);
        this.showLabels.addItemListener(this);
        this.showValues.addItemListener(this);
    }

    private void setInitialValues() {
        int w = (Integer)this.chart.getPropertyValue(803);
        int t = (int)((Double)this.chart.getPropertyValue(802) * 100.0);
        boolean skip = (Boolean)this.chart.getPropertyValue(807);
        this.width.setValue(w);
        this.widthValue.setText(this.getValueLable(w, false));
        this.opacity.setValue(t);
        this.opacityValue.setText(this.getValueLable(t, true));
        this.skipMissingValues.setSelected(skip);
        boolean b = (Boolean)this.chart.getPropertyValue(801);
        this.equalizeAxes.setSelected(b);
        if (this.colorMapperChooserPanel != null) {
            this.colorMapperChooserPanel.initFromSource();
        }
    }

    private String getValueLable(int i, boolean percent) {
        Message message = percent ? new Message(ResourceLoader.getResourceString((Object)rb, (String)"ParallelAxisPanel.PercentValueLabel.fmt.txt", (String)"({0}%)")) : new Message(ResourceLoader.getResourceString((Object)rb, (String)"ParallelAxisPanel.ValueLabel.fmt.txt", (String)"({0})"));
        String lab = Integer.toString(i);
        return message.toString((Object)lab);
    }

    public boolean cancelChanges() {
        this.setInitialValues();
        this.chart.cancelPropertyChanges();
        return true;
    }

    public boolean applyChanges() {
        this.chart.applyPropertyChanges();
        return true;
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        Object source = evt.getSource();
        if (source == this.width) {
            int w = this.width.getValue();
            this.widthValue.setText(this.getValueLable(w, false));
            this.chart.setPropertyValue(803, (Object)new Integer(w));
        } else if (source == this.opacity) {
            int t = this.opacity.getValue();
            this.opacityValue.setText(this.getValueLable(t, true));
            this.chart.setPropertyValue(802, (Object)new Double((double)t / 100.0));
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        boolean sel;
        Object source = e.getSource();
        boolean bl = sel = e.getStateChange() == 1;
        if (source == this.equalizeAxes) {
            this.chart.setPropertyValue(801, (Object)new Boolean(sel));
        } else if (source == this.skipMissingValues) {
            this.chart.setPropertyValue(807, (Object)new Boolean(sel));
        }
    }

    @Override
    public void setVisible(boolean aFlag) {
        if (aFlag && this.colorMapperChooserPanel != null) {
            this.colorMapperChooserPanel.initFromSource();
        }
        super.setVisible(aFlag);
    }

    public boolean addPropertyListener(PropertyInterface prop) {
        if (prop != null && !this.listeners.contains(prop)) {
            this.listeners.add(prop);
            return true;
        }
        return false;
    }

    public boolean removePropertyListener(PropertyInterface prop) {
        if (prop != null) {
            return this.listeners.remove(prop);
        }
        return false;
    }
}

