/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.PropertyUtils;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MapAdvancedPanel
extends JPanel
implements TabPanelInterface,
ActionListener,
ChangeListener {
    private static final long serialVersionUID = -2061784190446661323L;
    protected JPanel graphPanel = null;
    protected JLabel graphTypeLabel = null;
    protected JCheckBox showGraphsCheckBox = null;
    protected JComboBox graphTypeComboBox = null;
    protected JLabel minSizeLabel = null;
    protected JSlider minSizeSlider = null;
    protected JLabel maxSizeLabel = null;
    protected JSlider maxSizeSlider = null;
    protected JCheckBox explodeGraphsCheckBox = null;
    protected JCheckBox showNonExplodedGraphsCheckBox = null;
    protected JCheckBox colorByChartCheckBox = null;
    protected Vector maps;
    protected PropertyInterface text;
    protected ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    protected TitledBorder graphBorder = null;
    private boolean update = true;
    String BAR = ResourceLoader.getResourceString((Object)this.rb, (String)"MapAdvancedPanel.Bar.txt", (String)"Bar");
    String PIE = ResourceLoader.getResourceString((Object)this.rb, (String)"MapAdvancedPanel.Pie.txt", (String)"Pie");

    public MapAdvancedPanel(PropertyInterface map, PropertyInterface text) {
        this.maps = new Vector();
        this.maps.add(map);
        this.text = text;
        this.initGUI();
        this.showGraphsCheckBox.addActionListener(this);
        this.graphTypeComboBox.addActionListener(this);
        this.minSizeSlider.addChangeListener(this);
        this.maxSizeSlider.addChangeListener(this);
        this.explodeGraphsCheckBox.addActionListener(this);
        this.showNonExplodedGraphsCheckBox.addActionListener(this);
        this.colorByChartCheckBox.addActionListener(this);
        this.initFromSource();
    }

    protected void initGUI() {
        this.setLayout(null);
        this.graphBorder = new TitledBorder(new EtchedBorder());
        this.graphBorder.setTitleFont(TabbedPropertiesDialog.dialogFont);
        this.graphBorder.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"MapAdvancedPanel.GraphsLabel.txt", (String)"Graphs"));
        this.graphBorder.setTitleColor(Color.black);
        this.graphPanel = new JPanel();
        this.graphPanel.setLayout(null);
        this.graphPanel.setBorder(this.graphBorder);
        this.showGraphsCheckBox = new JCheckBox();
        this.showGraphsCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
        this.showGraphsCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"MapAdvancedPanel.Show_graphs.txt", (String)"Show graphs"));
        this.graphTypeComboBox = new JComboBox();
        this.graphTypeComboBox.setFont(TabbedPropertiesDialog.dialogFont);
        this.graphTypeLabel = new JLabel();
        this.graphTypeLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.graphTypeLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"MapAdvancedPanel.Type.txt", (String)"Type:"));
        this.minSizeLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"MapAdvancedPanel.Min_size.txt", (String)"Min size:"));
        this.minSizeLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.minSizeSlider = new JSlider();
        this.maxSizeLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"MapAdvancedPanel.Max_size.txt", (String)"Max size:"));
        this.maxSizeLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.maxSizeSlider = new JSlider();
        this.explodeGraphsCheckBox = new JCheckBox();
        this.explodeGraphsCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
        this.explodeGraphsCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"MapAdvancedPanel.Explode_selected.txt", (String)"Explode selected"));
        this.showNonExplodedGraphsCheckBox = new JCheckBox();
        this.showNonExplodedGraphsCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
        this.showNonExplodedGraphsCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"MapAdvancedPanel.Show_Non_Exploded_graphs", (String)"Show non-exploded graphs"));
        this.colorByChartCheckBox = new JCheckBox();
        this.colorByChartCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
        this.colorByChartCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"MapAdvancedPanel.Color_By_Chart", (String)"Color by chart"));
        this.graphPanel.add(this.showGraphsCheckBox);
        this.graphPanel.add(this.graphTypeLabel);
        this.graphPanel.add(this.graphTypeComboBox);
        this.graphPanel.add(this.minSizeLabel);
        this.graphPanel.add(this.maxSizeLabel);
        this.graphPanel.add(this.minSizeSlider);
        this.graphPanel.add(this.maxSizeSlider);
        this.graphPanel.add(this.explodeGraphsCheckBox);
        this.graphPanel.add(this.showNonExplodedGraphsCheckBox);
        this.graphPanel.add(this.colorByChartCheckBox);
        this.add(this.graphPanel);
        this.showGraphsCheckBox.setBounds(15, 20, 100, 18);
        this.graphTypeLabel.setBounds(15, 45, 100, 18);
        this.graphTypeComboBox.setBounds(110, 45, 140, 18);
        this.minSizeLabel.setBounds(15, 70, 100, 18);
        this.minSizeSlider.setBounds(110, 72, 120, 18);
        this.maxSizeLabel.setBounds(15, 95, 100, 18);
        this.maxSizeSlider.setBounds(110, 97, 120, 18);
        this.explodeGraphsCheckBox.setBounds(15, 120, 180, 18);
        this.showNonExplodedGraphsCheckBox.setBounds(15, 140, 180, 18);
        this.colorByChartCheckBox.setBounds(15, 160, 180, 18);
        this.graphPanel.setBounds(0, 10, 277, 200);
        this.graphTypeComboBox.addItem(this.BAR);
        this.graphTypeComboBox.addItem(this.PIE);
    }

    protected void initFromSource() {
        this.update = false;
        Object o = PropertyUtils.getPropertyValue((Vector)this.maps, (int)7023);
        if (o != null && o instanceof Boolean) {
            this.showGraphsCheckBox.setEnabled(true);
            this.showGraphsCheckBox.setSelected((Boolean)o);
        } else {
            this.showGraphsCheckBox.setEnabled(false);
        }
        o = PropertyUtils.getPropertyValue((Vector)this.maps, (int)7025);
        if (o != null && o instanceof String) {
            this.graphTypeComboBox.setEnabled(true);
            this.graphTypeComboBox.setSelectedItem(this.getTranslatedGraphType((String)o));
        } else {
            this.graphTypeComboBox.setEnabled(false);
        }
        o = PropertyUtils.getPropertyValue((Vector)this.maps, (int)7027);
        if (o != null && o instanceof Number) {
            this.minSizeSlider.setEnabled(true);
            this.minSizeLabel.setEnabled(true);
            this.minSizeSlider.setValue(((Number)o).intValue());
            this.setMinSizeLabel(((Number)o).intValue());
        } else {
            this.minSizeSlider.setEnabled(false);
            this.minSizeLabel.setEnabled(false);
        }
        o = PropertyUtils.getPropertyValue((Vector)this.maps, (int)7028);
        if (o != null && o instanceof Number) {
            this.maxSizeSlider.setEnabled(true);
            this.maxSizeLabel.setEnabled(true);
            this.maxSizeSlider.setValue(((Number)o).intValue());
            this.setMaxSizeLabel(((Number)o).intValue());
        } else {
            this.maxSizeSlider.setEnabled(false);
            this.maxSizeLabel.setEnabled(false);
        }
        o = PropertyUtils.getPropertyValue((Vector)this.maps, (int)7026);
        if (o != null && o instanceof Boolean) {
            this.explodeGraphsCheckBox.setEnabled(true);
            this.explodeGraphsCheckBox.setSelected((Boolean)o);
        } else {
            this.explodeGraphsCheckBox.setEnabled(false);
        }
        o = PropertyUtils.getPropertyValue((Vector)this.maps, (int)7024);
        if (o != null && o instanceof Boolean) {
            this.showNonExplodedGraphsCheckBox.setEnabled(true);
            this.showNonExplodedGraphsCheckBox.setSelected((Boolean)o);
        } else {
            this.showNonExplodedGraphsCheckBox.setEnabled(false);
        }
        o = PropertyUtils.getPropertyValue((Vector)this.maps, (int)7031);
        if (o != null && o instanceof Boolean) {
            this.colorByChartCheckBox.setEnabled(true);
            this.colorByChartCheckBox.setSelected((Boolean)o);
        } else {
            this.colorByChartCheckBox.setEnabled(false);
        }
        this.update = true;
    }

    @Override
    public void setVisible(boolean show) {
        if (show) {
            this.initFromSource();
        }
        super.setVisible(show);
    }

    public boolean applyChanges() {
        return false;
    }

    public boolean cancelChanges() {
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.update) {
            return;
        }
        Object source = e.getSource();
        if (source == this.graphTypeComboBox) {
            PropertyUtils.setPropertyValue((Vector)this.maps, (int)7025, (Object)this.getGraphType((String)this.graphTypeComboBox.getSelectedItem()));
        } else if (source == this.showGraphsCheckBox) {
            PropertyUtils.setPropertyValue((Vector)this.maps, (int)7023, (Object)new Boolean(this.showGraphsCheckBox.isSelected()));
        } else if (source == this.showNonExplodedGraphsCheckBox) {
            PropertyUtils.setPropertyValue((Vector)this.maps, (int)7024, (Object)new Boolean(this.showNonExplodedGraphsCheckBox.isSelected()));
        } else if (source == this.colorByChartCheckBox) {
            PropertyUtils.setPropertyValue((Vector)this.maps, (int)7031, (Object)new Boolean(this.colorByChartCheckBox.isSelected()));
        } else if (source == this.explodeGraphsCheckBox) {
            PropertyUtils.setPropertyValue((Vector)this.maps, (int)7026, (Object)new Boolean(this.explodeGraphsCheckBox.isSelected()));
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (this.maps == null || this.maps.size() == 0 || !this.update) {
            return;
        }
        if (source == this.minSizeSlider) {
            int newSize = this.minSizeSlider.getValue();
            PropertyUtils.setPropertyValue((Vector)this.maps, (int)7027, (Object)new Integer(newSize));
            this.setMinSizeLabel(newSize);
        } else if (source == this.maxSizeSlider) {
            int newSize = this.maxSizeSlider.getValue();
            PropertyUtils.setPropertyValue((Vector)this.maps, (int)7028, (Object)new Integer(newSize));
            this.setMaxSizeLabel(newSize);
        }
    }

    protected String getTranslatedGraphType(String s) {
        if (s.equalsIgnoreCase("Bar")) {
            return this.BAR;
        }
        if (s.equalsIgnoreCase("Pie")) {
            return this.PIE;
        }
        return null;
    }

    protected String getGraphType(String s) {
        if (s.equalsIgnoreCase(this.BAR)) {
            return "Bar";
        }
        if (s.equalsIgnoreCase(this.PIE)) {
            return "Pie";
        }
        return null;
    }

    private void setMinSizeLabel(int i) {
        String sliderPattern = ResourceLoader.getResourceString((Object)this.rb, (String)"MapAdvancedPanel.Min_Size_Slider_Text.fmt", (String)"Min: {0,number,integer}");
        Object[] sliderArgs = new Object[]{new Integer(i)};
        this.minSizeLabel.setText(MessageFormat.format(sliderPattern, sliderArgs));
    }

    private void setMaxSizeLabel(int i) {
        String sliderPattern = ResourceLoader.getResourceString((Object)this.rb, (String)"MapAdvancedPanel.Max_Size_Slider_Text.fmt", (String)"Max: {0,number,integer}");
        Object[] sliderArgs = new Object[]{new Integer(i)};
        this.maxSizeLabel.setText(MessageFormat.format(sliderPattern, sliderArgs));
    }

    public boolean addPropertyListener(PropertyInterface prop) {
        return false;
    }

    public boolean removePropertyListener(PropertyInterface prop) {
        return false;
    }
}

