/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.LatticePropertyInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.CenteredHorizontalSeparator;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class LatticePanel
extends JPanel
implements TabPanelInterface,
ItemListener,
LatticePropertyInterface,
DocumentListener {
    private static final long serialVersionUID = 2391719297728965637L;
    private PropertyInterface chart;
    private static int BORDER = 8;
    private static int PANEL_WIDTH = 265;
    private static int PANEL_HEIGHT = 410;
    private static int ITEM_HEIGHT = 20;
    private JTextField countField;
    private JLabel countLabel;
    private JCheckBox enableWrapCB;
    private JLabel xeLabel;
    private JLabel yeLabel;
    private boolean updateTextFields = false;
    private boolean init = false;
    private int divisionType;
    private int maxDivisions;
    private int initialDivisions;
    private int numDivisions;
    private JComboBox xEqCombo = null;
    private JComboBox yEqCombo = null;
    private JCheckBox showExternalAxisCB = null;
    private JPanel equalizationPanel;
    private static ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");

    public LatticePanel(PropertyInterface chart) {
        this.chart = chart;
        this.setSize(PANEL_WIDTH, PANEL_HEIGHT);
        this.initialize();
        this.updatePanelUI(this);
        this.addListeners();
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.setInitialValues();
        }
    }

    private void updatePanelUI(JComponent comp) {
        Border b = comp.getBorder();
        if (b != null && b instanceof TitledBorder) {
            ((TitledBorder)b).setTitleFont(TabbedPropertiesDialog.dialogFont);
            ((TitledBorder)b).setTitleColor(Color.black);
        } else if (b != null && b instanceof CompoundBorder) {
            ((TitledBorder)((CompoundBorder)b).getInsideBorder()).setTitleFont(TabbedPropertiesDialog.dialogFont);
            ((TitledBorder)((CompoundBorder)b).getInsideBorder()).setTitleColor(Color.black);
        }
        int count = comp.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component c = comp.getComponent(i);
            if (c instanceof JPanel) {
                this.updatePanelUI((JComponent)c);
                continue;
            }
            c.setForeground(Color.black);
            c.setFont(TabbedPropertiesDialog.dialogFont);
        }
    }

    private void initialize() {
        BorderLayout l = new BorderLayout();
        l.setVgap(4);
        this.setLayout(l);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.getLatticeLayoutPanel(), "North");
        JPanel lowerPan = new JPanel(new BorderLayout());
        lowerPan.add((Component)this.getJPanel2(), "North");
        lowerPan.add((Component)this.getLatticeExternalAxesPanel(), "Center");
        this.add((Component)lowerPan, "Center");
        Object o = this.chart.getPropertyValue(11007);
        if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
            this.updateExternalAxesSettings();
            this.updateEqCombo();
        }
    }

    private JPanel getJPanel2() {
        JPanel jp2 = new JPanel(new BorderLayout());
        this.equalizationPanel = this.getEqualizationPanel();
        jp2.add((Component)this.equalizationPanel, "North");
        return jp2;
    }

    private JPanel getEqualizationPanel() {
        JPanel equalizationPanel = new JPanel(new BorderLayout());
        equalizationPanel.add((Component)this.getEqHeaderPanel(), "North");
        equalizationPanel.add(this.getEqPanel());
        return equalizationPanel;
    }

    private JPanel getEqHeaderPanel() {
        JPanel eqHeaderPanel = new JPanel(new BorderLayout());
        JLabel jl = new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"LatticePanel.AxisEqualization.txt", (String)"Axis Equalization"));
        eqHeaderPanel.add((Component)jl, "West");
        eqHeaderPanel.add((Component)new CenteredHorizontalSeparator());
        return eqHeaderPanel;
    }

    private JPanel getEqPanel() {
        JPanel eqPanel = new JPanel();
        BorderLayout layout = new BorderLayout();
        layout.setVgap(4);
        eqPanel.setLayout(layout);
        eqPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 5));
        eqPanel.add(this.getXEqualizationPanel());
        eqPanel.add((Component)this.getYEqualizationPanel(), "South");
        return eqPanel;
    }

    private JPanel getXEqualizationPanel() {
        JPanel xep = new JPanel(new BorderLayout());
        this.xeLabel = new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"LatticePanel.XAxesEqualization.txt", (String)"X-Axes: "));
        xep.add(this.xeLabel);
        this.xEqCombo = this.getEqualizationComboBox(this.getEqualizationType(11004));
        xep.add((Component)this.xEqCombo, "East");
        return xep;
    }

    private JPanel getYEqualizationPanel() {
        JPanel yep = new JPanel(new BorderLayout());
        this.yeLabel = new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"LatticePanel.YAxesEqualization.txt", (String)"Y-Axes: "));
        yep.add(this.yeLabel);
        this.yEqCombo = this.getEqualizationComboBox(this.getEqualizationType(11005));
        yep.add((Component)this.yEqCombo, "East");
        return yep;
    }

    private int getEqualizationType(int prop) {
        Object o = this.chart.getPropertyValue(prop);
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        return 4;
    }

    private JComboBox getEqualizationComboBox(int eqType) {
        JComboBox<String> jcb = new JComboBox<String>();
        jcb.addItem(ResourceLoader.getResourceString((Object)rb, (String)"LatticePanel.NoEqualization.txt", (String)"No Equalization"));
        jcb.addItem(ResourceLoader.getResourceString((Object)rb, (String)"LatticePanel.RowEqualization.txt", (String)"Row Equalization"));
        jcb.addItem(ResourceLoader.getResourceString((Object)rb, (String)"LatticePanel.ColumnEqualization.txt", (String)"Column Equalization"));
        jcb.addItem(ResourceLoader.getResourceString((Object)rb, (String)"LatticePanel.EqualizeGrid.txt", (String)"Equalize Across Grid"));
        jcb.setSelectedIndex(eqType - 1);
        jcb.addItemListener(this);
        return jcb;
    }

    private JPanel getLatticeLayoutPanel() {
        JPanel latticeLayoutPanel = new JPanel();
        latticeLayoutPanel.setLayout(new BorderLayout());
        latticeLayoutPanel.add((Component)this.getLayoutHeaderPanel(), "North");
        latticeLayoutPanel.add(this.getLayoutPanel());
        return latticeLayoutPanel;
    }

    private JPanel getLayoutHeaderPanel() {
        JPanel layoutHeaderPanel = new JPanel(new BorderLayout());
        JLabel jl = new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"LatticePanel.Layout.txt", (String)"Layout"));
        layoutHeaderPanel.add((Component)jl, "West");
        layoutHeaderPanel.add((Component)new CenteredHorizontalSeparator());
        return layoutHeaderPanel;
    }

    private JPanel getLayoutPanel() {
        JPanel layoutPanel = new JPanel(new BorderLayout());
        JPanel countPanel = new JPanel(new FlowLayout());
        layoutPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 5));
        this.enableWrapCB = new JCheckBox(ResourceLoader.getResourceString((Object)rb, (String)"LatticePanel.Wrap.txt", (String)"Wrap"), false);
        this.enableWrapCB.addItemListener(this);
        this.countLabel = new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"LatticePanel.WrapCount.txt", (String)"Wrap Count for Charts :"));
        this.countField = new JTextField(3);
        this.countField.setEditable(true);
        int valueWidth = new JLabel((String)"9999").getPreferredSize().width;
        Dimension d = this.countField.getPreferredSize();
        d.width = valueWidth;
        this.countField.setPreferredSize(d);
        countPanel.add(this.countLabel);
        countPanel.add(this.countField);
        layoutPanel.add((Component)this.enableWrapCB, "West");
        layoutPanel.add((Component)countPanel, "East");
        return layoutPanel;
    }

    private JPanel getLatticeExternalAxesPanel() {
        JPanel latticeLayoutPanel = new JPanel();
        latticeLayoutPanel.setLayout(new BorderLayout());
        latticeLayoutPanel.add((Component)this.getExternalAxesHeaderPanel(), "North");
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        jp.add((Component)this.getExternalAxesPanel(), "North");
        latticeLayoutPanel.add((Component)jp, "Center");
        return latticeLayoutPanel;
    }

    private JPanel getExternalAxesHeaderPanel() {
        JPanel layoutHeaderPanel = new JPanel(new BorderLayout());
        JLabel jl = new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"LatticePanel.ExternalAxes.txt", (String)"External Axes"));
        layoutHeaderPanel.add((Component)jl, "West");
        layoutHeaderPanel.add((Component)new CenteredHorizontalSeparator());
        return layoutHeaderPanel;
    }

    private JPanel getExternalAxesPanel() {
        JPanel externalAxesPanel = new JPanel(new BorderLayout());
        this.showExternalAxisCB = new JCheckBox();
        externalAxesPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 5));
        this.showExternalAxisCB.setText(ResourceLoader.getResourceString((Object)rb, (String)"LatticePanel.ShowExternalAxes.txt", (String)"Show"));
        this.showExternalAxisCB.setActionCommand(ResourceLoader.getResourceString((Object)rb, (String)"LatticePanel.ShowExternalAxes.txt", (String)"Show"));
        this.showExternalAxisCB.setBounds(192, 12, 60, 24);
        this.showExternalAxisCB.addItemListener(this);
        externalAxesPanel.add(this.showExternalAxisCB);
        return externalAxesPanel;
    }

    private void layoutPanel() {
        this.setLayout(null);
        Insets margin = new Insets(BORDER, BORDER, BORDER, BORDER);
        this.countLabel = new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"LatticePanel.WrapCount.txt", (String)"Wrap Count for Charts :"));
        this.countField = new JTextField(3);
        this.countField.setEditable(true);
        int w = this.countLabel.getPreferredSize().width;
        int x = margin.left + BORDER * 2;
        int y = margin.top + BORDER * 4;
        int labelWidth = w + BORDER * 2;
        int valueWidth = new JLabel((String)"9999").getPreferredSize().width;
        this.countLabel.setBounds(x, y, labelWidth, ITEM_HEIGHT);
        this.countField.setBounds(x += labelWidth + BORDER, y, valueWidth, ITEM_HEIGHT);
        this.add(this.countLabel);
        this.add(this.countField);
        margin.bottom = PANEL_HEIGHT - (y += ITEM_HEIGHT + BORDER);
        Border b1 = BorderFactory.createEmptyBorder(margin.top, margin.left, margin.bottom, margin.right);
        TitledBorder b2 = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceLoader.getResourceString((Object)rb, (String)"LatticePanel.Layout.txt", (String)"Layout"));
        this.setBorder(BorderFactory.createCompoundBorder(b1, b2));
    }

    private void addListeners() {
        this.countField.getDocument().addDocumentListener(this);
    }

    private void setInitialValues() {
        boolean wrapEnable;
        this.init = true;
        Object o = this.chart.getPropertyValue(11003);
        this.divisionType = o instanceof Number ? ((Number)o).intValue() : 0;
        o = this.chart.getPropertyValue(11002);
        this.maxDivisions = o instanceof Number ? ((Number)o).intValue() : 0;
        o = this.chart.getPropertyValue(11001);
        this.initialDivisions = o instanceof Number ? ((Number)o).intValue() : 0;
        o = this.chart.getPropertyValue(11009);
        boolean bl = wrapEnable = o instanceof Boolean ? (Boolean)o : true;
        if (this.divisionType == 2 || this.divisionType == 1) {
            this.countLabel.setEnabled(wrapEnable);
            this.countField.setEnabled(wrapEnable);
            this.countField.setText(String.valueOf(this.initialDivisions));
            this.enableWrapCB.removeItemListener(this);
            this.enableWrapCB.setSelected(wrapEnable);
            this.enableWrapCB.addItemListener(this);
            this.enableWrapCB.setEnabled(true);
        } else {
            this.countLabel.setEnabled(false);
            this.countField.setEnabled(false);
            this.countField.setText("");
            this.enableWrapCB.setEnabled(false);
        }
        o = this.chart.getPropertyValue(11007);
        if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
            this.updateExternalAxesSettings();
            this.updateEqCombo();
        } else {
            this.xEqCombo.setEnabled(false);
            this.yEqCombo.setEnabled(false);
            this.xeLabel.setEnabled(false);
            this.yeLabel.setEnabled(false);
        }
        o = this.chart.getPropertyValue(11008);
        if (o instanceof Boolean) {
            this.showExternalAxisCB.setEnabled((Boolean)o);
        }
        this.init = false;
    }

    public boolean cancelChanges() {
        this.chart.cancelPropertyChanges();
        return true;
    }

    public boolean applyChanges() {
        if (this.updateTextFields) {
            this.numDivisions = Math.min(Math.max(1, this.numDivisions), this.maxDivisions);
            this.chart.setPropertyValue(11001, (Object)new Integer(this.numDivisions));
            if (this.divisionType == 2 || this.divisionType == 1) {
                this.countField.setText(String.valueOf(this.numDivisions));
            }
            this.chart.applyPropertyChanges();
            this.updateTextFields = false;
            this.initialDivisions = this.numDivisions;
        }
        return true;
    }

    public boolean addPropertyListener(PropertyInterface prop) {
        return false;
    }

    public boolean removePropertyListener(PropertyInterface prop) {
        return false;
    }

    @Override
    public void changedUpdate(DocumentEvent evt) {
    }

    @Override
    public void insertUpdate(DocumentEvent evt) {
        Document doc = evt.getDocument();
        this.updateTextFieldValue(doc);
    }

    @Override
    public void removeUpdate(DocumentEvent evt) {
        Document doc = evt.getDocument();
        this.updateTextFieldValue(doc);
    }

    private void updateTextFieldValue(Document doc) {
        int n = -1;
        String s = null;
        if (doc.getLength() > 0) {
            try {
                s = doc.getText(0, doc.getLength());
            }
            catch (BadLocationException ble) {
                this.numDivisions = this.initialDivisions;
            }
            if (s != null) {
                try {
                    n = Integer.parseInt(s);
                }
                catch (NumberFormatException nfe) {
                    this.numDivisions = this.initialDivisions;
                }
            }
            if (n > 0) {
                this.numDivisions = n;
            }
        } else {
            this.numDivisions = this.initialDivisions;
        }
        if (!this.init) {
            this.updateTextFields = true;
            this.chart.setPropertyValue(11001, (Object)new Integer(this.numDivisions));
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        int eqIndex;
        int eqProp;
        if (e.getSource() == this.showExternalAxisCB) {
            this.chart.setPropertyValue(11006, (Object)this.showExternalAxisCB.isSelected());
            this.updateEqCombo();
            return;
        }
        if (e.getSource() == this.enableWrapCB) {
            this.chart.setPropertyValue(11009, (Object)this.enableWrapCB.isSelected());
            this.countLabel.setEnabled(this.enableWrapCB.isSelected());
            this.countField.setEnabled(this.enableWrapCB.isSelected());
            Object o = this.chart.getPropertyValue(11001);
            if (o instanceof Number) {
                this.countField.setText(String.valueOf((Integer)o));
            }
            return;
        }
        if (e.getSource() == this.yEqCombo) {
            eqProp = 11005;
            eqIndex = this.getValidEqualization(eqProp, this.yEqCombo.getSelectedIndex());
        } else {
            eqProp = 11004;
            eqIndex = this.getValidEqualization(eqProp, this.xEqCombo.getSelectedIndex());
        }
        this.chart.setPropertyValue(eqProp, (Object)new Integer(eqIndex));
    }

    private boolean getExternalAxesVisible() {
        Object o = this.chart.getPropertyValue(11006);
        return o instanceof Boolean ? (Boolean)o : false;
    }

    private void updateEqCombo() {
        boolean enabled = this.getExternalAxesVisible();
        this.xEqCombo.removeItemListener(this);
        this.yEqCombo.removeItemListener(this);
        this.xEqCombo.removeAllItems();
        this.yEqCombo.removeAllItems();
        if (enabled) {
            this.xEqCombo.addItem(ResourceLoader.getResourceString((Object)rb, (String)"LatticePanel.ColumnEqualization.txt", (String)"Column Equalization"));
            this.xEqCombo.addItem(ResourceLoader.getResourceString((Object)rb, (String)"LatticePanel.EqualizeGrid.txt", (String)"Equalize Across Grid"));
            this.xEqCombo.setSelectedIndex(this.getValidIndex(11004, this.getEqualizationType(11004)));
            this.yEqCombo.addItem(ResourceLoader.getResourceString((Object)rb, (String)"LatticePanel.RowEqualization.txt", (String)"Row Equalization"));
            this.yEqCombo.addItem(ResourceLoader.getResourceString((Object)rb, (String)"LatticePanel.EqualizeGrid.txt", (String)"Equalize Across Grid"));
            this.yEqCombo.setSelectedIndex(this.getValidIndex(11005, this.getEqualizationType(11005)));
        } else {
            this.xEqCombo.addItem(ResourceLoader.getResourceString((Object)rb, (String)"LatticePanel.NoEqualization.txt", (String)"No Equalization"));
            this.xEqCombo.addItem(ResourceLoader.getResourceString((Object)rb, (String)"LatticePanel.RowEqualization.txt", (String)"Row Equalization"));
            this.xEqCombo.addItem(ResourceLoader.getResourceString((Object)rb, (String)"LatticePanel.ColumnEqualization.txt", (String)"Column Equalization"));
            this.xEqCombo.addItem(ResourceLoader.getResourceString((Object)rb, (String)"LatticePanel.EqualizeGrid.txt", (String)"Equalize Across Grid"));
            this.xEqCombo.setSelectedIndex(this.getEqualizationType(11004) - 1);
            this.yEqCombo.addItem(ResourceLoader.getResourceString((Object)rb, (String)"LatticePanel.NoEqualization.txt", (String)"No Equalization"));
            this.yEqCombo.addItem(ResourceLoader.getResourceString((Object)rb, (String)"LatticePanel.RowEqualization.txt", (String)"Row Equalization"));
            this.yEqCombo.addItem(ResourceLoader.getResourceString((Object)rb, (String)"LatticePanel.ColumnEqualization.txt", (String)"Column Equalization"));
            this.yEqCombo.addItem(ResourceLoader.getResourceString((Object)rb, (String)"LatticePanel.EqualizeGrid.txt", (String)"Equalize Across Grid"));
            this.yEqCombo.setSelectedIndex(this.getEqualizationType(11005) - 1);
        }
        this.xEqCombo.addItemListener(this);
        this.yEqCombo.addItemListener(this);
    }

    private int getValidIndex(int axis, int equalizationType) {
        if (!this.getExternalAxesVisible()) {
            return equalizationType - 1;
        }
        switch (axis) {
            case 11004: {
                switch (equalizationType) {
                    case 3: {
                        return 0;
                    }
                }
                return 1;
            }
            case 11005: {
                switch (equalizationType) {
                    case 2: {
                        return 0;
                    }
                }
                return 1;
            }
        }
        return 3;
    }

    private int getValidEqualization(int axis, int index) {
        if (!this.getExternalAxesVisible()) {
            return index + 1;
        }
        switch (axis) {
            case 11004: {
                switch (index) {
                    case 0: {
                        return 3;
                    }
                }
                return 4;
            }
            case 11005: {
                switch (index) {
                    case 0: {
                        return 2;
                    }
                }
                return 4;
            }
        }
        return 4;
    }

    private void updateExternalAxesSettings() {
        Object o = this.chart.getPropertyValue(11006);
        boolean isExtAxes = o instanceof Boolean ? (Boolean)o : false;
        this.showExternalAxisCB.removeItemListener(this);
        this.showExternalAxisCB.setSelected(isExtAxes);
        this.showExternalAxisCB.addItemListener(this);
    }
}

