/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.OverlayComponent;
import com.sas.graphics.silk.interfaces.ComponentInterface;
import com.sas.graphics.silk.interfaces.LayerInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.InvisiblePanel;
import com.sas.graphics.silk.ui.OverlayTreeNodeObject;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.UIUtilities;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.util.PropertyUtils;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class ClassicOverlayPanel
extends JPanel
implements TabPanelInterface,
ActionListener,
TreeSelectionListener {
    private static final long serialVersionUID = 5082375288972570453L;
    private ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    private Vector propertyListeners = new Vector();
    private JTree tree = new JTree();
    private JCheckBox selectable = null;
    private JButton propertiesButton = null;
    private LayerInterface selectedChart = null;
    private Hashtable tabs = new Hashtable();
    private JButton up = null;
    private JButton down = null;
    private JButton delete = null;
    private JCheckBox x2 = null;
    private JCheckBox y2 = null;
    private DefaultMutableTreeNode treeRoot = new DefaultMutableTreeNode();
    private boolean handleSelection = true;

    public ClassicOverlayPanel() {
        this.initGUI();
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.getSelectionModel().addTreeSelectionListener(this);
        this.selectable.addActionListener(this);
        this.propertiesButton.addActionListener(this);
        this.up.addActionListener(this);
        this.down.addActionListener(this);
        this.delete.addActionListener(this);
        this.x2.addActionListener(this);
        this.y2.addActionListener(this);
    }

    private void initGUI() {
        this.selectable = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"ClassicOverlayPanel.Selectable.txt", (String)"Selectable"));
        this.propertiesButton = new JButton(ResourceLoader.getResourceString((Object)this.rb, (String)"ClassicOverlayPanel.Properties.txt", (String)"Properties..."));
        this.x2 = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"ClassicOverlayPanel.UseX2.txt", (String)"Use x2 Axis"));
        this.y2 = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"ClassicOverlayPanel.UseY2.txt", (String)"Use y2 Axis"));
        this.up = new JButton(null, new ImageIcon(ResourceLoader.getImage((Component)this, (String)"/icons/ascendingIcon.gif")));
        this.up.setPreferredSize(new Dimension(30, 20));
        this.up.setEnabled(false);
        this.down = new JButton(null, new ImageIcon(ResourceLoader.getImage((Component)this, (String)"/icons/descendingIcon.gif")));
        this.down.setPreferredSize(new Dimension(30, 20));
        this.down.setEnabled(false);
        this.delete = new JButton(null, new ImageIcon(ResourceLoader.getImage((Component)this, (String)"/icons/delete2.gif")));
        this.delete.setPreferredSize(new Dimension(30, 20));
        this.delete.setEnabled(false);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BoxLayout(this, 1));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add("Center", new JScrollPane(this.tree));
        JPanel bPanel = new JPanel();
        bPanel.setLayout(new BoxLayout(bPanel, 1));
        bPanel.add(new JPanel());
        bPanel.add(this.up);
        JLabel junk = new JLabel();
        junk.setPreferredSize(new Dimension(30, 15));
        bPanel.add(junk);
        bPanel.add(this.down);
        junk = new JLabel();
        junk.setPreferredSize(new Dimension(30, 15));
        bPanel.add(junk);
        bPanel.add(this.delete);
        bPanel.add(new JPanel());
        panel.add("East", bPanel);
        this.add(panel);
        this.selectable.setMinimumSize(new Dimension(300, 25));
        this.setAlignmentX(0.0f);
        this.add(this.selectable);
        this.add(this.x2);
        this.add(this.y2);
        this.add(this.propertiesButton);
    }

    private void initFromSource() {
        this.selectable.setSelected(false);
        this.selectable.setEnabled(false);
        this.x2.setEnabled(false);
        this.y2.setEnabled(false);
        this.propertiesButton.setEnabled(false);
        if (this.propertyListeners.size() == 0) {
            return;
        }
        Enumeration e = this.treeRoot.children();
        while (e.hasMoreElements()) {
            ((DefaultTreeModel)this.tree.getModel()).removeNodeFromParent((MutableTreeNode)e.nextElement());
        }
        for (int i = 0; i < this.propertyListeners.size(); ++i) {
            PropertyInterface p = (PropertyInterface)this.propertyListeners.elementAt(i);
            Object o = p.getPropertyValue(15000);
            DefaultMutableTreeNode root = new DefaultMutableTreeNode();
            if (o instanceof ComponentInterface && ((ComponentInterface)o).getId() != null) {
                root.setUserObject(new OverlayTreeNodeObject(p, ((ComponentInterface)o).getId()));
            } else {
                root.setUserObject(new OverlayTreeNodeObject(p, ResourceLoader.getResourceString((Object)this.rb, (String)"ClassicOverlayPanel.Overlay.txt", (String)"Overlay") + " " + this.treeRoot.getChildCount()));
            }
            this.treeRoot.add(root);
            e = Extract.elements((Object)o);
            while (e.hasMoreElements()) {
                Object chart = e.nextElement();
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(chart);
                root.add(node);
            }
        }
        this.tree.setModel(new DefaultTreeModel(this.treeRoot));
        this.tree.setRootVisible(false);
        this.tree.expandPath(new TreePath(this.treeRoot));
        for (int row = 0; row < this.tree.getRowCount(); ++row) {
            this.tree.expandRow(row);
        }
        TreePath selected = this.tree.getSelectionPath();
        if (selected == null) {
            this.up.setEnabled(false);
            this.down.setEnabled(false);
            this.delete.setEnabled(false);
        } else {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selected.getLastPathComponent();
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)selected.getParentPath().getLastPathComponent();
            int index = parent.getIndex(node);
            this.down.setEnabled(parent.getChildCount() >= index + 2);
            this.up.setEnabled(index >= 1);
            this.delete.setEnabled(true);
        }
    }

    public boolean applyChanges() {
        for (int i = 0; i < this.propertyListeners.size(); ++i) {
            PropertyInterface p = (PropertyInterface)this.propertyListeners.elementAt(i);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.tree.getModel().getRoot()).getChildAt(i);
            Object[] chartListData = new Object[node.getChildCount()];
            for (int j = 0; j < chartListData.length; ++j) {
                chartListData[j] = ((DefaultMutableTreeNode)node.getChildAt(j)).getUserObject();
            }
            p.setPropertyValue(15000, (Object)chartListData);
        }
        return PropertyUtils.applyChanges((Vector)this.propertyListeners);
    }

    public boolean cancelChanges() {
        return PropertyUtils.cancelChanges((Vector)this.propertyListeners);
    }

    public boolean addPropertyListener(PropertyInterface prop) {
        if (prop == null || this.propertyListeners.contains(prop)) {
            return false;
        }
        this.propertyListeners.addElement(prop);
        this.initFromSource();
        return true;
    }

    public boolean removePropertyListener(PropertyInterface prop) {
        boolean rc = this.propertyListeners.remove(prop);
        this.initFromSource();
        return rc;
    }

    @Override
    public void valueChanged(TreeSelectionEvent arg0) {
        if (this.propertyListeners.size() == 0 || !this.handleSelection) {
            return;
        }
        TreePath path = arg0.getPath();
        int length = path.getPathCount();
        this.delete.setEnabled(length == 3);
        if (length < 3) {
            this.up.setEnabled(false);
            this.down.setEnabled(false);
            this.x2.setEnabled(false);
            this.y2.setEnabled(false);
            this.selectable.setEnabled(false);
            this.propertiesButton.setEnabled(false);
            return;
        }
        Object overlay = path.getPathComponent(1);
        Object chart = path.getPathComponent(2);
        if (!(overlay instanceof DefaultMutableTreeNode) || !(chart instanceof DefaultMutableTreeNode)) {
            return;
        }
        DefaultMutableTreeNode ovr = (DefaultMutableTreeNode)overlay;
        DefaultMutableTreeNode chrt = (DefaultMutableTreeNode)chart;
        PropertyInterface p = (PropertyInterface)((OverlayTreeNodeObject)ovr.getUserObject()).overlay;
        Object o = p.getPropertyValue(15001);
        if (!(o instanceof OverlayComponent)) {
            return;
        }
        OverlayComponent l = (OverlayComponent)o;
        this.selectedChart = l.getLayerById(chrt.getUserObject());
        if (this.selectedChart != null) {
            this.selectable.setSelected(this.selectedChart.isSelectable());
        }
        this.up.setEnabled(ovr.getChildBefore(chrt) != null);
        this.down.setEnabled(ovr.getChildAfter(chrt) != null);
        this.x2.removeActionListener(this);
        this.y2.removeActionListener(this);
        this.selectable.removeActionListener(this);
        this.x2.setEnabled(true);
        this.y2.setEnabled(true);
        this.selectable.setEnabled(true);
        this.propertiesButton.setEnabled(true);
        this.x2.setSelected(this.selectedChart.getXAxisMapping() == 3);
        this.y2.setSelected(this.selectedChart.getYAxisMapping() == 4);
        this.selectable.setSelected(this.selectedChart.isSelectable());
        this.selectable.addActionListener(this);
        this.x2.addActionListener(this);
        this.y2.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Object source = arg0.getSource();
        if (source == this.selectable && this.selectedChart != null) {
            this.selectedChart.setSelectable(this.selectable.isSelected());
        } else if (source == this.propertiesButton && this.selectedChart != null) {
            PropertyInterface p;
            Object o;
            TabPanelInterface t = (TabPanelInterface)this.tabs.get(this.selectedChart);
            if (t == null && (t = this.selectedChart.getChartTab()) != null) {
                this.tabs.put(this.selectedChart, t);
            }
            Component c = this;
            if (this.selectedChart instanceof Component) {
                c = (Component)this.selectedChart;
            }
            if (!((o = (p = (PropertyInterface)this.propertyListeners.elementAt(0)).getPropertyValue(15001)) instanceof Component)) {
                c = (Component)o;
            }
            TabbedPropertiesDialog tpd = new TabbedPropertiesDialog(UIUtilities.getParentFrame((Component)c), c, ResourceLoader.getResourceString((Object)this.rb, (String)"ClassicOverlayPanel.Properties.txt", (String)"Properties"));
            tpd.addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"ClassicOverlayPanel.Properties.txt", (String)"Properties"), t);
            tpd.addTab("", (TabPanelInterface)new InvisiblePanel(this.propertyListeners));
            tpd.setVisible(true);
        } else if (source == this.up) {
            TreePath tp = this.tree.getSelectionPath();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp.getLastPathComponent();
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)tp.getParentPath().getLastPathComponent();
            int index = parent.getIndex(node);
            this.handleSelection = false;
            ((DefaultTreeModel)this.tree.getModel()).removeNodeFromParent(node);
            ((DefaultTreeModel)this.tree.getModel()).insertNodeInto(node, parent, index - 1);
            this.tree.setSelectionPath(tp);
            this.down.setEnabled(true);
            if (index == 1) {
                this.up.setEnabled(false);
            }
            this.handleSelection = true;
        } else if (source == this.down) {
            TreePath tp = this.tree.getSelectionPath();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp.getLastPathComponent();
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)tp.getParentPath().getLastPathComponent();
            int index = parent.getIndex(node);
            this.handleSelection = false;
            ((DefaultTreeModel)this.tree.getModel()).removeNodeFromParent(node);
            ((DefaultTreeModel)this.tree.getModel()).insertNodeInto(node, parent, index + 1);
            this.tree.setSelectionPath(tp);
            this.up.setEnabled(true);
            if (parent.getChildCount() == index + 2) {
                this.down.setEnabled(false);
            }
            this.handleSelection = true;
        } else if (source == this.delete) {
            TreePath tp = this.tree.getSelectionPath();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp.getLastPathComponent();
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)tp.getParentPath().getLastPathComponent();
            this.handleSelection = false;
            ((DefaultTreeModel)this.tree.getModel()).removeNodeFromParent(node);
            ((PropertyInterface)((OverlayTreeNodeObject)parent.getUserObject()).overlay).setPropertyValue(15002, node.getUserObject());
            this.initFromSource();
            this.up.setEnabled(false);
            this.down.setEnabled(false);
            this.delete.setEnabled(false);
            this.handleSelection = true;
        } else if (source == this.x2 || source == this.y2) {
            int x = this.x2.isSelected() ? 3 : 0;
            int y = this.y2.isSelected() ? 4 : 1;
            TreePath p = this.tree.getSelectionPath();
            int length = p.getPathCount();
            if (length < 3) {
                return;
            }
            Object overlay = p.getPathComponent(1);
            Object chart = p.getPathComponent(2);
            if (!(overlay instanceof DefaultMutableTreeNode) || !(chart instanceof DefaultMutableTreeNode)) {
                return;
            }
            DefaultMutableTreeNode ovr = (DefaultMutableTreeNode)overlay;
            PropertyInterface pi = (PropertyInterface)((OverlayTreeNodeObject)ovr.getUserObject()).overlay;
            Object o = pi.getPropertyValue(15001);
            if (!(o instanceof OverlayComponent)) {
                return;
            }
            this.selectedChart.setXAxisMapping(x);
            this.selectedChart.setYAxisMapping(y);
        }
    }

    @Override
    public void repaint() {
        super.repaint();
        if (this.propertyListeners == null || this.propertyListeners.isEmpty()) {
            return;
        }
        PropertyInterface p = (PropertyInterface)this.propertyListeners.elementAt(0);
        Object o = p.getPropertyValue(15001);
        if (!(o instanceof Component)) {
            ((Component)o).repaint();
        }
    }

    @Override
    public void setVisible(boolean arg0) {
        this.initFromSource();
        super.setVisible(arg0);
    }
}

