/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.data.DataFilterUtilities;
import com.sas.graphics.silk.interfaces.ComponentInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.UIUtilities;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.util.UniqueValueMapper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BySlider
extends JComponent
implements AdjustmentListener,
MouseListener,
ActionListener {
    private static final long serialVersionUID = 1247951053327513027L;
    JScrollBar scrollbar = null;
    JLabel label = null;
    Vector components = new Vector();
    DataFilterReadInterface filter = null;
    Object byVar = null;
    Object[] uniqueValues = null;
    JPopupMenu menu = new JPopupMenu();
    JCheckBoxMenuItem animate;
    JMenuItem properties;
    AnimateThread animator = null;
    PropertiesDialog dialog = null;
    long animationSpeed = 750L;
    boolean labelVisible = true;

    public BySlider() {
        this.setLayout(new BorderLayout());
        this.scrollbar = new JScrollBar(0);
        this.add("Center", this.scrollbar);
        this.label = new JLabel();
        this.label.setHorizontalAlignment(0);
        this.label.setFont(TabbedPropertiesDialog.dialogFont);
        this.add("North", this.label);
        this.scrollbar.setUnitIncrement(1);
        this.scrollbar.setBlockIncrement(1);
        this.scrollbar.setVisibleAmount(1);
        this.scrollbar.addAdjustmentListener(this);
        this.label.addMouseListener(this);
        this.scrollbar.addMouseListener(this);
        this.properties = new JMenuItem("Properties...");
        this.properties.setFont(TabbedPropertiesDialog.dialogFont);
        this.properties.addActionListener(this);
        this.menu.add(this.properties);
        this.animate = new JCheckBoxMenuItem("Animate");
        this.animate.setFont(TabbedPropertiesDialog.dialogFont);
        this.animate.addActionListener(this);
        this.menu.add(this.animate);
    }

    public boolean addComponent(ComponentInterface component) {
        if (component == null || this.components.contains(component)) {
            return false;
        }
        this.components.addElement(component);
        return true;
    }

    public boolean removeComponent(ComponentInterface component) {
        return this.components.remove(component);
    }

    public boolean setData(Object data, Object byVariable) {
        if (data == null || byVariable == null) {
            return false;
        }
        this.filter = FilterFactory.getDataSourceFilter((Object)data);
        if (this.filter == null) {
            return false;
        }
        return this.setVariable(byVariable);
    }

    public boolean setVariable(Object var) {
        if (this.filter == null || var == null || !this.filter.verifyVariable(var)) {
            return false;
        }
        this.byVar = var;
        UniqueValueMapper uvm = new UniqueValueMapper();
        for (int i = 0; i < this.filter.getNumberObservations(this.byVar); ++i) {
            uvm.addValue(this.filter.getValue(this.byVar, (long)i));
        }
        this.uniqueValues = uvm.getValues(0);
        this.scrollbar.setMaximum(this.uniqueValues.length);
        this.subsetCharts();
        return true;
    }

    private void subsetCharts() {
        Object value = this.uniqueValues[this.scrollbar.getValue()];
        this.label.setText("Where " + this.byVar.toString() + " = " + value.toString());
        String whereClause = this.byVar.toString() + " = " + value.toString();
        if (!this.filter.isNumericVariable(this.byVar)) {
            whereClause = this.byVar.toString() + " = \"" + value.toString() + "\"";
        }
        Enumeration e = this.components.elements();
        while (e.hasMoreElements()) {
            ComponentInterface c = (ComponentInterface)e.nextElement();
            DataFilterReadInterface f = c.getFilter();
            DataFilterUtilities.applyWhereClause((DataFilterReadInterface)f, (String)whereClause, (boolean)true, (int)2);
        }
    }

    public boolean isLabelVisible() {
        return this.labelVisible;
    }

    public void setLabelVisible(boolean vis) {
        this.remove(this.label);
        if (vis) {
            this.add("North", this.label);
        }
        this.labelVisible = vis;
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    public void next() {
        int inc = this.scrollbar.getUnitIncrement();
        int max = this.scrollbar.getMaximum();
        int currentValue = this.scrollbar.getValue();
        if (currentValue + inc >= max) {
            this.scrollbar.setValue(0);
        } else {
            this.scrollbar.setValue(currentValue + inc);
        }
        this.repaint();
    }

    public void previous() {
        int inc = this.scrollbar.getUnitIncrement();
        int max = this.scrollbar.getMaximum();
        int currentValue = this.scrollbar.getValue();
        if (currentValue - inc < 0) {
            this.scrollbar.setValue(max);
        } else {
            this.scrollbar.setValue(currentValue - inc);
        }
        this.repaint();
    }

    public long getAnimationDelay() {
        return this.animationSpeed;
    }

    public void setAnimationDelay(long ms) {
        this.animationSpeed = ms;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent arg0) {
        if (!arg0.getValueIsAdjusting()) {
            this.subsetCharts();
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        if (arg0.isPopupTrigger()) {
            this.menu.show(arg0.getComponent(), arg0.getX(), arg0.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        if (arg0.isPopupTrigger()) {
            this.menu.show(arg0.getComponent(), arg0.getX(), arg0.getY());
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Object source = arg0.getSource();
        if (source == this.animate) {
            if (this.animate.isSelected()) {
                this.animator = new AnimateThread();
                this.animator.start();
            } else {
                this.animator.stop = true;
                this.animator = null;
            }
        } else if (source == this.properties) {
            Container c;
            for (c = this.getParent(); c != null && !(c instanceof Frame); c = c.getParent()) {
            }
            if (this.dialog == null) {
                this.dialog = new PropertiesDialog((Frame)c);
            }
            this.dialog.setVisible(true);
        }
    }

    class AnimateThread
    extends Thread
    implements Runnable {
        public boolean stop = false;

        AnimateThread() {
        }

        @Override
        public synchronized void run() {
            while (Thread.currentThread() == this && !this.stop) {
                BySlider.this.next();
                try {
                    this.wait(BySlider.this.animationSpeed);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    class PropertiesDialog
    extends JDialog
    implements ActionListener,
    ChangeListener {
        private static final long serialVersionUID = -786986008928266782L;
        JComboBox varCombo;
        JSlider slider;
        JCheckBox showLabel;

        public PropertiesDialog(Frame parent) {
            super(parent);
            this.varCombo = new JComboBox();
            this.slider = new JSlider();
            this.showLabel = new JCheckBox("Show Label");
            this.setSize(300, 130);
            this.setResizable(false);
            this.setModal(true);
            UIUtilities.center((Window)this);
            this.buildGUI();
            this.initGUI();
        }

        private void buildGUI() {
            Container c = this.getContentPane();
            c.removeAll();
            c.setLayout(null);
            JLabel label = new JLabel("Variable:");
            label.setBounds(10, 10, 50, 18);
            label.setFont(TabbedPropertiesDialog.dialogFont);
            c.add(label);
            this.varCombo.setBounds(65, 9, 220, 20);
            this.varCombo.setBackground(Color.white);
            this.varCombo.setFont(TabbedPropertiesDialog.dialogFont);
            c.add(this.varCombo);
            label = new JLabel("Animation Speed:");
            label.setFont(TabbedPropertiesDialog.dialogFont);
            label.setBounds(10, 40, 90, 18);
            c.add(label);
            this.slider.setBounds(105, 39, 180, 20);
            c.add(this.slider);
            this.showLabel.setFont(TabbedPropertiesDialog.dialogFont);
            this.showLabel.setBounds(10, 70, 100, 18);
            c.add(this.showLabel);
        }

        public void initGUI() {
            this.varCombo.removeActionListener(this);
            this.slider.removeChangeListener(this);
            this.showLabel.removeActionListener(this);
            if (BySlider.this.filter != null) {
                int num = BySlider.this.filter.getNumberVariables();
                for (int i = 0; i < num; ++i) {
                    this.varCombo.addItem(BySlider.this.filter.getVariableId(i));
                }
                this.varCombo.setSelectedItem(BySlider.this.filter.getVariableId(BySlider.this.filter.getVariableIndex(BySlider.this.byVar)));
            }
            this.slider.setMinimum(0);
            this.slider.setMaximum(1300);
            this.slider.setValue((int)(1500L - BySlider.this.getAnimationDelay()));
            this.showLabel.setSelected(BySlider.this.isLabelVisible());
            this.showLabel.addActionListener(this);
            this.slider.addChangeListener(this);
            this.varCombo.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Object source = arg0.getSource();
            if (source == this.varCombo) {
                BySlider.this.setVariable(this.varCombo.getSelectedItem());
            } else if (source == this.showLabel) {
                BySlider.this.setLabelVisible(this.showLabel.isSelected());
            }
        }

        @Override
        public void stateChanged(ChangeEvent arg0) {
            if (arg0.getSource() == this.slider) {
                BySlider.this.setAnimationDelay(1500 - this.slider.getValue());
            }
        }
    }
}

