/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.ConstComponent;
import com.sas.graphics.silk.TreeviewComponent;
import com.sas.graphics.silk.interfaces.ColorSchemeInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BaseNodesPanel
extends JPanel
implements ItemListener,
ChangeListener,
TabPanelInterface {
    private static final long serialVersionUID = 4253659412018173975L;
    protected PropertyInterface propertyInterface;
    protected JComponent parent;
    protected ResourceBundle resourceBundle;
    JCheckBox NodeColorMappedButton = new JCheckBox();

    public BaseNodesPanel(PropertyInterface propInterface, JComponent component) {
        this.propertyInterface = propInterface;
        this.parent = component;
        this.resourceBundle = ResourceBundle.getBundle("com.sas.graphics.silk.constchart.NodesPanel");
        this.setLayout(null);
        this.setSize(265, 410);
        this.NodeColorMappedButton.setText("Map Color from Data Values");
        this.NodeColorMappedButton.setActionCommand("ColorMapped");
        this.add(this.NodeColorMappedButton);
        this.NodeColorMappedButton.setFont(TabbedPropertiesDialog.dialogFont);
        this.NodeColorMappedButton.setBounds(16, 40, 240, 24);
        String mapped = ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"NodesPanel.ColorMapped.txt", (String)"Map Color from Data Values");
        this.NodeColorMappedButton.setText(mapped);
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        JCheckBox check;
        Object source = evt.getSource();
        if (source instanceof JCheckBox && (check = (JCheckBox)source) == this.NodeColorMappedButton) {
            this.propertyInterface.setPropertyValue(812, (Object)new Boolean(!check.isSelected()));
            if (this.parent instanceof ConstComponent) {
                ((ConstComponent)this.parent).setColorMappingNodes(check.isSelected());
            } else if (this.parent instanceof TreeviewComponent) {
                ((TreeviewComponent)this.parent).setColorMappingNodes(check.isSelected());
            }
        }
    }

    protected double getNumericProperty(int id, double defaultValue) {
        Object o = this.propertyInterface.getPropertyValue(id);
        if (o == null || !(o instanceof Number)) {
            return defaultValue;
        }
        return ((Number)o).doubleValue();
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        Object source = evt.getSource();
        if (source instanceof ColorSchemeInterface) {
            ColorSchemeInterface colorScheme = (ColorSchemeInterface)source;
            Color c = colorScheme.getDataColors(true, true)[0];
            if (c == null) {
                return;
            }
            this.propertyInterface.setPropertyValue(800, (Object)c);
        }
    }

    public boolean cancelChanges() {
        this.propertyInterface.cancelPropertyChanges();
        this.refreshComponents();
        return true;
    }

    public boolean applyChanges() {
        this.propertyInterface.applyPropertyChanges();
        this.refreshComponents();
        return true;
    }

    public boolean addPropertyListener(PropertyInterface prop) {
        return false;
    }

    public boolean removePropertyListener(PropertyInterface prop) {
        return false;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.refreshComponents();
        }
        super.setVisible(b);
    }

    public void refreshComponents() {
        this.NodeColorMappedButton.removeItemListener(this);
        Object value = this.propertyInterface.getPropertyValue(804);
        boolean nodeColorMapped = false;
        if (value != null && value instanceof Boolean) {
            nodeColorMapped = (Boolean)value;
        }
        value = this.propertyInterface.getPropertyValue(812);
        boolean nodeColorFix = false;
        if (value != null && value instanceof Boolean) {
            nodeColorFix = (Boolean)value;
        }
        value = this.propertyInterface.getPropertyValue(807);
        boolean isValueMappingAllowed = false;
        if (value != null && value instanceof Boolean) {
            isValueMappingAllowed = (Boolean)value;
        }
        if (isValueMappingAllowed || nodeColorMapped) {
            this.NodeColorMappedButton.setEnabled(true);
            if (nodeColorFix) {
                this.NodeColorMappedButton.setSelected(false);
            } else {
                this.NodeColorMappedButton.setSelected(true);
            }
        } else {
            this.NodeColorMappedButton.setEnabled(false);
            this.NodeColorMappedButton.setSelected(false);
        }
        this.NodeColorMappedButton.addItemListener(this);
    }

    protected String GRS(ResourceBundle rb, String name, String defStrg) {
        String s = null;
        if (name == null) {
            return defStrg;
        }
        try {
            if (rb != null) {
                s = rb.getString(name);
            }
        }
        catch (MissingResourceException e) {
            s = null;
        }
        if (s == null) {
            s = defStrg;
        }
        return s;
    }
}

