/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.treeview;

import com.sas.graphics.util.AboutFrame;
import com.sas.graphics.util.SASIcon;
import com.sas.graphics.util.nld.NLDLink;
import com.sas.graphics.util.nld.NLDModel;
import com.sas.graphics.util.nld.NLDMouseFrame;
import com.sas.graphics.util.nld.NLDNode;
import com.sas.graphics.util.nld.NLDViewer;
import com.sas.graphics.util.nld.VectorLinkModel;
import com.sas.graphics.util.nld.VectorNodeModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class TreeViewer
extends NLDViewer {
    private static final long serialVersionUID = -811218427032465703L;
    private static final int CIRCLE = 0;
    private static final int NONE = 0;
    private static final int LEFT = 1;
    private static final int UP = 3;
    private static final int RIGHT = 2;
    private static final int DOWN = 4;
    private int dir = 0;
    private double span;
    private double savedSpan = this.span = Math.PI * 2;
    private double startAngle = 0.0;
    private double savedStartAngle = 0.0;
    private JMenu open = null;
    private JMenuItem setroot = null;
    private JMenuItem resetroot = null;
    private JCheckBoxMenuItem selN = null;
    private JCheckBoxMenuItem selT = null;
    private JCheckBoxMenuItem hideT = null;
    private JMenuItem[] csm = null;
    private JPopupMenu popup = null;
    private boolean spread = false;
    private boolean rotate = false;
    private boolean handlePopup = true;
    private Color nodeBorderColor = new Color(97, 115, 169);
    private Color rootColor = new Color(204, 226, 139);
    private String buildDate = "0000.0000";
    protected double minNColVal = 0.0;
    protected double maxNColVal = 0.0;
    protected double minLColVal = 0.0;
    protected double maxLColVal = 0.0;
    protected double defaultLinkWidth = 1.0;
    protected double defaultLinkWidthIncrease = 3.0;
    private boolean scaleLinkWidth = true;
    protected double minLWidthVal;
    protected double maxLWidthVal;
    private boolean diffRootSet = false;
    private String[] nodeOptActionStrArray = new String[]{"NLD_SET_ROOT", "NLD_SELECT_NODE", "NLD_SELECT_SUB_TREE", "NLD_HIDE_SUB_TREE"};
    double centerxMin = -0.5;
    double centerxMax = 0.5;
    double centeryMin = -0.5;
    double centeryMax = 0.5;
    double xsize = 0.0;
    double ysize = 0.0;
    int cntr = 0;
    private Object lock = new Object();
    private Vector[] kids = null;
    private Vector[] viskids = null;
    private int[] parent = null;
    private int[] depth = null;
    private int[] numLeaves = null;
    private int maxDepth = 0;
    private int maxPath = -1;
    private int root = -1;
    private NLDNode rootNode = null;
    private int defRoot = -1;
    private NLDNode defRootNode = null;
    private int numCols = 0;
    private Object context = null;
    private double smooth = 0.5;

    public TreeViewer() {
        this.setCenterSelected(true);
        this.setInitialValues();
    }

    public TreeViewer(NLDModel m) {
        this.setCenterSelected(true);
        this.model = m;
        this.setInitialValues();
    }

    private void setInitialValues() {
        this.buildAsNonSelected = true;
        this.showLabels = true;
        this.lens = true;
        this.fan = true;
        this.textBorderType = 3;
        this.setTextValign(1);
        this.setHalign(1);
        this.rbstr = "com.sas.graphics.silk.treeview.treeview";
        try {
            this.appRB = ResourceBundle.getBundle(this.rbstr);
        }
        catch (MissingResourceException e) {
            this.appRB = null;
        }
        catch (ClassCastException e) {
            this.appRB = null;
        }
        this.setRBString("com.sas.graphics.silk.treeview.treeview");
        if (this.model != null) {
            this.model.setHideLinks(false);
            this.model.setChartType(0);
        }
        this.nodeColor = Color.white;
        this.nodeBorderColor = new Color(97, 115, 169);
        this.linkColor = new Color(127, 89, 52);
        this.selectColor = this.nodeColor;
        this.rampColors[0] = new Color(152, 52, 28);
        this.rampColors[1] = Color.white;
        this.rampColors[2] = new Color(94, 82, 139);
    }

    public void copy(NLDViewer viewer) {
        super.copy(viewer);
        if (viewer instanceof TreeViewer) {
            TreeViewer tree = (TreeViewer)viewer;
            this.startAngle = tree.startAngle;
            this.savedStartAngle = tree.savedStartAngle;
            this.dir = tree.dir;
            this.span = tree.span;
            this.savedSpan = tree.savedSpan;
        }
    }

    protected void createChannel() {
        super.createChannel();
        if (this.channel != null) {
            this.setLens(this.lens);
            this.channel.setLensDirection(this.dir);
        }
    }

    public void resetView(boolean build) {
        this.setLensFactor(this.savedLensFactor);
        this.startAngle = this.savedStartAngle;
        this.span = this.savedSpan;
        if (this.span < 240.0) {
            this.setCenter();
            this.rebuild(build);
        } else {
            super.resetView(build);
        }
    }

    public void setStartAngle(double val) {
        this.startAngle = this.savedStartAngle = val * Math.PI / 180.0;
        this.resetLensLocation();
    }

    public void setTreeSpan(double val) {
        this.span = this.savedSpan = val * Math.PI / 180.0;
        this.resetLensLocation();
    }

    public double getTreeSpan() {
        return this.span * 180.0 / Math.PI;
    }

    public void setLongestPath(double val) {
        if (val >= 1.0) {
            this.maxPath = (int)val;
        }
    }

    public void setTreeDirection(String d) {
        if ((d = d.toLowerCase()).equals("u") || d.equals("up")) {
            if (this.span > Math.PI) {
                this.savedSpan = 1.5707963267948966;
                this.span = 1.5707963267948966;
            }
            this.savedStartAngle = 1.5707963267948966;
            this.startAngle = 1.5707963267948966;
            this.dir = 3;
        } else if (d.equals("d") || d.equals("down")) {
            this.savedStartAngle = -1.5707963267948966;
            this.startAngle = -1.5707963267948966;
            if (this.span > Math.PI) {
                this.savedSpan = 1.5707963267948966;
                this.span = 1.5707963267948966;
            }
            this.dir = 4;
        } else if (d.equals("l") || d.equals("left")) {
            this.savedStartAngle = Math.PI;
            this.startAngle = Math.PI;
            if (this.span > Math.PI) {
                this.savedSpan = 1.5707963267948966;
                this.span = 1.5707963267948966;
            }
            this.dir = 1;
        } else if (d.equals("r") || d.equals("right")) {
            this.savedStartAngle = 0.0;
            this.startAngle = 0.0;
            if (this.span > Math.PI) {
                this.savedSpan = 1.5707963267948966;
                this.span = 1.5707963267948966;
            }
            this.dir = 2;
        } else if (d.equals("c") || d.equals("circle")) {
            this.savedStartAngle = 0.0;
            this.startAngle = 0.0;
            this.savedSpan = Math.PI * 2;
            this.span = Math.PI * 2;
            this.dir = 0;
        } else {
            this.dir = 0;
            this.span = Math.PI * 2;
        }
        this.resetLensLocation();
    }

    public String getTreeDirection() {
        switch (this.dir) {
            case 3: {
                return "up";
            }
            case 4: {
                return "down";
            }
            case 1: {
                return "left";
            }
            case 2: {
                return "right";
            }
        }
        return "circle";
    }

    protected void setCenter() {
        if (this.dir == 0 || this.span >= 4.71238898038469) {
            this.centery = 0.0;
            this.centerx = 0.0;
            this.centerxMin = -0.8;
            this.centerxMax = 0.8;
            this.centeryMin = -0.8;
            this.centeryMax = 0.8;
        } else {
            if (this.rootNode != null) {
                double[] rootSize = this.rootNode.getSize(this.channel, this.handleType);
                this.xsize = rootSize[0] / 2.0;
                this.ysize = rootSize[1] / 2.0;
            }
            switch (this.dir) {
                default: {
                    this.centerx = 0.0;
                    this.centery = -0.75;
                    this.centeryMax = -0.25;
                    this.centeryMin = this.centery;
                    break;
                }
                case 3: {
                    this.centerx = 0.0;
                    this.centery = 0.5;
                    this.centeryMin = 0.25;
                    break;
                }
                case 1: {
                    this.centerx = -0.5;
                    this.centerxMin = -1.0 + this.xsize;
                    this.centerxMax = -this.xsize;
                    this.centery = 0.0;
                    break;
                }
                case 2: {
                    this.centerx = 0.5;
                    this.centery = 0.0;
                    this.centerxMax = Math.max(0.75, 1.0 - this.xsize);
                    this.centerxMin = this.xsize;
                }
            }
            if (this.channel != null) {
                this.channel.gluLookAt(this.centerx, this.centery, 0.0, 0.5, 0.0, 0.0, 0.0);
            }
        }
    }

    void resetLensLocation() {
        this.setCenter();
        this.spread = false;
        this.setLensLocation(0.0, 0.0);
    }

    public void setLens(boolean flag) {
        super.setLens(flag);
        if (flag && this.channel != null) {
            double min;
            for (min = this.startAngle - this.span / 2.0; min < -Math.PI; min += Math.PI * 2) {
            }
            while (min > Math.PI) {
                min -= Math.PI * 2;
            }
            double max = min + this.span;
            this.channel.setThetaLensAngles(min, max);
        }
    }

    public JPopupMenu getDefaultPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        String[] menlabs = new String[]{this.GRS("PopupMenu.DWG.ResetView.txt", "Reset View"), this.GRS("PopupMenu.DWG.Select.txt", "Select..."), this.GRS("PopupMenu.DWG.SelectAll.txt", "Select All"), this.GRS("PopupMenu.DWG.ShowAll.txt", "Show All Nodes")};
        String[] commands = new String[]{"reset", "filter", "selAll", "showAll"};
        JMenuItem mi = this.AddToMenu(popup, menlabs[0], commands[0], (ActionListener)((Object)this));
        mi = this.AddToMenu(popup, menlabs[1], commands[1], (ActionListener)((Object)this));
        mi = this.AddToMenu(popup, menlabs[2], commands[2], (ActionListener)((Object)this));
        mi = this.AddToMenu(popup, menlabs[3], commands[3], (ActionListener)((Object)this));
        popup.addSeparator();
        if (this.applet != null) {
            this.open = new JMenu();
            this.open.setText(this.GRS("PopupMenu.CS.CustomAction.txt", "Custom Action"));
            popup.add(this.open);
        }
        if (this.setroot == null) {
            this.setroot = this.AddToMenu(popup, this.GRS("PopupMenu.CS.SetRoot.txt", "Set Root"), this.nodeOptActionStrArray[0], (ActionListener)((Object)this), true);
        }
        this.resetroot = this.AddToMenu(popup, this.GRS("PopupMenu.CS.ResetRoot.txt", "Reset Root"), "resetRoot", (ActionListener)((Object)this), false);
        if (this.selN == null) {
            this.selN = this.AddOnOffToMenu(popup, this.GRS("PopupMenu.CS.SelectNode.txt", "Select node"), this.nodeOptActionStrArray[1], false, (ItemListener)((Object)this), true);
        }
        if (this.selT == null) {
            this.selT = this.AddOnOffToMenu(popup, this.GRS("PopupMenu.CS.SelectSubtree.txt", "Select subtree"), this.nodeOptActionStrArray[2], false, (ItemListener)((Object)this), true);
        }
        if (this.hideT == null) {
            this.hideT = this.AddOnOffToMenu(popup, this.GRS("PopupMenu.CS.HideSubtree.txt", "Hide subtree"), this.nodeOptActionStrArray[3], false, (ItemListener)((Object)this), true);
        }
        JMenuItem[] list = this.applet != null ? new JMenuItem[]{this.open, this.setroot, this.resetroot, this.selN, this.selT, this.hideT} : new JMenuItem[]{this.setroot, this.resetroot, this.selN, this.selT, this.hideT};
        this.csm = list;
        JMenu m = new JMenu(this.GRS("PopupMenu.Help.txt", "Help"));
        if (m != null) {
            popup.add(m);
            m.setName("Help");
        }
        if (this.applet != null && (mi = new JMenuItem(this.GRS("PopupMenu.Help.Applet.txt", "Treeview Applet Help"))) != null) {
            mi.setActionCommand("hp_Help");
            mi.addActionListener((ActionListener)((Object)this));
            m.add(mi);
        }
        if ((mi = new JMenuItem(this.GRS("PopupMenu.Help.Mouse.txt", "Mouse Help"))) != null) {
            mi.setActionCommand("hp_Mouse");
            mi.addActionListener((ActionListener)((Object)this));
            m.add(mi);
        }
        m.addSeparator();
        if (this.applet != null && (mi = new JMenuItem(this.GRS("PopupMenu.Help.AboutSASInstitute.txt", "SAS Institute on the Web"))) != null) {
            mi.setActionCommand("hp_SAS");
            mi.addActionListener((ActionListener)((Object)this));
            m.add(mi);
        }
        if ((mi = new JMenuItem(this.GRS("PopupMenu.Help.AboutApplet.txt", "About Treeview Applet"))) != null) {
            mi.setActionCommand("hp_Applet");
            mi.addActionListener((ActionListener)((Object)this));
            m.add(mi);
        }
        return popup;
    }

    public synchronized void mouseDragged(MouseEvent e) {
        if (!this.ready || this.emptyPlot) {
            return;
        }
        this.tooltipTimer.restart();
        this.tipText = null;
        if (this.tipLocation == null) {
            this.tipLocation = new Point();
        }
        this.tipLocation.x = e.getX();
        this.tipLocation.y = e.getY();
        int x = e.getX();
        int y = e.getY();
        Rectangle r = this.getBounds();
        int xd = this.prevx - x;
        int yd = this.prevy - y;
        this.drag = true;
        if (this.movenode) {
            double[] win1 = new double[3];
            double[] obj1 = new double[3];
            double[] win2 = new double[3];
            double[] obj2 = new double[3];
            double[] delta = new double[2];
            win1[0] = x;
            win1[1] = y;
            win2[0] = this.prevx;
            win2[1] = this.prevy;
            this.channel.gluUnProject(win1, obj1);
            this.channel.gluUnProject(win2, obj2);
            delta[0] = obj1[0] - obj2[0];
            delta[1] = obj1[1] - obj2[1];
            for (int i = 0; i < this.numNodes; ++i) {
                NLDNode n = (NLDNode)this.model.nodes.elementAt(i);
                if (!this.model.nodes.isSelected(i)) continue;
                n.setPosition(n.getCurXPosition() + delta[0], n.getCurYPosition() + delta[1]);
            }
            this.rebuild();
            this.prevx = x;
            this.prevy = y;
        } else if (this.zoom) {
            if (this.lens) {
                double minfac = 0.1;
                double percent = 1.0 * (double)yd / (double)r.height;
                double thresh = 0.01;
                if (Math.abs(percent) < thresh) {
                    return;
                }
                if (this.lensFactor < 1.0) {
                    double sqrtlen = Math.sqrt(this.lensFactor);
                    this.lensFactor += sqrtlen * percent;
                } else {
                    this.lensFactor *= 1.0 + percent;
                }
                if (this.lensFactor <= minfac) {
                    this.lensFactor = minfac;
                }
                if (this.applet != null) {
                    Object[] args = new Object[]{new Double(this.lensFactor)};
                    String msg1 = this.GRS("StatusText.factor.fmt.txt", "factor={0}");
                    String result = MessageFormat.format(msg1, args);
                    System.out.println(result);
                    this.applet.getAppletContext().showStatus(result);
                }
                this.channel.setLensFactor(this.lensFactor);
            } else {
                if (Math.abs(yd) < 5) {
                    return;
                }
                this.zoomval *= 1.0 - 1.5 * (double)yd / (double)r.height;
                this.setNodeImages();
                this.checkImages();
                this.proj();
                this.build();
            }
            this.prevx = x;
            this.prevy = y;
            this.rebuild();
        } else if (this.spread) {
            if (!this.JXDspread || Math.abs(yd) < 5) {
                return;
            }
            double minfac = 0.1;
            double percent = 1.0 * (double)yd / (double)r.height;
            double thresh = 0.01;
            if (Math.abs(percent) < thresh) {
                return;
            }
            if (this.spreadFactor < 1.0) {
                double sqrtlen = Math.sqrt(this.spreadFactor);
                this.spreadFactor += sqrtlen * percent;
            } else {
                this.spreadFactor *= 1.0 + percent;
            }
            if (this.spreadFactor <= minfac) {
                this.spreadFactor = minfac;
            }
            if (this.applet != null) {
                Object[] args = new Object[]{new Double(this.spreadFactor)};
                String msg1 = this.GRS("StatusText.spread.fmt.txt", "spread={0}");
                String result = MessageFormat.format(msg1, args);
                this.applet.getAppletContext().showStatus(result);
            }
            if (this.spreadFactor > 0.0 && this.channel != null) {
                this.channel.setThetaLensFactor(this.spreadFactor);
                this.channel.setLensFactor(this.lensFactor);
            }
            this.prevx = x;
            this.prevy = y;
            this.rebuild();
        } else if (this.rotate) {
            if (Math.abs(yd) < 5) {
                return;
            }
            this.startAngle += (double)(yd * 360 / r.height);
            this.prevx = x;
            this.prevy = y;
            this.place(this.root, this.startAngle * Math.PI / 180.0, this.span);
            this.rebuild();
        } else if (this.select || this.extsel) {
            this.brushActive = true;
            this.prevx = Math.min(x, this.pressX);
            this.prevy = Math.min(y, this.pressY);
            this.diffx = Math.abs(x - this.pressX);
            this.diffy = Math.abs(y - this.pressY);
            this.repaint();
        } else if (this.chgview) {
            this.repaint();
            Graphics gc = this.getGraphics();
            gc.setColor(Color.white);
            gc.setXORMode(Color.black);
            int xp = Math.min(x, this.prevx);
            int yp = Math.min(y, this.prevy);
            int w = Math.abs(xd);
            int h = Math.abs(yd);
            gc.drawRect(xp, yp, w, h);
            int ch = Math.min(h / 4, w / 4);
            gc.drawLine(xp + w / 2, yp + h / 2 - ch, xp + w / 2, yp + h / 2 + ch);
            gc.drawLine(xp + w / 2 - ch, yp + h / 2, xp + w / 2 + ch, yp + h / 2);
            gc.dispose();
        } else if (this.pan) {
            if (Math.abs(xd) < 5 && Math.abs(yd) < 5) {
                return;
            }
            double wxd = 0.0;
            double wyd = 0.0;
            if (this.lens) {
                double[] ps = new double[]{this.prevx, this.prevy, 0.0};
                double[] pw = new double[3];
                this.channel.gluUnProject(ps, pw);
                double[] cs = new double[]{x, y, 0.0};
                double[] cw = new double[3];
                this.channel.gluUnProject(cs, cw);
                wxd = pw[0] - cw[0];
                wyd = pw[1] - cw[1];
                wyd = -wyd;
            } else {
                wxd = this.pixsize * (double)xd;
                wyd = this.pixsize * (double)yd;
            }
            this.centerx += wxd;
            this.centery -= wyd;
            this.validateCenter();
            this.channel.gluLookAt(this.centerx, this.centery, 0.0, 0.5, 0.0, 0.0, 0.0);
            this.prevx = x;
            this.prevy = y;
            this.rebuildRequired = true;
            this.repaint();
        }
    }

    protected void validateCenter() {
        this.centery = Math.min(this.centeryMax, Math.max(this.centery, this.centeryMin));
        this.centerx = Math.min(this.centerxMax, Math.max(this.centerx, this.centerxMin));
    }

    public synchronized void mousePressed(MouseEvent e) {
        this.tipLocation = e.getPoint();
        this.tipText = null;
        this.tooltipTimer.restart();
        if (this.preMousePressed(e)) {
            // empty if block
        }
        this.postMousePressed(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean preMousePressed(MouseEvent e) {
        if (!this.ready) {
            return false;
        }
        boolean doubleClick = e.getClickCount() > 1;
        int x = e.getX();
        int y = e.getY();
        if (e.isPopupTrigger()) {
            if (this.popup == null) {
                this.popup = this.getDefaultPopupMenu();
            }
            this.setPopupLabels();
            this.resetroot.setEnabled(!this.isRootDefault());
            this.popup.show(e.getComponent(), x, y);
        } else {
            if (this.emptyPlot) {
                return false;
            }
            if (doubleClick) {
                Object object = this.lock;
                synchronized (object) {
                    if (!this.ready) {
                        this.interrupted = true;
                    }
                }
                if (this.resetNeeded) {
                    Thread resetThread = new Thread((Runnable)((Object)this), "resetThread");
                    resetThread.start();
                    this.resetNeeded = false;
                    return false;
                }
            }
        }
        this.pressX = this.prevx = x;
        this.pressY = this.prevy = y;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postMousePressed(MouseEvent e) {
        if (this.emptyPlot) {
            return;
        }
        boolean doubleClick = e.getClickCount() > 1;
        int x = e.getX();
        int y = e.getY();
        Object o = null;
        if (!doubleClick) {
            o = this.pick(x, y);
        }
        int mods = e.getModifiers();
        Object object = this.lock;
        synchronized (object) {
            if ((mods & 1) != 0) {
                this.extsel = true;
            }
            this.drag = false;
            this.lastPressNLDNode = this.pressNLDNode;
            this.pressNLDNode = null;
            if (o instanceof NLDNode) {
                this.pressNLDNode = (NLDNode)o;
                if (this.handleSelected) {
                    this.pressNLDNode = null;
                }
            }
            if (this.extsel) {
                if ((mods & 2) != 0) {
                    this.movenode = true;
                    this.extsel = false;
                    this.nodeMoved = true;
                } else {
                    this.select = true;
                }
            } else if ((mods & 8) != 0 && (mods & 2) != 0) {
                this.spread = true;
            } else if ((mods & 2) != 0) {
                this.zoom = true;
            } else if ((mods & 8) != 0) {
                this.rotate = true;
            } else {
                this.pan = true;
            }
        }
    }

    public synchronized void mouseReleased(MouseEvent e) {
        boolean doubleClick;
        if (this.applet != null) {
            this.applet.getAppletContext().showStatus("");
        }
        int x = e.getX();
        int y = e.getY();
        this.tooltipTimer.restart();
        this.tipText = null;
        if (this.tipLocation == null) {
            this.tipLocation = new Point();
        }
        this.tipLocation.x = e.getX();
        this.tipLocation.y = e.getY();
        this.brushActive = false;
        this.setCursor(this.actionMode);
        boolean bl = doubleClick = e.getClickCount() > 1;
        if (doubleClick) {
            return;
        }
        if (e.isPopupTrigger()) {
            if (this.handlePopup) {
                if (this.popup == null) {
                    this.popup = this.getDefaultPopupMenu();
                }
                this.setPopupLabels();
                this.resetroot.setEnabled(!this.isRootDefault());
                this.popup.show(e.getComponent(), x, y);
            }
            this.resetFlags();
            return;
        }
        if (this.emptyPlot) {
            return;
        }
        boolean build = false;
        if (!(this.drag || this.extsel || this.select)) {
            if (Math.abs(x - this.pressX) > 3 || Math.abs(y - this.pressY) > 3) {
                this.resetFlags();
                return;
            }
            Object o = this.pick(x, y);
            NLDNode relNLDNode = null;
            if (o instanceof NLDNode) {
                relNLDNode = (NLDNode)o;
            }
            if (relNLDNode != null && relNLDNode == this.pressNLDNode) {
                if (this.lens) {
                    this.startClickThread();
                }
                this.resetFlags();
                return;
            }
            if (!doubleClick && !this.deselAll) {
                this.model.deselectAll();
                this.deselAll = true;
                if (this.isInApplet()) {
                    this.buildSelected(null, 0, null, 0);
                }
                this.build();
                this.repaint();
            }
            this.resetFlags();
            this.showBackgroundURL(x, y);
            return;
        }
        if (this.select || this.extsel) {
            if (!this.extsel) {
                this.model.nodes.unselectAll(this.handleEvents);
            }
            int[] indices = null;
            int cntr = 0;
            this.channel.glRenderMode(1);
            if (this.drag) {
                int x1 = Math.min(x, this.pressX);
                int dx = Math.abs(x - this.pressX);
                int y1 = Math.min(y, this.pressY);
                int dy = Math.abs(y - this.pressY);
                this.channel.setPickAllHits(true);
                this.channel.gluPickMatrix(x1, y1, dx, dy);
                Stack hit = new Stack();
                this.channel.glSelectBuffer(hit);
                this.channel.glCallList(this.nodelist, true);
                this.channel.glRenderMode(0);
                this.channel.setPickAllHits(false);
                indices = new int[hit.size()];
                while (!hit.empty()) {
                    String name = (String)hit.pop();
                    if (name.equals("")) continue;
                    int index = new Integer(name.substring(1));
                    if (name.charAt(0) != 'N') continue;
                    indices[cntr++] = index;
                }
                this.myMouseAction = true;
                this.model.nodes.setSelected(indices, true, cntr, this.handleEvents);
                this.myMouseAction = false;
                if (this.isInApplet() && indices != null) {
                    int i;
                    int[] idx = new int[cntr + this.lastNumSelectedNodes];
                    int j = 0;
                    for (i = 0; i < this.lastNumSelectedNodes; ++i) {
                        idx[j++] = this.lastSelectedNodes[i];
                    }
                    for (i = 0; i < cntr; ++i) {
                        idx[j++] = indices[i];
                    }
                    this.buildSelected(idx, idx.length, null, 0);
                }
            } else {
                String name;
                int x1 = x;
                int y1 = y;
                int dy = 3;
                int dx = 3;
                this.channel.gluPickMatrix(x1, y1, dx, dy);
                Stack hit = new Stack();
                this.channel.glSelectBuffer(hit);
                this.channel.glCallList(this.nodelist, true);
                this.channel.glRenderMode(0);
                if (!hit.empty() && !(name = (String)hit.pop()).equals("")) {
                    int index = new Integer(name.substring(1));
                    if (name.charAt(0) == 'N') {
                        boolean newState = !this.model.nodes.isSelected(index);
                        this.model.nodes.setSelected(index, newState);
                        if (this.isInApplet()) {
                            if (newState) {
                                int[] idx = new int[1 + this.lastNumSelectedNodes];
                                int j = 0;
                                for (int i = 0; i < this.lastNumSelectedNodes; ++i) {
                                    idx[j++] = this.lastSelectedNodes[i];
                                }
                                idx[j++] = index;
                                this.buildSelected(idx, idx.length, null, 0);
                            } else if (this.lastNumSelectedNodes > 0) {
                                int[] idx = new int[this.lastNumSelectedNodes - 1];
                                int j = 0;
                                for (int i = 0; i < this.lastNumSelectedNodes; ++i) {
                                    if (this.lastSelectedNodes[i] == index) continue;
                                    idx[j++] = this.lastSelectedNodes[i];
                                }
                                this.buildSelected(idx, idx.length, null, 0);
                            } else {
                                this.buildSelected(null, 0, null, 0);
                            }
                        }
                    }
                }
            }
            this.repaint();
            this.deselAll = false;
            this.resetFlags();
            return;
        }
        if (build) {
            this.rebuild();
        }
        this.resetFlags();
    }

    protected void resetFlags() {
        super.resetFlags();
        this.spread = false;
        this.rotate = false;
    }

    public synchronized void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equalsIgnoreCase("hp_Applet")) {
            String title = this.GRS("AboutDialog.TitleText.txt", "SAS/GRAPH\u00ae 9.2 TreeView Applet");
            String version = null;
            if (this.aboutFrame == null) {
                if (this.sasIcon == null) {
                    this.sasIcon = new SASIcon((Component)((Object)this));
                }
                this.aboutFrame = new AboutFrame((Object)this.appRB, this.sasIcon, title, version, this.buildDate, this.useRBsizing);
            }
            if (!this.useRBsizing) {
                this.aboutFrame.setSize(350, 500);
            }
            this.aboutFrame.show();
            this.aboutFrame.toFront();
            return;
        }
        if (command.equalsIgnoreCase("hp_Help")) {
            try {
                URL url = new URL(this.applet.getCodeBase(), this.helpUrlString);
                this.applet.getAppletContext().showDocument(url, this.urlTarget);
            }
            catch (MalformedURLException url) {
                // empty catch block
            }
            return;
        }
        if (command.equalsIgnoreCase("hp_Mouse")) {
            String title = this.GRS("MouseDialog.Title.txt", "Mouse Help");
            if (this.mouseFrame == null) {
                String[] mouseActions = new String[]{this.GRS("MouseDialog.Key0.txt", "MOVE = Probe"), this.GRS("MouseDialog.Key1.txt", "CLICK (a node) = Brings the node to center"), this.GRS("MouseDialog.Key2.txt", "CLICK (outside a node) = Unselect all nodes"), this.GRS("MouseDialog.Key3.txt", "Shift + CLICK (a node) = Sel/Unsel the node"), this.GRS("MouseDialog.Key4.txt", "Shift + DRAG = Select all nodes inside the region"), this.GRS("MouseDialog.Key5.txt", "Shift + CTRL + DRAG = Move selected node(s)"), this.GRS("MouseDialog.Key6.txt", "DRAG = Panning/Shifting the focus"), this.GRS("MouseDialog.Key7.txt", "CTRL + DRAG = Zoom"), this.GRS("MouseDialog.Key8.txt", "ALT + DRAG = Rotate (About root)"), this.GRS("MouseDialog.Key9.txt", "CTRL + ALT + DRAG = Change Angular Spread"), this.GRS("MouseDialog.Key10.txt", "RIGHT = Popup Menu")};
                this.mouseFrame = new NLDMouseFrame(this.appRB, title, mouseActions, this.useRBsizing);
            }
            if (!this.useRBsizing) {
                this.mouseFrame.setSize(350, 280);
            }
            this.mouseFrame.show();
            this.mouseFrame.toFront();
            return;
        }
        if (command.equalsIgnoreCase("hp_SAS")) {
            try {
                URL url = new URL(this.applet.getDocumentBase(), "http://www.sas.com");
                this.applet.getAppletContext().showDocument(url, this.urlTarget);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            return;
        }
        if (command.equals("reset")) {
            this.reset();
        } else if (command.equalsIgnoreCase("showAll")) {
            this.showAll();
        } else if (command.equalsIgnoreCase("resetRoot")) {
            this.setRoot(this.defRootNode, true);
            this.diffRootSet = false;
        } else if (command.equalsIgnoreCase(this.nodeOptActionStrArray[0])) {
            if (this.context instanceof NLDNode) {
                this.diffRootSet = true;
                this.setRoot((NLDNode)this.context, false);
            }
        } else if (command.equals("selAll")) {
            this.selectAll();
        } else if (command.equals("filter")) {
            this.filter();
        } else {
            this.openURL(command);
        }
        this.context = null;
    }

    public void itemStateChanged(ItemEvent evt) {
        JCheckBoxMenuItem obj = (JCheckBoxMenuItem)evt.getSource();
        if (obj == null) {
            return;
        }
        String cmd = obj.getActionCommand();
        if (cmd.equals(this.nodeOptActionStrArray[3])) {
            this.hideSubtree(obj.getState());
        } else {
            this.selectSubtree(cmd.equals(this.nodeOptActionStrArray[2]), obj.getState(), true);
        }
        this.context = null;
    }

    public void reset() {
        this.setLensFactor(this.savedLensFactor);
        this.startAngle = this.savedStartAngle;
        this.spreadFactor = this.savedSpreadFactor;
        this.showAll();
        if (this.isNodeMoved()) {
            this.arrange();
        }
        if (!this.isDeselectAll()) {
            this.model.deselectAll();
            this.setDeselectAll(true);
        }
        this.nodeMoved = false;
        this.resetView(true);
    }

    public void showAll() {
        VectorNodeModel nodes = this.model.nodes;
        nodes.setShowAll();
        this.analyze();
        this.rearrange();
        this.buildSelected();
        this.repaint();
    }

    private void hideSubtree(boolean state) {
        if (this.context == null || !(this.context instanceof NLDNode)) {
            return;
        }
        this.hideSubtree(this.context, state);
        this.buildSelected();
        this.build();
        this.repaint();
    }

    public void hideSubtree(Object id, boolean state) {
        NLDNode n = null;
        n = id instanceof NLDNode ? (NLDNode)id : this.model.nodes.getNode(id);
        if (n == null) {
            return;
        }
        this.hideSubtree(n.getIndex(), state);
        this.model.nodes.setVisible(n.getIndex(), true);
        this.rearrange();
    }

    private void selectSubtree(boolean tree, boolean state, boolean update) {
        if (this.context == null || !(this.context instanceof NLDNode)) {
            return;
        }
        this.setSelected((NLDNode)this.context, tree, state, update);
    }

    public void setSelected(Object id, boolean tree, boolean state, boolean update) {
        NLDNode n = null;
        n = id instanceof NLDNode ? (NLDNode)id : this.model.nodes.getNode(id);
        if (n == null) {
            return;
        }
        this.setSelected(n, tree, state, update);
    }

    public void setCenterNode(Object id) {
        NLDNode n = null;
        n = id instanceof NLDNode ? (NLDNode)id : this.model.nodes.getNode(id);
        if (n == null) {
            return;
        }
        this.rebuild();
        this.centerNode(n, false);
    }

    public void rebuild() {
        this.build();
        this.buildSelected();
        this.repaint();
    }

    public void setSelectCenter(Object id, boolean animate) {
        NLDNode n = null;
        n = id instanceof NLDNode ? (NLDNode)id : this.model.nodes.getNode(id);
        if (n == null) {
            return;
        }
        this.setSelected(id, false, true, true);
        this.deselAll = false;
        this.rebuild();
        if (animate) {
            this.centerNode(n, false);
        } else {
            this.centerNode(n);
        }
    }

    public Object pick(int x, int y) {
        this.context = super.pick(x, y);
        return this.context;
    }

    public Object getCurrentContext() {
        return this.context;
    }

    public boolean isSubtreeSelected(Object obj) {
        NLDNode n = this.getNode(obj);
        return this.isSubtreeSelected(n.getIndex());
    }

    public boolean isRootDefault() {
        return this.root == this.defRoot;
    }

    private void setSelected(NLDNode n, boolean tree, boolean state, boolean update) {
        int i;
        this.setSelected(n, state);
        if (state) {
            this.setDeselectAll(false);
        }
        if (tree) {
            i = n.getIndex();
            int nk = this.kids[i].size();
            for (int k = 0; k < nk; ++k) {
                int ki = (Integer)this.kids[i].elementAt(k);
                NLDNode kid = (NLDNode)this.model.nodes.elementAt(ki);
                this.setSelected(kid, true, state, false);
            }
        }
        if (update && this.isInApplet()) {
            this.build();
            Hashtable<Integer, Integer> selNodes = new Hashtable<Integer, Integer>();
            for (i = 0; i < this.numNodes; ++i) {
                if (!this.model.nodes.isSelected(i)) continue;
                Integer idx = new Integer(i);
                selNodes.put(idx, idx);
            }
            if (selNodes.size() > 0) {
                int[] idx = new int[selNodes.size()];
                int j = 0;
                Enumeration e = selNodes.elements();
                while (e != null && e.hasMoreElements()) {
                    idx[j++] = (Integer)e.nextElement();
                }
                this.buildSelected(idx, idx.length, null, 0);
            } else {
                this.buildSelected(null, 0, null, 0);
            }
            this.repaint();
        }
    }

    public void load() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setBounds(this.getBounds());
        this.numNodes = this.model.getNumNodes();
        this.numLinks = this.model.getNumLinks();
        if (this.numNodes == 0 && this.numLinks == 0) {
            boolean ok = this.model.loadModel((NLDViewer)this);
            if (!ok) {
                this.emptyPlot = true;
                this.numLinks = 0;
                this.numNodes = 0;
                this.setCursor(Cursor.getDefaultCursor());
                if (this.applet != null) {
                    this.applet.getAppletContext().showStatus("");
                }
                return;
            }
            this.numNodes = this.model.getNumNodes();
            this.numLinks = this.model.getNumLinks();
        }
        if (this.numNodes <= 0) {
            this.emptyPlot = true;
            return;
        }
        this.emptyPlot = false;
        if (this.emptyPlot) {
            return;
        }
        this.setNodeAttr();
        this.setArcAttr();
        this.enhance();
        if (this.applet != null) {
            this.applet.getAppletContext().showStatus(this.GRS("StatusText.Processing.txt", "Processing tree..."));
        }
        this.analyze();
        this._setInitialState();
        this.arrange();
        for (int i = 0; i < this.numNodes; ++i) {
            NLDNode n = (NLDNode)this.model.nodes.elementAt(i);
            if (n.getColor() != null) continue;
            if (this.parent[n.getIndex()] == -1) {
                n.setColor(this.rootColor);
                this.setNodeBorderColor(n, Color.black);
                continue;
            }
            n.setColor(this.nodeColor);
            this.setNodeBorderColor(n, this.nodeBorderColor);
        }
        if (this.applet != null) {
            this.applet.getAppletContext().showStatus(this.GRS("StatusText.Drawing.txt", "Drawing tree..."));
        }
        if (this.cutoff == -1.0) {
            switch (this.maxDepth) {
                case 0: 
                case 1: 
                case 2: {
                    this.setRadialCutoffFactor(0.5 + 0.5 * Math.min(1.0, 50.0 / (double)this.numNodes));
                    break;
                }
                default: {
                    this.setRadialCutoffFactor(2.0 / (double)this.maxDepth);
                }
            }
        }
        if (this.lensFactor == -1.0) {
            switch (this.maxDepth) {
                case 0: 
                case 1: {
                    this.setLensFactor(0.01);
                    break;
                }
                case 2: {
                    this.setLensFactor(Math.max(0.01, Math.min(1.0, (double)this.numNodes / 100.0)));
                    break;
                }
                default: {
                    this.setLensFactor(Math.max(1.0, Math.min(8.0, Math.pow(this.numNodes, 0.1))));
                }
            }
        }
        if (this.applet != null) {
            this.document = this.applet.getDocumentBase();
            this.code = this.applet.getCodeBase();
            this.applet.getAppletContext().showStatus("");
        }
        if (this.DEBUG) {
            String messagePattern = this.GRS("StatusText.NumberOfNodes.fmt.txt", "number of nodes={0}");
            String formattedMessg = MessageFormat.format(messagePattern, this.numNodes);
            System.out.println(formattedMessg);
        }
        this.rebuildRequired = true;
        this.build();
        this.buildSelected();
        this.repaint();
        this.setCursor(Cursor.getDefaultCursor());
        this.ready = true;
    }

    private void _hideSubtree(int index) {
        this.model.nodes.setVisible(index, false);
        this.model.nodes.setCollapsed(index, true);
        int nk = this.kids[index].size();
        if (nk == 0) {
            return;
        }
        for (int k = 0; k < nk; ++k) {
            int ki = (Integer)this.kids[index].elementAt(k);
            this._hideSubtree(ki);
        }
    }

    private void _setInitialState() {
        int i;
        VectorNodeModel nodes = this.model.nodes;
        this.model.links.setShowAll();
        for (i = 0; i < this.numNodes; ++i) {
            this.viskids[i].removeAllElements();
            if (!nodes.isVisible(i)) continue;
            if (nodes.isCollapsed(i)) {
                this._hideSubtree(i);
                nodes.setVisible(i, true);
                continue;
            }
            for (int j = 0; j < this.kids[i].size(); ++j) {
                Integer kid = (Integer)this.kids[i].elementAt(j);
                if (!nodes.isVisible(kid.intValue())) continue;
                this.viskids[i].addElement(kid);
            }
        }
        for (i = 0; i < this.numNodes; ++i) {
            this.numLeaves[i] = 0;
            this.depth[i] = -1;
        }
        this.maxDepth = 0;
        this.setDepth(this.root, 0);
        if (this.DEBUG) {
            String messagePattern = this.GRS("StatusText.maxDepth.fmt.txt", "maximum depth={0}");
            String formattedMessg = MessageFormat.format(messagePattern, this.maxDepth);
            System.out.println(formattedMessg);
        }
        int tot = this.getLeaves(this.root);
        if (this.DEBUG) {
            String messagePattern = this.GRS("StatusText.totalLeaves.fmt.txt", "total leaves={0}");
            String formattedMessg = MessageFormat.format(messagePattern, tot);
            System.out.println(formattedMessg);
        }
        double zoomfac = Math.min(1.0, Math.max(1.0E-8, 30.0 / Math.sqrt(tot)));
        this.setDefaultZoom(zoomfac);
    }

    private void initLinkMinMaxColorWidth() {
        double colval;
        double linkWidth;
        VectorLinkModel links = this.model.links;
        this.numLinks = links.size();
        if (this.numLinks <= 0) {
            return;
        }
        this.linkColors = new Color[this.numLinks];
        this.linkWidths = new double[this.numLinks];
        double maxWidthValVal = linkWidth = links.getNumValue(5, 0);
        double minWidthValVal = linkWidth;
        double maxColVal = colval = links.getNumValue(10, 0);
        double minColVal = colval;
        for (int i = 0; i < this.numLinks; ++i) {
            linkWidth = links.getNumValue(5, i);
            minWidthValVal = Math.min(minWidthValVal, linkWidth);
            maxWidthValVal = Math.max(maxWidthValVal, linkWidth);
            colval = links.getNumValue(10, i);
            minColVal = Math.min(minColVal, colval);
            maxColVal = Math.max(maxColVal, colval);
        }
        this.minLColVal = minColVal;
        this.maxLColVal = maxColVal;
        this.minLWidthVal = minWidthValVal;
        this.maxLWidthVal = maxWidthValVal;
    }

    private void initNodeMinMaxColor() {
        double maxColVal;
        VectorNodeModel nodes = this.model.nodes;
        this.numNodes = nodes.size();
        if (this.numNodes <= 0) {
            return;
        }
        this.nodeColors = new Color[this.numNodes];
        double minColVal = maxColVal = nodes.getNumValue(16, 0);
        for (int i = 1; i < this.numNodes; ++i) {
            double colval = nodes.getNumValue(16, i);
            minColVal = Math.min(minColVal, colval);
            maxColVal = Math.max(maxColVal, colval);
        }
        if (minColVal == Double.MAX_VALUE && maxColVal == Double.MIN_VALUE) {
            maxColVal = minColVal;
        }
        this.minNColVal = minColVal;
        this.maxNColVal = maxColVal;
    }

    protected void setLinkWidth(int ind) {
        double scaledWidth;
        VectorLinkModel links = this.model.links;
        double width = links.getNumValue(5, ind);
        if (this.widthMapLinks) {
            if (this.minLWidthVal == this.maxLWidthVal) {
                scaledWidth = 3.0;
            } else if (this.scaleLinkWidth) {
                scaledWidth = 1.0 * (width - this.minLWidthVal) / (this.maxLWidthVal - this.minLWidthVal);
                scaledWidth = this.defaultLinkWidth + scaledWidth * this.defaultLinkWidthIncrease;
            } else {
                scaledWidth = width;
            }
        } else {
            scaledWidth = this.linkWidth;
        }
        this.linkWidths[ind] = scaledWidth;
        links.setWidth(ind, this.linkWidths[ind]);
    }

    protected void setNodeColor(int ind) {
        VectorNodeModel nodes = this.model.nodes;
        NLDNode n = (NLDNode)nodes.elementAt(ind);
        double colval = nodes.getNumValue(16, ind);
        double scaledColVal = 0.0;
        if (this.colmapNodes) {
            scaledColVal = this.maxNColVal == this.minNColVal ? 1.0 : 1.0 * (colval - this.minNColVal) / (this.maxNColVal - this.minNColVal);
            Color nColor = n.getColor();
            this.nodeColors[ind] = nColor == null ? this.colmap(scaledColVal) : nColor;
            nodes.setColor(ind, this.nodeColors[ind]);
        } else if (n.getColor() == null) {
            this.nodeColors[ind] = this.nodeColor;
            nodes.setColor(ind, this.nodeColor);
        }
    }

    protected void setLinkColor(int ind) {
        VectorLinkModel links = this.model.links;
        NLDLink l = (NLDLink)links.elementAt(ind);
        double colval = links.getNumValue(10, ind);
        double scaledColVal = 0.0;
        if (this.colmapLinks) {
            scaledColVal = this.maxLColVal == this.minLColVal ? 1.0 : 1.0 * (colval - this.minLColVal) / (this.maxLColVal - this.minLColVal);
            Color lColor = l.getColor();
            this.linkColors[ind] = lColor == null ? this.colmap(scaledColVal) : lColor;
            links.setColor(ind, this.linkColors[ind]);
        } else if (l.getColor() == null) {
            this.linkColors[ind] = this.linkColor;
            links.setColor(ind, this.linkColor);
        }
    }

    private void setNodeAttr() {
        this.setTextValign(1);
        this.setHalign(1);
        this.initNodeMinMaxColor();
        for (int i = 0; i < this.numNodes; ++i) {
            NLDNode n = (NLDNode)this.model.nodes.elementAt(i);
            n.setType(4);
            this.setNodeColor(i);
            n.setShowLabel(this.showLabels);
            n.setTextColor(this.textColor);
            n.setSelectColor(this.selectColor);
            if (n.getLabel() != null) continue;
            n.setLabel(" ");
        }
    }

    public void setScaleLinkWidth(boolean flag) {
        this.scaleLinkWidth = flag;
    }

    public boolean isScaleLinkWidth() {
        return this.scaleLinkWidth;
    }

    protected void setArcAttr() {
        this.initLinkMinMaxColorWidth();
        for (int i = 0; i < this.numLinks; ++i) {
            this.setLinkColor(i);
            this.setLinkWidth(i);
        }
    }

    private void resetArcAttr() {
        this.showAllLinks();
    }

    private void enhance() {
        int i;
        VectorNodeModel nodes = this.model.nodes;
        this.kids = new Vector[this.numNodes];
        this.parent = new int[this.numNodes];
        for (int i2 = 0; i2 < this.numNodes; ++i2) {
            this.kids[i2] = new Vector();
            this.parent[i2] = -1;
        }
        for (i = 0; i < this.numLinks; ++i) {
            NLDLink a = (NLDLink)this.model.links.elementAt(i);
            if (!a.isVisible()) continue;
            int to = a.getToIndex();
            int from = a.getFromIndex();
            if (to < 0 || from < 0 || to >= this.numNodes || from >= this.numNodes || this.parent[to] >= this.numNodes || this.parent[from] >= this.numNodes || to == from) {
                a.setCulled(true);
                if (!this.DEBUG) continue;
                System.out.println(this.GRS("StatusText.linkFrom.txt", "Link from ") + from + this.GRS("StatusText.to.txt", " to ") + to + this.GRS("StatusText.isIgnored1.txt", " is invalid and therefore ignored."));
                continue;
            }
            if (this.parent[to] == -1) {
                int anchester = from;
                boolean cycle = false;
                while (!cycle && this.parent[anchester] != -1) {
                    if (this.parent[anchester] == to) {
                        cycle = true;
                        continue;
                    }
                    anchester = this.parent[anchester];
                }
                if (cycle) {
                    if (this.DEBUG) {
                        System.out.println(this.GRS("StatusText.linkFrom.txt", "Link from ") + from + this.GRS("StatusText.to.txt", " to ") + to + this.GRS("StatusText.isIgnored2.txt", " creates cycle and therefore ignored."));
                    }
                    a.setCulled(true);
                    continue;
                }
                this.parent[to] = from;
                this.kids[from].addElement(new Integer(to));
                continue;
            }
            if (this.DEBUG) {
                System.out.println(this.GRS("StatusText.linkFrom.txt", "Link from ") + from + this.GRS("StatusText.to.txt", " to ") + to + this.GRS("StatusText.isIgnored3.txt", " creates multiple parents for ") + to + this.GRS("StatusText.isIgnored4.txt", " and therefore ignored."));
            }
            a.setCulled(true);
        }
        this.viskids = new Vector[this.numNodes];
        for (i = 0; i < this.numNodes; ++i) {
            this.viskids[i] = new Vector();
            for (int j = 0; j < this.kids[i].size(); ++j) {
                Integer kid = (Integer)this.kids[i].elementAt(j);
                NLDNode n = (NLDNode)nodes.elementAt(kid.intValue());
                if (!n.isVisible()) continue;
                int nIdx = n.getIndex();
                if (nIdx >= 0 && nIdx < nodes.size() && this.isSubtreeHidden(nIdx)) {
                    this.hideSubtree(n.getIndex(), true);
                }
                this.viskids[i].addElement(kid);
                n.setVisible(true);
            }
        }
    }

    private void analyze() {
        int i;
        if (this.applet != null) {
            this.applet.getAppletContext().showStatus(this.GRS("StatusText.analyzingTree.txt", "Analyzing tree..."));
        }
        Vector<Integer> roots = new Vector<Integer>();
        for (i = 0; i < this.numNodes; ++i) {
            if (this.parent[i] != -1) continue;
            if (roots.size() == 0) {
                this.root = i;
            }
            roots.addElement(new Integer(i));
        }
        this.defRoot = this.root;
        this.defRootNode = this.rootNode = (NLDNode)this.model.nodes.elementAt(this.root);
        if (roots.size() > 1) {
            int pr = 0;
            if (this.DEBUG) {
                System.out.println(this.GRS("StatusText.forest.txt", "Multiple roots, graph is a forest."));
                System.out.println(this.GRS("StatusText.onlyTree.txt", "Only the tree with Root ") + this.rootNode.getID() + this.GRS("StatusText.isDisplayed.txt", " is displayed."));
                System.out.println(this.GRS("StatusText.notDisplayed.txt", "The tree(s) not displayed are:"));
            }
            for (int i2 = 1; i2 < roots.size(); ++i2) {
                pr = (Integer)roots.elementAt(i2);
                this.hideSubtree(pr, true);
                if (!this.DEBUG) continue;
                System.out.println(this.GRS("StatusText.forest.txt", "\tRoot ") + i2 + this.GRS("StatusText.id.txt", " ID: ") + this.model.nodes.getStringValue(0, pr));
            }
        }
        if (!(this.rootNode.getColor() != null || this.colmap && this.numCols != 0 || this.rootNode.getColor() != null && this.rootNode.getColor() != this.nodeColor)) {
            this.rootNode.setColor(this.rootColor);
            this.setNodeBorderColor(this.rootNode, Color.black);
        }
        this.numLeaves = new int[this.numNodes];
        this.depth = new int[this.numNodes];
        for (i = 0; i < this.numNodes; ++i) {
            this.numLeaves[i] = 0;
            this.depth[i] = -1;
        }
        this.maxDepth = 0;
        this.setDepth(this.root, 0);
        if (this.DEBUG) {
            String messagePattern = this.GRS("StatusText.maxDepth.fmt.txt", "maximum depth={0}");
            String formattedMessg = MessageFormat.format(messagePattern, this.maxDepth);
            System.out.println(formattedMessg);
        }
        int tot = this.getLeaves(this.root);
        if (this.DEBUG) {
            String messagePattern = this.GRS("StatusText.totalLeaves.fmt.txt", "total leaves={0}");
            String formattedMessg = MessageFormat.format(messagePattern, tot);
            System.out.println(formattedMessg);
        }
        double zoomfac = Math.min(1.0, Math.max(1.0E-8, 30.0 / Math.sqrt(tot)));
        this.setDefaultZoom(zoomfac);
    }

    private void rearrange() {
        int i;
        VectorNodeModel nodes = this.model.nodes;
        this.resetArcAttr();
        for (i = 0; i < this.numNodes; ++i) {
            this.viskids[i].removeAllElements();
            for (int j = 0; j < this.kids[i].size(); ++j) {
                Integer kid = (Integer)this.kids[i].elementAt(j);
                if (!nodes.isVisible(kid.intValue())) continue;
                this.viskids[i].addElement(kid);
            }
        }
        for (i = 0; i < this.numNodes; ++i) {
            this.numLeaves[i] = 0;
            this.depth[i] = -1;
        }
        this.maxDepth = 0;
        this.setDepth(this.root, 0);
        if (this.DEBUG) {
            String messagePattern = this.GRS("StatusText.maxDepth.fmt.txt", "maximum depth={0}");
            String formattedMessg = MessageFormat.format(messagePattern, this.maxDepth);
            System.out.println(formattedMessg);
        }
        int tot = this.getLeaves(this.root);
        if (this.DEBUG) {
            String messagePattern = this.GRS("StatusText.totalLeaves.fmt.txt", "total leaves={0}");
            String formattedMessg = MessageFormat.format(messagePattern, tot);
            System.out.println(formattedMessg);
        }
        double zoomfac = Math.min(1.0, Math.max(1.0E-8, 30.0 / Math.sqrt(tot)));
        this.setDefaultZoom(zoomfac);
        this.arrange();
        if (this.applet != null) {
            this.applet.getAppletContext().showStatus(this.GRS("StatusText.drawingTree.txt", "Drawing tree..."));
        }
        this.build();
        this.repaint();
        if (this.applet != null) {
            this.applet.getAppletContext().showStatus("");
        }
    }

    private void arrange() {
        if (this.applet != null) {
            this.applet.getAppletContext().showStatus(this.GRS("StatusText.placingNodes.txt", "Placing nodes..."));
        }
        if (this.model.nodes.isVisible(this.root)) {
            this.place(this.root, this.startAngle, this.span);
            this.setCenter();
        }
        if (this.applet != null) {
            this.applet.getAppletContext().showStatus("");
        }
    }

    private void place(int i, double ang, double span) {
        if (!this.model.nodes.isVisible(i)) {
            return;
        }
        double[] loc = this.computeCoordinates(i, ang, span);
        this.model.nodes.setCurLoc(i, loc[0], loc[1]);
        int NL = this.numLeaves[i];
        double next = ang - span / 2.0;
        int nk = this.viskids[i].size();
        double aks = span / (double)nk;
        if (nk == 0) {
            return;
        }
        if (nk == 1) {
            double kspan;
            int ki = (Integer)this.viskids[i].elementAt(0);
            int nl = this.numLeaves[ki];
            if (nl == 1) {
                kspan = 0.0;
            } else {
                kspan = span * (double)nl / (double)NL;
                kspan += this.smooth * (aks - kspan);
            }
            this.place(ki, ang, kspan / 2.0);
        } else {
            for (int k = 0; k < nk; ++k) {
                int ki = (Integer)this.viskids[i].elementAt(k);
                int nl = this.numLeaves[ki];
                double kspan = span * (double)nl / (double)NL;
                kspan += this.smooth * (aks - kspan);
                double kang = next + kspan / 2.0;
                this.place(ki, kang, kspan);
                next = kang + kspan / 2.0;
            }
        }
    }

    private double[] computeCoordinates(int i, double ang, double span) {
        double outer = 0.95;
        double radius = 0.0;
        if (this.maxDepth > 0) {
            int path = this.maxPath == -1 ? this.maxDepth : Math.min(this.maxDepth, this.maxPath);
            radius = outer * (double)this.depth[i] / (double)path;
        }
        double[] newCoords = new double[2];
        switch (this.dir) {
            default: {
                newCoords[0] = radius * Math.cos(ang);
                newCoords[1] = radius * Math.sin(ang);
                break;
            }
            case 4: {
                newCoords[0] = radius * Math.cos(ang);
                newCoords[1] = radius * Math.sin(ang);
                break;
            }
            case 3: {
                newCoords[0] = radius * Math.cos(ang);
                newCoords[1] = radius * Math.sin(ang);
                break;
            }
            case 1: {
                newCoords[0] = radius * Math.cos(ang);
                newCoords[1] = radius * Math.sin(ang);
                break;
            }
            case 2: {
                newCoords[0] = radius * Math.cos(ang);
                newCoords[1] = radius * Math.sin(ang);
            }
        }
        return newCoords;
    }

    private boolean isParent(NLDNode n) {
        return this.kids[n.getIndex()].size() > 0;
    }

    private void hideSubtree(int index, boolean hide) {
        if (index == -1) {
            return;
        }
        this.model.nodes.setVisible(index, !hide);
        int nk = this.kids[index].size();
        if (nk == 0) {
            return;
        }
        for (int k = 0; k < nk; ++k) {
            int ki = (Integer)this.kids[index].elementAt(k);
            this.hideSubtree(ki, hide);
        }
        this.model.nodes.setCollapsed(index, hide);
    }

    private void setRoot(NLDNode n, boolean reset) {
        int i;
        VectorNodeModel nodes = this.model.nodes;
        if (reset) {
            nodes.setShowAll();
            this.rootNode = this.defRootNode;
            this.root = this.defRoot;
            Vector<Integer> roots = new Vector<Integer>();
            for (int i2 = 0; i2 < this.numNodes; ++i2) {
                if (this.parent[i2] != -1) continue;
                roots.addElement(new Integer(i2));
            }
            if (roots.size() > 1) {
                int pr = 0;
                for (int i3 = 1; i3 < roots.size(); ++i3) {
                    pr = (Integer)roots.elementAt(i3);
                    this.hideSubtree(pr, true);
                }
            }
        } else {
            for (int i4 = 0; i4 < this.numNodes; ++i4) {
                nodes.setVisible(i4, false);
            }
            this.rootNode = n;
            this.root = n.getIndex();
            this.hideSubtree(this.root, false);
        }
        this.resetArcAttr();
        for (i = 0; i < this.numNodes; ++i) {
            this.viskids[i].removeAllElements();
            for (int j = 0; j < this.kids[i].size(); ++j) {
                Integer kid = (Integer)this.kids[i].elementAt(j);
                if (!nodes.isVisible(kid.intValue())) continue;
                this.viskids[i].addElement(kid);
            }
        }
        for (i = 0; i < this.numNodes; ++i) {
            this.numLeaves[i] = 0;
            this.depth[i] = -1;
        }
        this.maxDepth = 0;
        this.setDepth(this.root, 0);
        if (this.DEBUG) {
            String messagePattern = this.GRS("StatusText.maxDepth.fmt.txt", "maximum depth={0}");
            String formattedMessg = MessageFormat.format(messagePattern, this.maxDepth);
            System.out.println(formattedMessg);
        }
        int tot = this.getLeaves(this.root);
        if (this.DEBUG) {
            String messagePattern = this.GRS("StatusText.totalLeaves.fmt.txt", "total leaves={0}");
            String formattedMessg = MessageFormat.format(messagePattern, tot);
            System.out.println(formattedMessg);
        }
        double zoomfac = Math.min(1.0, Math.max(1.0E-8, 30.0 / Math.sqrt(tot)));
        this.setDefaultZoom(zoomfac);
        this.arrange();
        if (this.applet != null) {
            this.applet.getAppletContext().showStatus(this.GRS("StatusText.drawingTree.txt", "Drawing tree..."));
        }
        this.centerx = n.getCurXPosition();
        this.centery = n.getCurYPosition();
        this.channel.gluLookAt(this.centerx, this.centery, 0.0, 0.5, 0.0, 0.0, 0.0);
        this.rebuild();
        if (this.applet != null) {
            this.applet.getAppletContext().showStatus("");
        }
    }

    private boolean isSubtreeHidden(int index) {
        int nk = this.kids[index].size();
        if (nk == 0) {
            return false;
        }
        for (int k = 0; k < nk; ++k) {
            int ki = (Integer)this.kids[index].elementAt(k);
            if (!this.model.nodes.isVisible(ki)) continue;
            return false;
        }
        return true;
    }

    private int getLeaves(int i) {
        int nl;
        if (!this.model.nodes.isVisible(i)) {
            nl = 0;
        } else if (this.viskids[i].size() == 0) {
            nl = 1;
        } else {
            nl = 0;
            for (int k = 0; k < this.viskids[i].size(); ++k) {
                int ki = (Integer)this.viskids[i].elementAt(k);
                nl += this.getLeaves(ki);
            }
        }
        this.numLeaves[i] = nl;
        return nl;
    }

    private void setDepth(int i, int d) {
        if (d > this.maxDepth) {
            this.maxDepth = d;
        }
        this.depth[i] = d;
        if (!this.model.nodes.isVisible(i)) {
            return;
        }
        for (int k = 0; k < this.viskids[i].size(); ++k) {
            int ki = (Integer)this.viskids[i].elementAt(k);
            this.setDepth(ki, d + 1);
        }
    }

    private void openURL(String str) {
        this.openActionURL(this.context, str);
        this.context = null;
    }

    private boolean isSubtreeSelected(int index) {
        boolean selected = this.model.nodes.isSelected(index);
        if (!selected) {
            return false;
        }
        int i = index;
        int nk = this.kids[i].size();
        int k = 0;
        while (k < nk & selected) {
            int ki = (Integer)this.kids[i].elementAt(k);
            selected = this.isSubtreeSelected(ki);
            ++k;
        }
        return selected;
    }

    public void setPopupLabels() {
        if (this.context instanceof NLDNode) {
            NLDNode n = (NLDNode)this.context;
            int index = n.getIndex();
            String[] str = this.getCustomActionString(n);
            if (this.open != null) {
                this.open.removeActionListener((ActionListener)((Object)this));
                if (str != null && str.length >= 1) {
                    this.open.removeAll();
                    for (int count = 0; count < str.length && str[count] != null; ++count) {
                        JMenuItem jm = new JMenuItem();
                        jm.setText(str[count]);
                        jm.removeActionListener((ActionListener)((Object)this));
                        jm.addActionListener((ActionListener)((Object)this));
                        String num = "" + count;
                        jm.setActionCommand(num);
                        this.open.add(jm);
                    }
                    this.open.setEnabled(true);
                } else {
                    this.open.setEnabled(false);
                }
                this.open.addActionListener((ActionListener)((Object)this));
            }
            this.setroot.removeActionListener((ActionListener)((Object)this));
            this.setroot.setEnabled(index != this.root && this.isParent(n));
            this.setroot.addActionListener((ActionListener)((Object)this));
            this.selN.removeItemListener((ItemListener)((Object)this));
            this.selN.setEnabled(true);
            this.selN.setState(this.isSelected(n));
            this.selN.addItemListener((ItemListener)((Object)this));
            this.selT.removeItemListener((ItemListener)((Object)this));
            this.selT.setEnabled(true);
            this.selT.setState(this.isSubtreeSelected(n));
            this.selT.addItemListener((ItemListener)((Object)this));
            this.hideT.removeItemListener((ItemListener)((Object)this));
            this.hideT.setEnabled(index != this.root && this.isParent(n));
            this.hideT.setState(this.isSubtreeHidden(n.getIndex()));
            this.hideT.addItemListener((ItemListener)((Object)this));
        } else {
            for (int m = 0; m < this.csm.length; ++m) {
                if (this.csm[m] == null) continue;
                this.csm[m].removeActionListener((ActionListener)((Object)this));
                this.csm[m].setEnabled(false);
                this.csm[m].addActionListener((ActionListener)((Object)this));
            }
        }
        this.resetroot.removeActionListener((ActionListener)((Object)this));
        this.resetroot.setEnabled(this.diffRootSet);
        this.resetroot.addActionListener((ActionListener)((Object)this));
    }

    public void setHandlePopup(boolean val) {
        this.handlePopup = val;
    }

    public void setBuildDate(String bldDate) {
        if (bldDate != null) {
            this.buildDate = bldDate;
        }
    }

    public void setNodeBorderColor(Color c) {
        if (c == null) {
            return;
        }
        this.nodeBorderColor = c;
    }

    public void setNodeBorderColor(Color c, boolean applyToNodes) {
        this.setNodeBorderColor(c);
        if (applyToNodes && this.model.nodes != null) {
            for (int i = 0; i < this.numNodes; ++i) {
                NLDNode n = (NLDNode)this.model.nodes.elementAt(i);
                this.setNodeBorderColor(n, c);
            }
        }
    }

    public void setLinkWidths() {
        VectorLinkModel links = this.model.links;
        int numLinks = links.size();
        for (int i = 0; i < numLinks; ++i) {
            links.setWidth(i, this.linkWidths[i]);
        }
    }

    public void setMenuItems(JMenuItem mi) {
        if (mi.getActionCommand().equalsIgnoreCase(this.nodeOptActionStrArray[0])) {
            this.setroot = mi;
        } else if (mi.getActionCommand().equalsIgnoreCase(this.nodeOptActionStrArray[1])) {
            this.selN = (JCheckBoxMenuItem)mi;
        } else if (mi.getActionCommand().equalsIgnoreCase(this.nodeOptActionStrArray[2])) {
            this.selT = (JCheckBoxMenuItem)mi;
        } else if (mi.getActionCommand().equalsIgnoreCase(this.nodeOptActionStrArray[3])) {
            this.hideT = (JCheckBoxMenuItem)mi;
        }
    }

    public void setNodeOptionActionArray(String[] actionCmd) {
        for (int i = 0; i < actionCmd.length; ++i) {
            this.nodeOptActionStrArray[i] = actionCmd[i];
        }
    }

    public Object getId() {
        if (this.id == null) {
            this.id = "TreeView";
        }
        return this.id;
    }
}

