/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.treeview;

import com.sas.graphics.silk.event.DrilldownEvent;
import com.sas.graphics.silk.event.DrilldownListenerInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.treeview.TreeViewer;
import com.sas.graphics.silk.util.nld.DataFilterLinkModel;
import com.sas.graphics.silk.util.nld.DataFilterNodeModel;
import com.sas.graphics.silk.util.nld.DvrLink;
import com.sas.graphics.util.SASLinePatterns;
import com.sas.graphics.util.nld.NLD;
import com.sas.graphics.util.nld.NLDLink;
import com.sas.graphics.util.nld.NLDModel;
import com.sas.graphics.util.nld.NLDNode;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Vector;

public class DataFilterTreeViewer
extends TreeViewer {
    private static final long serialVersionUID = 339950100464581087L;
    private static final int NUM_LINE_STYLES = 7;
    private static final int LINE_STYLE_SOLID = 0;
    private static final int LINE_STYLE_DASH = 4;
    private static final int LINE_STYLE_DOT_DENSE = 11;
    private static final int LINE_STYLE_DASH_DOT = 5;
    private static final int LINE_STYLE_DOT_3_DASH_MEDIUM = 10;
    private static final int LINE_STYLE_DOT_THIN = 13;
    private static final int LINE_STYLE_DASH_LONG = 3;
    protected Vector drillDownListeners = new Vector();
    protected NLDNode drillNLDNode = null;
    private Hashtable groups = new Hashtable();

    public DataFilterTreeViewer() {
        this.initActionCmds();
    }

    public DataFilterTreeViewer(NLDModel m) {
        super(m);
        this.initActionCmds();
    }

    private void initActionCmds() {
        String[] nodeOptActionStrArray = new String[]{"NLD_SET_ROOT", "NLD_SELECT_NODE", "NLD_SELECT_SUB_TREE", "NLD_HIDE_SUB_TREE"};
        this.setNodeOptionActionArray(nodeOptActionStrArray);
    }

    public Color colmap(double val) {
        double blue;
        double green;
        double red;
        if (val < 0.0 || val > 1.0) {
            return this.rampColors[0];
        }
        super.colmap(val);
        int r1 = this.rampColors[0].getRed();
        int g1 = this.rampColors[0].getGreen();
        int b1 = this.rampColors[0].getBlue();
        int r2 = this.rampColors[1].getRed();
        int g2 = this.rampColors[1].getGreen();
        int b2 = this.rampColors[1].getBlue();
        int r3 = this.rampColors[2].getRed();
        int g3 = this.rampColors[2].getGreen();
        int b3 = this.rampColors[2].getBlue();
        if (val >= 0.5) {
            red = (double)r1 + (double)(r2 - r1) * (1.0 - val) * 2.0;
            green = (double)g1 + (double)(g2 - g1) * (1.0 - val) * 2.0;
            blue = (double)b1 + (double)(b2 - b1) * (1.0 - val) * 2.0;
        } else {
            red = (double)r2 + (double)(r3 - r2) * (0.5 - val) * 2.0;
            green = (double)g2 + (double)(g3 - g2) * (0.5 - val) * 2.0;
            blue = (double)b2 + (double)(b3 - b2) * (0.5 - val) * 2.0;
        }
        int ir = (int)red;
        int ig = (int)green;
        int ib = (int)blue;
        return new Color(ir, ig, ib);
    }

    @Override
    protected void createChannel() {
        super.createChannel();
        this.build();
        this.repaint();
    }

    public void removeDrillDownListener(DrilldownListenerInterface d) {
        if (d != null) {
            this.drillDownListeners.remove(d);
        }
    }

    public void addDrillDownListener(DrilldownListenerInterface d) {
        if (d != null) {
            this.drillDownListeners.add(d);
        }
    }

    @Override
    public synchronized void mousePressed(MouseEvent e) {
        if (!this.preMousePressed(e)) {
            return;
        }
        switch (this.actionMode) {
            default: {
                this.pan = true;
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                this.brush = true;
                break;
            }
            case 2: {
                this.viewport = true;
                break;
            }
            case 3: {
                this.zoom = true;
                break;
            }
            case 6: {
                if ((e.getModifiers() & 2) != 0) {
                    this.extsel = true;
                    break;
                }
                this.select = true;
            }
        }
        if (this.actionMode == 8 && e.getClickCount() < 2) {
            Object o = this.pick(e.getX(), e.getY());
            this.drillNLDNode = o instanceof NLDNode ? (NLDNode)o : null;
        }
    }

    @Override
    public synchronized void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        if (this.emptyPlot) {
            return;
        }
        if (this.actionMode == 8 && (e.getModifiers() & 0x10) != 0) {
            this.fireDrillDownEvent(this.drillNLDNode, e);
        }
    }

    protected void fireDrillDownEvent(NLDNode node, MouseEvent me) {
        if (node == null) {
            return;
        }
        if (this.drillDownListeners.size() == 0) {
            return;
        }
        String url = node.getUrl();
        if (url == null) {
            url = node.getID();
        }
        Hashtable<Integer, Object> drillInfo = new Hashtable<Integer, Object>();
        drillInfo.put(DrilldownEvent.DRILLDOWN_KEY_URL, url);
        drillInfo.put(DrilldownEvent.DRILLDOWN_KEY_MOUSE_EVENT, me);
        drillInfo.put(DrilldownEvent.DRILLDOWN_KEY_NODE_ID, node.getID());
        drillInfo.put(DrilldownEvent.DRILLDOWN_KEY_NODE_OBS_INDEX, new Integer(node.getIndex()));
        DrilldownEvent e = new DrilldownEvent(url, drillInfo);
        for (int i = 0; i < this.drillDownListeners.size(); ++i) {
            DrilldownListenerInterface d = (DrilldownListenerInterface)this.drillDownListeners.elementAt(i);
            d.drilldown(e);
        }
    }

    @Override
    protected void setArcAttr() {
        String g;
        NLDLink a;
        int i;
        super.setArcAttr();
        int groupIndex = 0;
        for (i = 0; i < this.numLinks; ++i) {
            a = (NLDLink)this.model.links.elementAt(i);
            g = a.getGroup();
            if (g == null || this.groups.containsKey(g)) continue;
            this.groups.put(g, new Integer(groupIndex));
            ++groupIndex;
        }
        if (this.groups.size() > 1) {
            for (i = 0; i < this.numLinks; ++i) {
                a = (NLDLink)this.model.links.elementAt(i);
                g = a.getGroup();
                if (g == null) continue;
                Object gi = this.groups.get(g);
                int stipple = SASLinePatterns.getStippleFactor((int)0);
                if (gi instanceof Number) {
                    switch (((Number)gi).intValue() % 7) {
                        default: {
                            stipple = SASLinePatterns.getStipplePattern((int)0);
                            break;
                        }
                        case 1: {
                            stipple = SASLinePatterns.getStipplePattern((int)4);
                            break;
                        }
                        case 2: {
                            stipple = SASLinePatterns.getStipplePattern((int)11);
                            break;
                        }
                        case 3: {
                            stipple = SASLinePatterns.getStipplePattern((int)10);
                            break;
                        }
                        case 4: {
                            stipple = SASLinePatterns.getStipplePattern((int)13);
                            break;
                        }
                        case 5: {
                            stipple = SASLinePatterns.getStipplePattern((int)5);
                            break;
                        }
                        case 6: {
                            stipple = SASLinePatterns.getStipplePattern((int)3);
                        }
                    }
                }
                a.setStipple(stipple);
            }
        }
    }

    @Override
    public void setLinkWidth(int ind) {
        Object widthVobj = ((DataFilterLinkModel)this.model.links).getVariable(5);
        if (null != widthVobj) {
            this.setWidthMappingLinks(true);
        } else {
            this.setWidthMappingLinks(false);
        }
        super.setLinkWidth(ind);
    }

    @Override
    public void setNodeColor(int ind) {
        Object vobj = ((DataFilterNodeModel)this.model.nodes).getVariable(4);
        if (vobj != null) {
            this.setColorMappingNodes(true);
        } else {
            this.setColorMappingNodes(false);
        }
        super.setNodeColor(ind);
    }

    @Override
    public void setLinkColor(int ind) {
        Object vobj = ((DataFilterLinkModel)this.model.links).getVariable(7);
        if (vobj != null) {
            this.setColorMappingLinks(true);
        } else {
            this.setColorMappingLinks(false);
        }
        super.setLinkColor(ind);
    }

    public void colormapLinks() {
        if (!(this.model.links instanceof DataFilterLinkModel)) {
            return;
        }
        Object vobj = ((DataFilterLinkModel)this.model.links).getVariable(7);
        Object iobj = ((DataFilterLinkModel)this.model.links).getVariable(0);
        if (vobj == null) {
            return;
        }
        double scaledColVal = 0.0;
        DataFilterReadInterface linkFilter = ((DataFilterLinkModel)this.model.links).getFilter();
        int nLinksInFilter = linkFilter.getNumberObservations(-1);
        int linkIndex = 0;
        for (int filtrIdx = 0; filtrIdx < nLinksInFilter && linkIndex < this.numLinks; ++filtrIdx) {
            String filterLinkId;
            DvrLink l = (DvrLink)((Object)((DataFilterLinkModel)this.model.links).elementAt(linkIndex));
            String vecLinkId = l.getID();
            if (!vecLinkId.equalsIgnoreCase(filterLinkId = linkFilter.getValue(iobj, (long)filtrIdx).toString())) continue;
            int i = linkIndex;
            Object obj = linkFilter.getValue(vobj, (long)filtrIdx);
            Color c = this.getColor(obj);
            if (c != null) {
                l.setColor(c);
                this.linkColors[i] = c;
            } else if (linkFilter.isNumericVariable(vobj)) {
                if (obj != null) {
                    double colval = ((Number)obj).doubleValue();
                    if (!Double.isNaN(colval)) {
                        l.setColorValue(colval);
                        scaledColVal = this.maxLColVal == this.minLColVal ? 1.0 : 1.0 * (colval - this.minLColVal) / (this.maxLColVal - this.minLColVal);
                        this.linkColors[i] = this.colmap(scaledColVal);
                    } else {
                        this.linkColors[i] = this.getLinkErrorColor();
                    }
                } else {
                    this.linkColors[i] = this.getLinkErrorColor();
                }
                l.setColor(this.linkColors[i]);
            } else {
                this.linkColors[i] = this.getLinkErrorColor();
                l.setColor(this.linkColors[i]);
            }
            ++linkIndex;
        }
    }

    public void colormapNodes() {
        if (!(this.model.nodes instanceof DataFilterNodeModel)) {
            return;
        }
        Object vobj = ((DataFilterNodeModel)this.model.nodes).getVariable(4);
        Object iObj = ((DataFilterNodeModel)this.model.nodes).getVariable(0);
        if (null == vobj || iObj == null) {
            return;
        }
        double scaledColVal = 0.0;
        DataFilterReadInterface nodeFilter = ((DataFilterNodeModel)this.model.nodes).getFilter();
        int nNodesInFilter = nodeFilter.getNumberObservations(-1);
        int nodeIndex = 0;
        for (int filtrIdx = 0; filtrIdx < nNodesInFilter && nodeIndex < this.numNodes; ++filtrIdx) {
            String filterNodeId;
            NLDNode n = (NLDNode)((DataFilterNodeModel)this.model.nodes).elementAt(nodeIndex);
            String vecNodeId = n.getID();
            if (!vecNodeId.equalsIgnoreCase(filterNodeId = nodeFilter.getValue(iObj, (long)filtrIdx).toString())) continue;
            int i = nodeIndex;
            Object obj = nodeFilter.getValue(vobj, (long)filtrIdx);
            Color c = this.getColor(obj);
            if (c != null) {
                n.setColor(c);
                this.nodeColors[i] = c;
            } else if (nodeFilter.isNumericVariable(vobj)) {
                if (obj != null) {
                    double colval = ((Number)obj).doubleValue();
                    if (!Double.isNaN(colval)) {
                        n.setColorValue(colval);
                        scaledColVal = this.maxNColVal == this.minNColVal ? 1.0 : 1.0 * (colval - this.minNColVal) / (this.maxNColVal - this.minNColVal);
                        this.nodeColors[i] = this.colmap(scaledColVal);
                    } else {
                        this.nodeColors[i] = this.getNodeErrorColor();
                    }
                } else {
                    this.nodeColors[i] = this.getNodeErrorColor();
                }
                n.setColor(this.nodeColors[i]);
            } else {
                this.nodeColors[i] = this.getNodeErrorColor();
                n.setColor(this.nodeColors[i]);
            }
            ++nodeIndex;
        }
    }

    private Color getColor(Object o) {
        if (o instanceof Color) {
            return (Color)o;
        }
        if (o instanceof String) {
            return NLD.decodeColor((String)o.toString());
        }
        return null;
    }
}

