/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.spectrumplot;

import com.sas.graphics.silk.event.RedrawEvent;
import com.sas.graphics.silk.event.ViewportEvent;
import com.sas.graphics.silk.event.ViewportListenerInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.GeometryInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RedrawListener;
import com.sas.graphics.silk.interfaces.RenderInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.interfaces.TransformInterface;
import com.sas.graphics.silk.interfaces.UpdateInterface;
import com.sas.graphics.silk.interfaces.ViewportInterface;
import com.sas.graphics.silk.spectrumplot.DendrogramModel;
import com.sas.graphics.silk.util.Axes;
import com.sas.graphics.silk.util.AxisZoomPanHandler;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.ZoomScrollBarLayout;
import com.sas.graphics.util.ColorParse;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;

public class DendrogramChart
implements GeometryInterface,
RenderInterface,
RoleInterface,
UpdateInterface,
TransformInterface,
ViewportInterface,
ViewportListenerInterface,
PropertyInterface {
    protected boolean visible = true;
    protected double opacity = 1.0;
    protected boolean rebuildRequired = true;
    protected Color selectionColor;
    protected Color treeColor;
    protected int orientation = 0;
    protected DataFilterReadInterface dataIn = null;
    protected DataFilterReadInterface dataOut = null;
    protected DendrogramModel treeModel = null;
    protected Axes heightAxis = null;
    protected Axes treeAxis = null;
    protected double xMin;
    protected double xMax;
    protected double yMin;
    protected double yMax;
    protected SASFormat respFormat;
    protected ArrayList branchList;
    protected ArrayList crossList;
    protected ArrayList redrawListener;
    protected Object marginSource;
    protected boolean dataChanged = false;
    protected boolean dataPrepared = false;
    protected double[] chartBBox = new double[6];
    protected double[] scr1 = new double[3];
    protected double[] scr2 = new double[3];
    protected Rectangle clipRect;
    protected Dimension chartAreaDimension;
    protected Object[] orderedLeaves;
    protected boolean redraw = true;
    protected ArrayList propertyIndex;
    protected ArrayList propertyValue;
    protected ZoomScrollBarLayout scrollbar;
    protected double dataXMin;
    protected double dataXMax;
    protected double dataYMin;
    protected double dataYMax;
    protected int numSelectedNodes;
    protected AxisZoomPanHandler zoomPanHandler;
    protected ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.spectrumplot.spectrumplot_NLS");

    public DendrogramChart(Object dataObject) {
        this.selectionColor = new Color(255, 197, 0);
        this.treeColor = Color.black;
        this.branchList = new ArrayList();
        this.crossList = new ArrayList();
        this.redrawListener = new ArrayList();
        this.xMin = Double.NaN;
        this.xMax = Double.NaN;
        this.yMin = Double.NaN;
        this.yMax = Double.NaN;
        this.propertyIndex = new ArrayList();
        this.propertyValue = new ArrayList();
        this.setDataSource(dataObject);
    }

    public DendrogramChart() {
        this(null);
    }

    public Axes getHeightAxis() {
        return this.heightAxis;
    }

    public void setHeightAxis(Axes axis) {
        this.heightAxis = axis;
        this.heightAxis.setTransformObject((Object)this);
    }

    public Axes getTreeAxis() {
        return this.treeAxis;
    }

    public void setTreeAxis(Axes axis) {
        this.treeAxis = axis;
        if (this.treeAxis != null) {
            this.treeAxis.setTransformObject((Object)new TreeAxisTransform());
        }
    }

    public boolean isDataAssigned() {
        return this.getVariable("Cluster") != null && this.getVariable("Parent") != null;
    }

    public Insets getOuterMargin(Graphics2D g) {
        Insets om = new Insets(0, 0, 0, 0);
        if (this.rebuildRequired && !this.build(null)) {
            return om;
        }
        if (this.orientation == 0) {
            om.left = Math.max(this.treeAxis.getLeftWidth(g), (int)(0.5 * (double)this.heightAxis.getValueWidth(g, 0)));
            om.left = Math.max(om.left, 20);
            om.bottom = Math.max(this.treeAxis.getValueHeight(g, 0), this.heightAxis.getBottomHeight(g));
            om.right = (int)(0.5 * (double)this.heightAxis.getValueWidth(g, -1));
            om.top = this.treeAxis.getValueHeight(g, -1);
        } else {
            om.left = Math.max(this.heightAxis.getLeftWidth(g), (int)(0.5 * (double)this.treeAxis.getValueWidth(g, 0)));
            om.bottom = Math.max(this.heightAxis.getValueHeight(g, 0), this.treeAxis.getBottomHeight(g));
            om.bottom = Math.max(om.bottom, 20);
            om.right = (int)(0.5 * (double)this.treeAxis.getValueWidth(g, -1));
            om.top = this.heightAxis.getValueHeight(g, -1);
        }
        return om;
    }

    public ZoomScrollBarLayout getScrollBar() {
        return this.scrollbar;
    }

    public void setScrollBar(ZoomScrollBarLayout sbar) {
        this.scrollbar = sbar;
    }

    public AxisZoomPanHandler getZoomPanHandler() {
        return this.zoomPanHandler;
    }

    public void setZoomPanHandler(AxisZoomPanHandler hd) {
        this.zoomPanHandler = hd;
    }

    public void setChartAreaDimension(Dimension d) {
        this.chartAreaDimension = d;
        this.heightAxis.setChartAreaDimension(d);
        if (this.treeAxis != null) {
            this.treeAxis.setChartAreaDimension(d);
        }
        if (this.scrollbar != null) {
            this.scrollbar.setComponentSize(d.width, d.height);
        }
    }

    public Rectangle getChartClipArea() {
        return this.clipRect;
    }

    public void setChartClipArea(Rectangle rect) {
        if (rect == null) {
            return;
        }
        this.clipRect = rect;
        this.heightAxis.setScreenArea(this.clipRect.x, this.clipRect.y, this.clipRect.width, this.clipRect.height);
        if (this.treeAxis != null) {
            this.treeAxis.setScreenArea(this.clipRect.x, this.clipRect.y, this.clipRect.width, this.clipRect.height);
        }
    }

    public void setScrollBarOffsets(int hoff, int voff) {
        if (this.scrollbar != null) {
            this.scrollbar.setChartArea(this.clipRect, hoff, voff);
        }
    }

    public Object[] getOrderedLeaves() {
        return this.orderedLeaves;
    }

    private void updateScrollBar() {
        if (this.orientation == 0) {
            this.scrollbar.setDataRange(1, this.dataXMin, this.dataXMax);
            this.scrollbar.setMinimumViewportRange(1, 0.001 * (this.dataXMax - this.dataXMin));
        } else {
            this.scrollbar.setDataRange(2, this.dataYMin, this.dataYMax);
            this.scrollbar.setMinimumViewportRange(2, 0.001 * (this.dataYMax - this.dataYMin));
        }
        this.scrollbar.updateScrollbars();
    }

    private boolean buildDendrogram(Object buildData) {
        HashMap leaves = this.treeModel.getLeaves();
        int level = this.treeModel.getTreeLevel();
        HashMap<DendrogramModel.Node, Double> positions = new HashMap<DendrogramModel.Node, Double>();
        this.orderedLeaves = new Object[leaves.size()];
        Iterator iter = leaves.keySet().iterator();
        int size = leaves.size();
        for (int i = 0; i < size; ++i) {
            DendrogramModel.Node leaf = (DendrogramModel.Node)iter.next();
            if (this.orientation == 0) {
                positions.put(leaf, new Double(size - 1 - i));
            } else {
                positions.put(leaf, new Double(i));
            }
            this.orderedLeaves[i] = leaf.name;
        }
        this.buildBranchAndCross(leaves, positions, level);
        return true;
    }

    private void buildBranchAndCross(HashMap leaves, HashMap positions, int level) {
        Object[] leaveArray = leaves.keySet().toArray();
        for (int i = 0; i < leaveArray.length; ++i) {
            DendrogramModel.Node leaf = (DendrogramModel.Node)leaveArray[i];
            if (leaf.parent == null) {
                return;
            }
            if (!leaf.firstChild || leaf.level != level) continue;
            DendrogramModel.Node parent = leaf.parent;
            int numKids = parent.children.size();
            double v = 0.0;
            double vmin = Double.MAX_VALUE;
            double vmax = -1.7976931348623157E308;
            for (int k = 0; k < numKids; ++k) {
                DendrogramModel.Node kid = (DendrogramModel.Node)parent.children.get(k);
                v = ((Number)positions.get(kid)).doubleValue();
                if (v < vmin) {
                    vmin = v;
                }
                if (v > vmax) {
                    vmax = v;
                }
                Branch b = new Branch();
                if (this.orientation == 0) {
                    b.kidEnd = new Point2D.Double(kid.height, v);
                    b.parentEnd = new Point2D.Double(parent.height, v);
                } else {
                    b.kidEnd = new Point2D.Double(v, kid.height);
                    b.parentEnd = new Point2D.Double(v, parent.height);
                }
                b.node = kid;
                this.branchList.add(b);
                leaves.remove(kid);
                positions.remove(kid);
            }
            Cross c = new Cross();
            if (this.orientation == 0) {
                c.minEnd = new Point2D.Double(parent.height, vmin);
                c.maxEnd = new Point2D.Double(parent.height, vmax);
            } else {
                c.minEnd = new Point2D.Double(vmin, parent.height);
                c.maxEnd = new Point2D.Double(vmax, parent.height);
            }
            c.node = parent;
            this.crossList.add(c);
            leaves.put(parent, "leaf");
            positions.put(parent, new Double(0.5 * (vmin + vmax)));
        }
        this.buildBranchAndCross(leaves, positions, --level);
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.selectionColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.selectionColor = col;
        }
        this.fireRedrawEvent(new RedrawEvent((Object)this));
    }

    public Color getTreeColor() {
        return this.treeColor;
    }

    public void setTreeColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.treeColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.treeColor = col;
        }
        this.fireRedrawEvent(new RedrawEvent((Object)this));
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int o) {
        switch (o) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                return;
            }
        }
        if (this.orientation == o) {
            return;
        }
        this.orientation = o;
    }

    public boolean isHighlightRequired() {
        return this.numSelectedNodes > 0;
    }

    public ArrayList getSelectedValues() {
        return this.treeModel.getSelectedValues();
    }

    public boolean setSelection(int mouseX, int mouseY, boolean extend) {
        return this.setSelection(new Rectangle(mouseX - 1, mouseY - 1, 5, 5), extend, false);
    }

    public boolean setSelection(Rectangle rect, boolean extend) {
        return this.setSelection(rect, extend, true);
    }

    private boolean setSelection(Rectangle rect, boolean extend, boolean all) {
        Rectangle2D.Double rect2D;
        double[] pt1 = this.unProject(rect.getX(), rect.getY(), 0.0, null);
        double[] pt2 = this.unProject(rect.getX() + rect.getWidth(), rect.getY() + rect.getHeight(), 0.0, null);
        if (this.orientation == 0) {
            pt1[0] = this.xMax - pt1[0] + this.xMin;
            pt2[0] = this.xMax - pt2[0] + this.xMin;
            rect2D = new Rectangle2D.Double(pt2[0], pt2[1], pt1[0] - pt2[0], pt1[1] - pt2[1]);
        } else {
            pt1[1] = this.yMax - pt1[1] + this.yMin;
            pt2[1] = this.yMax - pt2[1] + this.yMin;
            rect2D = new Rectangle2D.Double(pt1[0], pt1[1], pt2[0] - pt1[0], pt2[1] - pt1[1]);
        }
        Line2D.Double line = new Line2D.Double();
        boolean fire = false;
        if (extend) {
            for (int i = 0; i < this.branchList.size(); ++i) {
                Branch b = (Branch)this.branchList.get(i);
                line.setLine(b.kidEnd, b.parentEnd);
                if (!line.intersects(rect2D)) continue;
                fire = true;
                if (b.node.selected) {
                    this.treeModel.setSelection(b.node, false);
                    --this.numSelectedNodes;
                } else {
                    this.treeModel.setSelection(b.node, true);
                    ++this.numSelectedNodes;
                }
                if (all) {
                    continue;
                }
                break;
            }
        } else {
            fire = true;
            this.treeModel.setSelectAll(false);
            this.numSelectedNodes = 0;
            for (int i = 0; i < this.branchList.size(); ++i) {
                Branch b = (Branch)this.branchList.get(i);
                line.setLine(b.kidEnd, b.parentEnd);
                if (!line.intersects(rect2D)) continue;
                this.treeModel.setSelection(b.node, true);
                ++this.numSelectedNodes;
                if (all) {
                    continue;
                }
                break;
            }
        }
        return fire;
    }

    public String getToolTipText(int mouseX, int mouseY) {
        Rectangle2D.Double rect2D;
        double[] pt1 = this.unProject(mouseX - 1, mouseY - 1, 0.0, null);
        double[] pt2 = this.unProject(mouseX + 4, mouseY + 4, 0.0, null);
        if (this.orientation == 0) {
            pt1[0] = this.xMax - pt1[0] + this.xMin;
            pt2[0] = this.xMax - pt2[0] + this.xMin;
            rect2D = new Rectangle2D.Double(pt2[0], pt2[1], pt1[0] - pt2[0], pt1[1] - pt2[1]);
        } else {
            pt1[1] = this.yMax - pt1[1] + this.yMin;
            pt2[1] = this.yMax - pt2[1] + this.yMin;
            rect2D = new Rectangle2D.Double(pt1[0], pt1[1], pt2[0] - pt1[0], pt2[1] - pt1[1]);
        }
        Line2D.Double line = new Line2D.Double();
        DendrogramModel.Node node = null;
        for (int i = 0; i < this.branchList.size(); ++i) {
            Branch b = (Branch)this.branchList.get(i);
            line.setLine(b.kidEnd, b.parentEnd);
            if (!line.intersects(rect2D)) continue;
            node = b.node;
            break;
        }
        if (node == null) {
            return null;
        }
        Message probeMessage = new Message(ResourceLoader.getResourceString((Object)this.rb, (String)"SpectrumPlotChart.Probe.fmt.txt", (String)"{0} : {1}"));
        String cstr = "";
        String hstr = "";
        cstr = probeMessage.toString((Object)((String)this.treeModel.getVariableDescription(this.getVariable("Cluster"))), (Object)node.name.toString()) + "\n";
        if (this.getVariable("Height") != null) {
            Object format = this.dataIn.getFormat(this.getVariable("Height"), null);
            hstr = probeMessage.toString((Object)((String)this.treeModel.getVariableDescription(this.getVariable("Height"))), (Object)this.dataIn.getFormattedValue(this.getVariable("Height"), (Object)new Double(node.height), format));
        }
        return cstr + hstr;
    }

    public boolean create(Object createData) {
        return true;
    }

    public boolean isRebuildRequired() {
        return this.rebuildRequired;
    }

    public boolean build(Object buildData) {
        double max;
        double min;
        if (!this.rebuildRequired) {
            return true;
        }
        if (this.treeModel == null) {
            return false;
        }
        if (!this.isDataAssigned()) {
            return false;
        }
        if (!this.treeModel.buildUpTree()) {
            return false;
        }
        if (this.clipRect == null || this.clipRect.width == 0 || this.clipRect.height == 0) {
            return false;
        }
        this.branchList.clear();
        this.crossList.clear();
        this.numSelectedNodes = 0;
        if (this.getVariable("Height") != null) {
            min = ((Number)this.getRoleValue("Height", 0)).doubleValue();
            max = ((Number)this.getRoleValue("Height", 1)).doubleValue();
            if (this.orientation == 0) {
                this.heightAxis.setRole(this.getVariable("Height"), (Object)"XAxis");
            } else {
                this.heightAxis.setRole(this.getVariable("Height"), (Object)"YAxis");
            }
            this.heightAxis.setVisible(true);
            this.heightAxis.setLabel(this.treeModel.getVariableDescription(this.getVariable("Height")));
            this.heightAxis.setGridLines((Object)Boolean.FALSE);
            this.heightAxis.setLabel((Object)Boolean.FALSE);
            this.heightAxis.setAxis((Object)new Double(min), (Object)new Double(max), -1, -1, null, Boolean.TRUE, null);
            double[] ends = this.heightAxis.getMinMaxTickMarkValues();
            min = ends[0];
            max = ends[1];
        } else {
            this.heightAxis.setVisible(false);
            min = 0.0;
            max = this.treeModel.getTreeLevel();
        }
        if (this.orientation == 0) {
            this.dataXMin = this.xMin = min;
            this.dataXMax = this.xMax = max;
        } else {
            this.dataYMin = this.yMin = min;
            this.dataYMax = this.yMax = max;
        }
        this.heightAxis.setScreenArea(this.clipRect.x, this.clipRect.y, this.clipRect.width, this.clipRect.height);
        boolean rc = this.buildDendrogram(buildData);
        if (this.treeAxis != null) {
            if (this.orientation == 0) {
                this.treeAxis.setRole(this.getVariable("Cluster"), (Object)"YAxis");
            } else {
                this.treeAxis.setRole(this.getVariable("Cluster"), (Object)"XAxis");
            }
            this.treeAxis.setGridLines((Object)Boolean.FALSE);
            this.treeAxis.setLabel((Object)Boolean.FALSE);
            this.treeAxis.setLine((Object)Boolean.FALSE);
            this.treeAxis.setMajorTicks((Object)Boolean.FALSE);
            Object[] values = this.getOrderedLeaves();
            this.treeAxis.setAxis((Object)new Double(0.0), (Object)new Double(values.length - 1), -1, -1, values, Boolean.TRUE, null);
            if (this.orientation == 0) {
                this.yMin = 0.0;
                this.dataYMin = 0.0;
                this.dataYMax = this.yMax = (double)(values.length - 1);
                this.zoomPanHandler.setDataRange(this.dataYMin, this.dataYMax);
            } else {
                this.xMin = 0.0;
                this.dataXMin = 0.0;
                this.dataXMax = this.xMax = (double)(values.length - 1);
                this.zoomPanHandler.setDataRange(this.dataXMin, this.dataXMax);
            }
        }
        if (this.dataChanged) {
            this.updateScrollBar();
        }
        this.rebuildRequired = false;
        this.dataChanged = false;
        this.redraw = true;
        return rc;
    }

    public boolean buildAndDraw(Object buildData, Object drawContext, Object drawData) {
        boolean status = this.build(buildData);
        this.draw(drawContext, false);
        return status;
    }

    public long getMasks() {
        return 0L;
    }

    public long setMasks(long mask, long bits) {
        return 0L;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean viz) {
        this.visible = viz;
        this.fireRedrawEvent(new RedrawEvent((Object)this));
    }

    public Object getOpacityValue() {
        return new Double(this.opacity);
    }

    public boolean setOpacityValue(Object newOpacity) {
        if (newOpacity == null || !(newOpacity instanceof Number)) {
            return false;
        }
        double newValue = ((Number)newOpacity).doubleValue();
        if (newValue < 0.0 || newValue > 1.0) {
            return false;
        }
        if (newValue != this.opacity) {
            this.opacity = newValue;
            this.fireRedrawEvent(new RedrawEvent((Object)this));
        }
        return true;
    }

    public void draw(Object p, boolean callHighlightDraw) {
        if (p == null || !(p instanceof Graphics2D) || !this.visible) {
            return;
        }
        if (this.branchList == null || this.crossList == null) {
            return;
        }
        Graphics2D g = (Graphics2D)p;
        Composite comp = g.getComposite();
        if (this.opacity < 1.0) {
            AlphaComposite alphaComp = AlphaComposite.getInstance(3, (float)this.opacity);
            g.setComposite(alphaComp);
        }
        g.setColor(this.treeColor);
        for (int i = 0; i < this.branchList.size(); ++i) {
            Branch b = (Branch)this.branchList.get(i);
            this.project(b.kidEnd.getX(), b.kidEnd.getY(), 0.0, this.scr1);
            this.project(b.parentEnd.getX(), b.parentEnd.getY(), 0.0, this.scr2);
            g.drawLine((int)this.scr1[0], (int)this.scr1[1], (int)this.scr2[0], (int)this.scr2[1]);
        }
        g.setColor(this.treeColor);
        for (int i = 0; i < this.crossList.size(); ++i) {
            Cross c = (Cross)this.crossList.get(i);
            this.project(c.minEnd.getX(), c.minEnd.getY(), 0.0, this.scr1);
            this.project(c.maxEnd.getX(), c.maxEnd.getY(), 0.0, this.scr2);
            g.drawLine((int)this.scr1[0], (int)this.scr1[1], (int)this.scr2[0], (int)this.scr2[1]);
        }
        if (callHighlightDraw) {
            this.drawHighlight(p);
        }
        g.setComposite(comp);
        this.redraw = false;
    }

    public void drawHighlight(Object p) {
        if (p == null || !(p instanceof Graphics2D) || !this.visible) {
            return;
        }
        if (this.branchList == null || this.crossList == null) {
            return;
        }
        Graphics2D g = (Graphics2D)p;
        g.setColor(this.selectionColor);
        for (int i = 0; i < this.branchList.size(); ++i) {
            Branch b = (Branch)this.branchList.get(i);
            if (!b.node.selected) continue;
            this.project(b.kidEnd.getX(), b.kidEnd.getY(), 0.0, this.scr1);
            this.project(b.parentEnd.getX(), b.parentEnd.getY(), 0.0, this.scr2);
            g.drawLine((int)this.scr1[0], (int)this.scr1[1], (int)this.scr2[0], (int)this.scr2[1]);
        }
        for (int i = 0; i < this.crossList.size(); ++i) {
            Cross c = (Cross)this.crossList.get(i);
            if (!c.node.selected) continue;
            this.project(c.minEnd.getX(), c.minEnd.getY(), 0.0, this.scr1);
            this.project(c.maxEnd.getX(), c.maxEnd.getY(), 0.0, this.scr2);
            g.drawLine((int)this.scr1[0], (int)this.scr1[1], (int)this.scr2[0], (int)this.scr2[1]);
        }
    }

    public Object[] getDataIds() {
        return null;
    }

    public Object getDataSource() {
        return this.getDataSource(null);
    }

    public Object getDataSource(Object id) {
        if (this.dataIn == null) {
            return null;
        }
        return this.dataIn.getSource();
    }

    public boolean setDataSource(Object source) {
        return this.setDataSource(source, null);
    }

    public boolean setDataSource(Object source, Object id) {
        if (source == null || !(source instanceof DataFilterReadInterface)) {
            return false;
        }
        this.dataIn = (DataFilterReadInterface)source;
        if (this.treeModel == null) {
            this.treeModel = new DendrogramModel();
        }
        if (this.treeModel != null) {
            this.treeModel.setDataSource(this.dataIn);
            this.dataOut = null;
        }
        this.rebuildRequired = true;
        this.dataChanged = true;
        this.dataPrepared = false;
        return true;
    }

    public Object getAllVariables(Object role) {
        return this.getVariable(role);
    }

    public Object getVariable(Object role) {
        if (this.treeModel == null) {
            return null;
        }
        return this.treeModel.getVariable(role);
    }

    public Object getRole(Object variableId) {
        if (this.treeModel == null) {
            return null;
        }
        return this.treeModel.getRole(variableId);
    }

    public boolean setRole(Object variableId, Object role) {
        if (this.treeModel == null || role == null) {
            return false;
        }
        this.rebuildRequired = true;
        this.dataChanged = true;
        this.dataPrepared = false;
        return this.treeModel.setRole(variableId, role);
    }

    public boolean addRole(Object variableId, Object role) {
        if (this.treeModel == null || role == null) {
            return false;
        }
        this.rebuildRequired = true;
        this.dataChanged = true;
        this.dataPrepared = false;
        return this.treeModel.addRole(variableId, role);
    }

    public boolean removeRole(Object variableId, Object role) {
        if (this.treeModel == null || role == null) {
            return false;
        }
        this.rebuildRequired = true;
        this.dataChanged = true;
        this.dataPrepared = false;
        return this.treeModel.removeRole(variableId, role);
    }

    public boolean isDiscrete(Object role) {
        if (this.treeModel == null) {
            return false;
        }
        return this.treeModel.isDiscrete(role);
    }

    public boolean setDiscrete(Object role, boolean discrete) {
        if (this.treeModel == null) {
            return false;
        }
        this.rebuildRequired = true;
        this.dataChanged = true;
        this.dataPrepared = false;
        return this.treeModel.setDiscrete(role, discrete);
    }

    public Object getSortOrder(Object role) {
        if (this.treeModel == null) {
            return null;
        }
        return this.treeModel.getSortOrder(role);
    }

    public boolean setSortOrder(Object role, Object order) {
        if (this.treeModel == null) {
            return false;
        }
        this.rebuildRequired = true;
        this.dataChanged = true;
        this.dataPrepared = false;
        return this.treeModel.setSortOrder(role, order);
    }

    public Object getRoleValue(Object role, int which) {
        if (this.treeModel == null) {
            return null;
        }
        return this.treeModel.getRoleValue(role, which);
    }

    public Object[] getSupportedRoles(Object id, boolean discrete) {
        Object[] roles = discrete ? new Object[]{"Cluster", "Parent", "Height"} : new Object[]{"Height"};
        return roles;
    }

    public int getMaxAllowed(Object role) {
        return 1;
    }

    public void addRoleListener(RoleListenerInterface listener) {
    }

    public void removeRoleListener(RoleListenerInterface listener) {
    }

    public boolean supportsMultipleAssignments(Object role) {
        return false;
    }

    public Object getLimit(Object role) {
        return null;
    }

    public boolean setLimit(Object role, Object value) {
        return false;
    }

    public Object[][] getSupportedSortableRoles() {
        return null;
    }

    public int[] getSupportedSortDirections(Object role) {
        return null;
    }

    public boolean requiresMultipleRoleAssignments() {
        return false;
    }

    public Object getPropertyValue(int idx) {
        int i = this.propertyIndex.indexOf(new Integer(idx));
        if (i >= 0) {
            return this.propertyValue.get(i);
        }
        return null;
    }

    public boolean setPropertyValue(int idx, Object value) {
        int i = this.propertyIndex.indexOf(new Integer(idx));
        if (i >= 0) {
            this.propertyValue.set(i, value);
        } else {
            this.propertyIndex.add(new Integer(idx));
            this.propertyValue.add(value);
        }
        return true;
    }

    public int getNumberProperties() {
        return 0;
    }

    public boolean applyPropertyChanges() {
        if (this.propertyIndex.size() <= 0) {
            return false;
        }
        this.fireRedrawEvent(new RedrawEvent((Object)this));
        this.propertyIndex.clear();
        this.propertyValue.clear();
        return true;
    }

    public boolean applyPropertyChanges(Object source) {
        return true;
    }

    public void cancelPropertyChanges() {
        this.propertyIndex.clear();
        this.propertyValue.clear();
    }

    public void cancelPropertyChanges(Object source) {
    }

    public int[] getPendingChanges() {
        int[] index = new int[this.propertyIndex.size()];
        for (int i = 0; i < this.propertyIndex.size(); ++i) {
            index[i] = (Integer)this.propertyIndex.get(i);
        }
        return index;
    }

    public int[] getPendingChanges(Object source) {
        int[] index = new int[this.propertyIndex.size()];
        return index;
    }

    public boolean isPropertySupported(int idx) {
        switch (idx) {
            default: 
        }
        return false;
    }

    public boolean isPropertyPending(int idx) {
        return false;
    }

    public int getNumberPendingProperties() {
        return -1;
    }

    public boolean hasUserSetValue(int id) {
        boolean rc = true;
        return rc;
    }

    public Object getTransformObject() {
        return this;
    }

    public boolean setTransformObject(Object transIn) {
        return true;
    }

    public double[] getBoundingBox() {
        return null;
    }

    public boolean setBoundingBox(double xmin, double ymin, double zmin, double xmax, double ymax, double zmax) {
        if (this.orientation == 0) {
            this.yMin = ymin;
            this.yMax = ymax;
        } else {
            this.xMin = xmin;
            this.xMax = xmax;
        }
        return true;
    }

    public Rectangle getScreenArea() {
        return null;
    }

    public boolean setScreenArea(int xmin, int ymin, int width, int height) {
        return false;
    }

    public double[] project(double x, double y, double z, double[] out) {
        if (Double.isNaN(this.xMin) || Double.isNaN(this.xMax) || Double.isNaN(this.yMin) || Double.isNaN(this.yMax)) {
            return null;
        }
        double[] ret = out;
        if (ret == null && (ret = new double[3]) == null) {
            return null;
        }
        double w = this.clipRect.width;
        double h = this.clipRect.height;
        double xo = this.clipRect.x;
        double yo = this.clipRect.y;
        if (this.orientation == 0) {
            ret[0] = this.xMax == this.xMin ? xo : w - w * (x - this.xMin) / (this.xMax - this.xMin) + xo;
        } else {
            double d = ret[0] = this.xMax == this.xMin ? xo : w * (x - this.xMin) / (this.xMax - this.xMin) + xo;
        }
        ret[1] = this.orientation == 0 ? (this.yMax == this.yMin ? yo : h - h * (y - this.yMin) / (this.yMax - this.yMin) + yo) : (this.yMax == this.yMin ? yo : h * (y - this.yMin) / (this.yMax - this.yMin) + yo);
        ret[2] = 0.0;
        return ret;
    }

    public double[] unProject(double pixelX, double pixelY, double pixelZ, double[] out) {
        if (Double.isNaN(this.xMin) || Double.isNaN(this.xMax) || Double.isNaN(this.yMin) || Double.isNaN(this.yMax)) {
            return null;
        }
        double[] ret = out;
        if (ret == null && (ret = new double[3]) == null) {
            return null;
        }
        double w = this.clipRect.width;
        double h = this.clipRect.height;
        double xo = this.clipRect.x;
        double yo = this.clipRect.y;
        ret[0] = w == 0.0 ? this.xMin : (this.xMax - this.xMin) * (pixelX - xo) / w + this.xMin;
        ret[1] = h == 0.0 ? this.yMin : (this.yMax - this.yMin) * (h + yo - pixelY) / h + this.yMin;
        ret[2] = 0.0;
        return ret;
    }

    public boolean isReverse(int axis) {
        return false;
    }

    public void setReverse(int axis, boolean flag) {
    }

    public double[] getViewport(int type, int level, int dimension) {
        double[] vport = new double[2];
        switch (dimension) {
            case 1: {
                if (this.orientation != 0) break;
                vport[0] = this.dataXMin + (this.dataXMax - this.xMax);
                vport[1] = this.dataXMax - (this.xMin - this.dataXMin);
                break;
            }
            case 2: {
                if (this.orientation != 1) break;
                vport[0] = this.dataYMin + (this.dataYMax - this.yMax);
                vport[1] = this.dataYMax - (this.yMin - this.dataYMin);
                break;
            }
            default: {
                return null;
            }
        }
        return vport;
    }

    public boolean setViewport(int type, int dimension, double min, double max) {
        switch (dimension) {
            case 1: {
                if (this.orientation != 0) break;
                this.xMin = this.dataXMin + (this.dataXMax - max);
                this.xMax = this.dataXMax - (min - this.dataXMin);
                break;
            }
            case 2: {
                if (this.orientation != 1) break;
                this.yMin = this.dataYMin + (this.dataYMax - max);
                this.yMax = this.dataYMax - (min - this.dataYMin);
                break;
            }
            default: {
                return false;
            }
        }
        this.heightAxis.setScreenArea(this.clipRect.x, this.clipRect.y, this.clipRect.width, this.clipRect.height);
        this.fireRedrawEvent(new RedrawEvent((Object)this));
        return true;
    }

    public boolean setViewport(int type, double xmin, double xmax, double ymin, double ymax, double zmin, double zmax) {
        if (type == 3) {
            double[] min = new double[3];
            double[] max = new double[3];
            this.unProject(xmin, ymax, 0.0, min);
            this.unProject(xmax, ymin, 0.0, max);
            if (this.orientation == 0) {
                this.yMin = min[1];
                this.yMax = max[1];
            } else if (this.orientation == 1) {
                this.xMin = min[0];
                this.xMax = max[0];
            }
            this.treeAxis.setScreenArea(this.clipRect.x, this.clipRect.y, this.clipRect.width, this.clipRect.height);
            this.fireRedrawEvent(new RedrawEvent((Object)this));
        }
        return true;
    }

    public boolean resetViewport() {
        if (this.orientation == 0) {
            this.yMin = this.dataYMin;
            this.yMax = this.dataYMax;
        } else if (this.orientation == 1) {
            this.xMin = this.dataXMin;
            this.xMax = this.dataXMax;
        }
        this.treeAxis.setScreenArea(this.clipRect.x, this.clipRect.y, this.clipRect.width, this.clipRect.height);
        this.fireRedrawEvent(new RedrawEvent((Object)this));
        return true;
    }

    public void viewportChanged(ViewportEvent evt) {
        if (this.orientation == 0) {
            this.yMin = evt.yMin;
            this.yMax = evt.yMax;
        } else if (this.orientation == 1) {
            this.xMin = evt.xMin;
            this.xMax = evt.xMax;
        }
        this.treeAxis.setScreenArea(this.clipRect.x, this.clipRect.y, this.clipRect.width, this.clipRect.height);
        this.fireRedrawEvent(new RedrawEvent((Object)this));
    }

    protected void fireRedrawEvent(RedrawEvent e) {
        if (this.redraw) {
            return;
        }
        block4: for (int i = 0; i < this.redrawListener.size(); ++i) {
            RedrawListener listener = (RedrawListener)this.redrawListener.get(i);
            if (listener == null) continue;
            switch (e.type) {
                default: {
                    listener.redraw(e);
                    continue block4;
                }
                case 2: {
                    listener.boundingBoxChanged(e);
                    listener.outerMarginChanged(e);
                    continue block4;
                }
                case 3: {
                    listener.outerMarginChanged(e);
                }
            }
        }
    }

    public void addRedrawListener(RedrawListener listener) {
        if (!this.redrawListener.contains(listener)) {
            this.redrawListener.add(listener);
        }
    }

    public void removeRedrawListener(RedrawListener listener) {
        if (this.redrawListener.contains(listener)) {
            this.redrawListener.remove(this.redrawListener.indexOf(listener));
        }
    }

    class TreeAxisTransform
    implements TransformInterface {
        private boolean xReverse = false;
        private boolean yReverse = false;

        TreeAxisTransform() {
        }

        public double[] project(double x, double y, double z, double[] out) {
            if (Double.isNaN(DendrogramChart.this.xMin) || Double.isNaN(DendrogramChart.this.xMax) || Double.isNaN(DendrogramChart.this.yMin) || Double.isNaN(DendrogramChart.this.yMax)) {
                return null;
            }
            double[] ret = out;
            if (ret == null && (ret = new double[3]) == null) {
                return null;
            }
            double w = DendrogramChart.this.clipRect.width;
            double h = DendrogramChart.this.clipRect.height;
            double xo = DendrogramChart.this.clipRect.x;
            double yo = DendrogramChart.this.clipRect.y;
            ret[2] = 0.0;
            if (this.xReverse) {
                ret[0] = DendrogramChart.this.xMin == DendrogramChart.this.xMax ? xo : w * (x - DendrogramChart.this.xMax) / (DendrogramChart.this.xMin - DendrogramChart.this.xMax) + xo;
            } else {
                double d = ret[0] = DendrogramChart.this.xMax == DendrogramChart.this.xMin ? xo : w * (x - DendrogramChart.this.xMin) / (DendrogramChart.this.xMax - DendrogramChart.this.xMin) + xo;
            }
            ret[1] = this.yReverse ? (DendrogramChart.this.yMin == DendrogramChart.this.yMax ? yo : h - h * (y - DendrogramChart.this.yMax) / (DendrogramChart.this.yMin - DendrogramChart.this.yMax) + yo) : (DendrogramChart.this.yMax == DendrogramChart.this.yMin ? yo : h - h * (y - DendrogramChart.this.yMin) / (DendrogramChart.this.yMax - DendrogramChart.this.yMin) + yo);
            ret[2] = 0.0;
            return ret;
        }

        public double[] unProject(double pixelX, double pixelY, double pixelZ, double[] out) {
            if (Double.isNaN(DendrogramChart.this.xMin) || Double.isNaN(DendrogramChart.this.xMax) || Double.isNaN(DendrogramChart.this.yMin) || Double.isNaN(DendrogramChart.this.yMax)) {
                return null;
            }
            double[] ret = out;
            if (ret == null && (ret = new double[3]) == null) {
                return null;
            }
            double w = DendrogramChart.this.clipRect.width;
            double h = DendrogramChart.this.clipRect.height;
            double xo = DendrogramChart.this.clipRect.x;
            double yo = DendrogramChart.this.clipRect.y;
            if (this.xReverse) {
                ret[0] = w == 0.0 ? DendrogramChart.this.xMax : (DendrogramChart.this.xMin - DendrogramChart.this.xMax) * (pixelX - xo) / w + DendrogramChart.this.xMax;
            } else {
                double d = ret[0] = w == 0.0 ? DendrogramChart.this.xMin : (DendrogramChart.this.xMax - DendrogramChart.this.xMin) * (pixelX - xo) / w + DendrogramChart.this.xMin;
            }
            if (this.yReverse) {
                ret[0] = w == 0.0 ? DendrogramChart.this.xMax : (DendrogramChart.this.xMin - DendrogramChart.this.xMax) * (pixelY - xo) / w + DendrogramChart.this.xMax;
            } else {
                ret[1] = h == 0.0 ? DendrogramChart.this.yMin : (DendrogramChart.this.yMax - DendrogramChart.this.yMin) * (h + yo - pixelY) / h + DendrogramChart.this.yMin;
            }
            ret[2] = 0.0;
            return ret;
        }

        public void setReverse(int axis, boolean flag) {
            switch (axis) {
                case 0: 
                case 3: {
                    this.xReverse = flag;
                    break;
                }
                case 1: 
                case 4: {
                    this.yReverse = flag;
                }
            }
        }

        public boolean isReverse(int axis) {
            boolean rc = false;
            switch (axis) {
                case 0: 
                case 3: {
                    rc = this.xReverse;
                    break;
                }
                case 1: 
                case 4: {
                    rc = this.yReverse;
                }
            }
            return rc;
        }
    }

    class Branch {
        Point2D kidEnd;
        Point2D parentEnd;
        Color color;
        DendrogramModel.Node node;

        Branch() {
        }
    }

    class Cross {
        Point2D minEnd;
        Point2D maxEnd;
        Color color;
        DendrogramModel.Node node;

        Cross() {
        }
    }
}

