/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.simple;

import com.sas.graphics.silk.simple.SimpleAwtPieChartInterface;
import com.sas.graphics.silk.simple.SimpleDataModelInterface;
import com.sas.graphics.silk.simple.SimplePickInfoInterface;
import com.sas.graphics.silk.simple.SimplePieChartAbstraction;
import com.sas.graphics.silk.simple.SimpleUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;

public class SimpleAwtPieChart
extends SimplePieChartAbstraction
implements SimpleAwtPieChartInterface {
    public static final Object WEIGHT = SimpleUtil.RESPONSE;
    public static final Object FILL;
    public static final Object COLOR;
    private static final int MIN_PREFERRED_RADIUS = 50;
    private Rectangle bounds;

    @Override
    public void setBounds(Rectangle r) {
        this.bounds = r;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public void paint(Graphics g) {
        Rectangle b = this.getBounds();
        if (b == null && (b = g.getClipBounds()) == null) {
            this._paintInvalidPie(null, null, SimpleUtil.UNSPECIFIED_DISPLAY_BOUNDS_ERROR);
            return;
        }
        b = new Rectangle(b.x, b.y, b.width - 1, b.height - 1);
        --b.width;
        --b.height;
        this._paint(g, b);
    }

    private final void _paint(Graphics g, Rectangle b) {
        int hwf;
        int wwf;
        int framePix;
        Rectangle eb;
        double frame = this.getFramePercent();
        double aspect = this.getAspectRatio();
        if (aspect == 0.0) {
            eb = new Rectangle(b);
        } else if ((double)b.width * aspect < (double)b.height) {
            framePix = (int)(frame / 100.0 * (double)b.width);
            wwf = b.width - 2 * framePix;
            hwf = (int)((double)wwf * aspect);
            eb = new Rectangle(b.x + framePix, b.y + (b.height / 2 - hwf / 2), wwf, hwf);
        } else {
            framePix = (int)(frame / 100.0 * (double)b.height);
            hwf = b.height - 2 * framePix;
            wwf = (int)((double)hwf / aspect);
            eb = new Rectangle(b.x + (b.width / 2 - wwf / 2), b.y + framePix, wwf, hwf);
        }
        if (eb.width <= 0) {
            this._paintInvalidPie(g, b, SimpleUtil.INSUFFICIENT_DISPLAY_REALESTATE_ERROR);
        } else {
            Color outlineColor = this.getElementOutlineVisible() == true ? this.getElementOutlineColor() : null;
            double[][] hrxx = null;
            double[] hrx = null;
            Object heightDataObject = this._getHeightData();
            if (heightDataObject instanceof double[][]) {
                hrxx = (double[][])heightDataObject;
                for (int ii = 0; ii < hrxx.length; ++ii) {
                    hrx = hrxx[ii];
                    if (hrx == null) continue;
                    double totalHeight = 0.0;
                    for (int jj = 0; jj < hrx.length; ++jj) {
                        if (Double.isNaN(hrx[jj])) continue;
                        totalHeight += hrx[jj];
                    }
                    int startAngle = 0;
                    int sliceAngle = 0;
                    Rectangle subRect = new Rectangle(eb.x + ii * (eb.width / (hrxx.length + 2)), eb.y + ii * (eb.height / (hrxx.length + 2)), eb.width - 2 * ii * (eb.width / (hrxx.length + 2)), eb.height - 2 * ii * (eb.height / (hrxx.length + 2)));
                    for (int jj = 0; jj < hrx.length; ++jj) {
                        if (Double.isNaN(hrx[jj])) continue;
                        sliceAngle = (int)(hrx[jj] / totalHeight * 360.0 + 0.5);
                        Object fill = this._getSubgroupFill(ii, jj);
                        if (fill != null) {
                            SimpleUtil.setFill(g, fill);
                            g.fillArc(subRect.x, subRect.y, subRect.width, subRect.height, startAngle, sliceAngle);
                            if (outlineColor != null) {
                                g.setColor(outlineColor);
                                g.drawArc(subRect.x, subRect.y, subRect.width, subRect.height, startAngle, sliceAngle);
                            }
                        }
                        startAngle += sliceAngle;
                    }
                }
            } else if (heightDataObject instanceof double[]) {
                hrx = (double[])heightDataObject;
                double totalHeight = 0.0;
                for (int ii = 0; ii < hrx.length; ++ii) {
                    if (Double.isNaN(hrx[ii])) continue;
                    totalHeight += hrx[ii];
                }
                int startAngle = 0;
                int sliceAngle = 0;
                for (int ii = 0; ii < hrx.length; ++ii) {
                    if (Double.isNaN(hrx[ii])) continue;
                    sliceAngle = (int)(hrx[ii] / totalHeight * 360.0 + 0.5);
                    Object fill = this._getCategoryFill(ii);
                    if (fill != null) {
                        SimpleUtil.setFill(g, fill);
                        g.fillArc(eb.x, eb.y, eb.width, eb.height, startAngle, sliceAngle);
                        if (outlineColor != null) {
                            g.setColor(outlineColor);
                            g.drawArc(eb.x, eb.y, eb.width, eb.height, startAngle, sliceAngle);
                        }
                    }
                    startAngle += sliceAngle;
                }
            } else {
                this._paintInvalidPie(g, b, SimpleUtil.UNSUPPORTED_DATA_SOURCE_ERROR);
            }
        }
    }

    protected void _paintInvalidPie(Graphics g, Rectangle b, String message) {
        if (g == null || b != null) {
            // empty if block
        }
        if (message != null) {
            // empty if block
        }
    }

    protected Object _getSubgroupFill(int ii, int jj) {
        Object v = null;
        Object fillData = this._getFillData();
        if (fillData instanceof Object[][]) {
            Object[][] crxx = (Object[][])fillData;
            try {
                int ii2 = ii % crxx.length;
                v = crxx[ii2][jj % crxx[ii2].length];
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (NullPointerException nullPointerException) {}
        } else if (fillData instanceof Object[]) {
            Object[] crx = (Object[])fillData;
            try {
                v = crx[jj % crx.length];
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return v;
    }

    protected Object _getCategoryFill(int ii) {
        return this._getSubgroupFill(-1, ii);
    }

    @Override
    public Dimension getPreferredSize(Graphics g) {
        int x;
        int y = x = Math.max(250, 100);
        return new Dimension(x, y);
    }

    protected Object _getHeightData() {
        Object model = this.getModel();
        if (model instanceof SimpleDataModelInterface) {
            return ((SimpleDataModelInterface)model).getValues(WEIGHT);
        }
        return null;
    }

    protected Object _getFillData() {
        Object model = this.getModel();
        if (model instanceof SimpleDataModelInterface) {
            return ((SimpleDataModelInterface)model).getValues(FILL);
        }
        return null;
    }

    public SimplePickInfoInterface pick(int x, int y) {
        return null;
    }

    static {
        COLOR = FILL = SimpleUtil.FILL;
    }
}

