/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.simple;

import com.sas.graphics.silk.simple.SimpleAwtBarChartInterface;
import com.sas.graphics.silk.simple.SimpleAxisChartStyleInterface;
import com.sas.graphics.silk.simple.SimpleBarChartAbstraction;
import com.sas.graphics.silk.simple.SimpleDataModelInterface;
import com.sas.graphics.silk.simple.SimplePickInfoInterface;
import com.sas.graphics.silk.simple.SimpleUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;

public class SimpleAwtBarChart
extends SimpleBarChartAbstraction
implements SimpleAwtBarChartInterface {
    public static final Object HEIGHT = SimpleUtil.RESPONSE;
    public static final Object FILL;
    public static final Object COLOR;
    private static final int MIN_PREFERRED_BAR_WIDTH = 5;
    private static final int DEFAULT_ELEMENT_THICKNESS = 1;
    private static final double BASELINE = 0.0;
    private Rectangle bounds;

    @Override
    public void setBounds(Rectangle r) {
        this.bounds = r;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public void paint(Graphics g) {
        Rectangle b = this.getBounds();
        if (b == null && (b = g.getClipBounds()) == null) {
            this._paintInvalidBar(null, null, SimpleUtil.UNSPECIFIED_DISPLAY_BOUNDS_ERROR);
            return;
        }
        b = new Rectangle(b.x, b.y, b.width - 1, b.height - 1);
        Object orientation = this.getOrientation();
        if (orientation == SimpleAxisChartStyleInterface.HORIZONTAL_EAST_ORIENTATION) {
            this._paint(g, b, true, false, true);
        } else if (orientation == SimpleAxisChartStyleInterface.HORIZONTAL_WEST_ORIENTATION) {
            this._paint(g, b, true, true, true);
        } else {
            this._paint(g, b, false, false, false);
        }
    }

    private final void _paint(Graphics g, Rectangle b, boolean horizontal, boolean flipIAxis, boolean flipDAxis) {
        double[] minMax = this._calcDependentAxisMinMax();
        double axisMinValue = minMax[0];
        double axisValueRange = minMax[1] - minMax[0];
        boolean dav = this.getDependentAxisVisible();
        boolean iav = this.getIndependentAxisVisible();
        int dalt = dav ? 1 : 0;
        Rectangle eb = new Rectangle(b.x + dalt, b.y, b.width - dalt, b.height);
        int cw = horizontal ? eb.height : eb.width;
        int ch = horizontal ? eb.width : eb.height;
        double scaleFactor = (double)ch / axisValueRange;
        int yOrigin = (int)(-axisMinValue * scaleFactor + 0.5);
        Double elementThickness = this.getElementThickness();
        double percentageOfBarCell = elementThickness.isNaN() ? 1.0 : Math.max(Math.min(elementThickness, 1.0), 0.0);
        int categoryCount = this._getCategoryCount();
        int cellWidth = cw / categoryCount;
        int barWidth = (int)((double)cellWidth * percentageOfBarCell + 0.5);
        int interBarWidth = cellWidth - barWidth;
        int initialSpace = (cw - cellWidth * categoryCount) / 2;
        Color outlineColor = barWidth > 3 && this.getElementOutlineVisible() != false ? this.getElementOutlineColor() : null;
        int bhs = yOrigin;
        int bws = initialSpace + interBarWidth / 2;
        Object heightDataObject = this._getHeightData();
        double[] hrx = null;
        if (heightDataObject instanceof double[][]) {
            double[][] hrxx = (double[][])heightDataObject;
            for (int ii = 0; ii < hrxx.length; ++ii) {
                hrx = hrxx[ii];
                if (hrx != null) {
                    for (int jj = 0; jj < hrx.length; ++jj) {
                        if (Double.isNaN(hrx[jj])) continue;
                        int barHeight = (int)(hrx[jj] * scaleFactor);
                        Object fill = this._getSubgroupFill(ii, jj);
                        if (fill != null) {
                            this._drawRect(g, bws, bhs, barWidth, barHeight, eb, fill, outlineColor, horizontal, flipIAxis, flipDAxis);
                        }
                        bhs += barHeight;
                    }
                }
                bws += cellWidth;
                bhs = yOrigin;
            }
        } else if (heightDataObject instanceof double[]) {
            hrx = (double[])heightDataObject;
            for (int ii = 0; ii < hrx.length; ++ii) {
                Object fill = this._getCategoryFill(ii);
                if (fill != null && !Double.isNaN(hrx[ii])) {
                    int barHeight = (int)(hrx[ii] * scaleFactor);
                    this._drawRect(g, bws, bhs, barWidth, barHeight, eb, fill, outlineColor, horizontal, flipIAxis, flipDAxis);
                }
                bws += cellWidth;
            }
        } else {
            this._paintInvalidBar(g, b, SimpleUtil.UNSUPPORTED_DATA_SOURCE_ERROR);
        }
        if (dav) {
            this._drawRect(g, 0, 0, 0, ch, b, null, this.getDependentAxisColor(), horizontal, flipIAxis, flipDAxis);
        }
        if (iav) {
            this._drawRect(g, 0, yOrigin, cw, 0, eb, null, this.getIndependentAxisColor(), horizontal, flipIAxis, flipDAxis);
        }
    }

    protected void _paintInvalidBar(Graphics g, Rectangle b, String message) {
        if (g == null || b != null) {
            // empty if block
        }
        if (message != null) {
            // empty if block
        }
    }

    @Override
    public Dimension getPreferredSize(Graphics g) {
        int x = Math.max(20, (this._getCategoryCount() + 1) * 5);
        int y = (int)((double)(x * 3 / 4) + 0.5);
        return new Dimension(x, y);
    }

    protected int _getCategoryCount() {
        int v = 0;
        Object heightData = this._getHeightData();
        if (heightData instanceof double[][]) {
            v = ((double[][])heightData).length;
        } else if (heightData instanceof double[]) {
            v = ((double[])heightData).length;
        }
        return v;
    }

    protected Object _getSubgroupFill(int ii, int jj) {
        Object v = null;
        Object fillData = this._getFillData();
        if (fillData instanceof Object[][]) {
            Object[][] crxx = (Object[][])fillData;
            try {
                int ii2 = ii % crxx.length;
                v = crxx[ii2][jj % crxx[ii2].length];
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (NullPointerException nullPointerException) {}
        } else if (fillData instanceof Object[]) {
            Object[] crx = (Object[])fillData;
            try {
                v = crx[jj % crx.length];
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return v;
    }

    protected Object _getCategoryFill(int ii) {
        return this._getSubgroupFill(-1, ii);
    }

    private double[] _calcDependentAxisMinMax() {
        Double pu;
        Double pl;
        double[] hrx = null;
        double min = 0.0;
        double max = 0.0;
        Object heightData = this._getHeightData();
        if (heightData instanceof double[][]) {
            double[][] hrxx = (double[][])heightData;
            for (int ii = 0; ii < hrxx.length; ++ii) {
                hrx = hrxx[ii];
                if (hrx == null) continue;
                double v = 0.0;
                for (int jj = 0; jj < hrx.length; ++jj) {
                    if (Double.isNaN(hrx[jj])) continue;
                    v += hrx[jj];
                }
                min = Math.min(min, v);
                max = Math.max(max, v);
            }
        } else if (heightData instanceof double[]) {
            hrx = (double[])heightData;
            for (int ii = 0; ii < hrx.length; ++ii) {
                if (Double.isNaN(hrx[ii])) continue;
                min = Math.min(min, hrx[ii]);
                max = Math.max(max, hrx[ii]);
            }
        }
        if ((pl = this.getPreferredDependentAxisLowerLimit()) != null && !pl.isNaN()) {
            min = Math.min(pl, min);
        }
        if ((pu = this.getPreferredDependentAxisUpperLimit()) != null && !pu.isNaN()) {
            max = Math.max(pu, max);
        }
        return new double[]{min, max};
    }

    protected Object _getHeightData() {
        Object model = this.getModel();
        if (model instanceof SimpleDataModelInterface) {
            return ((SimpleDataModelInterface)model).getValues(HEIGHT);
        }
        return null;
    }

    protected Object _getFillData() {
        Object model = this.getModel();
        if (model instanceof SimpleDataModelInterface) {
            return ((SimpleDataModelInterface)model).getValues(FILL);
        }
        return null;
    }

    public SimplePickInfoInterface pick(int x, int y) {
        return null;
    }

    private final void _drawRect(Graphics g, int x, int y, int w, int h, Rectangle bounds, Object fill, Color outlineColor, boolean horizontal, boolean flipIAxis, boolean flipDAxis) {
        int x2;
        if (horizontal) {
            int t = x;
            x = y;
            y = t;
            t = w;
            w = h;
            h = t;
        }
        if (h < 0) {
            h = -h;
            y -= h;
        }
        if (w < 0) {
            w = -w;
            x -= w;
        }
        int y2 = flipDAxis ? bounds.y + y : bounds.height + bounds.y - y - h;
        int n = x2 = flipIAxis ? bounds.width + bounds.x - x - w : bounds.x + x;
        if (fill != null && h != 0 && w != 0) {
            SimpleUtil.setFill(g, fill);
            g.fillRect(x2, y2, w, h);
        }
        if (outlineColor != null) {
            g.setColor(outlineColor);
            if (w == 0) {
                g.drawLine(x2, y2, x2, y2 + h);
            } else if (h == 0) {
                g.drawLine(x2, y2, x2 + w, y2);
            } else {
                g.drawLine(x2, y2, x2 + w, y2);
                g.drawLine(x2 + w, y2, x2 + w, y2 + h);
                g.drawLine(x2, y2 + h, x2 + w, y2 + h);
                g.drawLine(x2, y2, x2, y2 + h);
            }
        }
    }

    static {
        COLOR = FILL = SimpleUtil.FILL;
    }
}

