/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.orgchart;

import com.sas.graphics.silk.interfaces.TreeFindInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class FindPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -4653701301934942250L;
    private JLabel findLabel = null;
    private JButton findButton = null;
    private JButton cancelButton = null;
    private JCheckBox matchCaseCheckBox = null;
    private JPanel findDirectionPanel = null;
    private JRadioButton acrossRadioButton = null;
    private JRadioButton downRadioButton = null;
    private TreeFindInterface tree;
    private ResourceBundle rb;
    private JDialog parentDialog;
    private static final String FIND_NEXT_ACTION_COMMAND = "findNext";
    private static final String CANCEL_ACTION_COMMAND = "cancel";
    private JTextField findTextField = null;

    public FindPanel() {
        this.initialize();
        this.rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    }

    public FindPanel(TreeFindInterface tree, JDialog d) {
        this();
        this.tree = tree;
        this.parentDialog = d;
    }

    private void initialize() {
        this.findLabel = new JLabel();
        this.findLabel.setBounds(7, 15, 58, 23);
        this.findLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"OrgChart.FindPanel.Find.txt", (String)"Find:"));
        this.findLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.setLayout(null);
        this.setBounds(0, 0, 408, 148);
        this.add((Component)this.findLabel, null);
        this.add((Component)this.getFindButton(), null);
        this.add((Component)this.getCancelButton(), null);
        this.add((Component)this.getMatchCaseCheckBox(), null);
        this.add((Component)this.getFindDirectionPanel(), null);
        this.add((Component)this.getFindTextField(), null);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.acrossRadioButton);
        bg.add(this.downRadioButton);
    }

    private JButton getFindButton() {
        if (this.findButton == null) {
            this.findButton = new JButton();
            this.findButton.setBounds(300, 13, 97, 26);
            this.findButton.setFont(TabbedPropertiesDialog.dialogFont);
            this.findButton.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"OrgChart.FindPanel.FindNext.txt", (String)"Find Next"));
            this.findButton.setActionCommand(FIND_NEXT_ACTION_COMMAND);
            this.findButton.addActionListener(this);
        }
        return this.findButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setBounds(300, 44, 97, 26);
            this.cancelButton.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"OrgChart.FindPanel.Cancel.txt", (String)"Cancel"));
            this.cancelButton.setFont(TabbedPropertiesDialog.dialogFont);
            this.cancelButton.setActionCommand(CANCEL_ACTION_COMMAND);
            this.cancelButton.addActionListener(this);
        }
        return this.cancelButton;
    }

    private JCheckBox getMatchCaseCheckBox() {
        if (this.matchCaseCheckBox == null) {
            this.matchCaseCheckBox = new JCheckBox();
            this.matchCaseCheckBox.setBounds(7, 44, 88, 27);
            this.matchCaseCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"OrgChart.FindPanel.MatchCase.txt", (String)"Match case"));
            this.matchCaseCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
        }
        return this.matchCaseCheckBox;
    }

    private JPanel getFindDirectionPanel() {
        if (this.findDirectionPanel == null) {
            String txt = ResourceLoader.getResourceString((Object)this.rb, (String)"OrgChart.FindPanel.Direction.txt", (String)"Direction");
            TitledBorder titledBorder = BorderFactory.createTitledBorder(null, txt, 0, 0, null, null);
            titledBorder.setBorder(BorderFactory.createEtchedBorder(1));
            titledBorder.setTitleFont(TabbedPropertiesDialog.dialogFont);
            this.findDirectionPanel = new JPanel();
            this.findDirectionPanel.setLayout(null);
            this.findDirectionPanel.setBounds(99, 44, 196, 85);
            this.findDirectionPanel.setBorder(titledBorder);
            this.findDirectionPanel.add((Component)this.getAcrossRadioButton(), null);
            this.findDirectionPanel.add((Component)this.getDownRadioButton(), null);
        }
        return this.findDirectionPanel;
    }

    private JRadioButton getAcrossRadioButton() {
        if (this.acrossRadioButton == null) {
            this.acrossRadioButton = new JRadioButton();
            this.acrossRadioButton.setBounds(12, 22, 172, 24);
            this.acrossRadioButton.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"OrgChart.FindPanel.Across.txt", (String)"Across then down"));
            this.acrossRadioButton.setFont(TabbedPropertiesDialog.dialogFont);
            this.acrossRadioButton.setSelected(true);
        }
        return this.acrossRadioButton;
    }

    private JRadioButton getDownRadioButton() {
        if (this.downRadioButton == null) {
            this.downRadioButton = new JRadioButton();
            this.downRadioButton.setBounds(12, 47, 172, 24);
            this.downRadioButton.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"OrgChart.FindPanel.Down.txt", (String)"Down then across"));
            this.downRadioButton.setFont(TabbedPropertiesDialog.dialogFont);
        }
        return this.downRadioButton;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (FIND_NEXT_ACTION_COMMAND.equalsIgnoreCase(cmd) && this.tree != null) {
            boolean matchCase = this.matchCaseCheckBox.isSelected();
            String searchString = this.findTextField.getText();
            int searchType = this.acrossRadioButton.isSelected() ? 1 : 2;
            this.tree.find(searchType, searchString, matchCase);
        } else if (CANCEL_ACTION_COMMAND.equalsIgnoreCase(cmd) && this.parentDialog != null) {
            this.parentDialog.setVisible(false);
        }
    }

    private JTextField getFindTextField() {
        if (this.findTextField == null) {
            this.findTextField = new JTextField();
            this.findTextField.setBounds(72, 14, 223, 24);
        }
        return this.findTextField;
    }
}

