/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.orgchart;

import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.orgchart.OrgViewer;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class CustomZoomDialog
extends JDialog
implements ActionListener {
    protected PropertyInterface propertyInterface;
    protected JComponent parent;
    protected ResourceBundle resourceBundle;
    protected JButton okButton = null;
    protected JButton cancelButton = null;
    protected JTextField userInputTextField = null;
    protected JLabel userInputLabel = null;
    private OrgViewer chart = null;
    private int zoomScale = 1;

    public CustomZoomDialog(Object obj) {
        this.propertyInterface = (PropertyInterface)obj;
        this.parent = (JComponent)obj;
        this.chart = (OrgViewer)obj;
        this.resourceBundle = ResourceBundle.getBundle("com.sas.graphics.silk.orgchart.silk_orgchart_NLS");
        this.setLayout(null);
        this.setSize(217, 150);
        String title = ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"CustomZoomDialog.Title.txt", (String)"Custom zoom");
        this.setTitle(title);
        Object currZoomVal = this.propertyInterface.getPropertyValue(804);
        this.zoomScale = (int)Math.max(1.0, (Double)currZoomVal * 100.0);
        String textBoxStr = new String("" + this.zoomScale);
        if (currZoomVal instanceof Number) {
            textBoxStr = new String("" + this.zoomScale);
        }
        this.userInputTextField = new JTextField();
        this.userInputTextField.setText(textBoxStr);
        this.userInputTextField.setFont(TabbedPropertiesDialog.dialogFont);
        this.userInputTextField.setBounds(16, 50, 180, 24);
        this.add(this.userInputTextField);
        String label = ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"CustomZoomDialog.Label.txt", (String)"Please enter zoom scale percentage");
        this.userInputLabel = new JLabel(label);
        this.userInputLabel.setLabelFor(this.userInputTextField);
        this.userInputLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.userInputLabel.setBounds(16, 20, 180, 24);
        this.add(this.userInputLabel);
        this.okButton = new JButton();
        String okString = ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"CustomZoomDialog.OK.txt", (String)"OK");
        this.okButton.setText(okString);
        this.okButton.setActionCommand("OK");
        this.okButton.setFont(TabbedPropertiesDialog.dialogFont);
        this.okButton.setBounds(16, 80, 70, 24);
        this.okButton.addActionListener(this);
        this.add(this.okButton);
        this.cancelButton = new JButton();
        String cancelString = ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"CustomZoomDialog.Cancel.txt", (String)"Cancel");
        this.cancelButton.setText(cancelString);
        this.cancelButton.setActionCommand("Cancel");
        this.cancelButton.setFont(TabbedPropertiesDialog.dialogFont);
        this.cancelButton.setBounds(125, 80, 70, 24);
        this.cancelButton.addActionListener(this);
        this.add(this.cancelButton);
        this.setModal(true);
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String cmmnd = evt.getActionCommand();
        if (cmmnd.equalsIgnoreCase(this.okButton.getActionCommand())) {
            String val = this.userInputTextField.getText();
            int valI = 1;
            try {
                valI = Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                String errorString = ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"CustomZoomDialog.error.txt", (String)"Error");
                String errorMessageString = ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"CustomZoomDialog.errorMessage.txt", (String)"Please enter numeric value.");
                JOptionPane.showMessageDialog(this, errorMessageString, errorString, 0);
                this.userInputTextField.requestFocus();
                return;
            }
            if (this.zoomScale != valI) {
                this.zoomScale = valI;
                this.propertyInterface.setPropertyValue(803, (Object)new Boolean(true));
                this.propertyInterface.applyPropertyChanges();
                this.chart.setZoomScale((double)this.zoomScale / 100.0);
                this.chart.updateView();
            }
            this.setVisible(false);
        } else if (cmmnd.equalsIgnoreCase(this.cancelButton.getActionCommand())) {
            this.setVisible(false);
        }
    }

    public void refreshComponents() {
        this.okButton.removeActionListener(this);
        this.cancelButton.removeActionListener(this);
        Object currZoomVal = this.propertyInterface.getPropertyValue(804);
        this.zoomScale = (int)Math.max(1.0, (Double)currZoomVal * 100.0);
        String textBoxStr = new String("" + this.zoomScale);
        if (currZoomVal instanceof Number) {
            textBoxStr = new String("" + this.zoomScale);
        }
        this.userInputTextField.setText(textBoxStr);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.refreshComponents();
        }
        super.setVisible(b);
    }
}

