/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.map;

import com.sas.graphics.silk.interfaces.ColorSchemeInterface;
import com.sas.graphics.silk.interfaces.DataFilterInfoInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.URLConsumerInterface;
import com.sas.graphics.silk.interfaces.URLSourceInterface;
import com.sas.graphics.silk.map.Categorization;
import com.sas.graphics.silk.util.ColorRamp;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.RoleManager;
import com.sas.graphics.util.Markers;
import com.sas.text.SASFormat;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;

public class MarkerObject
implements URLSourceInterface {
    protected int numMarkers = 0;
    protected ColorRamp colorRamp = null;
    protected Rectangle drawingBounds = null;
    protected ResourceBundle rb = null;
    protected boolean connected = false;
    protected Color linkColor = Color.white;
    protected int markerType = 16;
    protected DataFilterReadInterface data = null;
    RoleManager roleManager = null;
    protected MapMarker[] markers = null;
    protected boolean shadowsOn = false;
    protected Hashtable colorHashtable = null;
    protected boolean useColorRamp = true;
    protected boolean useContrastColors = true;
    protected Categorization categorization = null;
    double xMin;
    double xMax;
    double yMin;
    double yMax;
    boolean[] selectedMarkers = null;
    double markerSize = 20.0;
    double minSize = 0.02;
    double maxSize = 0.08;
    protected ColorSchemeInterface colorScheme = null;
    protected Color selectionColor = new Color(255, 192, 0);
    protected double showLevel = 0.0;
    protected Color[] defaultColors = new Color[]{new Color(97, 115, 169), new Color(141, 166, 66), new Color(152, 52, 28), new Color(253, 200, 97), new Color(138, 164, 201), new Color(111, 117, 0), new Color(184, 127, 50), new Color(214, 198, 110), new Color(94, 82, 139), new Color(103, 153, 32), new Color(200, 87, 60), new Color(127, 89, 52)};
    protected Vector urlConsumers;

    public MarkerObject() {
        this.rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.map.silk_map_NLS");
        this.categorization = new Categorization(0);
        this.urlConsumers = new Vector();
    }

    public void setRoleManager(RoleManager r) {
        this.roleManager = r;
    }

    public void rolesChanged() {
        Object r = this.roleManager.getVariable((Object)RoleInterface.ROLE_MARKER_COLOR, 0);
        if (this.data != null) {
            if (this.data.isNumericVariable(r)) {
                this.checkCategorySize();
            } else {
                this.categorization.setCategoryType(1);
            }
        }
    }

    public void drawMarkers(Graphics g1, Point p, int showLevel, double scale, boolean useSimple) {
        int locationY;
        int locationX;
        int i;
        Object levelRole = this.roleManager.getVariable((Object)RoleInterface.ROLE_MARKER_LEVEL, 0);
        Object URLRole = this.roleManager.getVariable((Object)RoleInterface.ROLE_MARKER_URL, 0);
        if (this.data == null || this.drawingBounds == null) {
            return;
        }
        Graphics2D g = (Graphics2D)g1;
        Color shadowColor = new Color(0, 0, 0, 128);
        scale = 1.0;
        g.translate(p.x, p.y);
        if (this.shadowsOn) {
            g.translate(2, 2);
            g.setColor(shadowColor);
            if (this.connected) {
                Stroke stroke = g.getStroke();
                g.setStroke(new BasicStroke(3.0f));
                for (i = 1; i < this.numMarkers; ++i) {
                    if (levelRole != null && !((Double)this.data.getValue(levelRole, (long)i) <= (double)showLevel)) continue;
                    g.drawLine(this.markers[i - 1].x, this.markers[i - 1].y, this.markers[i].x, this.markers[i].y);
                    locationX = this.markers[i - 1].x + (this.markers[i].x - this.markers[i - 1].x) / 2;
                    locationY = this.markers[i - 1].y + (this.markers[i].y - this.markers[i - 1].y) / 2;
                    this.drawArrow(g, this.markers[i - 1].x, this.markers[i - 1].y, locationX, locationY);
                }
                g.setStroke(stroke);
            }
            for (int e = 0; e < this.numMarkers; ++e) {
                if (levelRole != null && !((Double)this.data.getValue(levelRole, (long)e) <= (double)showLevel)) continue;
                if (useSimple) {
                    Markers.drawStroke((Graphics)g, null, null, (int)this.markerType, (int)((int)((double)this.markers[e].size * scale)), (int)((int)((double)this.markers[e].x * scale)), (int)((int)((double)this.markers[e].y * scale)), (boolean)true);
                    continue;
                }
                Markers.draw((Graphics)g, null, null, (int)this.markerType, (int)((int)((double)this.markers[e].size * scale)), (int)((int)((double)this.markers[e].x * scale)), (int)((int)((double)this.markers[e].y * scale)));
            }
            g.translate(-2, -2);
        }
        if (this.connected) {
            g.setColor(this.linkColor);
            Stroke stroke = g.getStroke();
            g.setStroke(new BasicStroke(3.0f));
            for (i = 1; i < this.numMarkers; ++i) {
                if (levelRole != null && !((Double)this.data.getValue(levelRole, (long)i) <= (double)showLevel)) continue;
                g.drawLine(this.markers[i - 1].x, this.markers[i - 1].y, this.markers[i].x, this.markers[i].y);
                locationX = this.markers[i - 1].x + (this.markers[i].x - this.markers[i - 1].x) / 2;
                locationY = this.markers[i - 1].y + (this.markers[i].y - this.markers[i - 1].y) / 2;
                this.drawArrow(g, this.markers[i - 1].x, this.markers[i - 1].y, locationX, locationY);
            }
            g.setStroke(stroke);
        }
        boolean writeURLs = URLRole != null && this.urlConsumers != null && this.urlConsumers.size() > 0;
        boolean didWriteURL = false;
        for (int i2 = 0; i2 < this.numMarkers; ++i2) {
            if (levelRole != null && !((Double)this.data.getValue(levelRole, (long)i2) <= (double)showLevel)) continue;
            if (writeURLs) {
                didWriteURL = this.writeURL(URLRole, i2);
            }
            Color color = this.selectedMarkers != null && i2 < this.numMarkers && this.selectedMarkers[i2] ? this.selectionColor : this.markers[i2].color;
            if (useSimple) {
                Markers.drawStroke((Graphics)g, (Color)color, (Color)Color.black, (int)this.markerType, (int)((int)((double)this.markers[i2].size * scale)), (int)((int)((double)this.markers[i2].x * scale)), (int)((int)((double)this.markers[i2].y * scale)), (boolean)true);
            } else {
                Markers.draw((Graphics)g, (Color)color, (Color)Color.black, (int)this.markerType, (int)((int)((double)this.markers[i2].size * scale)), (int)((int)((double)this.markers[i2].x * scale)), (int)((int)((double)this.markers[i2].y * scale)));
            }
            if (!didWriteURL) continue;
            this.closeURLs();
        }
        g.translate(-p.x, -p.y);
    }

    protected boolean writeURL(Object URLRole, long iobs) {
        int n = this.urlConsumers.size();
        Object o = this.data.getValue(URLRole, iobs);
        if (o == null) {
            return false;
        }
        String s = o.toString();
        for (int i = 0; i < n; ++i) {
            URLConsumer con = (URLConsumer)this.urlConsumers.elementAt(i);
            if (con == null) continue;
            con.consumer.beginURL(con.context, (Object)s, null);
        }
        return true;
    }

    protected void closeURLs() {
        int n;
        if (this.urlConsumers == null || (n = this.urlConsumers.size()) <= 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            URLConsumer con = (URLConsumer)this.urlConsumers.elementAt(i);
            if (con == null) continue;
            con.consumer.endURL(con.context);
        }
    }

    public void drawAllMarkers(Graphics2D g, Point p) {
    }

    public void drawSelectedMarkers(Graphics g1, Point p) {
    }

    public void regenerateMarkers() {
        double[] range;
        boolean sized;
        if (this.numMarkers == 0 || this.drawingBounds == null) {
            return;
        }
        Object xRole = this.roleManager.getVariable((Object)RoleInterface.ROLE_MARKER_X, 0);
        Object yRole = this.roleManager.getVariable((Object)RoleInterface.ROLE_MARKER_Y, 0);
        Object colorRole = this.roleManager.getVariable((Object)RoleInterface.ROLE_MARKER_COLOR, 0);
        Object colorIndexRole = this.roleManager.getVariable((Object)RoleInterface.ROLE_MARKER_COLOR_INDEX, 0);
        Object sizeRole = this.roleManager.getVariable((Object)RoleInterface.ROLE_MARKER_SIZE, 0);
        if (this.data == null || xRole == null || yRole == null) {
            return;
        }
        Color[] colors = null;
        double dMin = 0.0;
        double dMax = 1.0;
        boolean bl = sized = sizeRole != null && this.data.verifyVariable(sizeRole);
        if (sized && (range = Categorization.getContinuousRanges(this.data, sizeRole, 2)) != null) {
            if (range.length > 1) {
                dMin = range[0];
                dMax = range[1];
            } else if (range.length == 1) {
                dMin = dMax = range[0];
            }
        }
        if (this.colorScheme != null) {
            colors = this.colorScheme.getDataColors(true);
        }
        int num = this.data.getNumberObservations(xRole);
        int count = 0;
        for (int i = 0; i < num; ++i) {
            Double x = (Double)this.data.getValue(xRole, (long)i);
            Double y = (Double)this.data.getValue(yRole, (long)i);
            if (this.data.isMissing(xRole, (Object)x) || this.data.isMissing(yRole, (Object)y)) continue;
            this.markers[count].x = (int)(((Double)this.data.getValue(xRole, (long)i) - this.xMin) / (this.xMax - this.xMin) * (double)this.drawingBounds.width);
            this.markers[count].y = this.drawingBounds.height - (int)(((Double)this.data.getValue(yRole, (long)i) - this.yMin) / (this.yMax - this.yMin) * (double)this.drawingBounds.height);
            if (sized) {
                double val = (Double)this.data.getValue(sizeRole, (long)i);
                this.markers[count].size = (int)((this.minSize + (val - dMin) * (this.maxSize - this.minSize) / (dMax - dMin)) * this.markerSize);
            } else {
                this.markers[count].size = (int)(this.minSize * this.markerSize);
            }
            if (colorIndexRole != null) {
                int index = ((Double)this.data.getValue(colorIndexRole, (long)i)).intValue();
                this.markers[count].color = colors[index % colors.length];
            } else if (colorRole == null) {
                this.markers[count].color = colors[0];
            } else if (this.data.isNumericVariable(colorRole)) {
                Double d = (Double)this.data.getValue(colorRole, (long)i);
                this.markers[count].color = this.categorization.getCategoryType() == 1 ? (Color)this.colorHashtable.get(d) : (this.colorRamp == null ? colors[0] : this.colorRamp.query((Object)d, false, null));
            } else if (this.colorHashtable != null) {
                String s = (String)this.data.getValue(colorRole, (long)i);
                this.markers[count].color = (Color)this.colorHashtable.get(s);
            } else {
                this.markers[count].color = colors[0];
            }
            ++count;
        }
    }

    public void syncColors() {
        Object colorRole = this.roleManager.getVariable((Object)RoleInterface.ROLE_MARKER_COLOR, 0);
        if (this.data == null || !(this.data instanceof DataFilterInfoInterface)) {
            return;
        }
        if (colorRole != null) {
            this.recreateColorRamp();
        }
        this.regenerateMarkers();
    }

    public String getToolTipText(Point p) {
        Object colorRole = this.roleManager.getVariable((Object)RoleInterface.ROLE_MARKER_COLOR, 0);
        Object sizeRole = this.roleManager.getVariable((Object)RoleInterface.ROLE_MARKER_SIZE, 0);
        int i = this.pick(p.x, p.y);
        if (i >= 0) {
            String s = "";
            if (colorRole != null) {
                s = s + this.data.getVariableDescription(colorRole) + ":\t" + this.data.getFormattedValue(colorRole, this.data.getValue(colorRole, (long)i), SASFormat.class).toString() + "\n";
            }
            if (sizeRole != null) {
                s = s + this.data.getVariableDescription(sizeRole) + ":\t" + this.data.getFormattedValue(sizeRole, this.data.getValue(sizeRole, (long)i), SASFormat.class).toString() + "\n";
            }
            return s;
        }
        return null;
    }

    public void setDrawingBounds(Rectangle r) {
        this.drawingBounds = r;
        this.recalculateMarkerSize();
        this.regenerateMarkers();
    }

    public void addSelectedMarker(Integer i) {
        if (this.selectedMarkers != null && i < this.numMarkers) {
            this.selectedMarkers[i.intValue()] = true;
        }
    }

    public void removeSelectedMarker(Integer i) {
        if (this.selectedMarkers != null && i < this.numMarkers) {
            this.selectedMarkers[i.intValue()] = false;
        }
    }

    public void clearSelectedMarkers() {
        this.selectedMarkers = new boolean[this.numMarkers];
    }

    public boolean isMarkerSelected(Integer i) {
        if (this.selectedMarkers != null && i < this.numMarkers) {
            return this.selectedMarkers[i];
        }
        return false;
    }

    public ArrayList getSelectedMarkers() {
        ArrayList<Integer> markers = new ArrayList<Integer>();
        if (this.selectedMarkers != null) {
            for (int i = 0; i < this.selectedMarkers.length; ++i) {
                if (!this.selectedMarkers[i]) continue;
                markers.add(new Integer(i));
            }
        }
        return markers;
    }

    public void pick(Rectangle r) {
        Object xRole = this.roleManager.getVariable((Object)RoleInterface.ROLE_MARKER_X, 0);
        Object yRole = this.roleManager.getVariable((Object)RoleInterface.ROLE_MARKER_Y, 0);
        if (this.markers == null) {
            return;
        }
        Rectangle boundingRect = new Rectangle();
        if (xRole == null || yRole == null) {
            return;
        }
        this.clearSelectedMarkers();
        for (int i = 0; i < this.markers.length; ++i) {
            boundingRect.x = this.markers[i].x - this.markers[i].size / 2;
            boundingRect.width = this.markers[i].size;
            boundingRect.y = this.markers[i].y - this.markers[i].size / 2;
            boundingRect.height = this.markers[i].size;
            if (!boundingRect.intersects(r.x, r.y, r.width, r.height)) continue;
            Integer myInt = new Integer(i);
            this.addSelectedMarker(myInt);
        }
    }

    public int pick(double x, double y) {
        if (this.markers == null) {
            return -1;
        }
        for (int i = 0; i < this.markers.length; ++i) {
            if (!(Math.abs(x - (double)this.markers[i].x) <= (double)(this.markers[i].size / 2)) || !(Math.abs(y - (double)this.markers[i].y) <= (double)(this.markers[i].size / 2))) continue;
            return i;
        }
        return -1;
    }

    public void setExtents(double x1, double x2, double y1, double y2) {
        this.xMin = x1;
        this.xMax = x2;
        this.yMin = y1;
        this.yMax = y2;
        this.regenerateMarkers();
    }

    private void recalculateMarkerSize() {
        this.markerSize = (int)Math.sqrt(this.drawingBounds.width * this.drawingBounds.width + this.drawingBounds.height * this.drawingBounds.height);
    }

    private void recreateColorRamp() {
        Object xRole = this.roleManager.getVariable((Object)RoleInterface.ROLE_MARKER_X, 0);
        Object yRole = this.roleManager.getVariable((Object)RoleInterface.ROLE_MARKER_Y, 0);
        Object colorRole = this.roleManager.getVariable((Object)RoleInterface.ROLE_MARKER_COLOR, 0);
        Object colorIndexRole = this.roleManager.getVariable((Object)RoleInterface.ROLE_MARKER_COLOR_INDEX, 0);
        if (xRole == null || yRole == null || colorRole == null && colorIndexRole == null) {
            return;
        }
        if (colorIndexRole != null) {
            double[] d = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0};
            Color[] colors = this.getColors(12);
            this.colorRamp = new ColorRamp((Object)colors, (Object)d, 0L);
        } else if (this.data.isNumericVariable(colorRole)) {
            if (this.categorization.getCategoryType() == 0) {
                double[] d = this.categorization.getNumericRanges(this.data, colorRole);
                Color[] colors = this.getColors(d.length);
                this.colorRamp = new ColorRamp((Object)colors, (Object)d, 0L);
            } else if (this.categorization.getCategoryType() == 3 || this.categorization.getCategoryType() == 2) {
                double[] d = this.categorization.getNumericRanges(this.data, colorRole);
                Color[] colors = this.getColors(d.length - 1);
                this.colorRamp = new ColorRamp((Object)colors, (Object)d, 0L);
            } else if (this.categorization.getCategoryType() == 1) {
                double[] d = this.categorization.getNumericRanges(this.data, colorRole);
                Color[] colors = this.getColors(d.length);
                this.colorHashtable = new Hashtable(d.length);
                for (int e = 0; e < d.length; ++e) {
                    this.colorHashtable.put(new Double(d[e]), colors[e]);
                }
                this.colorRamp = null;
            }
        } else {
            String[] s = Categorization.getStringRanges(this.data, colorRole, this.getSorted());
            Color[] colors = this.getColors(s.length);
            this.colorHashtable = new Hashtable(s.length);
            for (int e = 0; e < s.length; ++e) {
                this.colorHashtable.put(s[e], colors[e]);
            }
            this.colorRamp = null;
        }
    }

    private Color[] getColors(int numColors) {
        Color[] colors = new Color[numColors];
        if (this.useColorRamp) {
            Color[] rampColors = this.colorScheme.getRampColors(true, this.useContrastColors, false);
            if (colors.length == 1) {
                colors[0] = rampColors[0];
            } else {
                Color minColor = rampColors[0];
                Color maxColor = rampColors[1];
                float redGradient = (float)(maxColor.getRed() - minColor.getRed()) / 255.0f / (float)(numColors - 1);
                float greenGradient = (float)(maxColor.getGreen() - minColor.getGreen()) / 255.0f / (float)(numColors - 1);
                float blueGradient = (float)(maxColor.getBlue() - minColor.getBlue()) / 255.0f / (float)(numColors - 1);
                for (int k = 0; k < numColors; ++k) {
                    colors[k] = new Color(Math.abs((float)minColor.getRed() / 255.0f + (float)k * redGradient), Math.abs((float)minColor.getGreen() / 255.0f + (float)k * greenGradient), Math.abs((float)minColor.getBlue() / 255.0f + (float)k * blueGradient));
                }
            }
        } else {
            Color[] dataColors = this.colorScheme.getDataColors(true, this.useContrastColors);
            for (int i = 0; i < numColors; ++i) {
                colors[i] = this.getCycledColor(dataColors[i % this.defaultColors.length], (i - 1) / this.defaultColors.length);
            }
        }
        return colors;
    }

    public Color[] getMarkerColors() {
        Object colorRole = this.roleManager.getVariable((Object)RoleInterface.ROLE_MARKER_COLOR, 0);
        Object colorIndexRole = this.roleManager.getVariable((Object)RoleInterface.ROLE_MARKER_COLOR_INDEX, 0);
        if (colorRole == null && colorIndexRole == null) {
            return null;
        }
        if (colorIndexRole != null) {
            return this.getColors(12);
        }
        if (!this.data.isNumericVariable(colorRole)) {
            String[] s = Categorization.getStringRanges(this.data, colorRole, this.getSorted());
            Color[] c2 = new Color[s.length];
            for (int i = 0; i < s.length; ++i) {
                c2[i] = (Color)this.colorHashtable.get(s[i]);
            }
            return c2;
        }
        if (this.categorization.getCategoryType() == 1) {
            boolean sorted = this.getSorted();
            double[] d = Categorization.getDiscreteRanges(this.data, colorRole, sorted);
            Color[] c2 = new Color[d.length];
            for (int i = 0; i < d.length; ++i) {
                c2[i] = (Color)this.colorHashtable.get(new Double(d[i]));
            }
            return c2;
        }
        if (this.categorization.getCategoryType() == 0) {
            return this.colorRamp.getColors();
        }
        Color[] c1 = this.colorRamp.getColors();
        Color[] c2 = new Color[c1.length - 1];
        System.arraycopy(c1, 0, c2, 0, c1.length - 1);
        return c2;
    }

    public String[] getMarkerColorLabels() {
        String[] strings;
        Object markerColorRole = this.roleManager.getVariable((Object)RoleInterface.ROLE_MARKER_COLOR, 0);
        Object[] breaks = null;
        if (this.data.isNumericVariable(markerColorRole)) {
            if (this.categorization.getCategoryType() == 1) {
                double[] d = Categorization.getDiscreteRanges(this.data, markerColorRole, this.getSorted());
                strings = new String[d.length];
                for (int i = 0; i < d.length; ++i) {
                    Double myDouble = new Double(d[i]);
                    strings[i] = this.data.getFormattedValue(markerColorRole, (Object)myDouble, this.data.getFormat(markerColorRole, SASFormat.class)).toString();
                }
            } else {
                if (this.colorRamp == null) {
                    return null;
                }
                breaks = this.colorRamp.getBreaks();
                int size = breaks.length - 1;
                strings = new String[size];
                String sep = ResourceLoader.getResourceString((Object)this.rb, (String)"MapObject.BreakSeparator.txt", (String)" - ");
                sep = " " + sep.trim() + " ";
                for (int i = 0; i < size; ++i) {
                    String s1 = this.data.getFormattedValue(markerColorRole, breaks[i], this.data.getFormat(markerColorRole, SASFormat.class)).toString();
                    String s2 = this.data.getFormattedValue(markerColorRole, breaks[i + 1], this.data.getFormat(markerColorRole, SASFormat.class)).toString();
                    if (this.categorization.getCategoryType() == 1) continue;
                    strings[i] = s1.trim() + sep + s2.trim();
                }
            }
        } else {
            strings = Categorization.getStringRanges(this.data, markerColorRole, this.getSorted());
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = this.data.getFormattedValue(markerColorRole, (Object)strings[i], this.data.getFormat(markerColorRole, SASFormat.class));
            }
        }
        return strings;
    }

    private boolean getSorted() {
        boolean sorted = false;
        Object order = this.roleManager.getSortOrder((Object)RoleInterface.ROLE_MAP_COLOR_INDEX);
        if (order instanceof Number) {
            sorted = ((Number)order).intValue() == 1;
        }
        return sorted;
    }

    protected Color getCycledColor(Color color, int cycle) {
        if (cycle > 0) {
            float[] hsbVals = new float[3];
            Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsbVals);
            if (cycle < 5) {
                float cycleFactor = (float)Math.pow(0.8, cycle);
                color = Color.getHSBColor(hsbVals[0], hsbVals[1], hsbVals[2] * cycleFactor);
            } else if (cycle < 10) {
                float cycleFactor = (float)Math.pow(0.8, (double)cycle - 4.0);
                color = Color.getHSBColor(hsbVals[0], hsbVals[1] * cycleFactor, hsbVals[2]);
            } else if (cycle < 15) {
                float cycleFactor = (float)Math.pow(0.8, (double)cycle - 9.0);
                color = Color.getHSBColor(hsbVals[0], hsbVals[1] * cycleFactor, hsbVals[2] * cycleFactor);
            }
        }
        return color;
    }

    public boolean isShadowsOn() {
        return this.shadowsOn;
    }

    public void setShadowsOn(boolean shadowsOn) {
        this.shadowsOn = shadowsOn;
    }

    public String[] getColorLegendLabels() {
        Object[] breaks = this.colorRamp.getBreaks();
        String[] strings = new String[breaks.length - 1];
        String sep = ResourceLoader.getResourceString((Object)this.rb, (String)"MarkerObject.BreakSeparator.txt", (String)" - ");
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = breaks[i].toString() + sep + breaks[i + 1].toString();
        }
        return strings;
    }

    public Color[] getColorLegendColors() {
        Object colorRole = this.roleManager.getVariable((Object)RoleInterface.ROLE_MARKER_COLOR, 0);
        if (this.colorRamp == null) {
            return null;
        }
        if (!this.data.isNumericVariable(colorRole) || this.categorization.getCategoryType() == 0) {
            return this.colorRamp.getColors();
        }
        Color[] c1 = this.colorRamp.getColors();
        Color[] c2 = new Color[c1.length - 1];
        System.arraycopy(c1, 0, c2, 0, c1.length - 1);
        return c2;
    }

    public void setColorScheme(ColorSchemeInterface scheme) {
        this.colorScheme = scheme;
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color selectionColor) {
        this.selectionColor = selectionColor;
        this.regenerateMarkers();
    }

    public Categorization getCategorization() {
        return this.categorization;
    }

    public void setCategorization(Categorization categorization) {
        this.categorization = categorization;
        this.checkCategorySize();
        this.recreateColorRamp();
        this.regenerateMarkers();
    }

    private void checkCategorySize() {
        double[] myRanges;
        Object colorRole = this.roleManager.getVariable((Object)RoleInterface.ROLE_MARKER_COLOR, 0);
        if (colorRole != null && this.data.isNumericVariable(colorRole) && this.categorization.getCategoryType() != 1 && (myRanges = Categorization.getDiscreteRanges(this.data, colorRole, true)).length == 1) {
            this.categorization.setCategoryType(1);
        }
    }

    public DataFilterReadInterface getData() {
        return this.data;
    }

    public void setData(DataFilterReadInterface data) {
        this.data = data;
        this.regenerateMarkers();
    }

    public void recreateMarkers() {
        Object xRole = this.roleManager.getVariable((Object)RoleInterface.ROLE_MARKER_X, 0);
        Object yRole = this.roleManager.getVariable((Object)RoleInterface.ROLE_MARKER_Y, 0);
        if (this.data != null && xRole != null) {
            int i;
            int num;
            this.numMarkers = num = this.data.getNumberObservations(xRole);
            for (i = 0; i < num; ++i) {
                if (!this.data.isGraphed((long)i)) {
                    --this.numMarkers;
                    continue;
                }
                if (this.data.isMissing(xRole, this.data.getValue(xRole, (long)i))) {
                    --this.numMarkers;
                    continue;
                }
                if (!this.data.isMissing(yRole, this.data.getValue(yRole, (long)i))) continue;
                --this.numMarkers;
            }
            this.selectedMarkers = new boolean[this.numMarkers];
            this.markers = new MapMarker[this.numMarkers];
            for (i = 0; i < this.numMarkers; ++i) {
                this.markers[i] = new MapMarker();
            }
        } else {
            this.numMarkers = 0;
        }
    }

    public void setMarkerType(String type) {
        if (type.equalsIgnoreCase("Circle")) {
            this.markerType = 16;
        } else if (type.equalsIgnoreCase("Plus")) {
            this.markerType = 17;
        } else if (type.equalsIgnoreCase("Cross")) {
            this.markerType = 52;
        } else if (type.equalsIgnoreCase("Diamond")) {
            this.markerType = 22;
        } else if (type.equalsIgnoreCase("Square")) {
            this.markerType = 19;
        } else if (type.equalsIgnoreCase("Star")) {
            this.markerType = 23;
        }
    }

    public String getMarkerType() {
        if (this.markerType == 16) {
            return "Circle";
        }
        if (this.markerType == 17) {
            return "Plus";
        }
        if (this.markerType == 52) {
            return "Cross";
        }
        if (this.markerType == 22) {
            return "Diamond";
        }
        if (this.markerType == 19) {
            return "Square";
        }
        if (this.markerType == 23) {
            return "Star";
        }
        return "None";
    }

    public double getMinSize() {
        return this.minSize;
    }

    public void setMinSize(double minSize) {
        this.minSize = minSize;
    }

    public double getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(double maxSize) {
        this.maxSize = maxSize;
    }

    public Color getDefaultColor() {
        return Color.black;
    }

    public void setDefaultColor(Color defaultColor) {
    }

    public ColorRamp getColorRamp() {
        return this.colorRamp;
    }

    public void setColorRamp(ColorRamp colorRamp) {
        this.colorRamp = colorRamp;
    }

    public void setLinkMarkers(boolean b) {
        this.connected = b;
    }

    public boolean getLinkMarkers() {
        return this.connected;
    }

    public Color getLinkColor() {
        return this.linkColor;
    }

    public void setLinkColor(Color linkColor) {
        this.linkColor = linkColor;
    }

    public void drawArrow(Graphics g, int x1, int y1, int x2, int y2) {
        g.drawPolygon(this.getArrow(x1, y1, x2, y2, 8, 4, 0.5));
    }

    public Polygon getArrow(int x1, int y1, int x2, int y2, int headsize, int difference, double factor) {
        int[] crosslinebase = this.getArrowHeadLine(x1, y1, x2, y2, headsize);
        int[] headbase = this.getArrowHeadLine(x1, y1, x2, y2, headsize - difference);
        int[] crossline = this.getArrowHeadCrossLine(crosslinebase[0], crosslinebase[1], x2, y2, factor);
        Polygon head = new Polygon();
        head.addPoint(headbase[0], headbase[1]);
        head.addPoint(crossline[0], crossline[1]);
        head.addPoint(x2, y2);
        head.addPoint(crossline[2], crossline[3]);
        head.addPoint(headbase[0], headbase[1]);
        head.addPoint(x1, y1);
        return head;
    }

    public int[] getArrowHeadLine(int xsource, int ysource, int xdest, int ydest, int distance) {
        int[] arrowhead = new int[2];
        int headsize = distance;
        double stretchfactor = 0.0;
        stretchfactor = 1.0 - (double)headsize / Math.sqrt((xdest - xsource) * (xdest - xsource) + (ydest - ysource) * (ydest - ysource));
        arrowhead[0] = (int)(stretchfactor * (double)(xdest - xsource)) + xsource;
        arrowhead[1] = (int)(stretchfactor * (double)(ydest - ysource)) + ysource;
        return arrowhead;
    }

    public int[] getArrowHeadCrossLine(int x1, int x2, int b1, int b2, double factor) {
        int[] crossline = new int[4];
        int x_dest = (int)((double)(b1 - x1) * factor + (double)x1);
        int y_dest = (int)((double)(b2 - x2) * factor + (double)x2);
        crossline[0] = x1 + x2 - y_dest;
        crossline[1] = x2 + x_dest - x1;
        crossline[2] = crossline[0] + (x1 - crossline[0]) * 2;
        crossline[3] = crossline[1] + (x2 - crossline[1]) * 2;
        return crossline;
    }

    public synchronized void addURLConsumer(Object context, URLConsumerInterface consumer) {
        URLConsumer con;
        Object o;
        int i;
        int n = 0;
        if (consumer == null || this.urlConsumers == null) {
            return;
        }
        n = this.urlConsumers.size();
        for (i = 0; !(i >= n || (o = this.urlConsumers.elementAt(i)) != null && o instanceof URLConsumer && consumer.equals((Object)(con = (URLConsumer)o))); ++i) {
        }
        if (i < n) {
            return;
        }
        this.urlConsumers.addElement(new URLConsumer(context, consumer));
    }

    public synchronized void removeURLConsumer(URLConsumerInterface consumer) {
        URLConsumer con;
        Object o;
        int i;
        int n = 0;
        if (consumer == null || this.urlConsumers == null) {
            return;
        }
        n = this.urlConsumers.size();
        for (i = 0; !(i >= n || (o = this.urlConsumers.elementAt(i)) != null && o instanceof URLConsumer && consumer.equals((Object)(con = (URLConsumer)o))); ++i) {
        }
        if (i >= n) {
            return;
        }
        this.urlConsumers.removeElementAt(i);
    }

    public boolean isUseColorRamp() {
        return this.useColorRamp;
    }

    public void setUseColorRamp(boolean b) {
        this.useColorRamp = b;
    }

    protected class MapMarker {
        int x;
        int y;
        Color color;
        int size;
        int level;

        protected MapMarker() {
        }
    }

    class URLConsumer {
        public Object context;
        public URLConsumerInterface consumer;

        public URLConsumer(Object context, URLConsumerInterface consumer) {
            this.context = context;
            this.consumer = consumer;
        }
    }
}

