/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.map;

import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.URLConsumerInterface;
import com.sas.graphics.silk.map.Categorization;
import com.sas.graphics.silk.simple.SimpleAwtBarChart;
import com.sas.graphics.silk.simple.SimpleAwtPieChart;
import com.sas.graphics.silk.simple.SimpleDataModel;
import com.sas.graphics.silk.util.ColorRamp;
import com.sas.graphics.silk.util.GlobalDefaults;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.RoleManager;
import com.sas.graphics.silk.util.Text;
import com.sas.graphics.styles.Style;
import com.sas.graphics.util.FillPattern;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.WKBMultiPolygon;
import com.sas.graphics.util.WKBPolygon;
import com.sas.text.SASFormat;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;

public class MapObject {
    protected ArrayList selectedRegions = null;
    protected HashMap regionIDHashMap = null;
    protected HashMap mapIDHashMap = null;
    protected WKBMultiPolygon[] multiPolygons = null;
    protected int numMultiPolygons = 0;
    protected Area[] regionAreas = null;
    protected Point[] centroids = null;
    protected ColorRamp colorRamp = null;
    protected Rectangle drawingBounds = null;
    protected Rectangle totalBounds = null;
    protected double graphMin = Double.MAX_VALUE;
    protected double graphMax = -1.7976931348623157E308;
    protected boolean useContrastColors = true;
    private Hashtable colorHashtable = null;
    protected DataFilterReadInterface spatialData = null;
    protected DataFilterReadInterface mapResponseData = null;
    protected RoleManager roles = null;
    protected Object mapColorRole = null;
    protected Object mapTransparencyRole = null;
    protected Object mapOpacityRole = null;
    protected Object mapWatermarkRole = null;
    protected Vector mapIDVector = null;
    protected String graphType = "bar";
    protected int[] indexArray = null;
    protected boolean useColorRamp = false;
    protected boolean shadowsOn = false;
    protected boolean showOutlines = true;
    protected boolean showGraphs = true;
    protected boolean showNonExplodedGraphs = true;
    protected boolean colorGraphsByChart = true;
    protected int outlineWidth = 1;
    protected Categorization categorization = null;
    protected Font labelFont = null;
    double xMin;
    double xMax;
    double yMin;
    double yMax;
    protected int labelTransparency = 100;
    protected int hitsGraphIndex = -1;
    protected Text text;
    protected int zoomOutlineWidth = 2;
    protected ResourceBundle rb = null;
    protected Color defaultColor = Color.gray;
    protected Style style = null;
    protected Color selectionColor = new Color(255, 192, 0);
    protected Color outlineColor = Color.black;
    protected Vector urlConsumers;
    protected double minGraphPercent = 5.0;
    protected double maxGraphPercent = 15.0;
    protected boolean explodeGraphs = true;
    double[] transparencyRange = null;
    double[] opacityRange = null;
    double[] watermarkRange = null;
    double[] discreteRanges = null;
    double[] numericRanges = null;
    String[] stringRanges = null;
    boolean graphExtentsCalculated = false;
    boolean drawAllRegions = false;
    protected Color[] defaultColors = new Color[]{new Color(97, 115, 169), new Color(141, 166, 66), new Color(152, 52, 28), new Color(253, 200, 97), new Color(138, 164, 201), new Color(111, 117, 0), new Color(184, 127, 50), new Color(214, 198, 110), new Color(94, 82, 139), new Color(103, 153, 32), new Color(200, 87, 60), new Color(127, 89, 52)};
    protected GlobalDefaults globalDefaults = new GlobalDefaults();

    public MapObject() {
        this.rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.map.silk_map_NLS");
        this.selectedRegions = new ArrayList();
        this.categorization = new Categorization();
        this.labelFont = FontManager.getFont((String)"Dialog", (int)0, (int)10);
        this.text = new Text();
        Font f = this.text.getFont();
        Font f2 = FontManager.getFont((String)f.getFamily(), (int)f.getStyle(), (int)10);
        this.text.setFont((Object)f2);
        this.text.setPropertyValue(9006, (Object)new Integer(0));
        this.urlConsumers = new Vector();
    }

    public void setRoleManager(RoleManager r1) {
        this.roles = r1;
    }

    public void drawGraphs(Graphics g1, Point p, double scale) {
        int j;
        int ysize;
        int xsize;
        int i;
        if (this.roles == null) {
            return;
        }
        int numBars = this.roles.getNumVariablesAssigned((Object)RoleInterface.ROLE_GRAPH_VAR);
        if (numBars == 0 || this.centroids == null) {
            return;
        }
        if (!this.graphExtentsCalculated) {
            this.resetGraphExtents();
        }
        boolean bars = this.graphType.equalsIgnoreCase("bar");
        Graphics2D g = (Graphics2D)g1;
        g.translate(p.x, p.y);
        if (scale != 1.0) {
            g.scale(scale, scale);
        }
        Rectangle r = new Rectangle();
        SimpleAwtBarChart simpleBar = new SimpleAwtBarChart();
        SimpleAwtPieChart simplePie = new SimpleAwtPieChart();
        SimpleDataModel simpleData = new SimpleDataModel();
        if (bars) {
            simpleBar.setElementThickness(new Double(0.8));
            simpleBar.setPreferredDependentAxisLowerLimit(new Double(this.graphMin));
            simpleBar.setPreferredDependentAxisUpperLimit(new Double(this.graphMax));
        }
        double[] graphData = new double[numBars];
        Color[] graphColors = new Color[numBars];
        Object[] graphRoles = new Object[numBars];
        for (i = 0; i < numBars; ++i) {
            graphRoles[i] = this.roles.getVariable((Object)RoleInterface.ROLE_GRAPH_VAR, i);
        }
        Color[] colors = this.style.getDataLineColors();
        if (this.showNonExplodedGraphs) {
            xsize = (int)((double)this.drawingBounds.width * this.minGraphPercent / 100.0 * 1.5);
            ysize = (int)((double)this.drawingBounds.width * this.minGraphPercent / 100.0);
            for (i = 0; i < this.centroids.length; ++i) {
                if (this.hitsGraphIndex == i || this.indexArray[i] == -1) continue;
                for (j = 0; j < numBars; ++j) {
                    graphData[j] = (Double)this.mapResponseData.getValue(graphRoles[j], (long)this.indexArray[i]);
                    graphColors[j] = bars && this.colorGraphsByChart ? colors[0] : colors[j % 12];
                }
                simpleData.setValues(SimpleAwtBarChart.HEIGHT, graphData);
                simpleData.setValues(SimpleAwtBarChart.COLOR, graphColors);
                r.setBounds(this.centroids[i].x - xsize / 2, this.centroids[i].y - ysize / 2, xsize, ysize);
                if (bars) {
                    simpleBar.setModel(simpleData);
                    simpleBar.setBounds(r);
                    simpleBar.paint(g);
                    continue;
                }
                simplePie.setModel(simpleData);
                simplePie.setBounds(r);
                simplePie.paint(g);
            }
        }
        if (this.hitsGraphIndex != -1 && this.indexArray[this.hitsGraphIndex] != -1) {
            if (this.explodeGraphs) {
                xsize = (int)((double)this.drawingBounds.width * this.maxGraphPercent / 100.0 * 1.5);
                ysize = (int)((double)this.drawingBounds.width * this.maxGraphPercent / 100.0);
            } else {
                xsize = (int)((double)this.drawingBounds.width * this.minGraphPercent / 100.0 * 1.5);
                ysize = (int)((double)this.drawingBounds.width * this.minGraphPercent / 100.0);
            }
            for (j = 0; j < numBars; ++j) {
                graphData[j] = (Double)this.mapResponseData.getValue(graphRoles[j], (long)this.indexArray[this.hitsGraphIndex]);
                graphColors[j] = bars && this.colorGraphsByChart ? colors[0] : colors[j % 12];
            }
            simpleData.setValues(SimpleAwtBarChart.HEIGHT, graphData);
            simpleData.setValues(SimpleAwtBarChart.COLOR, graphColors);
            Point cp = new Point();
            cp.x = this.centroids[this.hitsGraphIndex].x - xsize / 2;
            cp.y = this.centroids[this.hitsGraphIndex].y - ysize / 2;
            if (cp.x + xsize > this.totalBounds.width) {
                cp.x = this.totalBounds.width - xsize;
            }
            if (cp.y + ysize > this.totalBounds.height) {
                cp.y = this.totalBounds.height - ysize;
            }
            if (cp.x < 0) {
                cp.x = -Math.min(p.x, Math.abs(cp.x));
            }
            if (cp.y < 0) {
                cp.y = -Math.min(p.y, Math.abs(cp.y));
            }
            r.setBounds(cp.x, cp.y, xsize, ysize);
            if (bars) {
                simpleBar.setModel(simpleData);
                simpleBar.setBounds(r);
                simpleBar.paint(g);
            } else {
                simplePie.setModel(simpleData);
                simplePie.setBounds(r);
                simplePie.paint(g);
            }
        }
        if (scale != 1.0) {
            g.scale(1.0, 1.0);
        }
        g.translate(-p.x, -p.y);
    }

    public void rebuild() {
        this.syncMapColors();
        this.resetGraphExtents();
    }

    public void resetGraphExtents() {
        int i;
        if (this.regionAreas == null || this.indexArray == null || this.roles == null) {
            return;
        }
        this.graphMin = Double.MAX_VALUE;
        this.graphMax = -1.7976931348623157E308;
        int numBars = this.roles.getNumVariablesAssigned((Object)RoleInterface.ROLE_GRAPH_VAR);
        Object[] graphRoles = new Object[numBars];
        for (i = 0; i < numBars; ++i) {
            graphRoles[i] = this.roles.getVariable((Object)RoleInterface.ROLE_GRAPH_VAR, i);
        }
        for (i = 0; i < this.regionAreas.length; ++i) {
            if (this.indexArray[i] == -1) continue;
            for (int j = 0; j < numBars; ++j) {
                Double myDouble = (Double)this.mapResponseData.getValue(graphRoles[j], (long)this.indexArray[i]);
                if (myDouble == null) continue;
                double d = myDouble;
                if (d > this.graphMax) {
                    this.graphMax = d;
                }
                if (!(d < this.graphMin)) continue;
                this.graphMin = d;
            }
        }
        this.graphExtentsCalculated = true;
    }

    protected boolean isGraphed(int i) {
        if (this.indexArray == null || this.mapResponseData == null || this.isDrawAllRegions()) {
            return true;
        }
        if (this.indexArray[i] == -1) {
            return false;
        }
        return this.mapResponseData.isGraphed((long)this.indexArray[i]);
    }

    public void drawRegions(Graphics g1, Point p, int showLevel, double scale) {
        if (this.roles == null) {
            return;
        }
        int numWatermarkRoles = this.roles.getNumVariablesAssigned((Object)RoleInterface.ROLE_WATERMARK);
        Object mapOpacityRole = this.roles.getVariable((Object)RoleInterface.ROLE_MAP_OPACITY, 0);
        Object mapTransparencyRole = this.roles.getVariable((Object)RoleInterface.ROLE_MAP_TRANSPARENCY, 0);
        Object mapColorRole = this.roles.getVariable((Object)RoleInterface.ROLE_MAP_COLOR, 0);
        Object mapLevelRole = this.roles.getVariable((Object)RoleInterface.ROLE_MAP_LEVEL, 0);
        Object mapColorIndexRole = this.roles.getVariable((Object)RoleInterface.ROLE_MAP_COLOR_INDEX, 0);
        Object URLRole = this.roles.getVariable((Object)RoleInterface.ROLE_URL, 0);
        if (this.spatialData == null) {
            return;
        }
        Graphics2D g = (Graphics2D)g1;
        Color[] colors = this.defaultColors;
        colors = this.style.getDataFillColors();
        Color shadowColor = new Color(0, 0, 0, 128);
        Color transparentColor = new Color(0, 0, 0, 0);
        double watermarkMin = 0.0;
        double watermarkMax = 1.0;
        double transMin = 0.0;
        double transMax = 1.0;
        int trans = 255;
        int index = 0;
        Object[] watermarkRoles = null;
        BasicStroke stroke = new BasicStroke(this.outlineWidth);
        if (numWatermarkRoles > 0) {
            watermarkMin = this.watermarkRange[0];
            watermarkMax = this.watermarkRange[1];
            watermarkRoles = new Object[numWatermarkRoles];
            for (int i = 0; i < numWatermarkRoles; ++i) {
                watermarkRoles[i] = this.roles.getVariable((Object)RoleInterface.ROLE_WATERMARK, i);
            }
        }
        if (mapOpacityRole != null) {
            transMin = this.opacityRange[0];
            transMax = this.opacityRange[1];
        }
        if (mapTransparencyRole != null) {
            transMin = this.transparencyRange[0];
            transMax = this.transparencyRange[1];
        }
        if (this.showOutlines && this.outlineWidth != 1) {
            g.setStroke(stroke);
        }
        g.translate(p.x, p.y);
        if (scale != 1.0) {
            g.scale(scale, scale);
        }
        if (this.regionAreas != null) {
            if (this.shadowsOn) {
                g.setColor(shadowColor);
                g.translate(4, 4);
                for (int e = 0; e < this.regionAreas.length; ++e) {
                    if (!this.isGraphed(e)) continue;
                    g.fill(this.regionAreas[e]);
                }
                g.translate(-4, -4);
            }
            boolean writeURLs = URLRole != null && this.urlConsumers != null && this.urlConsumers.size() > 0;
            boolean didWriteURL = false;
            for (int i = 0; i < this.regionAreas.length; ++i) {
                GradientPaint paint;
                Color color;
                if (!this.isGraphed(i) || mapLevelRole != null && !((Double)this.mapResponseData.getValue(mapLevelRole, (long)i) <= (double)showLevel)) continue;
                if (mapColorIndexRole != null) {
                    if (this.indexArray[i] == -1) {
                        color = this.defaultColor;
                    } else {
                        index = ((Double)this.mapResponseData.getValue(mapColorIndexRole, (long)this.indexArray[i])).intValue();
                        color = colors[index % colors.length];
                    }
                } else if (mapColorRole == null || this.indexArray[i] == -1 || this.mapResponseData == null) {
                    color = this.defaultColor;
                } else if (this.mapResponseData.isNumericVariable(mapColorRole)) {
                    Double d2;
                    if (this.categorization.getCategoryType() == 1) {
                        d2 = (Double)this.mapResponseData.getValue(mapColorRole, (long)this.indexArray[i]);
                        color = d2.isNaN() ? this.defaultColor : (Color)this.colorHashtable.get(d2);
                    } else {
                        d2 = (Double)this.mapResponseData.getValue(mapColorRole, (long)this.indexArray[i]);
                        color = this.colorRamp == null ? this.defaultColor : this.colorRamp.query((Object)d2, false, null);
                    }
                } else {
                    String s = (String)this.mapResponseData.getValue(mapColorRole, (long)this.indexArray[i]);
                    color = (Color)this.colorHashtable.get(s);
                }
                if (mapOpacityRole != null && this.indexArray[i] != -1) {
                    trans = (int)(255.0 - 255.0 * ((Double)this.mapResponseData.getValue(mapOpacityRole, (long)this.indexArray[i]) - transMin) / (transMax - transMin));
                    color = new Color(color.getRed(), color.getGreen(), color.getBlue(), trans);
                } else if (mapTransparencyRole != null && this.indexArray[i] != -1) {
                    trans = (int)(255.0 * ((Double)this.mapResponseData.getValue(mapTransparencyRole, (long)this.indexArray[i]) - transMin) / (transMax - transMin));
                    color = new Color(color.getRed(), color.getGreen(), color.getBlue(), trans);
                }
                if (writeURLs) {
                    didWriteURL = this.writeURL(URLRole, i);
                }
                if (numWatermarkRoles == 1 && this.indexArray[i] != -1) {
                    Double d = (Double)this.mapResponseData.getValue(this.mapWatermarkRole, (long)this.indexArray[i]);
                    double val = 1.0 - (d - watermarkMin) / (watermarkMax - watermarkMin);
                    paint = new GradientPaint(this.regionAreas[i].getBounds().x, (int)((double)this.regionAreas[i].getBounds().y + (double)this.regionAreas[i].getBounds().height * val + 1.0), color, this.regionAreas[i].getBounds().x, (int)((double)this.regionAreas[i].getBounds().y + (double)this.regionAreas[i].getBounds().height * val), transparentColor, false);
                    g.setPaint(paint);
                    g.fill(this.regionAreas[i]);
                } else if (numWatermarkRoles > 1 && this.indexArray[i] != -1) {
                    int e;
                    double[] vals = new double[numWatermarkRoles];
                    double sum = 0.0;
                    double runningTotal = 0.0;
                    for (e = 0; e < numWatermarkRoles; ++e) {
                        vals[e] = (Double)this.mapResponseData.getValue(watermarkRoles[e], (long)this.indexArray[i]);
                        sum += vals[e];
                    }
                    g.setPaint(this.defaultColors[0]);
                    g.fill(this.regionAreas[i]);
                    runningTotal = vals[0];
                    for (e = 1; e < numWatermarkRoles; ++e) {
                        double perc = runningTotal / sum;
                        paint = new GradientPaint(this.regionAreas[i].getBounds().x, (int)((double)this.regionAreas[i].getBounds().y + (double)this.regionAreas[i].getBounds().height * perc + 1.0), colors[e % colors.length], this.regionAreas[i].getBounds().x, (int)((double)this.regionAreas[i].getBounds().y + (double)this.regionAreas[i].getBounds().height * perc), transparentColor, false);
                        g.setPaint(paint);
                        g.fill(this.regionAreas[i]);
                        runningTotal += vals[e];
                    }
                } else {
                    g.setColor(color);
                    g.fill(this.regionAreas[i]);
                }
                if (didWriteURL) {
                    this.closeURLs();
                }
                if (!this.showOutlines) continue;
                g.setColor(this.outlineColor);
                g.draw(this.regionAreas[i]);
            }
            if (this.showOutlines && showLevel == 1) {
                BasicStroke newStroke = new BasicStroke(2.0f);
                g.setStroke(newStroke);
                g.setColor(this.outlineColor);
                for (int i = 0; i < this.regionAreas.length; ++i) {
                    if (!this.spatialData.isGraphed((long)i) || mapLevelRole == null || (Double)this.mapResponseData.getValue(mapLevelRole, (long)i) != 0.0) continue;
                    g.draw(this.regionAreas[i]);
                }
                newStroke = new BasicStroke(2.0f);
                g.setStroke(newStroke);
            }
        }
        if (scale != 1.0) {
            g.scale(1.0, 1.0);
        }
        g.translate(-p.x, -p.y);
    }

    public void drawLabels(Graphics g, Point p) {
        Object mapLabelRole = this.roles.getVariable((Object)RoleInterface.ROLE_MAP_LABEL, 0);
        if (this.mapResponseData == null || mapLabelRole == null || this.indexArray == null) {
            return;
        }
        g.setFont(this.text.getFont());
        g.translate(p.x, p.y);
        Object format = this.text.getFormat();
        for (int i = 0; i < this.centroids.length; ++i) {
            String s;
            if (this.mapResponseData.isNumericVariable(mapLabelRole)) {
                Double d = (Double)this.mapResponseData.getValue(mapLabelRole, (long)this.indexArray[i]);
                s = this.mapResponseData.getFormattedValue(mapLabelRole, (Object)d, format);
            } else {
                s = (String)this.mapResponseData.getValue(mapLabelRole, (long)this.indexArray[i]);
            }
            if (s == null) continue;
            this.text.drawText((Graphics2D)g, s, new Point(this.centroids[i].x, this.centroids[i].y - 2));
        }
        g.translate(-p.x, -p.y);
    }

    public void drawSelectedRegions(Graphics g, Point p, int showLevel) {
        int myInt;
        int i;
        Object mapLevelRole = this.roles.getVariable((Object)RoleInterface.ROLE_MAP_LEVEL, 0);
        TexturePaint tp = null;
        if (!this.globalDefaults.selectionStyle.equalsIgnoreCase("Solid")) {
            FillPattern fillPattern = new FillPattern();
            tp = fillPattern.getHatch45(this.selectionColor);
        }
        ((Graphics2D)g).setPaint(this.selectionColor);
        if (p.x != 0 || p.y != 0) {
            g.translate(p.x, p.y);
        }
        for (i = 0; i < this.selectedRegions.size(); ++i) {
            if (mapLevelRole != null && this.mapResponseData != null && (Double)this.mapResponseData.getValue(mapLevelRole, (long)((Integer)this.selectedRegions.get(i)).intValue()) != (double)showLevel || (myInt = ((Integer)this.selectedRegions.get(i)).intValue()) < 0 || myInt >= this.regionAreas.length) continue;
            if (this.globalDefaults.selectionStyle.equalsIgnoreCase("Solid")) {
                ((Graphics2D)g).fill(this.regionAreas[myInt]);
                continue;
            }
            ((Graphics2D)g).setPaint(tp);
            ((Graphics2D)g).fill(this.regionAreas[myInt]);
            ((Graphics2D)g).setPaint(this.selectionColor);
            ((Graphics2D)g).draw(this.regionAreas[myInt]);
        }
        if (this.globalDefaults.selectionStyle.equalsIgnoreCase("Solid") && this.showOutlines) {
            ((Graphics2D)g).setPaint(this.outlineColor);
            for (i = 0; i < this.selectedRegions.size(); ++i) {
                if (mapLevelRole != null && this.mapResponseData != null && (Double)this.mapResponseData.getValue(mapLevelRole, (long)((Integer)this.selectedRegions.get(i)).intValue()) != (double)showLevel || (myInt = ((Integer)this.selectedRegions.get(i)).intValue()) < 0 || myInt >= this.regionAreas.length) continue;
                ((Graphics2D)g).draw(this.regionAreas[myInt]);
            }
        }
        if (p.x != 0 || p.y != 0) {
            g.translate(-p.x, -p.y);
        }
    }

    private int findID(Object o) {
        try {
            return (Integer)this.regionIDHashMap.get(o);
        }
        catch (Exception e) {
            return -1;
        }
    }

    private void recreateIDHash() {
        Object mapResponseIDRole = this.roles.getVariable((Object)RoleInterface.ROLE_MAP_RESPONSE_ID, 0);
        this.regionIDHashMap = new HashMap();
        if (this.mapResponseData == null) {
            return;
        }
        int num = this.mapResponseData.getNumberObservations(mapResponseIDRole);
        for (int i = 0; i < num; ++i) {
            Object val = this.mapResponseData.getValue(mapResponseIDRole, (long)i);
            this.regionIDHashMap.put(val, new Integer(i));
        }
    }

    private void regenerateIndexArray() {
        Object mapResponseIDRole = this.roles.getVariable((Object)RoleInterface.ROLE_MAP_RESPONSE_ID, 0);
        Object mapIDRole = this.roles.getVariable((Object)RoleInterface.ROLE_MAP_ID, 0);
        if (this.spatialData == null || this.mapResponseData == null || mapIDRole == null && this.mapIDVector == null || mapResponseIDRole == null) {
            return;
        }
        this.indexArray = new int[this.numMultiPolygons];
        this.recreateIDHash();
        for (int i = 0; i < this.numMultiPolygons; ++i) {
            this.indexArray[i] = this.mapIDVector != null ? this.findID(this.mapIDVector.elementAt(i)) : this.findID(this.spatialData.getValue(mapIDRole, (long)i));
        }
    }

    public void regeneratePolygons() {
        this.regenerateIndexArray();
        this.regionAreas = new Area[this.numMultiPolygons];
        for (int i = 0; i < this.numMultiPolygons; ++i) {
            this.regionAreas[i] = new Area();
            int j = 0;
            while ((long)j < this.multiPolygons[i].num_wkbPolygons) {
                int k = 0;
                while ((long)k < this.multiPolygons[i].WKBPolygons[j].numRings) {
                    int numPoints = (int)this.multiPolygons[i].WKBPolygons[j].rings[k].numPoints;
                    int[] x = new int[numPoints];
                    int[] y = new int[numPoints];
                    for (int l = 0; l < numPoints; ++l) {
                        x[l] = (int)((this.multiPolygons[i].WKBPolygons[j].rings[k].points[l].x - this.xMin) / (this.xMax - this.xMin) * (double)this.drawingBounds.width);
                        y[l] = this.drawingBounds.height - (int)((this.multiPolygons[i].WKBPolygons[j].rings[k].points[l].y - this.yMin) / (this.yMax - this.yMin) * (double)this.drawingBounds.height);
                    }
                    Polygon polygon = new Polygon(x, y, numPoints);
                    if (k == 0) {
                        this.regionAreas[i].add(new Area(polygon));
                    } else {
                        this.regionAreas[i].subtract(new Area(polygon));
                    }
                    ++k;
                }
                ++j;
            }
        }
        this.recreateCentroids();
    }

    public void syncMapColors() {
        Object mapColorRole = this.roles.getVariable((Object)RoleInterface.ROLE_MAP_COLOR, 0);
        if (this.mapResponseData == null) {
            return;
        }
        if (mapColorRole != null) {
            this.recreateColorRamp();
        }
    }

    public void checkGraphs(Point p) {
        this.hitsGraphIndex = -1;
        if (this.regionAreas == null || this.centroids == null || this.roles.getNumVariablesAssigned((Object)RoleInterface.ROLE_GRAPH_VAR) == 0) {
            return;
        }
        for (int i = 0; i < this.regionAreas.length; ++i) {
            if (!(Point.distance(p.x, p.y, this.centroids[i].x, this.centroids[i].y) < 20.0)) continue;
            this.hitsGraphIndex = i;
        }
    }

    public boolean isGraphSelected() {
        return this.hitsGraphIndex != -1;
    }

    public String getToolTipText(Point p, int showLevel) {
        Object mapWatermarkRole = this.roles.getVariable((Object)RoleInterface.ROLE_WATERMARK, 0);
        Object mapOpacityRole = this.roles.getVariable((Object)RoleInterface.ROLE_MAP_OPACITY, 0);
        Object mapTransparencyRole = this.roles.getVariable((Object)RoleInterface.ROLE_MAP_TRANSPARENCY, 0);
        Object mapColorRole = this.roles.getVariable((Object)RoleInterface.ROLE_MAP_COLOR, 0);
        Object mapResponseIDRole = this.roles.getVariable((Object)RoleInterface.ROLE_MAP_RESPONSE_ID, 0);
        Object mapLevelRole = this.roles.getVariable((Object)RoleInterface.ROLE_MAP_LEVEL, 0);
        Object mapLabelRole = this.roles.getVariable((Object)RoleInterface.ROLE_MAP_LABEL, 0);
        Object mapTipRole = null;
        int numTips = this.roles.getNumVariablesAssigned((Object)RoleInterface.ROLE_TIP);
        if (this.indexArray == null) {
            return new String();
        }
        String s = null;
        for (int i = 0; i < this.regionAreas.length; ++i) {
            if (mapLevelRole != null && (Double)this.mapResponseData.getValue(mapLevelRole, (long)i) != (double)showLevel || !this.spatialData.isGraphed((long)i) || !this.mapResponseData.isGraphed((long)this.indexArray[i]) || !this.regionAreas[i].contains(p.x, p.y)) continue;
            s = "";
            if (this.indexArray[i] != -1) {
                if (numTips > 0) {
                    for (int j = 0; j < numTips; ++j) {
                        mapTipRole = this.roles.getVariable((Object)RoleInterface.ROLE_TIP, j);
                        s = s + this.mapResponseData.getVariableDescription(mapTipRole) + ":\t" + this.mapResponseData.getFormattedValue(mapTipRole, this.mapResponseData.getValue(mapTipRole, (long)this.indexArray[i]), this.mapResponseData.getFormat(mapTipRole, SASFormat.class)).toString() + "\n";
                    }
                } else {
                    if (mapResponseIDRole != null) {
                        s = s + this.mapResponseData.getVariableDescription(mapResponseIDRole) + ":\t" + this.mapResponseData.getFormattedValue(mapResponseIDRole, this.mapResponseData.getValue(mapResponseIDRole, (long)this.indexArray[i]), this.mapResponseData.getFormat(mapResponseIDRole, SASFormat.class)).toString() + "\n";
                    }
                    if (mapColorRole != null) {
                        s = s + this.mapResponseData.getVariableDescription(mapColorRole) + ":\t" + this.mapResponseData.getFormattedValue(mapColorRole, this.mapResponseData.getValue(mapColorRole, (long)this.indexArray[i]), this.mapResponseData.getFormat(mapColorRole, SASFormat.class)).toString() + "\n";
                    }
                    if (mapTransparencyRole != null) {
                        s = s + this.mapResponseData.getVariableDescription(mapTransparencyRole) + ":\t" + this.mapResponseData.getFormattedValue(mapTransparencyRole, this.mapResponseData.getValue(mapTransparencyRole, (long)this.indexArray[i]), this.mapResponseData.getFormat(mapTransparencyRole, SASFormat.class)).toString() + "\n";
                    }
                    if (mapOpacityRole != null) {
                        s = s + this.mapResponseData.getVariableDescription(mapOpacityRole) + ":\t" + this.mapResponseData.getFormattedValue(mapOpacityRole, this.mapResponseData.getValue(mapOpacityRole, (long)this.indexArray[i]), this.mapResponseData.getFormat(mapOpacityRole, SASFormat.class)).toString() + "\n";
                    }
                    if (mapLabelRole != null) {
                        s = s + this.mapResponseData.getVariableDescription(mapLabelRole) + ":\t" + this.mapResponseData.getFormattedValue(mapLabelRole, this.mapResponseData.getValue(mapLabelRole, (long)this.indexArray[i]), this.mapResponseData.getFormat(mapLabelRole, SASFormat.class)).toString() + "\n";
                    }
                    if (mapWatermarkRole != null) {
                        s = s + this.mapResponseData.getVariableDescription(mapWatermarkRole) + ":\t" + this.mapResponseData.getFormattedValue(mapWatermarkRole, this.mapResponseData.getValue(mapWatermarkRole, (long)this.indexArray[i]), this.mapResponseData.getFormat(mapWatermarkRole, SASFormat.class)).toString() + "\n";
                    }
                }
            } else {
                s = ResourceLoader.getResourceString((Object)this.rb, (String)"MapObject.Region.txt", (String)"Region: ") + Integer.toString(i) + "\n";
            }
            return s;
        }
        return null;
    }

    public void setDrawingBounds(Rectangle r) {
        this.drawingBounds = r;
    }

    public void addSelectedRegion(Integer i) {
        if (!this.isRegionSelected(i)) {
            this.selectedRegions.add(i);
        }
    }

    public int getMapRegionWithID(Object o) {
        Integer i;
        if (this.mapIDHashMap == null) {
            if (this.mapIDVector == null) {
                Object mapIDRole = this.roles.getVariable((Object)RoleInterface.ROLE_MAP_ID, 0);
                int num = this.spatialData.getNumberObservations(mapIDRole);
                this.mapIDHashMap = new HashMap();
                for (int i2 = 0; i2 < num; ++i2) {
                    this.mapIDHashMap.put(this.spatialData.getValue(mapIDRole, (long)i2), new Integer(i2));
                }
            } else {
                int num = this.mapIDVector.size();
                this.mapIDHashMap = new HashMap();
                for (int i3 = 0; i3 < num; ++i3) {
                    this.mapIDHashMap.put(this.mapIDVector.elementAt(i3), new Integer(i3));
                }
            }
        }
        if ((i = (Integer)this.mapIDHashMap.get(o)) == null) {
            return -1;
        }
        return (Integer)this.mapIDHashMap.get(o);
    }

    public void removeSelectedRegion(Integer i) {
        this.selectedRegions.remove(i);
    }

    public void clearSelectedRegions() {
        this.selectedRegions.clear();
    }

    public boolean isRegionSelected(Integer i) {
        return this.selectedRegions.contains(i);
    }

    public ArrayList getSelectedRegions() {
        ArrayList<Integer> newList = new ArrayList<Integer>();
        if (this.indexArray == null) {
            return newList;
        }
        for (int i = 0; i < this.selectedRegions.size(); ++i) {
            newList.add(new Integer(this.indexArray[(Integer)this.selectedRegions.get(i)]));
        }
        return newList;
    }

    public void selectTouchingRegions(Rectangle r) {
        this.selectedRegions.clear();
        for (int i = 0; i < this.regionAreas.length; ++i) {
            if (!this.spatialData.isGraphed((long)i) || this.mapResponseData != null && !this.mapResponseData.isGraphed((long)this.indexArray[i]) || !this.regionAreas[i].intersects(r.x, r.y, r.width, r.height)) continue;
            Integer myInt = new Integer(i);
            this.selectedRegions.add(myInt);
        }
    }

    public int pick(double x, double y) {
        for (int i = 0; i < this.regionAreas.length; ++i) {
            if (!this.spatialData.isGraphed((long)i) || this.mapResponseData != null && (!this.mapResponseData.isGraphed((long)this.indexArray[i]) || !this.regionAreas[i].contains(x, y))) continue;
            return i;
        }
        return -1;
    }

    public WKBMultiPolygon[] getMultiPolygons() {
        return this.multiPolygons;
    }

    public void setMultiPolygons(WKBMultiPolygon[] multiPolygons) {
        this.multiPolygons = multiPolygons;
        this.numMultiPolygons = multiPolygons.length;
    }

    public void setExtents(double x1, double x2, double y1, double y2) {
        this.xMin = x1;
        this.xMax = x2;
        this.yMin = y1;
        this.yMax = y2;
    }

    public DataFilterReadInterface getSpatialData() {
        return this.spatialData;
    }

    private void recreateColorRamp() {
        Object mapColorRole = this.roles.getVariable((Object)RoleInterface.ROLE_MAP_COLOR, 0);
        Object mapResponseIDRole = this.roles.getVariable((Object)RoleInterface.ROLE_MAP_RESPONSE_ID, 0);
        Object mapColorIndexRole = this.roles.getVariable((Object)RoleInterface.ROLE_MAP_COLOR_INDEX, 0);
        if (this.spatialData == null || this.mapResponseData == null || mapResponseIDRole == null || mapColorRole == null && mapColorIndexRole == null) {
            return;
        }
        if (mapColorIndexRole != null) {
            double[] d = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0};
            Color[] colors = this.style.getDataFillColors();
            this.colorRamp = new ColorRamp((Object)colors, (Object)d, 0L);
            this.colorRamp.setMissingColor(this.defaultColor);
        } else if (this.mapResponseData.isNumericVariable(mapColorRole)) {
            if (this.categorization.getCategoryType() == 0) {
                Color[] colors = this.getColors(this.numericRanges.length);
                this.colorRamp = new ColorRamp((Object)colors, (Object)this.numericRanges, 0L);
                this.colorRamp.setMissingColor(this.defaultColor);
            } else if (this.categorization.getCategoryType() == 3 || this.categorization.getCategoryType() == 2) {
                Color[] colors = this.getColors(this.numericRanges.length - 1);
                this.colorRamp = new ColorRamp((Object)colors, (Object)this.numericRanges, 0L);
                this.colorRamp.setMissingColor(this.defaultColor);
            } else if (this.categorization.getCategoryType() == 1) {
                Color[] colors = this.getColors(this.discreteRanges.length);
                this.colorHashtable = new Hashtable(this.discreteRanges.length);
                for (int e = 0; e < this.discreteRanges.length; ++e) {
                    this.colorHashtable.put(new Double(this.discreteRanges[e]), colors[e]);
                }
                this.colorRamp = null;
            }
        } else {
            Color[] colors = this.getColors(this.stringRanges.length);
            this.colorHashtable = new Hashtable(this.stringRanges.length);
            for (int e = 0; e < this.stringRanges.length; ++e) {
                this.colorHashtable.put(this.stringRanges[e], colors[e]);
            }
            this.colorRamp = null;
        }
    }

    private Color[] getColors(int numColors) {
        Color[] colors = new Color[numColors];
        if (this.useColorRamp) {
            Color[] rampColors = this.style.getRampStyleElement("ThreeColorRamp").getColors();
            if (colors.length == 1) {
                colors[0] = rampColors[0];
            } else {
                Color minColor = rampColors[0];
                Color maxColor = rampColors[1];
                float redGradient = (float)(maxColor.getRed() - minColor.getRed()) / 255.0f / (float)(numColors - 1);
                float greenGradient = (float)(maxColor.getGreen() - minColor.getGreen()) / 255.0f / (float)(numColors - 1);
                float blueGradient = (float)(maxColor.getBlue() - minColor.getBlue()) / 255.0f / (float)(numColors - 1);
                for (int k = 0; k < numColors; ++k) {
                    colors[k] = new Color(Math.abs((float)minColor.getRed() / 255.0f + (float)k * redGradient), Math.abs((float)minColor.getGreen() / 255.0f + (float)k * greenGradient), Math.abs((float)minColor.getBlue() / 255.0f + (float)k * blueGradient));
                }
            }
        } else {
            Color[] dataColors = this.style.getRampStyleElement("ThreeColorRamp").getColors();
            for (int i = 0; i < numColors; ++i) {
                colors[i] = this.getCycledColor(dataColors[i % dataColors.length], (i - 1) / this.defaultColors.length);
            }
        }
        return colors;
    }

    protected Color getCycledColor(Color color, int cycle) {
        if (cycle > 0) {
            float[] hsbVals = new float[3];
            Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsbVals);
            if (cycle < 5) {
                float cycleFactor = (float)Math.pow(0.8, cycle);
                color = Color.getHSBColor(hsbVals[0], hsbVals[1], hsbVals[2] * cycleFactor);
            } else if (cycle < 10) {
                float cycleFactor = (float)Math.pow(0.8, (double)cycle - 4.0);
                color = Color.getHSBColor(hsbVals[0], hsbVals[1] * cycleFactor, hsbVals[2]);
            } else if (cycle < 15) {
                float cycleFactor = (float)Math.pow(0.8, (double)cycle - 9.0);
                color = Color.getHSBColor(hsbVals[0], hsbVals[1] * cycleFactor, hsbVals[2] * cycleFactor);
            }
        }
        return color;
    }

    public boolean isShadowsOn() {
        return this.shadowsOn;
    }

    public void setShadowsOn(boolean shadowsOn) {
        this.shadowsOn = shadowsOn;
    }

    public void rolesChanged() {
        this.rolesChanged(false);
    }

    public void rolesChanged(boolean recalc) {
        boolean sorted = this.getSorted();
        Object r = this.roles.getVariable((Object)RoleInterface.ROLE_MAP_COLOR, 0);
        if (recalc || r != this.mapColorRole) {
            this.mapColorRole = r;
            if (this.mapColorRole != null) {
                this.checkCategorySize();
                if (this.mapResponseData.isNumericVariable(this.mapColorRole)) {
                    if (this.categorization.getCategoryType() == 1) {
                        this.discreteRanges = Categorization.getDiscreteRanges(this.mapResponseData, this.mapColorRole, sorted);
                    } else {
                        this.numericRanges = this.categorization.getNumericRanges(this.mapResponseData, this.mapColorRole);
                    }
                } else {
                    this.stringRanges = Categorization.getStringRanges(this.mapResponseData, this.mapColorRole, sorted);
                    this.categorization.setCategoryType(1);
                }
            }
        }
        if ((r = this.roles.getVariable((Object)RoleInterface.ROLE_MAP_TRANSPARENCY, 0)) != this.mapTransparencyRole) {
            this.mapTransparencyRole = r;
            if (this.mapTransparencyRole != null) {
                this.transparencyRange = Categorization.getContinuousRanges(this.mapResponseData, this.mapTransparencyRole, 2);
            }
        }
        if ((r = this.roles.getVariable((Object)RoleInterface.ROLE_MAP_OPACITY, 0)) != this.mapOpacityRole) {
            this.mapOpacityRole = r;
            if (this.mapOpacityRole != null) {
                this.opacityRange = Categorization.getContinuousRanges(this.mapResponseData, this.mapOpacityRole, 2);
            }
        }
        if ((r = this.roles.getVariable((Object)RoleInterface.ROLE_WATERMARK, 0)) != this.mapWatermarkRole) {
            this.mapWatermarkRole = r;
            if (this.mapWatermarkRole != null) {
                this.watermarkRange = Categorization.getContinuousRanges(this.mapResponseData, this.mapWatermarkRole, 2);
            }
        }
        this.resetGraphExtents();
    }

    public String[] getMapColorLabels() {
        String[] strings;
        Object mapColorRole = this.roles.getVariable((Object)RoleInterface.ROLE_MAP_COLOR, 0);
        Object[] breaks = null;
        if (this.mapResponseData.isNumericVariable(mapColorRole)) {
            if (this.categorization.getCategoryType() == 1) {
                strings = new String[this.discreteRanges.length];
                for (int i = 0; i < this.discreteRanges.length; ++i) {
                    Double d = new Double(this.discreteRanges[i]);
                    strings[i] = this.mapResponseData.getFormattedValue(mapColorRole, (Object)d, this.mapResponseData.getFormat(mapColorRole, SASFormat.class)).toString();
                }
            } else if (this.categorization.getCategoryType() == 0) {
                breaks = this.colorRamp.getBreaks();
                strings = new String[]{this.mapResponseData.getFormattedValue(mapColorRole, breaks[0], this.mapResponseData.getFormat(mapColorRole, SASFormat.class)).toString(), this.mapResponseData.getFormattedValue(mapColorRole, breaks[1], this.mapResponseData.getFormat(mapColorRole, SASFormat.class)).toString()};
            } else {
                breaks = this.colorRamp.getBreaks();
                int size = breaks.length - 1;
                strings = new String[size];
                String sep = ResourceLoader.getResourceString((Object)this.rb, (String)"MapObject.BreakSeparator.txt", (String)" - ");
                sep = " " + sep.trim() + " ";
                for (int i = 0; i < size; ++i) {
                    String s1 = this.mapResponseData.getFormattedValue(mapColorRole, breaks[i], this.mapResponseData.getFormat(mapColorRole, SASFormat.class)).toString();
                    String s2 = this.mapResponseData.getFormattedValue(mapColorRole, breaks[i + 1], this.mapResponseData.getFormat(mapColorRole, SASFormat.class)).toString();
                    if (this.categorization.getCategoryType() == 1) continue;
                    strings[i] = s1.trim() + sep + s2.trim();
                }
            }
        } else {
            strings = this.stringRanges;
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = this.mapResponseData.getFormattedValue(mapColorRole, (Object)strings[i], this.mapResponseData.getFormat(mapColorRole, SASFormat.class));
            }
        }
        return strings;
    }

    public Color[] getMapColors() {
        Object mapColorRole = this.roles.getVariable((Object)RoleInterface.ROLE_MAP_COLOR, 0);
        Object mapColorIndexRole = this.roles.getVariable((Object)RoleInterface.ROLE_MAP_COLOR_INDEX, 0);
        if (mapColorIndexRole != null) {
            return this.style.getDataFillColors();
        }
        if (this.mapResponseData == null) {
            return null;
        }
        if (!this.mapResponseData.isNumericVariable(mapColorRole)) {
            Color[] c2 = new Color[this.stringRanges.length];
            for (int i = 0; i < this.stringRanges.length; ++i) {
                c2[i] = (Color)this.colorHashtable.get(this.stringRanges[i]);
            }
            return c2;
        }
        if (this.categorization.getCategoryType() == 1) {
            Color[] c2 = new Color[this.discreteRanges.length];
            for (int i = 0; i < this.discreteRanges.length; ++i) {
                c2[i] = (Color)this.colorHashtable.get(new Double(this.discreteRanges[i]));
            }
            return c2;
        }
        if (this.categorization.getCategoryType() == 0) {
            return this.colorRamp.getColors();
        }
        Color[] c1 = this.colorRamp.getColors();
        Color[] c2 = new Color[c1.length - 1];
        System.arraycopy(c1, 0, c2, 0, c1.length - 1);
        return c2;
    }

    public void setStyle(Style styleIn) {
        this.style = styleIn;
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    private boolean getSorted() {
        boolean sorted = false;
        Object order = this.roles.getSortOrder((Object)RoleInterface.ROLE_MAP_COLOR_INDEX);
        if (order instanceof Number) {
            sorted = ((Number)order).intValue() == 1;
        }
        return sorted;
    }

    public void setSelectionColor(Color selectionColor) {
        this.selectionColor = selectionColor;
    }

    public Categorization getCategorization() {
        return this.categorization;
    }

    public void setCategorization(Categorization cat) {
        this.categorization = cat;
        this.checkCategorySize();
        this.rolesChanged(true);
        this.recreateColorRamp();
    }

    private void checkCategorySize() {
        double[] myRanges;
        if (this.mapColorRole != null && this.mapResponseData.isNumericVariable(this.mapColorRole) && this.categorization.getCategoryType() != 1 && (myRanges = Categorization.getDiscreteRanges(this.mapResponseData, this.mapColorRole, true)).length == 1) {
            this.categorization.setCategoryType(1);
        }
    }

    public ColorRamp getColorRamp() {
        return this.colorRamp;
    }

    public void setColorRamp(ColorRamp colorRamp) {
        this.colorRamp = colorRamp;
    }

    public boolean isShowOutlines() {
        return this.showOutlines;
    }

    public void setShowOutlines(boolean showOutlines) {
        this.showOutlines = showOutlines;
    }

    public int getOutlineWidth() {
        return this.outlineWidth;
    }

    public void setOutlineWidth(int outlineWidth) {
        this.outlineWidth = outlineWidth;
    }

    protected void recreateCentroids() {
        this.centroids = new Point[this.numMultiPolygons];
        for (int i = 0; i < this.numMultiPolygons; ++i) {
            Vec3d v = this.getCenter(i);
            this.centroids[i] = v != null ? this.worldToScreen(v.x, v.y) : null;
        }
    }

    protected Point worldToScreen(double x, double y) {
        Point p = new Point();
        p.x = (int)((x - this.xMin) / (this.xMax - this.xMin) * (double)this.drawingBounds.width);
        p.y = this.drawingBounds.height - (int)((y - this.yMin) / (this.yMax - this.yMin) * (double)this.drawingBounds.height);
        return p;
    }

    public Vec3d getCenter(int index) {
        double maxSize = Double.MIN_VALUE;
        int foundIndex = -1;
        if (this.multiPolygons[index] == null) {
            return null;
        }
        int i = 0;
        while ((long)i < this.multiPolygons[index].num_wkbPolygons) {
            double newSize = this.getPolygonSize(this.multiPolygons[index].WKBPolygons[i]);
            if (newSize >= maxSize) {
                maxSize = newSize;
                foundIndex = i;
            }
            ++i;
        }
        if (foundIndex != -1) {
            return this.getCenterWithinPolygon(this.multiPolygons[index].WKBPolygons[foundIndex]);
        }
        return null;
    }

    protected double getPolygonSize(WKBPolygon poly) {
        double xmin = Double.MAX_VALUE;
        double xmax = -1.7976931348623157E308;
        double ymin = Double.MAX_VALUE;
        double ymax = -1.7976931348623157E308;
        int i = 0;
        while ((long)i < poly.rings[0].numPoints) {
            Vec3d point = poly.rings[0].points[i];
            if (point.x < xmin) {
                xmin = point.x;
            }
            if (point.x > xmax) {
                xmax = point.x;
            }
            if (point.y < ymin) {
                ymin = point.y;
            }
            if (point.y > ymax) {
                ymax = point.y;
            }
            ++i;
        }
        return Math.pow((xmax - xmin) * (xmax - xmin) + (ymax - ymin) * (ymax - ymin), 0.5);
    }

    Vec3d getCenterWithinPolygon(WKBPolygon poly) {
        int j;
        Vec3d centroid = new Vec3d();
        Vec3d average = new Vec3d();
        Vec3d newPoint = new Vec3d();
        int numPoints = 0;
        double polyxMin = Double.MAX_VALUE;
        double polyxMax = -1.7976931348623157E308;
        double polyyMin = Double.MAX_VALUE;
        double polyyMax = -1.7976931348623157E308;
        int i = 0;
        while ((long)i < poly.numRings) {
            j = 0;
            while ((long)j < poly.rings[i].numPoints) {
                Vec3d point = poly.rings[i].points[j];
                if (point.x < polyxMin) {
                    polyxMin = point.x;
                }
                if (point.x > polyxMax) {
                    polyxMax = point.x;
                }
                if (point.y < polyyMin) {
                    polyyMin = point.y;
                }
                if (point.y > polyyMax) {
                    polyyMax = point.y;
                }
                average.x += point.x;
                average.y += point.y;
                ++j;
            }
            numPoints = (int)((long)numPoints + poly.rings[i].numPoints);
            ++i;
        }
        average.x /= (double)numPoints;
        average.y /= (double)numPoints;
        centroid.x = (polyxMin + polyxMax) * 0.5;
        centroid.y = (polyyMin + polyyMax) * 0.5;
        if (poly.rings[0].numPoints <= 2L || this.yMin == this.yMax) {
            return centroid;
        }
        int n = 0;
        double[] work = new double[numPoints];
        int k = 0;
        while ((long)k < poly.numRings) {
            i = 0;
            while ((long)i < poly.rings[k].numPoints - 1L) {
                double y1 = poly.rings[k].points[i].y;
                double x1 = poly.rings[k].points[i].x;
                double y2 = poly.rings[k].points[i + 1].y;
                double x2 = poly.rings[k].points[i + 1].x;
                if (y1 > y2) {
                    double tempY = y1;
                    y1 = y2;
                    y2 = tempY;
                    double tempX = x1;
                    x1 = x2;
                    x2 = tempX;
                }
                if (centroid.y >= y1 && centroid.y < y2) {
                    newPoint.x = x1 + (centroid.y - y1) / (y2 - y1) * (x2 - x1);
                    if (n == 0) {
                        work[0] = newPoint.x;
                    } else if (newPoint.x >= work[n - 1]) {
                        work[n] = newPoint.x;
                    } else {
                        for (j = n; j > 0 && newPoint.x < work[j - 1]; --j) {
                            work[j] = work[j - 1];
                        }
                        work[j] = newPoint.x;
                    }
                    ++n;
                }
                ++i;
            }
            ++k;
        }
        switch (n) {
            case 0: {
                centroid.x = average.x;
                centroid.y = average.y;
                break;
            }
            case 2: 
            case 3: {
                centroid.x = (work[0] + work[1]) * 0.5;
                break;
            }
            default: {
                if ((n & 1) != 0) {
                    --n;
                }
                j = 0;
                for (i = 2; i < n; i += 2) {
                    if (!(work[i + 1] - work[i] > work[j + 1] - work[j])) continue;
                    j = i;
                }
                centroid.x = (work[j] + work[j + 1]) * 0.5;
            }
        }
        return centroid;
    }

    public int getIndex(int i) {
        if (this.indexArray == null || this.indexArray.length <= i) {
            return -1;
        }
        return this.indexArray[i];
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(Color outlineColor) {
        this.outlineColor = outlineColor;
    }

    public int getLabelTransparency() {
        return this.labelTransparency;
    }

    public void setLabelTransparency(int labelTransparency) {
        this.labelTransparency = labelTransparency;
    }

    public Text getText() {
        return this.text;
    }

    public void setText(Text text) {
        this.text = text;
    }

    public DataFilterReadInterface getMapResponseData() {
        return this.mapResponseData;
    }

    public void setMapResponseData(DataFilterReadInterface mapResponseData) {
        this.mapResponseData = mapResponseData;
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    public void setDefaultColor(Color defaultColor) {
        this.defaultColor = defaultColor;
        if (this.colorRamp != null) {
            this.colorRamp.setMissingColor(defaultColor);
        }
    }

    public void setSpatialData(DataFilterReadInterface spatialData) {
        this.spatialData = spatialData;
    }

    public synchronized void addURLConsumer(Object context, URLConsumerInterface consumer) {
        URLConsumer con;
        Object o;
        int i;
        int n = 0;
        if (consumer == null || this.urlConsumers == null) {
            return;
        }
        n = this.urlConsumers.size();
        for (i = 0; !(i >= n || (o = this.urlConsumers.elementAt(i)) != null && o instanceof URLConsumer && consumer.equals((Object)(con = (URLConsumer)o))); ++i) {
        }
        if (i < n) {
            return;
        }
        this.urlConsumers.addElement(new URLConsumer(context, consumer));
    }

    public synchronized void removeURLConsumer(URLConsumerInterface consumer) {
        URLConsumer con;
        Object o;
        int i;
        int n = 0;
        if (consumer == null || this.urlConsumers == null) {
            return;
        }
        n = this.urlConsumers.size();
        for (i = 0; !(i >= n || (o = this.urlConsumers.elementAt(i)) != null && o instanceof URLConsumer && consumer.equals((Object)(con = (URLConsumer)o))); ++i) {
        }
        if (i >= n) {
            return;
        }
        this.urlConsumers.removeElementAt(i);
    }

    protected boolean writeURL(Object URLRole, int iobs) {
        int n = this.urlConsumers.size();
        Object o = this.mapResponseData.getValue(URLRole, (long)this.indexArray[iobs]);
        if (o == null) {
            return false;
        }
        String s = o.toString();
        for (int i = 0; i < n; ++i) {
            URLConsumer con = (URLConsumer)this.urlConsumers.elementAt(i);
            if (con == null) continue;
            con.consumer.beginURL(con.context, (Object)s, null);
        }
        return true;
    }

    protected void closeURLs() {
        int n;
        if (this.urlConsumers == null || (n = this.urlConsumers.size()) <= 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            URLConsumer con = (URLConsumer)this.urlConsumers.elementAt(i);
            if (con == null) continue;
            con.consumer.endURL(con.context);
        }
    }

    public boolean isShowGraphs() {
        return this.showGraphs;
    }

    public void setShowGraphs(boolean showGraphs) {
        this.showGraphs = showGraphs;
    }

    public boolean isShowNonExplodedGraphs() {
        return this.showNonExplodedGraphs;
    }

    public void setShowNonExplodedGraphs(boolean showNonExplodedGraphs) {
        this.showNonExplodedGraphs = showNonExplodedGraphs;
    }

    public String getGraphType() {
        return this.graphType;
    }

    public void setGraphType(String graphType) {
        this.graphType = graphType;
    }

    public double getMaxGraphPercent() {
        return this.maxGraphPercent;
    }

    public double getMinGraphPercent() {
        return this.minGraphPercent;
    }

    public void setMaxGraphPercent(double maxGraphPercent) {
        this.maxGraphPercent = maxGraphPercent;
    }

    public void setMinGraphPercent(double minGraphPercent) {
        this.minGraphPercent = minGraphPercent;
    }

    public boolean isExplodeGraphs() {
        return this.explodeGraphs;
    }

    public void setExplodeGraphs(boolean explodeGraphs) {
        this.explodeGraphs = explodeGraphs;
    }

    public Color[] getWatermarkColors() {
        int numWatermarkRoles = this.roles.getNumVariablesAssigned((Object)RoleInterface.ROLE_WATERMARK);
        Color[] colors = new Color[numWatermarkRoles];
        Color[] colorsToUse = this.defaultColors;
        this.style.getDataFillColors();
        for (int i = 0; i < numWatermarkRoles; ++i) {
            colors[i] = colorsToUse[i % 12];
        }
        return colors;
    }

    public Rectangle getTotalBounds() {
        return this.totalBounds;
    }

    public void setTotalBounds(Rectangle rectangle) {
        this.totalBounds = rectangle;
    }

    public boolean isUseColorRamp() {
        return this.useColorRamp;
    }

    public void setUseColorRamp(boolean b) {
        this.useColorRamp = b;
    }

    public boolean isColorGraphsByChart() {
        return this.colorGraphsByChart;
    }

    public void setColorGraphsByChart(boolean b) {
        this.colorGraphsByChart = b;
    }

    public Vector getMapIDVector() {
        return this.mapIDVector;
    }

    public void setMapIDVector(Vector mapIDVector) {
        this.mapIDVector = mapIDVector;
    }

    public boolean isDrawAllRegions() {
        return this.drawAllRegions;
    }

    public void setDrawAllRegions(boolean drawAllRegions) {
        this.drawAllRegions = drawAllRegions;
    }

    class URLConsumer {
        public Object context;
        public URLConsumerInterface consumer;

        public URLConsumer(Object context, URLConsumerInterface consumer) {
            this.context = context;
            this.consumer = consumer;
        }
    }
}

