/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.icicle;

import com.sas.graphics.silk.icicle.IcicleNode;
import com.sas.graphics.silk.interfaces.TreeModelInterface;
import com.sas.graphics.silk.interfaces.TreeNodeInterface;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class IcicleNodeTree {
    TreeModelInterface treeData;
    IcicleNode root;
    int maxLevel;
    int height;
    double minNodeSize = Double.NaN;
    double maxNodeSize = Double.NaN;
    double minNodeColor = Double.NaN;
    double maxNodeColor = Double.NaN;

    public IcicleNodeTree(TreeModelInterface treeData) {
        this.treeData = treeData;
        if (treeData == null) {
            return;
        }
        this.insertNode(treeData.getRoot());
    }

    public void buildIcicleNodeTree(Object id) {
        Vector children = this.treeData.getChildren(id);
        if (children == null) {
            return;
        }
        for (int j = 0; j < children.size(); ++j) {
            this.insertNode((TreeNodeInterface)children.elementAt(j));
            this.buildIcicleNodeTree(((TreeNodeInterface)children.elementAt(j)).getId());
        }
    }

    private void insertNode(TreeNode treeNode) {
        if (treeNode == null) {
            return;
        }
        if (this.root == null) {
            this.root = new IcicleNode(treeNode, 0);
            this.root.setXStart(0);
            this.maxLevel = 0;
            if (treeNode instanceof TreeNodeInterface) {
                this.minNodeSize = this.maxNodeSize = ((TreeNodeInterface)treeNode).getNodeSize();
                this.minNodeColor = this.maxNodeColor = ((TreeNodeInterface)treeNode).getNodeColorValue();
            }
        } else {
            int level = this.insert(this.root, treeNode);
            this.maxLevel = Math.max(level, this.maxLevel);
            this.height = 300 / (this.maxLevel + 1);
            if (treeNode instanceof TreeNodeInterface) {
                this.minNodeSize = Math.min(this.minNodeSize, ((TreeNodeInterface)treeNode).getNodeSize());
                this.maxNodeSize = Math.max(this.maxNodeSize, ((TreeNodeInterface)treeNode).getNodeSize());
                this.minNodeColor = Math.min(this.minNodeColor, ((TreeNodeInterface)treeNode).getNodeColorValue());
                this.maxNodeColor = Math.max(this.maxNodeColor, ((TreeNodeInterface)treeNode).getNodeColorValue());
            }
        }
    }

    public int insert(IcicleNode currentNode, TreeNode treeNode) {
        int level = -1;
        if (treeNode instanceof TreeNodeInterface) {
            if (((TreeNodeInterface)treeNode).getParentId().equals(currentNode.getParentId())) {
                if (currentNode.sibling == null) {
                    currentNode.sibling = new IcicleNode(treeNode, currentNode.getLevel());
                } else {
                    level = this.insert(currentNode.sibling, treeNode);
                }
                return currentNode.getLevel();
            }
            if (((TreeNodeInterface)treeNode).getParentId().equals(currentNode.getId()) && currentNode.child == null) {
                currentNode.child = new IcicleNode(treeNode, currentNode.getLevel() + 1);
                return currentNode.getLevel() + 1;
            }
        } else {
            if (treeNode.getParent().equals(currentNode.data.getParent())) {
                if (currentNode.sibling == null) {
                    currentNode.sibling = new IcicleNode(treeNode, currentNode.getLevel());
                } else {
                    level = this.insert(currentNode.sibling, treeNode);
                }
                return currentNode.getLevel();
            }
            if (treeNode.getParent().equals(currentNode.toString()) && currentNode.child == null) {
                currentNode.child = new IcicleNode(treeNode, currentNode.getLevel() + 1);
                return currentNode.getLevel() + 1;
            }
        }
        if (currentNode.sibling != null) {
            level = this.insert(currentNode.sibling, treeNode);
        }
        if (currentNode.child != null && level == -1) {
            level = this.insert(currentNode.child, treeNode);
        }
        return level;
    }

    public Object getRoot() {
        return this.root;
    }

    public Object getNode(Object id) {
        return this.getIdNode(this.root, id);
    }

    private IcicleNode getIdNode(IcicleNode node, Object id) {
        IcicleNode rn = null;
        if (node == null) {
            return rn;
        }
        if (id.equals(node.getId())) {
            rn = node;
        } else {
            rn = this.getIdNode(node.sibling, id);
            if (rn == null) {
                rn = this.getIdNode(node.child, id);
            }
        }
        return rn;
    }

    public Object getChildren(Object id) {
        IcicleNode node = this.getIdNode(this.root, id);
        if (node == null || node.child == null) {
            return null;
        }
        Vector<IcicleNode> children = new Vector<IcicleNode>();
        node = node.child;
        while (node != null) {
            children.addElement(node.sibling);
            node = node.sibling;
        }
        return children;
    }

    public Object getLeaves() {
        Vector leaves = new Vector();
        this.findLeaves(this.root, leaves);
        return leaves;
    }

    private void findLeaves(IcicleNode node, Vector leaves) {
        if (node == null) {
            return;
        }
        if (node.sibling != null) {
            this.findLeaves(node.sibling, leaves);
        }
        if (node.child != null) {
            this.findLeaves(node.child, leaves);
        } else {
            leaves.addElement(node);
        }
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public double getMinNodeSize() {
        return this.minNodeSize;
    }

    public double getMaxNodeSize() {
        return this.maxNodeSize;
    }

    public double getMinNodeColor() {
        return this.minNodeColor;
    }

    public double getMaxNodeColor() {
        return this.maxNodeColor;
    }

    public void dispose() {
        this.treeData = null;
        if (this.root != null) {
            this.root.dispose();
        }
        this.root = null;
    }
}

