/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.icicle;

import com.sas.graphics.silk.interfaces.TreeNodeInterface;
import java.util.StringTokenizer;
import javax.swing.tree.TreeNode;

public class IcicleNode {
    int width;
    int xStart;
    int level;
    IcicleNode child;
    IcicleNode sibling;
    TreeNode data = null;
    String[][] parsedTipText = null;

    public IcicleNode(TreeNode treeNode, int lvl) {
        this.data = treeNode;
        this.sibling = null;
        this.child = null;
        this.level = lvl;
    }

    public String getNodeText() {
        if (this.data instanceof TreeNodeInterface) {
            return ((TreeNodeInterface)this.data).getNodeText();
        }
        return this.data.toString();
    }

    public String[][] getParsedToolTipText() {
        if (this.parsedTipText == null && this.data instanceof TreeNodeInterface) {
            this.parsedTipText = IcicleNode.parseText(((TreeNodeInterface)this.data).getToolTipText());
        }
        return this.parsedTipText;
    }

    public Object getId() {
        if (this.data instanceof TreeNodeInterface) {
            return ((TreeNodeInterface)this.data).getId();
        }
        return this.data.toString();
    }

    Object getParentId() {
        if (this.data instanceof TreeNodeInterface) {
            return ((TreeNodeInterface)this.data).getParentId();
        }
        return this.data.getParent().toString();
    }

    double getNodeSize() {
        if (this.data instanceof TreeNodeInterface) {
            return ((TreeNodeInterface)this.data).getNodeSize();
        }
        return Double.NaN;
    }

    void setXStart(int start) {
        this.xStart = start;
    }

    void setWidth(int width) {
        this.width = width;
    }

    int getWidth() {
        return this.width;
    }

    int getXStart() {
        return this.xStart;
    }

    int getLevel() {
        return this.level;
    }

    public static String[][] parseText(String text) {
        if (text == null) {
            return null;
        }
        StringTokenizer lineParser = new StringTokenizer(text, "\n");
        String[][] rc = new String[lineParser.countTokens()][];
        int maxCols = 0;
        int i = 0;
        while (lineParser.hasMoreTokens()) {
            StringTokenizer colParser = new StringTokenizer(lineParser.nextToken(), "\t");
            rc[i] = new String[colParser.countTokens()];
            if (colParser.countTokens() > maxCols) {
                maxCols = colParser.countTokens();
            }
            int j = 0;
            while (colParser.hasMoreTokens()) {
                rc[i][j] = colParser.nextToken();
                ++j;
            }
            ++i;
        }
        String[][] temp = rc;
        rc = new String[maxCols][];
        for (i = 0; i < maxCols; ++i) {
            rc[i] = IcicleNode.getCol(i, temp);
        }
        return rc;
    }

    public static String[] getCol(int i, String[][] arr) {
        String[] rc = new String[arr.length];
        for (int j = 0; j < arr.length; ++j) {
            rc[j] = arr[j].length > i ? arr[j][i] : new String("");
        }
        return rc;
    }

    public void dispose() {
        if (this.child != null) {
            this.child.dispose();
        }
        this.child = null;
        if (this.sibling != null) {
            this.sibling.dispose();
        }
        this.sibling = null;
        this.data = null;
        this.parsedTipText = null;
    }
}

