/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.heatmap;

import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.DataFilterInfoInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.util.CollectionSorter;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.util.NumericFormat;
import com.sas.graphics.util.StringCompare;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class HeatmapModel
implements RoleInterface,
DataFilterListenerInterface {
    public static final int ROLE_X = 0;
    public static final int ROLE_Y = 1;
    public static final int ROLE_RESP = 2;
    public static final int ROLE_TIP = 3;
    public static final int ROLE_COLOR_INDEX = 4;
    public static final int NUM_ROLES = 5;
    protected DataFilterReadInterface dataIn;
    protected Object[] variables = new Object[5];
    protected HashMap discrete = new HashMap();
    protected HashMap sortOrder = new HashMap();
    protected double[] selectedValues;
    protected HashMap uniqueXValues;
    protected HashMap uniqueYValues;
    protected HashMap xValues;
    protected HashMap yValues;
    protected double rMin;
    protected double rMax;
    protected double xMin;
    protected double xMax;
    protected String missingSymbol = "";
    protected boolean dateTime;
    protected double dateTimeSpan;
    protected double timeMin;
    protected double timeMax;
    protected double respMin;
    protected double respMax;
    protected boolean summarized = true;
    protected boolean spreadSheetData = false;
    protected boolean numericResponse = false;
    protected boolean validSpreadSheet = true;
    protected boolean transposed = false;
    protected Object[] uniqueResponseValues;
    protected Object[] globalUniqueResponseValues;
    public static final Roles ROLES = Roles.getInstance(null);
    public static final String X_ROLE_NAME = ROLES.getRoleNLSName("ROLE_X");
    public static final String Y_ROLE_NAME = ROLES.getRoleNLSName("ROLE_Y");
    public static final String RESP_ROLE_NAME = ROLES.getRoleNLSName("ROLE_RESPONSE");
    public static final String TIP_ROLE_NAME = ROLES.getRoleNLSName("ROLE_TIP");
    public static final String COLOR_INDEX_ROLE_NAME = ROLES.getRoleNLSName("ROLE_COLOR_INDEX");
    public static final SILKNumber X_ROLE_NUMBER = ROLES.getRoleObject("ROLE_X");
    public static final SILKNumber Y_ROLE_NUMBER = ROLES.getRoleObject("ROLE_Y");
    public static final SILKNumber RESP_ROLE_NUMBER = ROLES.getRoleObject("ROLE_RESPONSE");
    public static final SILKNumber TIP_ROLE_NUMBER = ROLES.getRoleObject("ROLE_TIP");
    public static final SILKNumber COLOR_INDEX_ROLE_NUMBER = ROLES.getRoleObject("ROLE_COLOR_INDEX");

    public HeatmapModel(DataFilterReadInterface data) {
        this.setDataSource(data);
    }

    public HeatmapModel() {
        this(null);
    }

    protected boolean isZeroObservation() {
        long obs = this.dataIn.getNumberObservations(-1);
        return obs <= 0L;
    }

    protected double[] getSelectedValues() {
        return this.selectedValues;
    }

    public boolean setSelection(int i, boolean selected) {
        this.dataIn.setSelected((long)i, selected);
        return true;
    }

    public boolean setSelection(int[] obs, boolean selected) {
        this.dataIn.setSelected((Object)obs, selected);
        return true;
    }

    public boolean setSelectionAll(boolean selected) {
        if (!selected) {
            this.dataIn.unselectAll();
        } else {
            int rows = this.dataIn.getNumberObservations(-1);
            int[] obs = new int[rows];
            for (int i = 0; i < rows; ++i) {
                obs[i] = i;
            }
            this.dataIn.setSelected((Object)obs, selected);
        }
        return true;
    }

    public boolean sendSelectionEvent() {
        this.dataIn.sendEvent((Object)new DvrDataFilterEvent(7));
        return true;
    }

    public boolean isDateTime() {
        return this.dateTime;
    }

    public double getDateTimeSpan() {
        return this.dateTimeSpan;
    }

    public double getMinimumValue(Object variableId) {
        return this.getMinimumValue(variableId, true);
    }

    public double getMinimumValue(Object variableId, boolean userSetting) {
        if (variableId == null) {
            return Double.NaN;
        }
        if (this.getRole(variableId).equals(X_ROLE_NAME)) {
            if (!this.isDateTime()) {
                return 0.0;
            }
            if (userSetting && !Double.isNaN(this.xMin)) {
                return this.xMin;
            }
            if (Double.isNaN(this.timeMin)) {
                return this.timeMin;
            }
        } else {
            if (this.getRole(variableId).equals(Y_ROLE_NAME)) {
                return 0.0;
            }
            if (this.getRole(variableId).equals(RESP_ROLE_NAME)) {
                if (userSetting && !Double.isNaN(this.rMin)) {
                    return this.rMin;
                }
                if (Double.isNaN(this.respMin)) {
                    return this.respMin;
                }
            }
        }
        int vid = this.dataIn.getVariableIndex(variableId);
        long rows = this.dataIn.getNumberObservations(vid);
        double min = Double.MAX_VALUE;
        for (long i = 0L; i < rows; ++i) {
            double v;
            if (!this.dataIn.isGraphed(i) || Double.isNaN(v = this.dataIn.getNumericValue(vid, i)) || !(v < min)) continue;
            min = v;
        }
        return min;
    }

    public double getMaximumValue(Object variableId) {
        return this.getMaximumValue(variableId, true);
    }

    public double getMaximumValue(Object variableId, boolean userSetting) {
        if (variableId == null) {
            return Double.NaN;
        }
        if (this.getRole(variableId).equals(X_ROLE_NAME)) {
            if (!this.isDateTime()) {
                if (userSetting && this.xValues != null) {
                    return this.xValues.size() - 1;
                }
                return this.uniqueXValues.size() - 1;
            }
            if (userSetting && !Double.isNaN(this.xMax)) {
                return this.xMax;
            }
            if (Double.isNaN(this.timeMax)) {
                return this.timeMax;
            }
        } else {
            if (this.getRole(variableId).equals(Y_ROLE_NAME)) {
                if (userSetting && this.yValues != null) {
                    return this.yValues.size() - 1;
                }
                return this.uniqueYValues.size() - 1;
            }
            if (this.getRole(variableId).equals(RESP_ROLE_NAME)) {
                if (userSetting && !Double.isNaN(this.rMax)) {
                    return this.rMax;
                }
                if (Double.isNaN(this.respMax)) {
                    return this.respMax;
                }
            }
        }
        int vid = this.dataIn.getVariableIndex(variableId);
        long rows = this.dataIn.getNumberObservations(vid);
        double max = -1.7976931348623157E308;
        for (long i = 0L; i < rows; ++i) {
            double v;
            if (!this.dataIn.isGraphed(i) || Double.isNaN(v = this.dataIn.getNumericValue(vid, i)) || !(v > max)) continue;
            max = v;
        }
        return max;
    }

    protected double getMinimumTime() {
        if (!Double.isNaN(this.xMin)) {
            return this.xMin;
        }
        return this.timeMin;
    }

    protected double getMaximumTime() {
        if (!Double.isNaN(this.xMax)) {
            return this.xMax;
        }
        return this.timeMax;
    }

    protected double getMinimumResponse() {
        if (!Double.isNaN(this.rMin)) {
            return this.rMin;
        }
        return this.respMin;
    }

    protected double getMaximumResponse() {
        if (!Double.isNaN(this.rMax)) {
            return this.rMax;
        }
        return this.respMax;
    }

    public int getUniqueXValueCount() {
        return this.getUniqueXValueCount(true);
    }

    public int getUniqueXValueCount(boolean userSetting) {
        if (!this.isDateTime()) {
            HashMap vals = this.getXValues(userSetting);
            return vals == null ? 0 : vals.size();
        }
        return -1;
    }

    public Object[] getUniqueXValues() {
        return this.getUniqueXValues(true);
    }

    public Object[] getUniqueXValues(boolean userSetting) {
        return this.getXValues(userSetting).keySet().toArray();
    }

    public int getXValueIndex(Object v) {
        return this.getXValueIndex(v, true);
    }

    public int getXValueIndex(Object v, boolean userSetting) {
        HashMap vals = this.getXValues(userSetting);
        if (vals == null) {
            return 0;
        }
        if (this.dataIn.isMissing(this.variables[0], v)) {
            v = this.missingSymbol;
        }
        return (Integer)vals.get(v);
    }

    public int getUniqueYValueCount() {
        return this.getUniqueYValueCount(true);
    }

    public int getUniqueYValueCount(boolean userSetting) {
        HashMap vals = this.getYValues(userSetting);
        return vals == null ? 0 : vals.size();
    }

    public Object[] getUniqueYValues() {
        return this.getUniqueYValues(true);
    }

    public Object[] getUniqueYValues(boolean userSetting) {
        HashMap map = this.getYValues(userSetting);
        Object[] values = new Object[map.size()];
        Iterator iter = map.keySet().iterator();
        int idx = map.size() - 1;
        while (iter.hasNext()) {
            values[idx] = iter.next();
            --idx;
        }
        return values;
    }

    public int getYValueIndex(Object v) {
        return this.getYValueIndex(v, true);
    }

    public int getYValueIndex(Object v, boolean userSetting) {
        HashMap vals = this.getYValues(userSetting);
        if (vals == null) {
            return 0;
        }
        if (this.variables[1] != null && this.dataIn.isMissing(this.variables[1], v)) {
            v = this.missingSymbol;
        }
        return vals.size() - 1 - (Integer)vals.get(v);
    }

    public Object[] getUniqueResponseValues(boolean applyWhere) {
        if (this.spreadSheetData) {
            return applyWhere ? this.uniqueResponseValues : this.globalUniqueResponseValues;
        }
        return this.dataIn instanceof DataFilterInfoInterface && this.variables[2] != null ? ((DataFilterInfoInterface)this.dataIn).getUniqueValues(this.variables[2], applyWhere) : null;
    }

    public void setMinimumTime(double v) {
        this.xMin = v;
    }

    public void setMaximumTime(double v) {
        this.xMax = v;
    }

    public void setMinimumResponse(double v) {
        this.rMin = v;
    }

    public void setMaximumResponse(double v) {
        this.rMax = v;
    }

    public void setXValues(Object[] vals) {
        if (this.xValues == null) {
            this.xValues = new LinkedHashMap();
        } else {
            this.xValues.clear();
        }
        for (int i = 0; i < vals.length; ++i) {
            this.xValues.put(vals[i], new Integer(i));
        }
    }

    public void setYValues(Object[] vals) {
        if (this.yValues == null) {
            this.yValues = new LinkedHashMap();
        } else {
            this.yValues.clear();
        }
        for (int i = 0; i < vals.length; ++i) {
            this.yValues.put(vals[i], new Integer(i));
        }
    }

    public Object getVariableDescription(Object variable) {
        if (variable == null) {
            return null;
        }
        Object desc = this.dataIn.getVariableDescription(variable);
        if (desc == null || ((String)desc).equals("")) {
            return variable;
        }
        return desc;
    }

    public Object getRoleDescription(Object role) {
        return this.getVariableDescription(this.getVariable(role));
    }

    public SASFormat getResponseFormat(double min, double max) {
        SASFormat fmt = (SASFormat)this.dataIn.getFormat(this.variables[2], SASFormat.class);
        if (fmt == null && this.isNumericResponse()) {
            String fmtName = NumericFormat.getFormatName((double[])new double[]{min, max}, (int)8, (boolean)false);
            fmt = SASFormat.getInstance((String)fmtName);
        }
        return fmt;
    }

    public String getMissingSymbol() {
        return this.missingSymbol;
    }

    public Object[] getDataIds() {
        return null;
    }

    public Object getDataSource() {
        return this.getDataSource(null);
    }

    public Object getDataSource(Object id) {
        return this.dataIn;
    }

    public boolean setDataSource(Object source) {
        return this.setDataSource(source, null);
    }

    public boolean setDataSource(Object source, Object id) {
        if (!(source instanceof DataFilterReadInterface)) {
            return false;
        }
        this.dataIn = (DataFilterReadInterface)source;
        this.dataIn.addDataFilterListener((Object)this);
        for (int i = 0; i < this.variables.length; ++i) {
            this.variables[i] = null;
        }
        this.initUserSettings(null);
        if (this.spreadSheetData) {
            return this.processSpreadSheetData();
        }
        return true;
    }

    public Object getAllVariables(Object role) {
        return this.getVariable(role);
    }

    public Object getVariable(Object role) {
        int id;
        Object NLSRole = this.getNLSRole(role);
        if (NLSRole == null) {
            return null;
        }
        if (NLSRole.equals(X_ROLE_NAME)) {
            id = 0;
        } else if (NLSRole.equals(Y_ROLE_NAME)) {
            id = 1;
        } else if (NLSRole.equals(RESP_ROLE_NAME)) {
            id = 2;
        } else if (NLSRole.equals(TIP_ROLE_NAME)) {
            id = 3;
        } else if (NLSRole.equals(COLOR_INDEX_ROLE_NAME)) {
            id = 4;
        } else {
            return null;
        }
        return this.variables[id];
    }

    public Object getRole(Object variableId) {
        SILKNumber obj;
        int id = -1;
        for (int i = 0; i < this.variables.length; ++i) {
            if (this.variables[i] instanceof String && variableId instanceof String && StringCompare.equals((String)((String)this.variables[i]), (String)((String)variableId))) {
                id = i;
                break;
            }
            if (this.variables[i] == null || !this.variables[i].equals(variableId)) continue;
            id = i;
            break;
        }
        switch (id) {
            default: {
                obj = null;
                break;
            }
            case 0: {
                obj = X_ROLE_NUMBER;
                break;
            }
            case 1: {
                obj = Y_ROLE_NUMBER;
                break;
            }
            case 2: {
                obj = RESP_ROLE_NUMBER;
                break;
            }
            case 3: {
                obj = TIP_ROLE_NUMBER;
                break;
            }
            case 4: {
                obj = COLOR_INDEX_ROLE_NUMBER;
            }
        }
        return obj;
    }

    public boolean setRole(Object variableId, Object role) {
        int id;
        if (this.dataIn == null || !(this.dataIn instanceof DataFilterReadInterface)) {
            return false;
        }
        if (this.spreadSheetData) {
            return true;
        }
        Object NLSRole = this.getNLSRole(role);
        if (NLSRole == null) {
            return false;
        }
        if (NLSRole.equals(X_ROLE_NAME)) {
            id = 0;
        } else if (NLSRole.equals(Y_ROLE_NAME)) {
            id = 1;
        } else if (NLSRole.equals(RESP_ROLE_NAME)) {
            id = 2;
        } else if (NLSRole.equals(TIP_ROLE_NAME)) {
            id = 3;
        } else if (NLSRole.equals(COLOR_INDEX_ROLE_NAME) && this.dataIn.isNumericVariable(variableId)) {
            id = 4;
        } else {
            return false;
        }
        if (variableId == null) {
            return false;
        }
        if (variableId instanceof String[] || variableId instanceof Object[]) {
            this.spreadSheetData = true;
            return this.processSpreadSheetData(id, (Object[])variableId);
        }
        if (variableId != null && !this.dataIn.verifyVariable(variableId)) {
            return false;
        }
        this.variables[id] = variableId;
        if (id == 0) {
            SASFormat fmt;
            this.dateTime = false;
            if (this.dataIn.isNumericVariable(variableId) && (fmt = (SASFormat)this.dataIn.getFormat(variableId, SASFormat.class)) != null && fmt instanceof SASDateTimeFormat) {
                this.dateTime = true;
            }
            if (this.dateTime) {
                this.getTimeInfo(variableId);
            } else {
                this.uniqueXValues = this.findUniqueValues(variableId, null);
            }
        }
        if (id == 1) {
            this.uniqueYValues = this.findUniqueValues(variableId, null);
        }
        if (id == 2) {
            this.getResponseInfo(variableId);
        }
        this.initUserSettings(NLSRole);
        return true;
    }

    public boolean addRole(Object variableId, Object role) {
        return this.setRole(variableId, role);
    }

    public boolean removeRole(Object variableId, Object role) {
        int id;
        if (this.dataIn == null || !(this.dataIn instanceof DataFilterReadInterface)) {
            return false;
        }
        Object NLSRole = this.getNLSRole(role);
        if (NLSRole == null) {
            return false;
        }
        if (NLSRole.equals(X_ROLE_NAME)) {
            id = 0;
        } else if (NLSRole.equals(Y_ROLE_NAME)) {
            id = 1;
        } else if (NLSRole.equals(RESP_ROLE_NAME)) {
            id = 2;
        } else if (NLSRole.equals(TIP_ROLE_NAME)) {
            id = 3;
        } else if (NLSRole.equals(COLOR_INDEX_ROLE_NAME)) {
            id = 4;
        } else {
            return false;
        }
        if (this.variables[id] instanceof String && variableId instanceof String && StringCompare.equals((String)((String)this.variables[id]), (String)((String)variableId))) {
            this.variables[id] = null;
        } else if (this.variables[id] != null && this.variables[id].equals(variableId)) {
            this.variables[id] = null;
        } else {
            return false;
        }
        this.initUserSettings(NLSRole);
        return true;
    }

    public boolean isDiscrete(Object role) {
        Object NLSRole = this.getNLSRole(role);
        if (NLSRole == null) {
            return false;
        }
        Boolean dis = (Boolean)this.discrete.get(NLSRole);
        if (dis != null) {
            return dis;
        }
        return false;
    }

    public boolean setDiscrete(Object role, boolean discrete) {
        Object NLSRole = this.getNLSRole(role);
        if (NLSRole == null) {
            return false;
        }
        this.discrete.put(NLSRole, new Boolean(discrete));
        this.initUserSettings(NLSRole);
        return true;
    }

    public Object getSortOrder(Object role) {
        Object NLSRole = this.getNLSRole(role);
        if (NLSRole == null) {
            return null;
        }
        return this.sortOrder.get(NLSRole);
    }

    public boolean setSortOrder(Object role, Object order) {
        Object NLSRole = this.getNLSRole(role);
        if (NLSRole == null) {
            return false;
        }
        this.sortOrder.put(NLSRole, order);
        Object variableId = this.getVariable(role);
        if (NLSRole.equals(X_ROLE_NAME) && !this.isDateTime()) {
            this.uniqueXValues = this.findUniqueValues(variableId, null);
        }
        if (NLSRole.equals(Y_ROLE_NAME)) {
            this.uniqueYValues = this.findUniqueValues(variableId, null);
        }
        return true;
    }

    public Object getRoleValue(Object role, int which) {
        Object id = this.getVariable(role);
        if (id == null) {
            return null;
        }
        if (which == 0) {
            return new Double(this.getMinimumValue(id, false));
        }
        if (which == 1) {
            return new Double(this.getMaximumValue(id, false));
        }
        return null;
    }

    public Object[] getSupportedRoles(Object id, boolean discrete) {
        return null;
    }

    public int getMaxAllowed(Object role) {
        return -1;
    }

    public void addRoleListener(RoleListenerInterface listener) {
    }

    public void removeRoleListener(RoleListenerInterface listener) {
    }

    public Object getLimit(Object role) {
        return null;
    }

    public boolean setLimit(Object role, Object value) {
        return false;
    }

    public Object[][] getSupportedSortableRoles() {
        return null;
    }

    public int[] getSupportedSortDirections(Object role) {
        return null;
    }

    public boolean requiresMultipleRoleAssignments() {
        return false;
    }

    public void dataFilterChanged(DvrDataFilterEvent evt) {
        if (evt.isAdjusting) {
            return;
        }
        switch (evt.type) {
            case 8: 
            case 9: {
                break;
            }
            case 2: {
                break;
            }
            case 1: 
            case 3: {
                if (this.variables[0] != null) {
                    this.uniqueXValues = this.findUniqueValues(this.variables[0], null);
                }
                if (this.variables[1] != null) {
                    this.uniqueYValues = this.findUniqueValues(this.variables[1], null);
                }
                if (this.isSpreadSheetData()) {
                    this.uniqueResponseValues = this.findUniqueResponseValues(true);
                }
                this.initUserSettings(null);
            }
        }
    }

    public boolean supportsMultipleAssignments(Object role) {
        return false;
    }

    private Object getNLSRole(Object role) {
        if (role instanceof SILKNumber) {
            role = ((SILKNumber)role).toString();
        }
        if (!(role instanceof String) && !(role instanceof Number)) {
            return null;
        }
        String NLSRole = role instanceof String && ((String)role).equalsIgnoreCase("X") || role instanceof String && ((String)role).equalsIgnoreCase(X_ROLE_NAME) || role instanceof Number && ((Integer)role).equals(RoleInterface.ROLE_X) ? X_ROLE_NAME : (role instanceof String && ((String)role).equalsIgnoreCase("Y") || role instanceof String && ((String)role).equalsIgnoreCase(Y_ROLE_NAME) || role instanceof Number && ((Integer)role).equals(RoleInterface.ROLE_Y) ? Y_ROLE_NAME : (role instanceof String && ((String)role).equalsIgnoreCase("Response") || role instanceof String && ((String)role).equalsIgnoreCase(RESP_ROLE_NAME) || role instanceof Number && ((Integer)role).equals(RoleInterface.ROLE_RESPONSE) ? RESP_ROLE_NAME : (role instanceof String && ((String)role).equalsIgnoreCase("Tip") || role instanceof String && ((String)role).equalsIgnoreCase(TIP_ROLE_NAME) || role instanceof Number && ((Integer)role).equals(RoleInterface.ROLE_TIP) ? TIP_ROLE_NAME : (role instanceof String && ((String)role).equalsIgnoreCase("Color Index") || role instanceof String && ((String)role).equalsIgnoreCase(COLOR_INDEX_ROLE_NAME) || role instanceof Number && ((Integer)role).equals(RoleInterface.ROLE_COLOR_INDEX) ? COLOR_INDEX_ROLE_NAME : null))));
        return NLSRole;
    }

    private HashMap findUniqueValues(Object v, Object sortOrder) {
        int vid = this.dataIn.getVariableIndex(v);
        if (vid < 0) {
            return null;
        }
        long rows = this.dataIn.getNumberObservations(vid);
        boolean missing = false;
        Object SORT = sortOrder == null ? this.getSortOrder(this.getRole(v)) : sortOrder;
        int sort = SORT == null ? 0 : (Integer)SORT;
        Object o = null;
        Object fmtV = null;
        LinkedHashMap<Object, Integer> list = new LinkedHashMap<Object, Integer>();
        int num = 0;
        int i = 0;
        while ((long)i < rows) {
            if (this.dataIn.isGraphed((long)i)) {
                o = this.dataIn.getValue(vid, (long)i);
                if (this.dataIn.isMissing(vid, o)) {
                    missing = true;
                    fmtV = this.missingSymbol;
                } else {
                    fmtV = o;
                }
                if (!(list.containsKey(fmtV) || fmtV.equals(this.missingSymbol) && sort != 0)) {
                    list.put(fmtV, new Integer(num));
                    ++num;
                }
            }
            ++i;
        }
        int order = 0;
        if (sort == 1) {
            order = 1;
        } else if (sort == -1) {
            order = -1;
        }
        if (order != 0) {
            Collection c = CollectionSorter.getValues(list.keySet(), (int)order);
            Iterator iter = c.iterator();
            num = 0;
            list.clear();
            if (missing && sort == 1) {
                list.put(this.missingSymbol, new Integer(num));
                ++num;
            }
            while (iter.hasNext()) {
                list.put(iter.next(), new Integer(num));
                ++num;
            }
            if (missing && sort == -1) {
                list.put(this.missingSymbol, new Integer(num));
            }
        }
        return list;
    }

    private void getTimeInfo(Object variableId) {
        int vid = this.dataIn.getVariableIndex(variableId);
        long rows = this.dataIn.getNumberObservations(vid);
        this.timeMin = Double.MAX_VALUE;
        this.timeMax = -1.7976931348623157E308;
        this.dateTimeSpan = Double.MAX_VALUE;
        int idx = 0;
        double v1 = 0.0;
        double v2 = 0.0;
        int i = 0;
        while ((long)i < rows) {
            v1 = this.dataIn.getNumericValue(vid, (long)i);
            if (!Double.isNaN(v1)) {
                if (v1 > this.timeMax) {
                    this.timeMax = v1;
                }
                if (v1 < this.timeMin) {
                    this.timeMin = v1;
                }
                idx = i + 1;
                break;
            }
            ++i;
        }
        while ((long)idx < rows) {
            v2 = this.dataIn.getNumericValue(vid, (long)idx);
            ++idx;
            if (Double.isNaN(v2)) {
                i = idx;
                while ((long)i < rows) {
                    v2 = this.dataIn.getNumericValue(vid, (long)i);
                    if (!Double.isNaN(v2)) {
                        idx = i + 1;
                        break;
                    }
                    ++i;
                }
            }
            if (v2 > this.timeMax) {
                this.timeMax = v2;
            }
            if (v2 < this.timeMin) {
                this.timeMin = v2;
            }
            if (v2 > v1 && v2 - v1 < this.dateTimeSpan) {
                this.dateTimeSpan = v2 - v1;
            } else if (v1 > v2 && v1 - v2 < this.dateTimeSpan) {
                this.dateTimeSpan = v1 - v2;
            }
            v1 = v2;
        }
    }

    private void getResponseInfo(Object variableId) {
        if (!this.dataIn.isNumericVariable(variableId)) {
            this.numericResponse = false;
            return;
        }
        this.numericResponse = true;
        int vid = this.dataIn.getVariableIndex(variableId);
        long rows = this.dataIn.getNumberObservations(vid);
        this.respMin = Double.MAX_VALUE;
        this.respMax = -1.7976931348623157E308;
        for (long i = 0L; i < rows; ++i) {
            double v;
            if (!this.dataIn.isGraphed(i) || Double.isNaN(v = this.dataIn.getNumericValue(vid, i))) continue;
            if (v > this.respMax) {
                this.respMax = v;
            }
            if (!(v < this.respMin)) continue;
            this.respMin = v;
        }
    }

    private HashMap getXValues(boolean userSetting) {
        HashMap vals = this.variables[0] == null && !this.spreadSheetData ? null : (userSetting && this.xValues != null ? this.xValues : this.uniqueXValues);
        return vals;
    }

    private HashMap getYValues(boolean userSetting) {
        HashMap vals = this.variables[1] == null && !this.spreadSheetData ? null : (userSetting && this.yValues != null ? this.yValues : this.uniqueYValues);
        return vals;
    }

    private void initUserSettings(Object NLSRole) {
        if (NLSRole == null) {
            this.rMin = Double.NaN;
            this.rMax = Double.NaN;
            this.xMin = Double.NaN;
            this.xMax = Double.NaN;
            this.xValues = null;
            this.yValues = null;
        } else if (NLSRole.equals(X_ROLE_NAME)) {
            this.xMin = Double.NaN;
            this.xMax = Double.NaN;
            this.xValues = null;
        } else if (NLSRole.equals(Y_ROLE_NAME)) {
            this.yValues = null;
        } else if (NLSRole.equals(RESP_ROLE_NAME)) {
            this.rMin = Double.NaN;
            this.rMax = Double.NaN;
        }
    }

    private boolean processSpreadSheetData() {
        SASFormat fmt;
        this.transposed = true;
        this.variables[0] = this.dataIn.getVariableId(0);
        this.dateTime = false;
        if (this.dataIn.isNumericVariable(this.variables[0]) && (fmt = (SASFormat)this.dataIn.getFormat(this.variables[0], SASFormat.class)) != null && fmt instanceof SASDateTimeFormat) {
            this.dateTime = true;
        }
        if (this.dateTime) {
            this.getTimeInfo(this.variables[0]);
        } else {
            this.uniqueXValues = this.findUniqueValues(this.variables[0], null);
        }
        int cols = this.dataIn.getNumberVariables();
        this.uniqueYValues = new LinkedHashMap();
        int num = 0;
        for (int i = 1; i < cols; ++i) {
            if (this.isNumericResponse() && (!this.isNumericResponse() || !this.dataIn.isNumericVariable(i))) continue;
            this.uniqueYValues.put(this.dataIn.getVariableId(i), new Integer(num));
            ++num;
        }
        if (num == 0) {
            this.validSpreadSheet = false;
            return false;
        }
        this.getResponseInfo();
        return true;
    }

    private boolean processSpreadSheetData(int roleId, Object[] variables) {
        LinkedHashMap<Object, Integer> uniqueValues = new LinkedHashMap<Object, Integer>();
        if (roleId == 0) {
            this.uniqueXValues = uniqueValues;
            this.transposed = false;
        } else if (roleId == 1) {
            this.uniqueYValues = uniqueValues;
            this.transposed = true;
        }
        int num = 0;
        for (int i = 0; i < variables.length; ++i) {
            if (variables[i] == null || !this.dataIn.verifyVariable(variables[i]) || this.isNumericResponse() && (!this.isNumericResponse() || !this.dataIn.isNumericVariable(variables[i]))) continue;
            uniqueValues.put(variables[i], new Integer(num));
            ++num;
        }
        if (num == 0) {
            this.validSpreadSheet = false;
            return false;
        }
        this.getResponseInfo(variables);
        return true;
    }

    private void getResponseInfo() {
        if (!this.isNumericResponse()) {
            this.globalUniqueResponseValues = this.findUniqueResponseValues(false);
            this.uniqueResponseValues = this.globalUniqueResponseValues;
            return;
        }
        int cols = this.dataIn.getNumberVariables();
        long rows = this.dataIn.getNumberObservations(-1);
        this.respMin = Double.MAX_VALUE;
        this.respMax = -1.7976931348623157E308;
        for (int vid = 1; vid < cols; ++vid) {
            if (!this.dataIn.isNumericVariable(vid)) continue;
            for (long i = 0L; i < rows; ++i) {
                double v;
                if (!this.dataIn.isGraphed(i) || Double.isNaN(v = this.dataIn.getNumericValue(vid, i))) continue;
                if (v > this.respMax) {
                    this.respMax = v;
                }
                if (!(v < this.respMin)) continue;
                this.respMin = v;
            }
        }
    }

    private void getResponseInfo(Object[] variables) {
        if (!this.isNumericResponse()) {
            this.globalUniqueResponseValues = this.findUniqueResponseValues(variables, false);
            this.uniqueResponseValues = this.globalUniqueResponseValues;
            return;
        }
        long rows = this.dataIn.getNumberObservations(-1);
        this.respMin = Double.MAX_VALUE;
        this.respMax = -1.7976931348623157E308;
        for (int vid = 0; vid < variables.length; ++vid) {
            if (!this.dataIn.isNumericVariable(variables[vid])) continue;
            for (long i = 0L; i < rows; ++i) {
                double v;
                if (!this.dataIn.isGraphed(i) || Double.isNaN(v = this.dataIn.getNumericValue(variables[vid], i))) continue;
                if (v > this.respMax) {
                    this.respMax = v;
                }
                if (!(v < this.respMin)) continue;
                this.respMin = v;
            }
        }
    }

    private Object[] findUniqueResponseValues(boolean applyWhere) {
        if (!(this.dataIn instanceof DataFilterInfoInterface)) {
            return null;
        }
        int cols = this.dataIn.getNumberVariables();
        ArrayList<Object> values = new ArrayList<Object>();
        for (int vid = 1; vid < cols; ++vid) {
            Object[] v = ((DataFilterInfoInterface)this.dataIn).getUniqueValues(this.dataIn.getVariableId(vid), applyWhere);
            for (int i = 0; i < v.length; ++i) {
                if (values.contains(v[i])) continue;
                values.add(v[i]);
            }
        }
        return values.toArray();
    }

    private Object[] findUniqueResponseValues(Object[] variables, boolean applyWhere) {
        if (!(this.dataIn instanceof DataFilterInfoInterface)) {
            return null;
        }
        ArrayList<Object> values = new ArrayList<Object>();
        for (int vid = 0; vid < variables.length; ++vid) {
            Object[] v = ((DataFilterInfoInterface)this.dataIn).getUniqueValues(variables[vid], applyWhere);
            for (int i = 0; i < v.length; ++i) {
                if (values.contains(v[i])) continue;
                values.add(v[i]);
            }
        }
        return values.toArray();
    }

    public boolean isSpreadSheetData() {
        return this.spreadSheetData;
    }

    public boolean isValidSpreadSheet() {
        return this.spreadSheetData && this.validSpreadSheet;
    }

    public boolean isTransposed() {
        return this.transposed;
    }

    public boolean isNumericResponse() {
        return this.numericResponse;
    }
}

