/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.graphtable;

import com.sas.graphics.silk.graphtable.GTable;
import com.sas.graphics.silk.graphtable.GTablePanel;
import com.sas.graphics.silk.util.table.TableSorter;
import com.sas.graphics.silk.util.table.TableStyle;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.Hashtable;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TextAreaRenderer
extends JTextArea
implements TableCellRenderer {
    private static final long serialVersionUID = 3873904525129922980L;
    private int selectedRow = -1;
    private int selectedColumn = -1;
    SASFormat format = null;
    Color defaultForeColor;
    Color selectedForeColor;
    Color defaultBackColor;
    Color selectedBackColor;
    Color linkColor;
    Color visitedLinkColor;
    Font defaultFont;
    Font linkFont;
    TableSorter model;
    GTable gTable;
    GTablePanel gtPanel;
    boolean first = true;
    Point cell = new Point();
    AttributedString as;
    Class colClass;
    String sVal = new String(" ");
    Class sClass = this.sVal.getClass();
    TableStyle style;

    public TextAreaRenderer() {
    }

    public TextAreaRenderer(Class colClass, String formatString, GTable table, GTablePanel panel) {
        this();
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.gTable = table;
        this.gtPanel = panel;
        this.model = this.gTable.getGTableModel();
        this.colClass = colClass;
        this.style = this.gTable.getStyle();
        this.defaultForeColor = this.gTable.getForeground();
        this.defaultBackColor = this.gTable.getBackground();
        this.selectedForeColor = new Color(0, 0, 196);
        this.selectedBackColor = new Color(224, 224, 128);
        this.linkColor = new Color(0, 0, 176);
        this.setBorder(UIManager.getBorder("TableCell.cellBorder"));
        this.defaultFont = table.getFont();
        Hashtable<TextAttribute, Float> map = new Hashtable<TextAttribute, Float>();
        map.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        this.linkFont = this.defaultFont.deriveFont(map);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int modelColumnIndex = table.convertColumnIndexToModel(column);
        String link = this.model.getLink(row, modelColumnIndex);
        if (value == null) {
            this.setText(" . ");
        } else {
            this.setText(value.toString());
        }
        if (link != null) {
            this.setFont(this.linkFont);
        } else {
            this.setFont(this.defaultFont);
        }
        this.cell = this.gTable.getSelectedCell(this.cell);
        this.selectedColumn = this.cell.x;
        this.selectedRow = this.cell.y;
        if (table.isCellSelected(row, column)) {
            this.setBackground(this.style.selectedBackColor);
            this.setForeground(this.style.selectedForeColor);
        } else {
            this.setBackground(this.gTable.getCellItemColor(row, column, 0));
            if (row >= this.model.getRowCount() - this.model.getMetaRowCount()) {
                this.setForeground(this.style.metaDataColor);
            } else if (link != null) {
                this.setForeground(this.style.linkColor);
            } else {
                this.setForeground(this.style.cellForeColor);
            }
        }
        if (row == this.selectedRow && column == this.selectedColumn && link != null) {
            this.setForeground(this.style.visitedLinkColor);
        }
        TableColumnModel tcModel = table.getColumnModel();
        TableColumn tColumn = tcModel.getColumn(column);
        int width = tColumn.getWidth();
        int curHeight = table.getRowHeight(row);
        this.setSize(width, curHeight);
        Dimension size = this.getPreferredSize();
        int heightWanted = size.height;
        this.gtPanel.setRowHeight(row, heightWanted);
        return this;
    }

    public void setSelectedCell(int row, int column) {
        this.selectedRow = row;
        this.selectedColumn = column;
    }
}

