/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.graphtable;

import com.sas.graphics.silk.graphtable.GTable;
import com.sas.graphics.silk.graphtable.GTablePanel;
import com.sas.graphics.silk.graphtable.GraphicsLabelUI;
import com.sas.graphics.silk.interfaces.ColorInterface;
import com.sas.graphics.silk.util.table.TableSorter;
import com.sas.graphics.silk.util.table.TableStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.MessageFormat;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;

public class GraphicalColumnCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 5827458048407805117L;
    public static int BARMODE_ABSOLUTE = 0;
    public static int BARMODE_RELATIVE = 1;
    private static int count = 0;
    private Rectangle barRect = new Rectangle();
    private double dMin = 0.0;
    private double dMax = 1.0;
    private double dRange = 1.0;
    private double normVal;
    private double base;
    private double rawValue;
    private int barMode = BARMODE_ABSOLUTE;
    private int selectedRow = -1;
    private int selectedColumn = -1;
    private boolean funnel = false;
    public GraphicsLabelUI graphicsUI = new GraphicsLabelUI();
    Color defaultForeColor;
    Color selectedForeColor;
    Color defaultBackColor;
    Color selectedBackColor;
    GTable gTable;
    TableSorter model;
    Point cell = new Point();
    TableStyle style;
    ColorInterface ramp = null;
    GTablePanel gtPanel = null;
    boolean discrete = false;
    boolean segmented = false;
    int valueIndex = 0;
    Color discBarColor = null;
    boolean showText = false;

    public GraphicalColumnCellRenderer() {
        ++count;
        Double d1 = new Double(0.0);
        Double d2 = new Double(1.0);
        this.setColumnMetadata(d1.getClass(), d1, d2);
        this.defaultForeColor = this.getForeground();
        this.defaultBackColor = this.getBackground();
        this.selectedForeColor = new Color(0, 0, 196);
        this.selectedBackColor = new Color(224, 224, 128);
    }

    public GraphicalColumnCellRenderer(Class colClass, Object min, Object max, GTable table, boolean funnel) {
        this();
        this.funnel = funnel;
        this.gTable = table;
        this.model = this.gTable.getGTableModel();
        this.setColumnMetadata(colClass, min, max);
        this.setBorder(UIManager.getBorder("TableCell.cellBorder"));
        this.setUI(this.graphicsUI);
        this.style = this.gTable.getStyle();
    }

    public GraphicalColumnCellRenderer(Class colClass, GTable table, GTablePanel gtPanel, boolean discrete, boolean segmented) {
        this();
        this.gTable = table;
        this.gtPanel = gtPanel;
        this.model = this.gTable.getGTableModel();
        this.setDiscrete(discrete);
        this.setBorder(UIManager.getBorder("TableCell.cellBorder"));
        this.setUI(this.graphicsUI);
        this.style = this.gTable.getStyle();
    }

    public void setDiscrete(boolean discrete) {
        this.discrete = discrete;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.computeNormalizedValue(value, row, column);
        if (this.showText && value != null) {
            this.setText(this.gTable.getFormattedValue(value, row, column));
        } else {
            this.setText(null);
        }
        this.setFont(this.gTable.getFont());
        this.cell = this.gTable.getSelectedCell(this.cell);
        this.selectedColumn = this.cell.x;
        this.selectedRow = this.cell.y;
        if (table.isCellSelected(row, column)) {
            this.setBackground(this.style.selectedBackColor);
        } else if (this.ramp != null && value instanceof Number) {
            this.setBackground(this.ramp.queryDouble(((Number)value).doubleValue(), this.dMin, this.dMax, false, null));
        } else {
            this.setBackground(this.gTable.getCellItemColor(row, column, 0));
        }
        String link = this.model.getLink(row, column);
        if (row == this.selectedRow && column == this.selectedColumn && link != null) {
            this.setBackground(this.style.visitedLinkColor);
        }
        String msg = this.gTable.GRS(this.gTable.getResourceBundle(), "GTable.Tooltip.fmt.txt", "Row: {0} Value: {1}");
        this.setToolTipText(MessageFormat.format(msg, new Integer(row + 1), this.gTable.getFormattedValue(value, row, column)));
        if (this.gtPanel != null) {
            this.discBarColor = this.gtPanel.getCellColor(row, column, value, this);
        }
        return this;
    }

    @Override
    public void paint(Graphics g) {
        int x;
        Rectangle r = new Rectangle();
        if (Double.isNaN(this.normVal)) {
            return;
        }
        this.barRect = this.getBounds(r);
        int width = Math.max(0, r.width - 1);
        if (this.funnel) {
            this.base = 0.5 - 0.5 * this.normVal;
        } else if (this.discrete && this.segmented) {
            this.base = (double)this.valueIndex * this.normVal;
        }
        int x1 = (int)((double)r.width * this.base);
        int x2 = (int)((double)width * (this.normVal + this.base));
        this.barRect.x = x = Math.min(x1, x2);
        this.barRect.width = Math.abs(x2 - x1);
        this.barRect.y = 1;
        this.barRect.height -= 2;
        Color barColor = this.discrete && this.discBarColor != null ? this.discBarColor : (this.barMode == BARMODE_ABSOLUTE && (this.normVal < 0.0 || this.funnel && this.rawValue < 0.0) ? this.style.negativeBarColor : this.style.positiveBarColor);
        this.setForeground(barColor);
        super.paint(g);
    }

    public void setSelectedCell(int row, int column) {
        this.selectedRow = row;
        this.selectedColumn = column;
    }

    public Rectangle getBarRectangle(Rectangle r) {
        r.x = this.barRect.x;
        r.y = this.barRect.y;
        r.width = this.barRect.width;
        r.height = this.barRect.height;
        return r;
    }

    public int setColumnMetadata(Class colClass, Object min, Object max) {
        if (!(min instanceof Number) || !(max instanceof Number)) {
            return 0;
        }
        this.dMin = ((Number)min).doubleValue();
        this.dMax = ((Number)max).doubleValue();
        if (this.funnel) {
            this.dMin = Math.abs(this.dMin);
            this.dMax = Math.abs(this.dMax);
        }
        if (this.dMin < 0.0 && this.dMax < 0.0) {
            this.base = 1.0;
            this.dRange = Math.abs(this.dMin);
        } else if (this.dMin > 0.0 && this.dMax > 0.0) {
            this.base = 0.0;
            this.dRange = Math.abs(this.dMax);
            if (this.funnel) {
                this.dRange = Math.max(this.dMin, this.dMax);
            }
        } else {
            this.dRange = Math.abs(this.dMax - this.dMin);
            if (this.dRange < 1.0E-7) {
                this.dRange = 1.0;
            }
            this.base = Math.abs(this.dMin) / this.dRange;
        }
        if (this.dRange < 1.0E-7) {
            this.dRange = 1.0;
        }
        return 1;
    }

    private void computeNormalizedValue(Object value, int row, int column) {
        if (this.discrete) {
            if (this.gtPanel.isMissing(row, column)) {
                this.normVal = Double.NaN;
                return;
            }
            if (this.segmented) {
                this.valueIndex = this.gtPanel.getIndex(value, column);
                this.normVal = 1.0 / (double)this.gtPanel.getNumberOfUniqueValues(column);
            } else {
                this.normVal = 1.0;
            }
            this.rawValue = this.gtPanel.getIndex(value, column);
            return;
        }
        if (value instanceof Number) {
            this.normVal = this.rawValue = ((Number)value).doubleValue();
        } else {
            this.rawValue = 0.0;
            this.normVal = 0.0;
        }
        if (this.funnel) {
            this.normVal = Math.abs(this.normVal);
        }
        this.normVal = value == null ? 0.0 : (this.barMode == BARMODE_RELATIVE ? (this.normVal - this.dMin) / this.dRange : (this.normVal /= this.dRange));
    }

    public void setRamp(ColorInterface rampIn) {
        this.ramp = rampIn;
    }

    public ColorInterface getRamp() {
        return this.ramp;
    }
}

